/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JsonResponseHandler")
public final class JsonPathResponseHandler
extends SelectorBasedResponseHandler {
    private static final Map<Class<?>, String> JSON_TYPES;
    private final Map<String, JsonPath> myCompiledCache = new HashMap<String, JsonPath>();

    public JsonPathResponseHandler() {
    }

    public JsonPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Nullable
    private Object extractRawValue(@NotNull Selector selector, @NotNull String source) throws Exception {
        Object value;
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        JsonPath jsonPath = this.lazyCompile(selector.getPath());
        try {
            value = jsonPath.read(source);
        }
        catch (InvalidPathException e) {
            throw new Exception(String.format("JsonPath expression '%s' doesn't match", selector.getPath()), e);
        }
        if (value == null) {
            return null;
        }
        return value;
    }

    @Nullable
    private <T> T extractValueAndCheckType(@NotNull Selector selector, @NotNull String source, Class<T> cls) throws Exception {
        Object value = this.extractRawValue(selector, source);
        if (value == null) {
            return null;
        }
        if (!cls.isInstance(value)) {
            throw new Exception(String.format("JsonPath expression '%s' should match %s. Got '%s' instead", selector.getPath(), JSON_TYPES.get(cls), value));
        }
        Object casted = value;
        return (T)casted;
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        List list = this.extractValueAndCheckType(this.getSelector("tasks"), response, List.class);
        if (list == null) {
            return ContainerUtil.emptyList();
        }
        JsonProvider jsonProvider = Configuration.defaultConfiguration().jsonProvider();
        return ContainerUtil.getFirstItems((List)ContainerUtil.map2List((Collection)list, o -> jsonProvider.toJson(o)), (int)max);
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        Object value = this.extractRawValue(selector, (String)context);
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        throw new Exception(String.format("JsonPath expression '%s' should match string value. Got '%s' instead", selector.getPath(), value));
    }

    @Override
    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        return this.extractValueAndCheckType(selector, (String)context, Boolean.class);
    }

    @Nullable
    private Long selectLong(@NotNull Selector selector, @NotNull String source) throws Exception {
        return this.extractValueAndCheckType(selector, source, Long.class);
    }

    @NotNull
    private JsonPath lazyCompile(@NotNull String path) throws Exception {
        JsonPath jsonPath = this.myCompiledCache.get(path);
        if (jsonPath == null) {
            try {
                jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
                this.myCompiledCache.put(path, jsonPath);
            }
            catch (InvalidPathException e) {
                throw new Exception(String.format("Malformed JsonPath expression '%s'", path));
            }
        }
        return jsonPath;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        return ResponseType.JSON;
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
        JSON_TYPES = Map.of(Map.class, "JSON object", List.class, "JSON array", String.class, "JSON string", Integer.class, "JSON number", Double.class, "JSON number", Boolean.class, "JSON boolean");
    }
}

