/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.generic.GenericRepositoryUtil;
import com.intellij.tasks.generic.JsonPathResponseHandler;
import com.intellij.tasks.generic.RegExResponseHandler;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.tasks.generic.XPathResponseHandler;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Generic")
public class GenericRepository
extends BaseRepositoryImpl {
    @NonNls
    public static final String SERVER_URL = "serverUrl";
    @NonNls
    public static final String USERNAME = "username";
    @NonNls
    public static final String PASSWORD = "password";
    private final TemplateVariable.FactoryVariable myServerTemplateVariable = new TemplateVariable.FactoryVariable("serverUrl"){

        @Override
        @NotNull
        public String getValue() {
            return GenericRepository.this.getUrl();
        }
    };
    private final TemplateVariable.FactoryVariable myUserNameTemplateVariable = new TemplateVariable.FactoryVariable("username"){

        @Override
        @NotNull
        public String getValue() {
            return GenericRepository.this.getUsername();
        }
    };
    private final TemplateVariable.FactoryVariable myPasswordTemplateVariable = new TemplateVariable.FactoryVariable("password", true){

        @Override
        @NotNull
        public String getValue() {
            return GenericRepository.this.getPassword();
        }
    };
    private final List<TemplateVariable.FactoryVariable> myPredefinedTemplateVariables = Arrays.asList(this.myServerTemplateVariable, this.myUserNameTemplateVariable, this.myPasswordTemplateVariable);
    private String myLoginURL = "";
    private String myTasksListUrl = "";
    private String mySingleTaskUrl;
    private HTTPMethod myLoginMethodType = HTTPMethod.GET;
    private HTTPMethod myTasksListMethodType = HTTPMethod.GET;
    private HTTPMethod mySingleTaskMethodType = HTTPMethod.GET;
    private ResponseType myResponseType = ResponseType.JSON;
    private EnumMap<ResponseType, ResponseHandler> myResponseHandlersMap = new EnumMap(ResponseType.class);
    private List<TemplateVariable> myTemplateVariables = new ArrayList<TemplateVariable>();
    private String mySubtypeName;
    private boolean myDownloadTasksInSeparateRequests;

    public GenericRepository() {
        this.resetToDefaults();
    }

    public GenericRepository(TaskRepositoryType type) {
        super(type);
        this.resetToDefaults();
    }

    public GenericRepository(GenericRepository other) {
        super(other);
        this.myLoginURL = other.getLoginUrl();
        this.myTasksListUrl = other.getTasksListUrl();
        this.mySingleTaskUrl = other.getSingleTaskUrl();
        this.myLoginMethodType = other.getLoginMethodType();
        this.myTasksListMethodType = other.getTasksListMethodType();
        this.mySingleTaskMethodType = other.getSingleTaskMethodType();
        this.myResponseType = other.getResponseType();
        this.myTemplateVariables = other.getTemplateVariables();
        this.mySubtypeName = other.getSubtypeName();
        this.myDownloadTasksInSeparateRequests = other.getDownloadTasksInSeparateRequests();
        this.myResponseHandlersMap = new EnumMap(ResponseType.class);
        for (Map.Entry<ResponseType, ResponseHandler> e : other.myResponseHandlersMap.entrySet()) {
            ResponseHandler handler = e.getValue().clone();
            handler.setRepository(this);
            this.myResponseHandlersMap.put(e.getKey(), handler);
        }
    }

    public void resetToDefaults() {
        this.myLoginURL = "";
        this.myTasksListUrl = "";
        this.mySingleTaskUrl = "";
        this.myDownloadTasksInSeparateRequests = false;
        this.myLoginMethodType = HTTPMethod.GET;
        this.myTasksListMethodType = HTTPMethod.GET;
        this.mySingleTaskMethodType = HTTPMethod.GET;
        this.myResponseType = ResponseType.JSON;
        this.myTemplateVariables = new ArrayList<TemplateVariable>();
        this.myResponseHandlersMap = new EnumMap(ResponseType.class);
        this.myResponseHandlersMap.put(ResponseType.XML, this.getXmlResponseHandlerDefault());
        this.myResponseHandlersMap.put(ResponseType.JSON, this.getJsonResponseHandlerDefault());
        this.myResponseHandlersMap.put(ResponseType.TEXT, this.getTextResponseHandlerDefault());
    }

    @Override
    @NotNull
    public GenericRepository clone() {
        return new GenericRepository(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRepository)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericRepository that = (GenericRepository)((Object)o);
        if (!Objects.equals(this.getLoginUrl(), that.getLoginUrl())) {
            return false;
        }
        if (!Objects.equals(this.getTasksListUrl(), that.getTasksListUrl())) {
            return false;
        }
        if (!Objects.equals(this.getSingleTaskUrl(), that.getSingleTaskUrl())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getLoginMethodType(), (Object)that.getLoginMethodType())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getTasksListMethodType(), (Object)that.getTasksListMethodType())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getSingleTaskMethodType(), (Object)that.getSingleTaskMethodType())) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)this.getResponseType()), (Object)((Object)that.getResponseType()))) {
            return false;
        }
        if (!Comparing.equal(this.getTemplateVariables(), that.getTemplateVariables())) {
            return false;
        }
        if (!Comparing.equal(this.getResponseHandlers(), that.getResponseHandlers())) {
            return false;
        }
        return Comparing.equal((Object)this.getDownloadTasksInSeparateRequests(), (Object)that.getDownloadTasksInSeparateRequests());
    }

    public boolean isConfigured() {
        if (!super.isConfigured()) {
            return false;
        }
        for (TemplateVariable variable : this.getTemplateVariables()) {
            if (!variable.isShownOnFirstTab() || !StringUtil.isEmpty((String)variable.getValue())) continue;
            return false;
        }
        return StringUtil.isNotEmpty((String)this.myTasksListUrl) && this.getActiveResponseHandler().isConfigured();
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        if (StringUtil.isEmpty((String)this.myTasksListUrl)) {
            throw new Exception("'Task list URL' configuration parameter is mandatory");
        }
        if (!this.isLoginAnonymously() && !this.isUseHttpAuthentication()) {
            this.executeMethod(this.getLoginMethod());
        }
        List<TemplateVariable> variables = GenericRepositoryUtil.concat(this.getAllTemplateVariables(), new TemplateVariable("max", String.valueOf(max)), new TemplateVariable("since", String.valueOf(since)));
        String requestUrl = GenericRepositoryUtil.substituteTemplateVariables(this.getTasksListUrl(), variables);
        String responseBody = this.executeMethod(this.getHttpMethod(requestUrl, this.myTasksListMethodType));
        Task[] tasks = this.getActiveResponseHandler().parseIssues(responseBody, max);
        if (this.myResponseType == ResponseType.TEXT) {
            return tasks;
        }
        if (StringUtil.isNotEmpty((String)this.mySingleTaskUrl) && this.myDownloadTasksInSeparateRequests) {
            for (int i = 0; i < tasks.length; ++i) {
                tasks[i] = this.findTask(tasks[i].getId());
            }
        }
        return tasks;
    }

    private String executeMethod(HttpMethod method) throws Exception {
        String responseBody;
        this.getHttpClient().executeMethod(method);
        Header contentType = method.getResponseHeader("Content-Type");
        if (contentType != null && contentType.getValue().contains("charset")) {
            responseBody = StringUtil.notNullize((String)method.getResponseBodyAsString());
        } else {
            InputStream stream = method.getResponseBodyAsStream();
            if (stream == null) {
                responseBody = "";
            } else {
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    responseBody = StreamUtil.readText((Reader)reader);
                }
            }
        }
        if (method.getStatusCode() != 200) {
            throw new Exception("Request failed with HTTP error: " + method.getStatusText());
        }
        return responseBody;
    }

    private HttpMethod getHttpMethod(String requestUrl, HTTPMethod type) {
        HttpMethod method = type == HTTPMethod.GET ? new GetMethod(requestUrl) : GenericRepositoryUtil.getPostMethodFromURL(requestUrl);
        this.configureHttpMethod(method);
        return method;
    }

    private HttpMethod getLoginMethod() throws Exception {
        String requestUrl = GenericRepositoryUtil.substituteTemplateVariables(this.getLoginUrl(), this.getAllTemplateVariables());
        return this.getHttpMethod(requestUrl, this.myLoginMethodType);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        List<TemplateVariable> variables = GenericRepositoryUtil.concat(this.getAllTemplateVariables(), new TemplateVariable("id", id));
        String requestUrl = GenericRepositoryUtil.substituteTemplateVariables(this.getSingleTaskUrl(), variables);
        HttpMethod method = this.getHttpMethod(requestUrl, this.mySingleTaskMethodType);
        return this.getActiveResponseHandler().parseIssue(this.executeMethod(method));
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                GenericRepository.this.getIssues("", 1, 0L);
            }

            public void cancel() {
            }
        };
    }

    public void setLoginUrl(String loginUrl) {
        this.myLoginURL = loginUrl;
    }

    public void setTasksListUrl(String tasksListUrl) {
        this.myTasksListUrl = tasksListUrl;
    }

    public void setSingleTaskUrl(String singleTaskUrl) {
        this.mySingleTaskUrl = singleTaskUrl;
    }

    public String getLoginUrl() {
        return this.myLoginURL;
    }

    public String getTasksListUrl() {
        return this.myTasksListUrl;
    }

    public String getSingleTaskUrl() {
        return this.mySingleTaskUrl;
    }

    public void setLoginMethodType(HTTPMethod loginMethodType) {
        this.myLoginMethodType = loginMethodType;
    }

    public void setTasksListMethodType(HTTPMethod tasksListMethodType) {
        this.myTasksListMethodType = tasksListMethodType;
    }

    public void setSingleTaskMethodType(HTTPMethod singleTaskMethodType) {
        this.mySingleTaskMethodType = singleTaskMethodType;
    }

    public HTTPMethod getLoginMethodType() {
        return this.myLoginMethodType;
    }

    public HTTPMethod getTasksListMethodType() {
        return this.myTasksListMethodType;
    }

    public HTTPMethod getSingleTaskMethodType() {
        return this.mySingleTaskMethodType;
    }

    public ResponseType getResponseType() {
        return this.myResponseType;
    }

    public void setResponseType(ResponseType responseType) {
        this.myResponseType = responseType;
    }

    public List<TemplateVariable> getTemplateVariables() {
        return this.myTemplateVariables;
    }

    public List<TemplateVariable> getAllTemplateVariables() {
        return ContainerUtil.concat(this.myPredefinedTemplateVariables, this.getTemplateVariables());
    }

    public void setTemplateVariables(List<TemplateVariable> templateVariables) {
        this.myTemplateVariables = templateVariables;
    }

    public Icon getIcon() {
        if (this.mySubtypeName == null) {
            return super.getIcon();
        }
        List subtypes = this.getRepositoryType().getAvailableSubtypes();
        for (TaskRepositorySubtype s : subtypes) {
            if (!this.mySubtypeName.equals(s.getName())) continue;
            return s.getIcon();
        }
        throw new AssertionError((Object)"Unknown repository subtype");
    }

    protected int getFeatures() {
        return 3;
    }

    public ResponseHandler getResponseHandler(ResponseType type) {
        return this.myResponseHandlersMap.get((Object)type);
    }

    public ResponseHandler getActiveResponseHandler() {
        return this.myResponseHandlersMap.get((Object)this.myResponseType);
    }

    @XCollection(elementTypes={XPathResponseHandler.class, JsonPathResponseHandler.class, RegExResponseHandler.class})
    public List<ResponseHandler> getResponseHandlers() {
        if (this.myResponseHandlersMap.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ResponseHandler>(this.myResponseHandlersMap.values()));
    }

    public void setResponseHandlers(List<ResponseHandler> responseHandlers) {
        this.myResponseHandlersMap.clear();
        for (ResponseHandler handler : responseHandlers) {
            this.myResponseHandlersMap.put(handler.getResponseType(), handler);
        }
        for (ResponseHandler handler : this.myResponseHandlersMap.values()) {
            handler.setRepository(this);
        }
    }

    public ResponseHandler getXmlResponseHandlerDefault() {
        return new XPathResponseHandler(this);
    }

    public ResponseHandler getJsonResponseHandlerDefault() {
        return new JsonPathResponseHandler(this);
    }

    public ResponseHandler getTextResponseHandlerDefault() {
        return new RegExResponseHandler(this);
    }

    public String getSubtypeName() {
        return this.mySubtypeName;
    }

    public void setSubtypeName(String subtypeName) {
        this.mySubtypeName = subtypeName;
    }

    public boolean getDownloadTasksInSeparateRequests() {
        return this.myDownloadTasksInSeparateRequests;
    }

    public void setDownloadTasksInSeparateRequests(boolean downloadTasksInSeparateRequests) {
        this.myDownloadTasksInSeparateRequests = downloadTasksInSeparateRequests;
    }
}

