/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.reposearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u0017H\u0002J0\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u0017H\u0002J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eJ4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u0017J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010!\u001a\u00020\u0007J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070 2\b\u0010#\u001a\u0004\u0018\u00010\u0007J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007J\u0016\u0010&\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010(0(0'H\u0002J`\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u00172(\u0010,\u001a$\u0012\u0004\u0012\u00020(\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000f0-H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010(0(0'H\u0002J2\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010!\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eJ<\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010!\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0016j\u0002`\u0017R5\u0010\u0005\u001a)\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u0015\u0012\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "clearCache", "", "dispose", "fillResultsFromCache", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "future", "consumer", "Lkotlin/Function1;", "Lorg/jetbrains/idea/reposearch/ResultConsumer;", "foundInCache", "Lorg/jetbrains/concurrency/Promise;", "searchString", "fulltextSearch", "parameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "Ljava/util/function/Consumer;", "getArtifactIds", "", "groupId", "getGroupIds", "pattern", "getVersions", "artifactId", "localProviders", "", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "kotlin.jvm.PlatformType", "performSearch", "cacheKey", "searchMethod", "Lkotlin/Function2;", "remoteProviders", "suggestPrefix", "Companion", "intellij.repository.search"})
@ApiStatus.Experimental
public final class DependencySearchService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final ConcurrentMap<String, CompletableFuture<Collection<RepositoryArtifactData>>> cache;
    @JvmField
    @NotNull
    public static final ExtensionPointName<DependencySearchProvidersFactory> EP_NAME = new ExtensionPointName("org.jetbrains.idea.reposearch.provider");

    public DependencySearchService(@NotNull Project project) {
        this.project = project;
        this.executorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DependencySearch", (int)2);
        this.cache = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencySearchProvider> remoteProviders() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (DependencySearchProvidersFactory)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProviders(this.project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DependencySearchProvider)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLocal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencySearchProvider> localProviders() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (DependencySearchProvidersFactory)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProviders(this.project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DependencySearchProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isLocal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
    }

    private final Promise<Integer> performSearch(String cacheKey, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer, Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit> searchMethod) {
        Promise<Integer> cachedValue;
        if (parameters.useCache() && (cachedValue = this.foundInCache(cacheKey, consumer)) != null) {
            return cachedValue;
        }
        CompletableFuture<Collection<RepositoryArtifactData>> thisNewFuture = new CompletableFuture<Collection<RepositoryArtifactData>>();
        CompletableFuture<Collection<RepositoryArtifactData>> existingFuture = this.cache.putIfAbsent(cacheKey, thisNewFuture);
        if (existingFuture != null && parameters.useCache()) {
            return (Promise)this.fillResultsFromCache(existingFuture, consumer);
        }
        Set localResultSet = new LinkedHashSet();
        Iterable $this$forEach$iv = this.localProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencySearchProvider lp = (DependencySearchProvider)element$iv;
            boolean bl = false;
            searchMethod.invoke((Object)lp, (Object)new Function1<RepositoryArtifactData, Unit>((Set<RepositoryArtifactData>)localResultSet){
                final /* synthetic */ Set<RepositoryArtifactData> $localResultSet;
                {
                    this.$localResultSet = $localResultSet;
                    super(1);
                }

                public final void invoke(@NotNull RepositoryArtifactData it) {
                    this.$localResultSet.add(it);
                }
            });
        }
        $this$forEach$iv = localResultSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer.invoke(element$iv);
        }
        List<DependencySearchProvider> remoteProviders = this.remoteProviders();
        if (parameters.isLocalOnly() || remoteProviders.isEmpty()) {
            thisNewFuture.complete(localResultSet);
            return Promises.resolvedPromise((Object)0);
        }
        List promises = new ArrayList(remoteProviders.size());
        Set<RepositoryArtifactData> resultSet = Collections.synchronizedSet(localResultSet);
        for (DependencySearchProvider provider : remoteProviders) {
            AsyncPromise promise = new AsyncPromise();
            promises.add(promise);
            ProgressWrapper wrapper = ProgressWrapper.wrap((ProgressIndicator)ProgressIndicatorProvider.getInstance().getProgressIndicator());
            this.executorService.submit(() -> DependencySearchService.performSearch$lambda$6(wrapper, promise, searchMethod, provider, resultSet, consumer));
        }
        return Promises.all((Collection)promises, resultSet, (boolean)true).then(arg_0 -> DependencySearchService.performSearch$lambda$7((Function1)new Function1<Set<RepositoryArtifactData>, Integer>(resultSet, existingFuture, thisNewFuture){
            final /* synthetic */ Set<RepositoryArtifactData> $resultSet;
            final /* synthetic */ CompletableFuture<Collection<RepositoryArtifactData>> $existingFuture;
            final /* synthetic */ CompletableFuture<Collection<RepositoryArtifactData>> $thisNewFuture;
            {
                this.$resultSet = $resultSet;
                this.$existingFuture = $existingFuture;
                this.$thisNewFuture = $thisNewFuture;
                super(1);
            }

            public final Integer invoke(Set<RepositoryArtifactData> it) {
                if (!this.$resultSet.isEmpty() && this.$existingFuture == null) {
                    this.$thisNewFuture.complete(this.$resultSet);
                }
                return 1;
            }
        }, arg_0));
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        return this.suggestPrefix(groupId, artifactId, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer<RepositoryArtifactData> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                this.$consumer.accept(it);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        String cacheKey = "_" + groupId + ":" + artifactId;
        return this.performSearch(cacheKey, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(groupId, artifactId){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;
            {
                this.$groupId = $groupId;
                this.$artifactId = $artifactId;
                super(2);
            }

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                p.suggestPrefix(this.$groupId, this.$artifactId, arg_0 -> suggestPrefix.2.invoke$lambda$0(c, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, RepositoryArtifactData p0) {
                $tmp0.invoke((Object)p0);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        return this.fulltextSearch(searchString, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer<RepositoryArtifactData> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                this.$consumer.accept(it);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        return this.performSearch(searchString, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(searchString){
            final /* synthetic */ String $searchString;
            {
                this.$searchString = $searchString;
                super(2);
            }

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                p.fulltextSearch(this.$searchString, arg_0 -> fulltextSearch.2.invoke$lambda$0(c, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, RepositoryArtifactData p0) {
                $tmp0.invoke((Object)p0);
            }
        }));
    }

    @NotNull
    public final Set<String> getGroupIds(@Nullable String pattern) {
        Set result = new LinkedHashSet();
        String string = pattern;
        if (string == null) {
            string = "";
        }
        this.fulltextSearch(string, new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>((Set<String>)result){
            final /* synthetic */ Set<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                if (it instanceof MavenRepositoryArtifactInfo) {
                    this.$result.add(((MavenRepositoryArtifactInfo)it).getGroupId());
                }
            }
        }));
        return result;
    }

    @NotNull
    public final Set<String> getArtifactIds(@NotNull String groupId) {
        ProgressIndicatorProvider.checkCanceled();
        Set result = new LinkedHashSet();
        this.fulltextSearch(groupId + ":", new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(groupId, (Set<String>)result){
            final /* synthetic */ String $groupId;
            final /* synthetic */ Set<String> $result;
            {
                this.$groupId = $groupId;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)this.$groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId())) {
                    this.$result.add(((MavenRepositoryArtifactInfo)it).getArtifactId());
                }
            }
        }));
        return result;
    }

    @NotNull
    public final Set<String> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        ProgressIndicatorProvider.checkCanceled();
        Set result = new LinkedHashSet();
        this.fulltextSearch(groupId + ":" + artifactId, new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(groupId, artifactId, (Set<String>)result){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;
            final /* synthetic */ Set<String> $result;
            {
                this.$groupId = $groupId;
                this.$artifactId = $artifactId;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)this.$groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId()) && StringUtil.equals((CharSequence)this.$artifactId, (CharSequence)((MavenRepositoryArtifactInfo)it).getArtifactId())) {
                    for (MavenDependencyCompletionItem item : ((MavenRepositoryArtifactInfo)it).getItems()) {
                        if (item.getVersion() == null) continue;
                        String string = item.getVersion();
                        Intrinsics.checkNotNull((Object)string);
                        this.$result.add(string);
                    }
                }
            }
        }));
        return result;
    }

    private final Promise<Integer> foundInCache(String searchString, Function1<? super RepositoryArtifactData, Unit> consumer) {
        CompletableFuture future = (CompletableFuture)this.cache.get(searchString);
        if (future != null) {
            return (Promise)this.fillResultsFromCache(future, consumer);
        }
        return null;
    }

    private final AsyncPromise<Integer> fillResultsFromCache(CompletableFuture<Collection<RepositoryArtifactData>> future, Function1<? super RepositoryArtifactData, Unit> consumer) {
        AsyncPromise p = new AsyncPromise();
        future.whenComplete((arg_0, arg_1) -> DependencySearchService.fillResultsFromCache$lambda$8(p, consumer, arg_0, arg_1));
        return p;
    }

    public final void clearCache() {
        this.cache.clear();
    }

    private static final void performSearch$lambda$6$lambda$5(Function2 $searchMethod, DependencySearchProvider $provider, AsyncPromise $promise, Set $resultSet, Function1 $consumer) {
        $searchMethod.invoke((Object)$provider, (Object)new Function1<RepositoryArtifactData, Unit>((Set<RepositoryArtifactData>)$resultSet, (Function1<? super RepositoryArtifactData, Unit>)$consumer){
            final /* synthetic */ Set<RepositoryArtifactData> $resultSet;
            final /* synthetic */ Function1<RepositoryArtifactData, Unit> $consumer;
            {
                this.$resultSet = $resultSet;
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull RepositoryArtifactData it) {
                if (this.$resultSet.add(it)) {
                    this.$consumer.invoke((Object)it);
                }
            }
        });
        $promise.setResult(null);
    }

    private static final void performSearch$lambda$6(ProgressWrapper $wrapper, AsyncPromise $promise, Function2 $searchMethod, DependencySearchProvider $provider, Set $resultSet, Function1 $consumer) {
        try {
            ProgressManager.getInstance().runProcess(() -> DependencySearchService.performSearch$lambda$6$lambda$5($searchMethod, $provider, $promise, $resultSet, $consumer), (ProgressIndicator)$wrapper);
        }
        catch (Exception e) {
            $promise.setError((Throwable)e);
        }
    }

    private static final Integer performSearch$lambda$7(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final void fillResultsFromCache$lambda$8(AsyncPromise $p, Function1 $consumer, Collection r, Throwable e) {
        if (e != null) {
            $p.setError(e);
        } else {
            Iterable $this$forEach$iv = r;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                $consumer.invoke(element$iv);
            }
            $p.setResult(null);
        }
    }

    @JvmStatic
    @NotNull
    public static final DependencySearchService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvidersFactory;", "getInstance", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.repository.search"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DependencySearchService getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DependencySearchService> serviceClass$iv = DependencySearchService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (DependencySearchService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

