/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.formats.ico.IcoImageParser;
import org.intellij.images.editor.ImageDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IfsUtil {
    private static final Logger LOG = Logger.getInstance(IfsUtil.class);
    public static final String ICO_FORMAT = "ico";
    public static final String SVG_FORMAT = "svg";
    private static final Key<Pair<Long, Long>> TIME_MODIFICATION_STAMP_KEY = Key.create((String)"Image.timeModificationStamp");
    private static final Key<String> FORMAT_KEY = Key.create((String)"Image.format");
    private static final Key<SoftReference<ImageDocument.ScaledImageProvider>> IMAGE_PROVIDER_REF_KEY = Key.create((String)"Image.bufferedImageProvider");
    private static final IcoImageParser ICO_IMAGE_PARSER = new IcoImageParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean refresh(@NotNull VirtualFile file) throws IOException {
        block24: {
            loadedTimeModificationStamp = (Pair)file.getUserData(IfsUtil.TIME_MODIFICATION_STAMP_KEY);
            actualTimeModificationStamp = Pair.create((Object)file.getTimeStamp(), (Object)file.getModificationStamp());
            imageProviderRef = (SoftReference)file.getUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY);
            if (actualTimeModificationStamp.equals((Object)loadedTimeModificationStamp) && SoftReference.dereference((Reference)imageProviderRef) != null) break block24;
            try {
                block23: {
                    content = file.contentsToByteArray();
                    file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, null);
                    if (!"ico".equalsIgnoreCase(file.getExtension())) ** GOTO lbl-1000
                    try {
                        image = IfsUtil.ICO_IMAGE_PARSER.getBufferedImage((ByteSource)new ByteSourceArray(content), null);
                        file.putUserData(IfsUtil.FORMAT_KEY, (Object)"ico");
                        file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)(ImageDocument.ScaledImageProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$refresh$0(java.awt.image.BufferedImage java.lang.Double java.awt.Component ), (Ljava/lang/Double;Ljava/awt/Component;)Ljava/awt/image/BufferedImage;)((BufferedImage)image)));
                        var6_9 = true;
                        return var6_9;
                    }
                    catch (ImageReadException image) {
                        if (!IfsUtil.isSVG(file)) break block23;
                        url = Ref.create();
                        try {
                            url.set((Object)new File(file.getPath()).toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            IfsUtil.LOG.warn(ex.getMessage());
                        }
                        try {
                            SVGLoader.load((URL)((URL)url.get()), (InputStream)new ByteArrayInputStream(content), (float)1.0f);
                        }
                        catch (Throwable t) {
                            IfsUtil.LOG.warn(url.get() + " " + t.getMessage());
                            var7_14 = false;
                            file.putUserData(IfsUtil.TIME_MODIFICATION_STAMP_KEY, (Object)actualTimeModificationStamp);
                            return var7_14;
                        }
                    }
                    file.putUserData(IfsUtil.FORMAT_KEY, (Object)"svg");
                    file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)new ImageDocument.CachedScaledImageProvider(){
                        final ScaleContext.Cache<Image> cache = new ScaleContext.Cache(ctx -> {
                            try {
                                return SVGLoader.loadHiDPI((URL)((URL)url.get()), (InputStream)new ByteArrayInputStream(content), (ScaleContext)ctx);
                            }
                            catch (Throwable t) {
                                LOG.warn(url.get() + " " + t.getMessage());
                                return null;
                            }
                        });

                        @Override
                        public void clearCache() {
                            this.cache.clear();
                        }

                        @Override
                        public BufferedImage apply(Double zoom, Component ancestor) {
                            ScaleContext ctx = ScaleContext.create((Component)ancestor);
                            ctx.setScale(ScaleType.OBJ_SCALE.of(zoom.doubleValue()));
                            return (BufferedImage)this.cache.getOrProvide((UserScaleContext)ctx);
                        }
                    }));
                    t = true;
                    return t;
                }
                inputStream = new ByteArrayInputStream(content, 0, content.length);
                imageInputStream = ImageIO.createImageInputStream(inputStream);
                try {
                    imageReaders = ImageIO.getImageReaders(imageInputStream);
                    if (imageReaders.hasNext()) {
                        imageReader = imageReaders.next();
                        try {
                            file.putUserData(IfsUtil.FORMAT_KEY, (Object)imageReader.getFormatName());
                            param = imageReader.getDefaultReadParam();
                            imageReader.setInput(imageInputStream, true, true);
                            minIndex = imageReader.getMinIndex();
                            image = imageReader.read(minIndex, param);
                            file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)(ImageDocument.ScaledImageProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$refresh$1(java.awt.image.BufferedImage java.lang.Double java.awt.Component ), (Ljava/lang/Double;Ljava/awt/Component;)Ljava/awt/image/BufferedImage;)((BufferedImage)image)));
                            var12_22 = true;
                            imageReader.dispose();
                            return var12_22;
                        }
                        catch (Throwable var13_23) {
                            imageReader.dispose();
                            throw var13_23;
                        }
                    }
                    {
                        catch (Throwable var7_16) {
                            throw var7_16;
                        }
                    }
                }
                finally {
                    if (imageInputStream != null) {
                        imageInputStream.close();
                    }
                }
                {
                    catch (Throwable var14_24) {
                        throw var14_24;
                    }
                }
            }
            finally {
                file.putUserData(IfsUtil.TIME_MODIFICATION_STAMP_KEY, (Object)actualTimeModificationStamp);
            }
        }
        return false;
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file) throws IOException {
        return IfsUtil.getImage(file, null);
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file, @Nullable Component ancestor) throws IOException {
        ImageDocument.ScaledImageProvider imageProvider = IfsUtil.getImageProvider(file);
        if (imageProvider == null) {
            return null;
        }
        return (BufferedImage)imageProvider.apply(1.0, ancestor);
    }

    @Nullable
    public static ImageDocument.ScaledImageProvider getImageProvider(@NotNull VirtualFile file) throws IOException {
        IfsUtil.refresh(file);
        SoftReference imageProviderRef = (SoftReference)file.getUserData(IMAGE_PROVIDER_REF_KEY);
        return (ImageDocument.ScaledImageProvider)SoftReference.dereference((Reference)imageProviderRef);
    }

    public static boolean isSVG(@Nullable VirtualFile file) {
        return file != null && SVG_FORMAT.equalsIgnoreCase(file.getExtension());
    }

    @Nullable
    public static String getFormat(@NotNull VirtualFile file) throws IOException {
        IfsUtil.refresh(file);
        return (String)file.getUserData(FORMAT_KEY);
    }

    @NlsSafe
    public static String getReferencePath(Project project, VirtualFile file) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot != null) {
            return IfsUtil.getRelativePath(file, sourceRoot);
        }
        VirtualFile root = fileIndex.getContentRootForFile(file);
        if (root != null) {
            return IfsUtil.getRelativePath(file, root);
        }
        return file.getPath();
    }

    private static String getRelativePath(VirtualFile file, VirtualFile root) {
        if (root.equals(file)) {
            return file.getPath();
        }
        return "/" + VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }

    private static /* synthetic */ BufferedImage lambda$refresh$1(BufferedImage image, Double zoom, Component ancestor) {
        return image;
    }

    private static /* synthetic */ BufferedImage lambda$refresh$0(BufferedImage image, Double scale, Component ancestor) {
        return image;
    }
}

