/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageFileEditorState;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorImpl
extends UserDataHolderBase
implements ImageFileEditor,
PropertyChangeListener {
    private static final String NAME = "ImageFileEditor";
    private final ImageEditor imageEditor;
    private final EventDispatcher<PropertyChangeListener> myDispatcher = EventDispatcher.create(PropertyChangeListener.class);

    ImageFileEditorImpl(@NotNull Project project, @NotNull VirtualFile file) {
        this.imageEditor = new ImageEditorImpl(project, file);
        Disposer.register((Disposable)this, (Disposable)this.imageEditor);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.imageEditor.setGridVisible(gridOptions.isShowDefault());
        this.imageEditor.setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ((ImageEditorImpl)this.imageEditor).getComponent().getImageComponent().addPropertyChangeListener(this);
    }

    @NotNull
    public JComponent getComponent() {
        return this.imageEditor.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.imageEditor.getContentComponent();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
        return new ImageFileEditorState(this.imageEditor.isTransparencyChessboardVisible(), this.imageEditor.isGridVisible(), zoomModel.getZoomFactor(), zoomModel.isZoomLevelChanged());
    }

    public void setState(@NotNull FileEditorState state) {
        if (state instanceof ImageFileEditorState) {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            ImageFileEditorState editorState = (ImageFileEditorState)state;
            ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
            this.imageEditor.setTransparencyChessboardVisible(editorState.isBackgroundVisible());
            this.imageEditor.setGridVisible(editorState.isGridVisible());
            if (editorState.isZoomFactorChanged() || !zoomOptions.isSmartZooming()) {
                zoomModel.setZoomFactor(editorState.getZoomFactor());
            }
            zoomModel.setZoomLevelChanged(editorState.isZoomFactorChanged());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        PropertyChangeEvent editorEvent = new PropertyChangeEvent(this, event.getPropertyName(), event.getOldValue(), event.getNewValue());
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(editorEvent);
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public ImageEditor getImageEditor() {
        return this.imageEditor;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.imageEditor.getFile();
    }
}

