/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.impl.ImagesConfigurable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/images/actions/EditExternallyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.images"})
public final class EditExternallyAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile imageFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        String executablePath = null;
        executablePath = PropertiesComponent.getInstance().getValue("Images.ExternalEditorPath", "");
        if (!StringUtil.isEmpty((String)executablePath)) {
            String path;
            Map $this$forEach$iv = EnvironmentUtil.getEnvironmentMap();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String varName = (String)entry.getKey();
                String varValue = (String)entry.getValue();
                executablePath = SystemInfo.isWindows ? StringUtil.replace((String)executablePath, (String)("%" + varName + "%"), (String)varValue, (boolean)true) : StringUtil.replace((String)executablePath, (String)("${" + varName + "}"), (String)varValue, (boolean)false);
            }
            executablePath = FileUtil.toSystemDependentName((String)executablePath);
            File executable = new File(executablePath);
            GeneralCommandLine commandLine = new GeneralCommandLine();
            String string = path = executable.exists() ? executable.getAbsolutePath() : executablePath;
            if (SystemInfo.isMac) {
                commandLine.setExePath(ExecUtil.getOpenCommandPath());
                commandLine.addParameter("-a");
                commandLine.addParameter(path);
            } else {
                commandLine.setExePath(path);
            }
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (imageFile.isInLocalFileSystem() && typeManager.isImage(imageFile)) {
                commandLine.addParameter(VfsUtilCore.virtualToIoFile((VirtualFile)imageFile).getAbsolutePath());
            }
            commandLine.setWorkDirectory(new File(executablePath).getParentFile());
            try {
                commandLine.createProcess();
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                ImagesConfigurable.show(e.getProject());
            }
        } else {
            try {
                Desktop.getDesktop().open(imageFile.toNioPath().toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = enabled = file != null && ImageFileTypeManager.getInstance().isImage(file);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

