/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.ide;

import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.inspectors.common.api.actions.NavigateToCodeAction;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.intellij.ide.actions.CopyAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IntellijContextMenuInstaller
implements ContextMenuInstaller {
    private static final String COMPONENT_CONTEXT_MENU = "ComponentContextMenu";
    private int myCachedX = -1;

    @Override
    public void installGenericContextMenu(final @NotNull JComponent component, final @NotNull ContextMenuItem contextMenuItem, final @NotNull IntPredicate itemEnabled, final @NotNull IntConsumer callback) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        if (contextMenuItem.equals(ContextMenuItem.SEPARATOR)) {
            popupGroup.addSeparator();
            return;
        }
        if (contextMenuItem.equals(ContextMenuItem.COPY)) {
            popupGroup.add((AnAction)new CopyAction(){

                public void update(@NotNull AnActionEvent event) {
                    super.update(event);
                    event.getPresentation().setText(contextMenuItem.getText());
                    event.getPresentation().setIcon(contextMenuItem.getIcon());
                    this.registerCustomShortcutSet(CommonShortcuts.getCopy(), component);
                }
            });
            return;
        }
        AnAction action = new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setText(contextMenuItem.getText());
                presentation.setIcon(contextMenuItem.getIcon());
                presentation.setEnabled(itemEnabled.test(IntellijContextMenuInstaller.this.myCachedX));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                callback.accept(IntellijContextMenuInstaller.this.myCachedX);
            }
        };
        action.registerCustomShortcutSet(new ShortcutSet(){

            @NotNull
            public Shortcut[] getShortcuts() {
                return (Shortcut[])Arrays.stream(contextMenuItem.getKeyStrokes()).filter(keyStroke -> keyStroke != null).map(keyStroke -> new KeyboardShortcut(keyStroke, null)).toArray(Shortcut[]::new);
            }
        }, component);
        popupGroup.add(action);
    }

    @Override
    public void installNavigationContextMenu(@NotNull JComponent component, @NotNull CodeNavigator navigator, @NotNull Supplier<CodeLocation> codeLocationSupplier) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        popupGroup.add((AnAction)new NavigateToCodeAction(codeLocationSupplier, navigator));
    }

    @NotNull
    private DefaultActionGroup createOrGetActionGroup(@NotNull JComponent component) {
        DefaultActionGroup actionGroup = (DefaultActionGroup)component.getClientProperty(COMPONENT_CONTEXT_MENU);
        if (actionGroup == null) {
            final DefaultActionGroup newActionGroup = new DefaultActionGroup();
            component.putClientProperty(COMPONENT_CONTEXT_MENU, newActionGroup);
            component.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    IntellijContextMenuInstaller.this.myCachedX = x;
                    ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)newActionGroup).getComponent().show(comp, x, y);
                }
            });
            actionGroup = newActionGroup;
        }
        return actionGroup;
    }
}

