/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(CidrEnvironmentUtil.class);
    public static final String envCommand = "env";
    private static final String envNullFlag = "--null";
    private static final String sourcePosixCommand = ".";
    private static final String redirectOutput = "1> /dev/null ";
    private static final String fallbackShellAdvancedSetting = "cidr.util.fallback.shell";

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host) throws IOException, ExecutionException {
        return CidrEnvironmentUtil.readLinuxEnvironmentFromFile(file, host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull Path file, @NotNull HostMachine host) throws IOException, ExecutionException {
        return CidrEnvironmentUtil.readLinuxEnvironmentFromFile(file.toString(), host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host, @Nullable String interpreterPath, @Nullable String envPath) throws IOException, ExecutionException {
        String envCommand = envPath == null ? envCommand : envPath;
        boolean envSupportsNullFlag = CidrEnvironmentUtil.testEnvForNullFlag(host, envCommand);
        if (interpreterPath == null && (interpreterPath = CidrEnvironmentUtil.getShellPath(host, envCommand, envSupportsNullFlag)) == null) {
            LOG.warn("SHELL is not found in environment, falling back to advanced setting cidr.util.fallback.shell");
            interpreterPath = AdvancedSettings.getString((String)fallbackShellAdvancedSetting);
        }
        StringBuilder envCommandStringBuilder = new StringBuilder(envCommand);
        if (envSupportsNullFlag) {
            envCommandStringBuilder.append(" ").append(envNullFlag);
        }
        String sourceCommandString = ". " + CommandLineUtil.posixQuote((String)file) + " 1> /dev/null && " + envCommandStringBuilder;
        GeneralCommandLine readShellEnvCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", envCommandStringBuilder.toString()});
        GeneralCommandLine readShellEnvWithFileCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", sourceCommandString});
        Map<String, String> shellEnv = CidrEnvironmentUtil.runCommandAndParseEnv(readShellEnvCommand, host, envSupportsNullFlag);
        Map<String, String> shellEnvWithFile = CidrEnvironmentUtil.runCommandAndParseEnv(readShellEnvWithFileCommand, host, envSupportsNullFlag);
        return CidrEnvironmentUtil.subtractEnvironments(shellEnvWithFile, shellEnv);
    }

    @Nullable
    private static String getShellPath(@NotNull HostMachine host, String envCommand, boolean envSupportsNullFlag) throws ExecutionException, IOException {
        GeneralCommandLine envCmd = new GeneralCommandLine();
        envCmd.setExePath(envCommand);
        if (envSupportsNullFlag) {
            envCmd.addParameter(envNullFlag);
        }
        Map<String, String> initialEnv = CidrEnvironmentUtil.runCommandAndParseEnv(envCmd, host, envSupportsNullFlag);
        return initialEnv.getOrDefault("SHELL", null);
    }

    private static boolean testEnvForNullFlag(@NotNull HostMachine host, @NotNull String envPath) {
        GeneralCommandLine envTestCmd = new GeneralCommandLine(new String[]{envPath, envNullFlag});
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{envTestCmd});
        try {
            ProcessOutput output = host.runProcess(envTestCmd, HostUtilKt.getReadEnvironmentFileTimeoutMs());
            return output.checkSuccess(CidrLogService.LOG);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    private static Map<String, String> runCommandAndParseEnv(@NotNull GeneralCommandLine shellSourceCmd, @NotNull HostMachine host, final boolean envSupportsNullFlag) throws ExecutionException, IOException {
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{shellSourceCmd});
        final ProcessOutput sourceOutput = host.runProcess(shellSourceCmd.withEnvironment("LC_ALL", "C.UTF-8"), CidrRunProcessUtil.getProgressIndicator(), HostUtilKt.getReadEnvironmentFileTimeoutMs());
        if (!sourceOutput.checkSuccess(CidrLogService.LOG)) {
            throw new IOException(sourceOutput.getStderr());
        }
        return new HashMap<String, String>(){
            {
                Arrays.stream(sourceOutput.getStdout().split(envSupportsNullFlag ? "\u0000" : "\n")).forEach((? super T string) -> {
                    int index = string.indexOf("=");
                    if (index > 0) {
                        this.put(string.substring(0, index), string.substring(index + 1));
                    }
                });
            }
        };
    }

    @NotNull
    public static Map<String, String> subtractEnvironments(@NotNull Map<String, String> sourcedEnv, @NotNull Map<String, String> originalEnv) {
        HashMap<String, String> result2 = new HashMap<String, String>(sourcedEnv);
        originalEnv.forEach((key, value) -> {
            if (result2.containsKey(key) && Objects.equals(value, result2.get(key))) {
                result2.remove(key);
            }
        });
        return result2;
    }
}

