/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/ForceMappingEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.cidr.debugger"})
public final class ForceMappingEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"cidr.debugger.disasm.force.mapping");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        VirtualFile frameFile;
        String sourcePath;
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)DisasmFileType.INSTANCE)) {
            return null;
        }
        if (!(file instanceof MemoryViewFile)) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)file.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (cidrDebugProcess == null) {
            return null;
        }
        CidrDebugProcess process = cidrDebugProcess;
        XStackFrame xStackFrame = process.getSession().getCurrentStackFrame();
        CidrStackFrame cidrStackFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
        if (cidrStackFrame == null) {
            return null;
        }
        CidrStackFrame frame = cidrStackFrame;
        String string = frame.getFrame().getFile();
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(sourcePath = string)).length() == 0 || frame.hasSourceFile()) {
            return null;
        }
        VirtualFile virtualFile = frameFile = VfsUtil.findFile((Path)Paths.get(sourcePath, new String[0]), (boolean)true);
        boolean frameFileExists = (virtualFile != null ? virtualFile.exists() : false) && !frameFile.isDirectory();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        if (frameFileExists) {
            var10_10 = new Object[]{PathUtil.getFileName((String)sourcePath)};
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.exists", var10_10));
        } else {
            var10_10 = new Object[]{PathUtil.getFileName((String)sourcePath)};
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping", var10_10));
        }
        DebuggerSourceFileHash sourceHash = frame.getFrame().getHash();
        if (frameFile != null && frameFileExists) {
            panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.use.it.anyway", new Object[0]), () -> ForceMappingEditorNotificationProvider.createNotificationPanel$lambda$0(process, sourcePath, sourceHash, frameFile));
        }
        panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.select.file", new Object[0]), () -> ForceMappingEditorNotificationProvider.createNotificationPanel$lambda$1(project, fileEditor, process, sourcePath, sourceHash));
        return panel2;
    }

    private static final void createNotificationPanel$lambda$0(CidrDebugProcess $process, String $sourcePath, DebuggerSourceFileHash $sourceHash, VirtualFile $frameFile) {
        $process.getSourceFileLocator().forceFileMapping($sourcePath, $sourceHash, $frameFile, false);
    }

    private static final void createNotificationPanel$lambda$1(Project $project, FileEditor $fileEditor, CidrDebugProcess $process, String $sourcePath, DebuggerSourceFileHash $sourceHash) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, $project, (Component)$fileEditor.getComponent());
        VirtualFile[] virtualFileArray = new VirtualFile[]{ProjectUtil.guessProjectDir((Project)$project)};
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])fileChooser.choose($project, virtualFileArray));
        if (virtualFile == null) {
            return;
        }
        VirtualFile chosenFile = virtualFile;
        $process.getSourceFileLocator().forceFileMapping($sourcePath, $sourceHash, chosenFile, true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/ForceMappingEditorNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

