/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.InternalMutableIntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JP\u0010\u001a\u001aB\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u0003 \u001b* \u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\b0\b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/IntervalTreeMap;", "Ljava/util/TreeMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "map", "Ljava/util/NavigableMap;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/NavigableMap;)V", "intervals", "", "getIntervals", "()Ljava/util/Collection;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "contains", "", "interval", "get", "address", "put", "remove", "", "removeAll", "span", "subMapView", "kotlin.jvm.PlatformType", "rangeSpan", "intellij.cidr.debugger"})
final class IntervalTreeMap
extends TreeMap<Address, Interval>
implements InternalMutableIntervalMap {
    @NotNull
    private final AddressRange range;

    public IntervalTreeMap(@NotNull AddressRange range, @NotNull NavigableMap<Address, Interval> map) {
        super((SortedMap)map);
        this.range = range;
    }

    public /* synthetic */ IntervalTreeMap(AddressRange addressRange, NavigableMap navigableMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            navigableMap = AddressSpaceKt.access$getEMPTY_NAVIGABLE_MAP$p();
        }
        this(addressRange, navigableMap);
    }

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    @NotNull
    public Collection<Interval> getIntervals() {
        return this.values();
    }

    @Override
    @NotNull
    public Interval get(@NotNull Address address2) {
        return (Interval)this.floorEntry(AddressSpaceKt.access$requireAddressInArena(this, address2)).getValue();
    }

    @Override
    @NotNull
    public InternalMutableIntervalMap get(@NotNull AddressRange range) {
        boolean bl;
        IntervalTreeMap intervalTreeMap;
        AddressRange rangeSpan = this.span(range);
        IntervalTreeMap it = intervalTreeMap = new IntervalTreeMap(rangeSpan, this.subMapView(rangeSpan));
        boolean bl2 = false;
        boolean bl3 = bl = !it.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return intervalTreeMap;
    }

    @Override
    public boolean contains(@NotNull Interval interval) {
        return Intrinsics.areEqual((Object)this.get((Object)interval.getRange().getStart()), (Object)interval);
    }

    @Override
    @NotNull
    public AddressRange span(@NotNull AddressRange range) {
        Address address2;
        Address start;
        AddressSpaceKt.access$requireAddressRangeIntersectsArena(this, range);
        Address address3 = this.floorKey(range.getStart());
        if (address3 == null) {
            address3 = start = this.getRange().getStart();
        }
        if ((address2 = this.higherKey(range.getEndInclusive())) == null || (address2 = address2.minus(1)) == null) {
            address2 = this.getRange().getEndInclusive();
        }
        Address endInclusive = address2;
        return (AddressRange)AddressUtil.checkNotEmpty((ClosedRange)AddressUtil.addressRangeInclusive(start, endInclusive));
    }

    private final NavigableMap<Address, Interval> subMapView(AddressRange rangeSpan) {
        return this.subMap(rangeSpan.getStart(), true, rangeSpan.getEndInclusive(), true);
    }

    @Override
    public void removeAll(@NotNull AddressRange range) {
        this.subMapView(this.span(range)).clear();
    }

    @Override
    public void remove(@NotNull Interval interval) {
        Interval oldInterval = (Interval)this.remove((Object)interval.getRange().getStart());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)oldInterval, (Object)interval)) {
            boolean bl2 = false;
            String string = "Removed unexpected interval " + oldInterval;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @Nullable
    public Interval put(@NotNull Interval interval) {
        Interval interval2;
        AddressRange range = interval.getRange();
        Address start = range.getStart();
        if (!this.getRange().contains(range)) {
            boolean $i$a$-require-IntervalTreeMap$put$22 = false;
            String $i$a$-require-IntervalTreeMap$put$22 = "Interval must be allocated within arena range";
            throw new IllegalArgumentException($i$a$-require-IntervalTreeMap$put$22.toString());
        }
        Interval oldInterval = interval2 = this.put(start, interval);
        boolean bl = false;
        if (!(oldInterval == null || oldInterval.getRange().contains(range))) {
            boolean $i$a$-check-IntervalTreeMap$put$2$42 = false;
            String $i$a$-check-IntervalTreeMap$put$2$42 = "Attempting unsafe region replacement";
            throw new IllegalStateException($i$a$-check-IntervalTreeMap$put$2$42.toString());
        }
        if (start.compareTo(this.getRange().getStart()) > 0 && !Intrinsics.areEqual((Object)((Interval)this.get((Object)start.minus(1))).getRange().getEndInclusive(), (Object)start.minus(1))) {
            boolean $i$a$-check-IntervalTreeMap$put$2$52 = false;
            String $i$a$-check-IntervalTreeMap$put$2$52 = "New region put next to a hole (must be adjacent)";
            throw new IllegalStateException($i$a$-check-IntervalTreeMap$put$2$52.toString());
        }
        if (!(this.get((Object)range.getEndInclusive()) == interval)) {
            boolean bl2 = false;
            String string = "New region overlaps a subsequent";
            throw new IllegalStateException(string.toString());
        }
        return interval2;
    }
}

