/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.ErrorDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.MemoryLineInfoProvider;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewVirtualFileSystem;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001PBA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%J\u0012\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020#J5\u0010+\u001a\u0002H,\"\u0004\b\u0001\u0010,2\u0006\u0010*\u001a\u00020#2\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/\u0012\u0004\u0012\u0002H,0.H\u0002\u00a2\u0006\u0002\u00100J%\u00101\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%022\u0006\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J,\u00104\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u0000062\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u0010\u0010;\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J5\u0010<\u001a\u0002H,\"\u0004\b\u0001\u0010,2\u0006\u0010*\u001a\u00020#2\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/\u0012\u0004\u0012\u0002H,0.H\u0002\u00a2\u0006\u0002\u00100J(\u0010=\u001a\u00020>2\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/H\u0002J$\u0010A\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00000/2\f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0002J7\u0010B\u001a\u0004\u0018\u0001H,\"\u0004\b\u0001\u0010,2\u0006\u0010*\u001a\u00020#2\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/\u0012\u0004\u0012\u0002H,0.H\u0002\u00a2\u0006\u0002\u00100J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020EH\u0007J&\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00000/*\b\u0012\u0004\u0012\u00028\u00000G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00000IH\u0002J2\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000/*\b\u0012\u0004\u0012\u00028\u00000G2\u0006\u0010*\u001a\u00020#2\u0010\b\u0002\u0010K\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/H\u0002J&\u0010L\u001a\u00020>*\b\u0012\u0004\u0012\u00028\u00000G2\u0012\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/0NH\u0002J \u0010O\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00028\u00000G2\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Q"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryLineInfoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "dataProvider", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "docRegionFactory", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getDataProvider", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "docAccess", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDocAccess;", "getName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFile;", "getVirtualFile", "()Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFile;", "cleanupErrors", "", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getAddressForLine", "line", "", "getAddressPosition", "address", "getOrRequestRegionInfo", "R", "getRegionInfoInReadAction", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getRangePositionsAndFetchInside", "Lkotlin/Pair;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleDataLoadCompletion", "loading", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Loading;", "docRegion", "unallocateOnCancellation", "", "markOutdated", "refresh", "requestRegionInfo", "textRangeBetween", "Lcom/intellij/openapi/util/TextRange;", "first", "last", "textRangeSpan", "tryReadRegionInfo", "waitForLoad", "timeoutMs", "", "createAndAllocateDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDocAccess$DocAccessScope;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "requestRegion", "oldDocRegion", "textRangeOf", "space", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "unallocateAndDeleteDocRegion", "DocRegionFactory", "intellij.cidr.debugger"})
public final class CidrMemoryDoc<T>
implements MemoryLineInfoProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final CidrMemoryData.DataProvider<T> dataProvider;
    @NotNull
    private final DocRegionFactory<T> docRegionFactory;
    @NotNull
    private final String name;
    @NotNull
    private final MemoryViewFile virtualFile;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CidrMemoryDocAccess<T> docAccess;

    public CidrMemoryDoc(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull CidrMemoryData.DataProvider<T> dataProvider, @NotNull DocRegionFactory<T> docRegionFactory, @NotNull FileType fileType, @NotNull String name) {
        Disposable disposable;
        this.project = project;
        this.dataProvider = dataProvider;
        this.docRegionFactory = docRegionFactory;
        this.name = name;
        this.virtualFile = MemoryViewVirtualFileSystem.Companion.getInstance().createMemoryViewFile(this, this.name, fileType);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("CidrMemoryDoc")));
        this.docAccess = new CidrMemoryDocAccess<T>(this.dataProvider, (VirtualFile)this.virtualFile);
        Disposable it = disposable = () -> CidrMemoryDoc._init_$lambda$2(this);
        boolean bl = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CidrMemoryData.DataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final MemoryViewFile getVirtualFile() {
        return this.virtualFile;
    }

    public final void markOutdated(@NotNull AddressRange range) {
        this.docAccess.edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Unit>(range){
            final /* synthetic */ AddressRange $range;
            {
                this.$range = $range;
                super(1);
            }

            public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                Iterable $this$forEach$iv = $this$edit.getAddressSpace().get(this.$range).filterRegions();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DocRegion it = (DocRegion)element$iv;
                    boolean bl = false;
                    it.markOutdated();
                }
            }
        });
    }

    public static /* synthetic */ void markOutdated$default(CidrMemoryDoc cidrMemoryDoc, AddressRange addressRange, int n, Object object) {
        if ((n & 1) != 0) {
            addressRange = AddressRange.WHOLE;
        }
        cidrMemoryDoc.markOutdated(addressRange);
    }

    public final void cleanupErrors(@NotNull AddressRange range) {
        this.docAccess.edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Unit>(range, this){
            final /* synthetic */ AddressRange $range;
            final /* synthetic */ CidrMemoryDoc<T> this$0;
            {
                this.$range = $range;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                void $this$forEach$iv;
                Iterable iterable = $this$edit.getAddressSpace().get(this.$range).filterRegions();
                CidrMemoryDoc<T> cidrMemoryDoc = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DocRegion docRegion2 = (DocRegion)element$iv;
                    boolean bl = false;
                    if (!(docRegion2.getDataRegion() instanceof CidrMemoryData.DataRegion.Completed.LoadError)) continue;
                    CidrMemoryDoc.access$unallocateAndDeleteDocRegion(cidrMemoryDoc, $this$edit, docRegion2);
                }
            }
        });
    }

    public static /* synthetic */ void cleanupErrors$default(CidrMemoryDoc cidrMemoryDoc, AddressRange addressRange, int n, Object object) {
        if ((n & 1) != 0) {
            addressRange = AddressRange.WHOLE;
        }
        cidrMemoryDoc.cleanupErrors(addressRange);
    }

    public final void refresh(@NotNull AddressRange range) {
        this.docAccess.edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Unit>(range, this){
            final /* synthetic */ AddressRange $range;
            final /* synthetic */ CidrMemoryDoc<T> this$0;
            {
                this.$range = $range;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                void $this$forEach$iv;
                $this$edit.getData().invalidateRange(this.$range);
                Iterable iterable = $this$edit.getAddressSpace().get(this.$range).filterRegions();
                CidrMemoryDoc<T> cidrMemoryDoc = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DocRegion it = (DocRegion)element$iv;
                    boolean bl = false;
                    CidrMemoryDoc.access$requestRegion(cidrMemoryDoc, $this$edit, it.getRange().getStart(), it);
                }
            }
        });
    }

    public static /* synthetic */ void refresh$default(CidrMemoryDoc cidrMemoryDoc, AddressRange addressRange, int n, Object object) {
        if ((n & 1) != 0) {
            addressRange = AddressRange.WHOLE;
        }
        cidrMemoryDoc.refresh(addressRange);
    }

    private final <R> R getOrRequestRegionInfo(Address address2, Function1<? super DocRegion<T>, ? extends R> getRegionInfoInReadAction) {
        R r = this.tryReadRegionInfo(address2, getRegionInfoInReadAction);
        if (r == null) {
            r = this.requestRegionInfo(address2, getRegionInfoInReadAction);
        }
        return r;
    }

    private final <R> R tryReadRegionInfo(Address address2, Function1<? super DocRegion<T>, ? extends R> getRegionInfoInReadAction) {
        return this.docAccess.read((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, R>(address2, getRegionInfoInReadAction){
            final /* synthetic */ Address $address;
            final /* synthetic */ Function1<DocRegion<T>, R> $getRegionInfoInReadAction;
            {
                this.$address = $address;
                this.$getRegionInfoInReadAction = $getRegionInfoInReadAction;
                super(1);
            }

            @Nullable
            public final R invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$read) {
                Object object;
                DocRegion docRegion2 = (DocRegion)$this$read.getAddressSpace().getRegion(this.$address);
                if (docRegion2 != null) {
                    DocRegion docRegion3 = docRegion2;
                    object = this.$getRegionInfoInReadAction.invoke((Object)docRegion3);
                } else {
                    object = null;
                }
                return (R)object;
            }
        });
    }

    private final <R> R requestRegionInfo(Address address2, Function1<? super DocRegion<T>, ? extends R> getRegionInfoInReadAction) {
        return this.docAccess.edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, R>(address2, this, getRegionInfoInReadAction){
            final /* synthetic */ Address $address;
            final /* synthetic */ CidrMemoryDoc<T> this$0;
            final /* synthetic */ Function1<DocRegion<T>, R> $getRegionInfoInReadAction;
            {
                this.$address = $address;
                this.this$0 = $receiver;
                this.$getRegionInfoInReadAction = $getRegionInfoInReadAction;
                super(1);
            }

            public final R invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                DocRegion docRegion2 = (DocRegion)$this$edit.getAddressSpace().getRegion(this.$address);
                if (docRegion2 == null) {
                    docRegion2 = CidrMemoryDoc.requestRegion$default(this.this$0, $this$edit, this.$address, null, 2, null);
                }
                DocRegion docRegion3 = docRegion2;
                return (R)this.$getRegionInfoInReadAction.invoke((Object)docRegion3);
            }
        });
    }

    private final DocRegion<T> requestRegion(CidrMemoryDocAccess.DocAccessScope<T> $this$requestRegion, Address address2, DocRegion<T> oldDocRegion) {
        DocRegion<T> docRegion2;
        CidrMemoryData.DataRegion<T> dataRegion = $this$requestRegion.getData().getOrFetchRangeForAddress(this.coroutineScope, address2);
        DocRegion<T> it = docRegion2 = oldDocRegion;
        boolean bl = false;
        DocRegion<T> docRegion3 = dataRegion instanceof CidrMemoryData.DataRegion.Loading ? docRegion2 : null;
        if (docRegion3 == null) {
            docRegion3 = this.createAndAllocateDocRegion($this$requestRegion, dataRegion);
        }
        DocRegion<T> docRegion4 = docRegion3;
        AddressUtil.requireInRange(address2, docRegion4.getRange());
        if (dataRegion instanceof CidrMemoryData.DataRegion.Loading) {
            ApplicationManager.getApplication().invokeLater(() -> CidrMemoryDoc.requestRegion$lambda$5(this, dataRegion, docRegion4, oldDocRegion));
        }
        return docRegion4;
    }

    static /* synthetic */ DocRegion requestRegion$default(CidrMemoryDoc cidrMemoryDoc, CidrMemoryDocAccess.DocAccessScope docAccessScope, Address address2, DocRegion docRegion2, int n, Object object) {
        if ((n & 2) != 0) {
            docRegion2 = null;
        }
        return cidrMemoryDoc.requestRegion(docAccessScope, address2, docRegion2);
    }

    private final void handleDataLoadCompletion(CidrMemoryData.DataRegion.Loading<T> loading, DocRegion<T> docRegion2, boolean unallocateOnCancellation) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loading, this, docRegion2, unallocateOnCancellation, null){
            int label;
            final /* synthetic */ CidrMemoryData.DataRegion.Loading<T> $loading;
            final /* synthetic */ CidrMemoryDoc<T> this$0;
            final /* synthetic */ DocRegion<T> $docRegion;
            final /* synthetic */ boolean $unallocateOnCancellation;
            {
                this.$loading = $loading;
                this.this$0 = $receiver;
                this.$docRegion = $docRegion;
                this.$unallocateOnCancellation = $unallocateOnCancellation;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$loading.awaitCompleted((Continuation)this);
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var3_3 = (CidrMemoryData.DataRegion.Completed)v0;
                        }
                        catch (CancellationException e) {
                            CidrMemoryDoc.access$getDocAccess$p(this.this$0).edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Unit>(this.$docRegion, this.$unallocateOnCancellation, this.this$0){
                                final /* synthetic */ DocRegion<T> $docRegion;
                                final /* synthetic */ boolean $unallocateOnCancellation;
                                final /* synthetic */ CidrMemoryDoc<T> this$0;
                                {
                                    this.$docRegion = $docRegion;
                                    this.$unallocateOnCancellation = $unallocateOnCancellation;
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                                    if (!$this$edit.getAddressSpace().contains(this.$docRegion)) {
                                        return;
                                    }
                                    if (this.$unallocateOnCancellation) {
                                        CidrMemoryDoc.access$unallocateAndDeleteDocRegion(this.this$0, $this$edit, this.$docRegion);
                                    }
                                }
                            });
                            throw e;
                        }
                        completed = var3_3;
                        CidrMemoryDoc.access$getDocAccess$p(this.this$0).edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Unit>(this.$docRegion, this.this$0, completed){
                            final /* synthetic */ DocRegion<T> $docRegion;
                            final /* synthetic */ CidrMemoryDoc<T> this$0;
                            final /* synthetic */ CidrMemoryData.DataRegion.Completed<T> $completed;
                            {
                                this.$docRegion = $docRegion;
                                this.this$0 = $receiver;
                                this.$completed = $completed;
                                super(1);
                            }

                            public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$edit) {
                                if (!$this$edit.getAddressSpace().contains(this.$docRegion)) {
                                    return;
                                }
                                CidrMemoryDoc.access$createAndAllocateDocRegion(this.this$0, $this$edit, this.$completed);
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final DocRegion<T> createAndAllocateDocRegion(CidrMemoryDocAccess.DocAccessScope<T> $this$createAndAllocateDocRegion, CidrMemoryData.DataRegion<T> dataRegion) {
        Ref ref = new Ref();
        DocumentUtil.executeInBulk((Document)((Document)$this$createAndAllocateDocRegion.getDocument()), () -> CidrMemoryDoc.createAndAllocateDocRegion$lambda$7($this$createAndAllocateDocRegion, dataRegion, this, ref));
        return (DocRegion)ref.get();
    }

    private final void unallocateAndDeleteDocRegion(CidrMemoryDocAccess.DocAccessScope<T> $this$unallocateAndDeleteDocRegion, DocRegion<T> docRegion2) {
        $this$unallocateAndDeleteDocRegion.getAddressSpace().unallocate((DocRegion<T>)((AddressSpace.Region)docRegion2));
        docRegion2.deleteFromDocument();
    }

    private final TextRange textRangeOf(CidrMemoryDocAccess.DocAccessScope<T> $this$textRangeOf, AddressSpace<DocRegion<T>> space) {
        List<DocRegion<T>> regions = space.filterRegions();
        if (!((Collection)regions).isEmpty()) {
            return this.textRangeSpan((DocRegion)CollectionsKt.first(regions), (DocRegion)CollectionsKt.last(regions));
        }
        Pair<DocRegion<T>, DocRegion<T>> pair = $this$textRangeOf.getAddressSpace().getNeighbors(space.getRange());
        DocRegion prev = (DocRegion)pair.component1();
        DocRegion next = (DocRegion)pair.component2();
        return this.textRangeBetween(prev, next);
    }

    private final TextRange textRangeSpan(DocRegion<T> first, DocRegion<T> last) {
        int startOffset = first.getTextRange().getStartOffset();
        int endOffset = last.getTextRange().getEndOffset();
        return new TextRange(startOffset, endOffset);
    }

    private final TextRange textRangeBetween(DocRegion<T> first, DocRegion<T> last) {
        int n;
        int n2;
        TextRange textRange = first;
        Integer firstEndOffset = textRange != null && (textRange = textRange.getTextRange()) != null ? Integer.valueOf(textRange.getEndOffset()) : null;
        TextRange textRange2 = last;
        Integer lastStartOffset = textRange2 != null && (textRange2 = textRange2.getTextRange()) != null ? Integer.valueOf(textRange2.getStartOffset()) : null;
        Integer n3 = firstEndOffset;
        if (n3 != null) {
            n2 = n3;
        } else {
            Integer n4 = lastStartOffset;
            n2 = n4 != null ? n4 : 0;
        }
        int startOffset = n2;
        Integer n5 = lastStartOffset;
        if (n5 != null) {
            n = n5;
        } else {
            Integer n6 = firstEndOffset;
            n = n6 != null ? n6 : 0;
        }
        int endOffset = n;
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public final XSourcePosition getAddressPosition(@NotNull Address address2) {
        Project project = this.project;
        MemoryViewFile memoryViewFile = this.virtualFile;
        return new XSourcePosition(this, address2, project, memoryViewFile){
            final /* synthetic */ CidrMemoryDoc<T> this$0;
            final /* synthetic */ Address $address;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                super($super_call_param$1, (VirtualFile)$super_call_param$2);
            }

            public int getLine() {
                return ((Number)CidrMemoryDoc.access$getOrRequestRegionInfo(this.this$0, this.$address, (Function1)new Function1<DocRegion<T>, Integer>(this.$address){
                    final /* synthetic */ Address $address;
                    {
                        this.$address = $address;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull DocRegion<T> region2) {
                        return region2.getLineNumberInDocument(this.$address);
                    }
                })).intValue();
            }

            public int getColumn() {
                return 0;
            }

            public int getOffset() {
                return ((Number)CidrMemoryDoc.access$getOrRequestRegionInfo(this.this$0, this.$address, (Function1)new Function1<DocRegion<T>, Integer>(this.$address){
                    final /* synthetic */ Address $address;
                    {
                        this.$address = $address;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull DocRegion<T> region2) {
                        return region2.getOffsetInDocument(this.$address);
                    }
                })).intValue();
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project) {
                return (Navigatable)this;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRangePositionsAndFetchInside(@NotNull AddressRange var1_1, @NotNull Continuation<? super Pair<? extends XSourcePosition, ? extends XSourcePosition>> var2_2) {
        if (!(var2_2 instanceof getRangePositionsAndFetchInside.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ CidrMemoryDoc<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRangePositionsAndFetchInside(null, (Continuation<Pair<XSourcePosition, XSourcePosition>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                addressInside = new Ref.ObjectRef();
                addressInside.element = range.getStart();
                prevAddressInside = (Address)addressInside.element;
                hasChanged = 1;
lbl16:
                // 3 sources

                while (((Address)addressInside.element).compareTo(range.getEndInclusive()) <= 0 && hasChanged != 0 && !((region = (DocRegion)this.getOrRequestRegionInfo((Address)addressInside.element, (Function1)new Function1<DocRegion<T>, DocRegion<T>>((Ref.ObjectRef<Address>)addressInside){
                    final /* synthetic */ Ref.ObjectRef<Address> $addressInside;
                    {
                        this.$addressInside = $addressInside;
                        super(1);
                    }

                    @NotNull
                    public final DocRegion<T> invoke(@NotNull DocRegion<T> region2) {
                        this.$addressInside.element = ((Address)this.$addressInside.element).plus(Address.Companion.getCoercing(region2.getRange().getSize()));
                        return region2;
                    }
                })) instanceof ErrorDocRegion)) {
                    hasChanged = Intrinsics.areEqual((Object)addressInside.element, (Object)prevAddressInside) == false ? 1 : 0;
                    prevAddressInside = (Address)addressInside.element;
                    $continuation.L$0 = this;
                    $continuation.L$1 = range;
                    $continuation.L$2 = addressInside;
                    $continuation.L$3 = prevAddressInside;
                    $continuation.I$0 = hasChanged;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                    if (v0 != var10_5) continue;
                    return var10_5;
                }
                break;
            }
            case 1: {
                hasChanged = $continuation.I$0;
                prevAddressInside = (Address)$continuation.L$3;
                addressInside = (Ref.ObjectRef)$continuation.L$2;
                range = (AddressRange)$continuation.L$1;
                this = (CidrMemoryDoc)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl16
            }
        }
        startPosition = this.getAddressPosition(range.getStart());
        endPosition = this.getAddressPosition(range.getEndInclusive());
        return new Pair((Object)startPosition, (Object)endPosition);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Address getAddress(@NotNull XSourcePosition sourcePosition) {
        return sourcePosition.getFile() == this.virtualFile ? this.getAddressForLine(sourcePosition.getLine()) : null;
    }

    @Override
    @Nullable
    public Address getAddressForLine(int line) {
        return (Address)this.docAccess.read((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<T>, Address>(line){
            final /* synthetic */ int $line;
            {
                this.$line = $line;
                super(1);
            }

            @Nullable
            public final Address invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<T> $this$read) {
                int n;
                List<G> regions = $this$read.getAddressSpace().filterRegions();
                int it = n = CollectionsKt.binarySearch$default(regions, (int)0, (int)0, (Function1)((Function1)new Function1<DocRegion<T>, Integer>(this.$line){
                    final /* synthetic */ int $line;
                    {
                        this.$line = $line;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull DocRegion<T> it) {
                        IntRange lineRange = it.getLineRangeInDocument();
                        return lineRange.getLast() < this.$line ? -1 : (this.$line < lineRange.getFirst() ? 1 : 0);
                    }
                }), (int)3, null);
                boolean bl = false;
                if (it < 0) {
                    return null;
                }
                int n2 = this.$line;
                int it2 = n;
                boolean bl2 = false;
                int foundIndex2 = it2 + (it2 < regions.size() - 1 && ((DocRegion)regions.get(it2 + 1)).getLineRangeInDocument().getFirst() <= n2 ? 1 : 0);
                return ((DocRegion)regions.get(foundIndex2)).getAddressForLineNumberInDocument(this.$line);
            }
        });
    }

    @TestOnly
    public final void waitForLoad(long timeoutMs) {
        while ((DocRegion)this.docAccess.read(waitForLoad.docRegion.1.INSTANCE) != null) {
            DocRegion docRegion2;
            BuildersKt.runBlocking((CoroutineContext)this.coroutineScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeoutMs, docRegion2, null){
                int label;
                final /* synthetic */ long $timeoutMs;
                final /* synthetic */ DocRegion<T> $docRegion;
                {
                    this.$timeoutMs = $timeoutMs;
                    this.$docRegion = $docRegion;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = TimeoutKt.withTimeout((long)this.$timeoutMs, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CidrMemoryData.DataRegion.Completed<T>>, Object>(this.$docRegion, null){
                                int label;
                                final /* synthetic */ DocRegion<T> $docRegion;
                                {
                                    this.$docRegion = $docRegion;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.$docRegion.getDataRegion().awaitCompleted((Continuation)this);
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CidrMemoryData.DataRegion.Completed<T>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = YieldKt.yield((Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        return;
    }

    private static final void lambda$2$lambda$1(CidrMemoryDoc this$0) {
        FileEditorManager.getInstance((Project)this$0.project).closeFile((VirtualFile)this$0.virtualFile);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this$0){
            final /* synthetic */ CidrMemoryDoc this$0;
            {
                this.this$0 = cidrMemoryDoc;
            }

            public final T compute() {
                boolean bl = false;
                this.this$0.getVirtualFile().setWritable(true);
                this.this$0.getVirtualFile().delete(this.this$0);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private static final void _init_$lambda$2(CidrMemoryDoc this$0) {
        AppUIExecutor.onWriteThread().execute(() -> CidrMemoryDoc.lambda$2$lambda$1(this$0));
    }

    private static final void requestRegion$lambda$5(CidrMemoryDoc this$0, CidrMemoryData.DataRegion $dataRegion, DocRegion $docRegion, DocRegion $oldDocRegion) {
        this$0.handleDataLoadCompletion((CidrMemoryData.DataRegion.Loading)$dataRegion, $docRegion, $oldDocRegion == null);
    }

    private static final void createAndAllocateDocRegion$lambda$7(CidrMemoryDocAccess.DocAccessScope $this_createAndAllocateDocRegion, CidrMemoryData.DataRegion $dataRegion, CidrMemoryDoc this$0, Ref $ref) {
        MutableAddressSpace unallocatedSpace = $this_createAndAllocateDocRegion.getAddressSpace().unallocate($dataRegion.getRange());
        TextRange textRange = this$0.textRangeOf($this_createAndAllocateDocRegion, unallocatedSpace);
        DocRegion newDocRegion = this$0.docRegionFactory.createDocRegion((Document)$this_createAndAllocateDocRegion.getDocument(), textRange, $dataRegion, unallocatedSpace);
        Iterable $this$forEach$iv = unallocatedSpace.filterRegions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocRegion it = (DocRegion)element$iv;
            boolean bl = false;
            it.deleteFromDocument();
        }
        $ref.set((Object)$this_createAndAllocateDocRegion.getAddressSpace().allocate((AddressSpace.Region)newDocRegion));
    }

    public static final /* synthetic */ void access$unallocateAndDeleteDocRegion(CidrMemoryDoc $this, CidrMemoryDocAccess.DocAccessScope $receiver, DocRegion docRegion2) {
        $this.unallocateAndDeleteDocRegion($receiver, docRegion2);
    }

    public static final /* synthetic */ DocRegion access$requestRegion(CidrMemoryDoc $this, CidrMemoryDocAccess.DocAccessScope $receiver, Address address2, DocRegion oldDocRegion) {
        return $this.requestRegion($receiver, address2, oldDocRegion);
    }

    public static final /* synthetic */ CidrMemoryDocAccess access$getDocAccess$p(CidrMemoryDoc $this) {
        return $this.docAccess;
    }

    public static final /* synthetic */ DocRegion access$createAndAllocateDocRegion(CidrMemoryDoc $this, CidrMemoryDocAccess.DocAccessScope $receiver, CidrMemoryData.DataRegion dataRegion) {
        return $this.createAndAllocateDocRegion($receiver, dataRegion);
    }

    public static final /* synthetic */ Object access$getOrRequestRegionInfo(CidrMemoryDoc $this, Address address2, Function1 getRegionInfoInReadAction) {
        return $this.getOrRequestRegionInfo(address2, getRegionInfoInReadAction);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "T", "", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "intellij.cidr.debugger"})
    public static interface DocRegionFactory<T> {
        @NotNull
        public DocRegion<T> createDocRegion(@NotNull Document var1, @NotNull TextRange var2, @NotNull CidrMemoryData.DataRegion<T> var3, @NotNull AddressSpace<DocRegion<T>> var4);
    }
}

