/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a#\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u001a\u001d\u0010\f\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\f\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0087\u0006\u00a2\u0006\u0002\b\u0019\u001a\u001a\u0010\u001a\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0087\u0004\u00a2\u0006\u0002\b\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\u001a#\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u001a\u0012\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a#\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u001a\u001d\u0010\u001e\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\u001e\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001f\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010 \u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00012\u0006\u0010$\u001a\u00020%\u001a\u0019\u0010&\u001a\u00020\u0002*\u00020\u00012\u0006\u0010'\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\b(\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00012\u0006\u0010)\u001a\u00020\u0016\u001a\u0015\u0010*\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0086\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006+"}, d2={"endCoerced", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getEndCoerced", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "endExclusive", "getEndExclusive", "checkInRange", "range", "lazyMessage", "Lkotlin/Function0;", "", "checkNotEmpty", "T", "Lkotlin/ranges/ClosedRange;", "(Lkotlin/ranges/ClosedRange;)Lkotlin/ranges/ClosedRange;", "(Lkotlin/ranges/ClosedRange;Lkotlin/jvm/functions/Function0;)Lkotlin/ranges/ClosedRange;", "grow", "boundary", "", "positiveReminder", "n", "", "rangeTo", "endInclusive", "addressRangeInclusive", "rangeToExclusive", "addressRangeExclusive", "reminder", "requireInRange", "requireNotEmpty", "roundDown", "roundUp", "slice", "Lkotlin/sequences/Sequence;", "toAlignedBlockRange", "blockSize", "", "toRange", "offsetBytes", "addressToRange", "bytes", "until", "intellij.cidr.debugger.backend"})
@JvmName(name="AddressUtil")
public final class AddressUtil {
    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty) {
        T t;
        T $this$checkNotEmpty$iv = $this$checkNotEmpty;
        boolean $i$f$checkNotEmpty = false;
        T $this$checkNotEmpty_u24lambda_u241$iv = t = $this$checkNotEmpty$iv;
        boolean bl = false;
        if (!(!$this$checkNotEmpty_u24lambda_u241$iv.isEmpty())) {
            boolean bl2 = false;
            String string = "Range must not be empty";
            throw new IllegalStateException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        T t;
        boolean $i$f$checkNotEmpty = false;
        T $this$checkNotEmpty_u24lambda_u241 = t = $this$checkNotEmpty;
        boolean bl = false;
        if (!(!$this$checkNotEmpty_u24lambda_u241.isEmpty())) {
            Object object = lazyMessage.invoke();
            throw new IllegalStateException(object.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty) {
        T t;
        T $this$requireNotEmpty$iv = $this$requireNotEmpty;
        boolean $i$f$requireNotEmpty = false;
        T $this$requireNotEmpty_u24lambda_u243$iv = t = $this$requireNotEmpty$iv;
        boolean bl = false;
        if (!(!$this$requireNotEmpty_u24lambda_u243$iv.isEmpty())) {
            boolean bl2 = false;
            String string = "Range must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        T t;
        boolean $i$f$requireNotEmpty = false;
        T $this$requireNotEmpty_u24lambda_u243 = t = $this$requireNotEmpty;
        boolean bl = false;
        if (!(!$this$requireNotEmpty_u24lambda_u243.isEmpty())) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return t;
    }

    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range) {
        AddressRange addressRange;
        AddressRange $this$checkInRange$iv = $this$checkInRange;
        boolean $i$f$checkInRange = false;
        AddressRange $this$checkInRange_u24lambda_u245$iv = addressRange = $this$checkInRange$iv;
        boolean bl = false;
        if (!range.contains($this$checkInRange_u24lambda_u245$iv)) {
            boolean bl2 = false;
            String string = "Range " + $this$checkInRange + " spans beyond the allowed " + range;
            throw new IllegalStateException(string.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        AddressRange addressRange;
        boolean $i$f$checkInRange = false;
        AddressRange $this$checkInRange_u24lambda_u245 = addressRange = $this$checkInRange;
        boolean bl = false;
        if (!range.contains($this$checkInRange_u24lambda_u245)) {
            Object object = lazyMessage.invoke();
            throw new IllegalStateException(object.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range) {
        Address address2;
        Address $this$requireInRange$iv = $this$requireInRange;
        boolean $i$f$requireInRange = false;
        Address $this$requireInRange_u24lambda_u247$iv = address2 = $this$requireInRange$iv;
        boolean bl = false;
        if (!range.contains((Comparable)$this$requireInRange_u24lambda_u247$iv)) {
            boolean bl2 = false;
            String string = "Address " + $this$requireInRange + " must be within " + range;
            throw new IllegalArgumentException(string.toString());
        }
        return address2;
    }

    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        Address address2;
        boolean $i$f$requireInRange = false;
        Address $this$requireInRange_u24lambda_u247 = address2 = $this$requireInRange;
        boolean bl = false;
        if (!range.contains((Comparable)$this$requireInRange_u24lambda_u247)) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return address2;
    }

    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range) {
        AddressRange addressRange;
        AddressRange $this$requireInRange$iv = $this$requireInRange;
        boolean $i$f$requireInRange = false;
        AddressRange $this$requireInRange_u24lambda_u249$iv = addressRange = $this$requireInRange$iv;
        boolean bl = false;
        if (!range.contains($this$requireInRange_u24lambda_u249$iv)) {
            boolean bl2 = false;
            String string = "Range " + $this$requireInRange + " must be within " + range;
            throw new IllegalArgumentException(string.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        AddressRange addressRange;
        boolean $i$f$requireInRange = false;
        AddressRange $this$requireInRange_u24lambda_u249 = addressRange = $this$requireInRange;
        boolean bl = false;
        if (!range.contains($this$requireInRange_u24lambda_u249)) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final Address getEndCoerced(@NotNull AddressRange $this$endCoerced) {
        return $this$endCoerced.getEndInclusive().plus(Address.Companion.getCoercing(1));
    }

    @NotNull
    public static final Address getEndExclusive(@NotNull AddressRange $this$endExclusive) {
        return $this$endExclusive.getEndInclusive().plus(1);
    }

    @NotNull
    public static final AddressRange grow(@NotNull AddressRange $this$grow, long boundary) {
        return AddressUtil.addressRangeExclusive(AddressUtil.roundDown($this$grow.getStart(), (Number)boundary), AddressUtil.roundUp(AddressUtil.getEndExclusive($this$grow), (Number)boundary));
    }

    @NotNull
    public static final Sequence<AddressRange> slice(@NotNull AddressRange $this$slice, long boundary) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super AddressRange>, Continuation<? super Unit>, Object>($this$slice, boundary, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AddressRange $this_slice;
            final /* synthetic */ long $boundary;
            {
                this.$this_slice = $receiver;
                this.$boundary = $boundary;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (this.$this_slice.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        prev = this.$this_slice.getStart();
lbl10:
                        // 2 sources

                        while (true) {
                            next = (Address)RangesKt.coerceAtMost((Comparable)AddressUtil.roundUp(prev, (Number)Boxing.boxLong((long)this.$boundary)), (Comparable)this.$this_slice.getEndInclusive());
                            this.L$0 = $this$sequence;
                            this.L$1 = next;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)AddressUtil.addressRangeInclusive(prev, next), (Continuation)this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                            break;
                        }
                    }
                    case 1: {
                        next = (Address)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        if (!Intrinsics.areEqual((Object)next, (Object)this.$this_slice.getEndInclusive())) {
                            prev = next.plus(Boxing.boxInt((int)1));
                            ** continue;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super AddressRange> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @JvmName(name="addressToRange")
    @NotNull
    public static final AddressRange addressToRange(@NotNull Address $this$toRange, long offsetBytes) {
        return offsetBytes == 1L ? AddressUtil.addressRangeInclusive($this$toRange, $this$toRange) : (offsetBytes > 0L ? AddressUtil.addressRangeExclusive($this$toRange, $this$toRange.plus(offsetBytes)) : (offsetBytes < 0L ? AddressUtil.addressRangeExclusive($this$toRange.plus(offsetBytes), $this$toRange) : AddressRange.EMPTY));
    }

    @NotNull
    public static final AddressRange toRange(@NotNull Address $this$toRange, @NotNull Number bytes) {
        return AddressUtil.addressToRange($this$toRange, bytes.longValue());
    }

    @NotNull
    public static final AddressRange toAlignedBlockRange(@NotNull Address $this$toAlignedBlockRange, int blockSize) {
        boolean bl;
        AddressRange addressRange;
        AddressRange it = addressRange = AddressUtil.toRange(AddressUtil.roundDown($this$toAlignedBlockRange, (Number)blockSize), blockSize);
        boolean bl2 = false;
        boolean bl3 = bl = it.getSize() == (long)blockSize;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return addressRange;
    }

    @NotNull
    public static final Address roundUp(@NotNull Address $this$roundUp, @NotNull Number n) {
        return Address.Companion.fromUnsignedLong(AddressUtil.roundUp($this$roundUp.getUnsignedLongValue(), n));
    }

    @NotNull
    public static final Address roundDown(@NotNull Address $this$roundDown, @NotNull Number n) {
        return Address.Companion.fromUnsignedLong(AddressUtil.roundDown($this$roundDown.getUnsignedLongValue(), n));
    }

    public static final long reminder(@NotNull Address $this$reminder, @NotNull Number n) {
        return AddressUtil.positiveReminder($this$reminder.getUnsignedLongValue(), n);
    }

    public static final long roundUp(long $this$roundUp, @NotNull Number n) {
        return AddressUtil.roundDown($this$roundUp + n.longValue() - 1L, n);
    }

    public static final long roundDown(long $this$roundDown, @NotNull Number n) {
        return $this$roundDown - AddressUtil.positiveReminder($this$roundDown, n.longValue());
    }

    private static final long positiveReminder(long $this$positiveReminder, Number n) {
        long reminder;
        long l = n.longValue();
        return reminder + ((reminder = $this$positiveReminder % l) < 0L ? l : 0L);
    }

    @JvmName(name="addressRangeInclusive")
    @NotNull
    public static final AddressRange addressRangeInclusive(@NotNull Address $this$rangeTo, @NotNull Address endInclusive) {
        return new AddressRange($this$rangeTo, endInclusive);
    }

    @JvmName(name="addressRangeExclusive")
    @NotNull
    public static final AddressRange addressRangeExclusive(@NotNull Address $this$rangeToExclusive, @NotNull Address endExclusive) {
        return AddressUtil.addressRangeInclusive($this$rangeToExclusive, endExclusive.minus(1));
    }

    @NotNull
    public static final AddressRange until(@NotNull Address $this$until, @NotNull Address endExclusive) {
        return endExclusive.compareTo(Address.MIN_VALUE) <= 0 ? AddressRange.EMPTY : AddressUtil.addressRangeExclusive($this$until, endExclusive);
    }
}

