/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    private static final Pattern SWIFT_DESCRIPTION_PATTERN = Pattern.compile("( *((\u25bf .*)|(- .*? : .*?))(\n|$))*");
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<CidrValueDescription> myValueCache = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<Integer> myChildrenCountCache = new CachedDebuggerResult();

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        this.myValue = value;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        LLValue childVar;
        Long address2;
        LLValueData varData = this.myValue.getPreparedVarData();
        boolean isSynthetic = varData.isSynthetic();
        if (lvalue && isSynthetic && (address2 = (childVar = child.getVar()).getAddress()) != null && ValueRenderer.isValueOfPrimitiveType(childVar)) {
            return "(*(" + childVar.getType() + "*)(0x" + Long.toHexString(address2) + "))";
        }
        boolean isPointer = varData.isPointer();
        boolean isSwift = this.myValue.isSwiftContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            return this.getChildEvaluationExpression(child, "", this.myValue);
        }
        if (!isSwift && isPointer) {
            return this.getChildEvaluationExpression(child, "->", this.myValue);
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                return this.getChildEvaluationExpression(child, "->", value.getContainer());
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                return parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
            }
        }
        return this.getChildEvaluationExpression(child, ".", this.myValue);
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.getData(this.messageSendToSelf(selectorAndArgs, returnType, context));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException {
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            String value = this.computeValueDescription(context).getValue();
            if (this.myValue.getProcess().isRichValueDescriptionEnabled()) {
                value = ValueRendererUtils.extractString(value);
            }
            builder.append("(").append(this.myValue.getType()).append((") " + value).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context, builder);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        return builder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DebuggerCommandException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context);
        try {
            this.computeChildren(context, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return ValueRenderer.getDisplayType(this.getValue());
    }

    @NotNull
    public static String getDisplayType(@NotNull CidrPhysicalValue value) {
        if (!Registry.is((String)"cidr.debugger.frameTypeDecorator", (boolean)true)) {
            return ValueRendererUtils.shortenTemplateType(value.getVar().getType());
        }
        CidrFrameTypeDecorator frameTypeDecorator = value.getFrame().getFrameTypeDecorator();
        return frameTypeDecorator.getValueDisplayType(value, true);
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        String childVarName;
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        Object parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + (String)parentRefExpression + "))";
        }
        return (childVarName = child.getVar().getName()).isBlank() ? parentRefExpression : (String)parentRefExpression + separator + childVarName;
    }

    @NotNull
    public CidrValueDescription computeValueDescription(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<CidrValueDescription>(){

            @Override
            @NotNull
            public CidrValueDescription calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    return new CidrValueDescription(objc ? "nil" : "NULL");
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    return new CidrValueDescription("");
                }
                Pair<String, XFullValueEvaluator> result2 = ValueRenderer.this.doComputeValueAndEvaluator(context);
                String value = (String)result2.first;
                XFullValueEvaluator evaluator = (XFullValueEvaluator)result2.second;
                if (value.equals("{...}")) {
                    return new CidrValueDescription("");
                }
                String pointerAddress = null;
                CidrDebugProcess process = ValueRenderer.this.myValue.getProcess();
                if (!((Boolean)CidrValue.DO_NOT_SHOW_ADDRESSES.get((UserDataHolder)process, (Object)false)).booleanValue() && !((Boolean)CidrValue.DO_NOT_SHOW_ADDRESSES.get((UserDataHolder)process.getProject(), (Object)false)).booleanValue() && (pointerAddress = data.getPointerOrNull()) != null) {
                    value = StringUtil.trimStart((String)value, (String)pointerAddress).stripLeading();
                    pointerAddress = LLValueData.getPresentablePointer(pointerAddress);
                }
                return new CidrValueDescription(value, evaluator, pointerAddress);
            }
        });
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.doComputeValueAndEvaluator(context, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context));
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        String description;
        boolean isRawStringViewEnabled = Registry.is((String)"cidr.debugger.value.stringEvaluator", (boolean)false);
        String value = null;
        XFullValueEvaluator evaluator = null;
        String descriptionOrig = data.getDescription();
        if (descriptionOrig != null) {
            description = descriptionOrig;
            if (this.myValue.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
                description = StringUtil.unescapeStringCharacters((String)description);
            }
            if (!this.ignoreDescription(description = description.trim())) {
                boolean hasLongerDescription = data.hasLongerDescription();
                if (isRawStringViewEnabled && ValueRendererUtils.isBeginQuotedString(description)) {
                    String linkText = CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]);
                    int _10mb = 0xA00000;
                    evaluator = this.createFullDescriptionEvaluator(var, _10mb, linkText, ValueRendererUtils::getRawString);
                } else if (hasLongerDescription) {
                    String linkText = XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]);
                    int _1mb = 0x100000;
                    evaluator = this.createFullDescriptionEvaluator(var, _1mb, linkText, null);
                }
                value = StringUtil.first((String)description, (int)1000, (boolean)false);
            }
        }
        if (value == null) {
            description = this.doComputeFallbackValue(context, var, data);
            if (isRawStringViewEnabled && ValueRendererUtils.isQuotedString(description)) {
                String linkText = CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]);
                evaluator = this.createImmediateDescriptionEvaluator(description, linkText, ValueRendererUtils::getRawString);
            } else if (description.length() > 1000) {
                String linkText = XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]);
                evaluator = this.createImmediateDescriptionEvaluator(description, linkText, null);
            }
            value = StringUtil.first((String)description, (int)1000, (boolean)false);
        }
        return Pair.create(value, evaluator);
    }

    protected boolean ignoreDescription(@NotNull String description) {
        DebuggerDriver.DebuggerLanguage language = this.myValue.getLanguage();
        return language == DebuggerDriver.StandardDebuggerLanguage.OBJC && StringUtil.containsLineBreak((CharSequence)description) || language == DebuggerDriver.StandardDebuggerLanguage.SWIFT && SWIFT_DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        return data.getValue();
    }

    private XFullValueEvaluator createImmediateDescriptionEvaluator(@NotNull String description, @NotNull @Nls String linkText, @Nullable Function<String, String> descriptionProc) {
        if (this.myValue.getProcess().isRichValueDescriptionEnabled()) {
            description = ValueRendererUtils.extractString(description);
        }
        if (descriptionProc != null) {
            description = descriptionProc.apply(description);
        }
        return new ImmediateFullValueEvaluator(linkText, description);
    }

    @NotNull
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value, final int size, @NotNull @Nls String linkText, final @Nullable Function<String, String> descriptionProc) {
        return new XFullValueEvaluator(linkText){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                ValueRenderer.this.getValue().getProcess().postCommand(driver -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    try {
                        String description = driver.getDescription(value, size);
                        description = StringUtil.notNullize((String)description);
                        if (ValueRenderer.this.myValue.getProcess().isRichValueDescriptionEnabled()) {
                            description = ValueRendererUtils.extractString(description);
                        }
                        if (descriptionProc != null) {
                            description = (String)descriptionProc.apply(description);
                        }
                        callback.evaluated(description);
                    }
                    catch (DebuggerCommandException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                });
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        Integer result2;
        if (this.mayHaveChildrenViaChildrenCount() && (result2 = this.computeChildrenCount(context)) != null) {
            return result2 > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                return data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myChildrenCountCache.getResult(new CachedDebuggerResult.Calculator<Integer>(){

            @Override
            @Nullable
            public Integer calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                return data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? Integer.valueOf(0) : ValueRenderer.this.doComputeChildrenCount(context);
            }
        });
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.getChildrenCount(this.myValue.getPresentationVar());
    }

    public final void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (!this.computeMayHaveChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container, 0, null);
    }

    protected int getBatchSize() {
        return ValueRenderer.getPositiveNumberFromRegistry("cidr.debugger.value.maxChildren", 50);
    }

    private static int getPositiveNumberFromRegistry(@NotNull String key, int defaultValue) {
        int value = Registry.intValue((String)key, (int)defaultValue);
        if (value <= 0) {
            CidrDebuggerLog.LOG.warn(key + " must be a positive number, falling back to default value: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, int fromIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result2 = context.getVariableChildren(var, fromIndex, this.getBatchSize());
        this.addChildrenTo(result2.list, context, container, fromIndex, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context)));
        if (result2.hasMore && !result2.list.isEmpty()) {
            int nextIndex = fromIndex + result2.list.size();
            this.tooManyChildren(context, container, nextIndex, totalCount);
        }
    }

    protected void tooManyChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, int nextIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        if (totalCount == null && (totalCount = this.computeChildrenCount(context)) == null) {
            totalCount = -1;
        }
        Integer finalTotalCount = totalCount;
        container.tooManyChildren(totalCount == -1 ? -1 : totalCount - nextIndex, () -> this.getValue().getProcess().postCommand(driver -> CidrPhysicalValue.invokeRenderChildren(container, () -> this.doComputeChildren(context, container, nextIndex, finalTotalCount))));
    }

    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context, @NotNull XCompositeNode container, int startIndex, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        SmartList values = new SmartList();
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            boolean isChildModifiable = modifiable || this.isChildModifiable(each);
            values.add(new CidrMemberValue(each, this.myValue, isChildModifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        return !data.isSynthetic();
    }

    protected boolean isChildModifiable(@NotNull LLValue var) {
        return var.getAddress() != null && ValueRenderer.isValueOfPrimitiveType(var);
    }

    private static boolean isValueOfPrimitiveType(@NotNull LLValue var) {
        LLValue.TypeClass typeClass = var.getTypeClass();
        return typeClass == LLValue.TypeClass.BUILTIN || typeClass == LLValue.TypeClass.POINTER;
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            for (int i = 0; i < children.size(); ++i) {
                String name = children.getName(i);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children.getValue(i)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

