/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorValueRenderer
extends ValueRenderer {
    public SelectorValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Nullable
    public static ValueRenderer createIfSelector(@NotNull ValueRendererFactory.FactoryContext context) {
        String type;
        SelectorValueRenderer result2 = null;
        if (context.getLLValueData().isValidPointer() && SelectorValueRenderer.isSelectorType(type = context.getLLValue().getType())) {
            result2 = new SelectorValueRenderer(context.getPhysicalValue());
        }
        return result2;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String result2 = this.getValue().getVarData(context).getDescription();
        if (StringUtil.isEmptyOrSpaces((String)result2) || StringUtil.unquoteString((String)result2).isEmpty()) {
            String pointer = context.getData(this.myValue.getVar()).getPointer();
            result2 = context.evaluateData("(char *)sel_getName((void *)" + pointer + ")").getPresentableValue();
        }
        return Pair.create((Object)result2, null);
    }

    public static boolean isSelectorType(@NlsSafe @NotNull String type) {
        return type.endsWith("objc_selector *") || type.equals("SEL");
    }
}

