/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedDebuggerResult<T> {
    private volatile Ref<T> myResult = null;
    private volatile ExecutionException myExecutionException = null;
    private volatile DebuggerCommandException myUserException = null;

    @Nullable
    public T getResultIfAvailable() {
        return (T)Ref.deref(this.myResult);
    }

    @NotNull
    public T getResult(NotNullCalculator<T> calculator) throws ExecutionException, DebuggerCommandException {
        return this.getResult((Calculator<T>)calculator);
    }

    @Nullable
    public T getResult(Calculator<T> calculator) throws ExecutionException, DebuggerCommandException {
        if (this.myExecutionException != null) {
            throw this.myExecutionException;
        }
        if (this.myUserException != null) {
            throw this.myUserException;
        }
        Ref result2 = this.myResult;
        if (result2 == null) {
            try {
                this.myResult = result2 = Ref.create(calculator.calculate());
            }
            catch (DebuggerCommandException e) {
                this.myUserException = e;
                throw e;
            }
            catch (ExecutionException e) {
                this.myExecutionException = e;
                throw e;
            }
        }
        return (T)result2.get();
    }

    public static interface Calculator<T> {
        @Nullable
        public T calculate() throws ExecutionException, DebuggerCommandException;
    }

    public static interface NotNullCalculator<T>
    extends Calculator<T> {
        @Override
        @NotNull
        public T calculate() throws ExecutionException, DebuggerCommandException;
    }
}

