/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueRendererFactory {
    public static final ExtensionPointName<ValueRendererFactory> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.valueRendererFactory");

    @Nullable
    public ValueRenderer createRenderer(@NotNull FactoryContext var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public static ValueRenderer createRenderer(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue physicalValue) throws ExecutionException, DebuggerCommandException {
        ValueRendererFactory[] extensions;
        LLValue value = physicalValue.getVar();
        if (!value.isValid()) {
            return new ValueRenderer(physicalValue);
        }
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        if (settings.isRenderersEnabled() && (extensions = (ValueRendererFactory[])EP_NAME.getExtensions()).length > 0) {
            LLValueData valueData = physicalValue.getVarData(evaluationContext);
            FactoryContext factoryContext = new FactoryContext(settings, evaluationContext, physicalValue, value, valueData);
            for (ValueRendererFactory factory : extensions) {
                ValueRenderer result2 = factory.createRenderer(factoryContext);
                if (result2 == null) continue;
                return result2;
            }
        }
        return new ValueRenderer(physicalValue);
    }

    public static class FactoryContext {
        @NotNull
        private final CidrDebuggerSettings mySettings;
        @NotNull
        private final EvaluationContext myEvaluationContext;
        @NotNull
        private final CidrPhysicalValue myPhysicalValue;
        @NotNull
        private final LLValue myLLValue;
        @NotNull
        private final LLValueData myLLValueData;

        public FactoryContext(@NotNull CidrDebuggerSettings settings, @NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue physicalValue, @NotNull LLValue LLValue2, @NotNull LLValueData LLValueData2) {
            this.mySettings = settings;
            this.myEvaluationContext = evaluationContext;
            this.myPhysicalValue = physicalValue;
            this.myLLValue = LLValue2;
            this.myLLValueData = LLValueData2;
        }

        @NotNull
        public CidrDebuggerSettings getSettings() {
            return this.mySettings;
        }

        @NotNull
        public EvaluationContext getEvaluationContext() {
            return this.myEvaluationContext;
        }

        @NotNull
        public CidrPhysicalValue getPhysicalValue() {
            return this.myPhysicalValue;
        }

        @NotNull
        public LLValue getLLValue() {
            return this.myLLValue;
        }

        @NotNull
        public LLValueData getLLValueData() {
            return this.myLLValueData;
        }
    }
}

