/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrFormattedNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberWithAdditionalFormatValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.TextWithPattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0001\u001a\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"POINTER_ATTRIBUTES_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "unsignedHexNumberPattern", "Lkotlin/text/Regex;", "getUnsignedHexNumberPattern", "()Lkotlin/text/Regex;", "createHexValuePresentation", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrNumberValuePresentation;", "value", "", "type", "numberText", "stringText", "number", "", "sizeBits", "", "asSecondaryFormat", "", "formatHexValue", "intellij.cidr.debugger"})
public final class ValuePresentationKt {
    @NotNull
    private static final TextAttributesKey POINTER_ATTRIBUTES_KEY = TextAttributesKey.createTextAttributesKey((String)"DEBUGGER_MEMORY_ADDRESS", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
    @NotNull
    private static final Regex unsignedHexNumberPattern = new Regex("^0x(\\p{XDigit}+)$");

    @NotNull
    public static final Regex getUnsignedHexNumberPattern() {
        return unsignedHexNumberPattern;
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, long number, int sizeBits, boolean asSecondaryFormat) {
        TextWithPattern hexFormattedNumber = new TextWithPattern(ValuePresentationKt.formatHexValue(number, sizeBits), unsignedHexNumberPattern);
        return asSecondaryFormat ? (CidrNumberValuePresentation)new CidrNumberWithAdditionalFormatValuePresentation(value, type, numberText, stringText, hexFormattedNumber) : (CidrNumberValuePresentation)new CidrFormattedNumberValuePresentation(value, type, hexFormattedNumber, stringText);
    }

    public static /* synthetic */ CidrNumberValuePresentation createHexValuePresentation$default(String string, String string2, String string3, String string4, long l, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        return ValuePresentationKt.createHexValuePresentation(string, string2, string3, string4, l, n, bl);
    }

    @NlsSafe
    @NotNull
    public static final String formatHexValue(long number, int sizeBits) {
        long mask = sizeBits < 64 ? (1L << sizeBits) - 1L : -1L;
        return "0x" + Long.toUnsignedString(number & mask, 16);
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, long number, int sizeBits) {
        return ValuePresentationKt.createHexValuePresentation$default(value, type, numberText, stringText, number, sizeBits, false, 64, null);
    }

    public static final /* synthetic */ TextAttributesKey access$getPOINTER_ATTRIBUTES_KEY$p() {
        return POINTER_ATTRIBUTES_KEY;
    }
}

