/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;

public class CidrValueModifier
extends XValueModifier {
    @NotNull
    private final CidrPhysicalValue myValue;

    public CidrValueModifier(@NotNull CidrPhysicalValue value) {
        this.myValue = value;
    }

    public void setValue(@NotNull XExpression expr, @NotNull XValueModifier.XModificationCallback callback) {
        this.myValue.getProcess().postCommand(driver -> {
            try {
                CidrStackFrame frame = this.myValue.getFrame();
                Pair<LLValue, String> valuePair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(frame.getProcess(), driver, expr, frame.getSourcePosition(), frame.getThreadId(), frame.getFrameIndex());
                this.setValue(expr.getExpression(), valuePair, callback, driver);
            }
            catch (DebuggerCommandException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", expr.getExpression(), this.myValue.getName()) + ":\n" + e.getMessage());
                CidrDebuggerLog.LOG.info(e.getMessage());
            }
        });
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    protected void setValue(final @NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, final @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws ExecutionException, DebuggerCommandException {
        EvaluationContext context = this.myValue.createEvaluationContext(driver, null);
        final String qualName = this.myValue.getEvaluationExpression(true);
        String lValueStr = context.convertToLValue(qualName);
        CidrEvaluator evaluator = this.myValue.getFrame().getEvaluator();
        if (evaluator == null) {
            callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName));
            CidrDebuggerLog.LOG.info(this.myValue.getFrame().toString() + " has null evaluator");
            return;
        }
        String rValueStr = context.convertToRValue(this.myValue.getVarData(context), valuePair);
        evaluator.evaluate(lValueStr + "=" + rValueStr, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result2) {
                callback.valueModified();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName) + ":\n" + errorMessage);
                CidrDebuggerLog.LOG.info(errorMessage);
            }
        }, this.myValue.getFrame().getSourcePosition());
    }
}

