/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPointerValuePresentationWrapper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static final Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    public static final Key<Boolean> THREAT_VALUE_AS_RICH_TEXT = Key.create((String)"THREAT_VALUE_AS_RICH_TEXT");
    private static final Logger LOG = Logger.getInstance(CidrValue.class);
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    private final List<String> myPresentationErrors = Collections.synchronizedList(new ArrayList());

    public CidrValue(@NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName);
        this.myProcess = process;
        this.myPosition = position;
        this.myFrame = frame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        return this.getEvaluationExpression(false);
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.getName();
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            XSourcePosition computedPosition;
            XSourcePosition position = this.getSourcePosition();
            if (position == null) {
                navigatable.setSourcePosition(null);
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                LOG.warn("computeSourcePosition finished with error: ProgressIndicator is null");
                return;
            }
            try {
                computedPosition = this.doComputePositionAsync(position, indicator).get();
            }
            catch (ProcessCanceledException | InterruptedException | CancellationException | ExecutionException e) {
                LOG.info("computeSourcePosition finished with error: " + e.getMessage());
                return;
            }
            ReadAction.run(() -> navigatable.setSourcePosition(computedPosition));
        }, CidrDebuggerBundle.message("debug.computing.source.position", new Object[0]), true, this.myProcess.getProject());
    }

    @NotNull
    protected abstract CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition var1, @NotNull ProgressIndicator var2);

    @NotNull
    protected CompletableFuture<XSourcePosition> doComputeNearestUsagePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        this.doComputeInlineDebuggerDataAsync(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
        return ThreeState.YES;
    }

    protected void doComputeInlineDebuggerDataAsync(XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        XDebugSession session = this.myProcess.getSession();
        Function<Function, CompletableFuture> execWithEmptyProgressIndicator = f -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            XDebugSessionListener listener = new XDebugSessionListener(){
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$indicator = progressIndicator;
                }

                public void sessionResumed() {
                    this.val$indicator.cancel();
                }

                public void sessionStopped() {
                    this.val$indicator.cancel();
                }
            };
            session.addSessionListener(listener);
            return ((CompletableFuture)f.apply(indicator)).whenComplete((v, t) -> session.removeSessionListener(listener));
        };
        execWithEmptyProgressIndicator.apply(i -> this.doComputePositionAsync(position, (ProgressIndicator)i).thenAccept(p -> ReadAction.run(() -> navigatable.setSourcePosition(p)))).whenComplete((v, t) -> execWithEmptyProgressIndicator.apply(ii -> this.doComputeNearestUsagePositionAsync(position, (ProgressIndicator)ii).thenAccept(pp -> ReadAction.run(() -> navigatable.setSourcePosition(pp)))));
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            if (node.isObsolete()) {
                return;
            }
            boolean hasChildren = false;
            try {
                XFullValueEvaluator evaluator;
                XValuePresentation presentation;
                Icon icon;
                EvaluationContext context = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                SmartList presentationErrors = new SmartList();
                try {
                    hasChildren = this.doComputeMayHaveChildren(context);
                    icon = this.doComputeIcon(context, hasChildren);
                }
                catch (DebuggerCommandException e) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                    presentationErrors.add(e.getMessage());
                }
                try {
                    Pair<XValuePresentation, XFullValueEvaluator> presentationAndEvaluator = this.doComputePresentationAndEvaluator(context);
                    presentation = (XValuePresentation)presentationAndEvaluator.first;
                    evaluator = (XFullValueEvaluator)presentationAndEvaluator.second;
                }
                catch (DebuggerCommandException e) {
                    CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                    return;
                }
                if (!presentationErrors.isEmpty()) {
                    this.myPresentationErrors.addAll((Collection<String>)presentationErrors);
                    hasChildren = true;
                }
                if (evaluator != null) {
                    node.setFullValueEvaluator(evaluator);
                }
                node.setPresentation(icon, presentation, hasChildren);
            }
            catch (com.intellij.execution.ExecutionException e) {
                CidrErrorValue.doComputePresentation(node, CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)), hasChildren);
                throw e;
            }
        });
    }

    protected abstract boolean doComputeMayHaveChildren(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected abstract CidrValueDescription doComputeValueDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected Pair<XValuePresentation, XFullValueEvaluator> doComputePresentationAndEvaluator(@NotNull EvaluationContext context) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String type = CidrDebuggerSettings.getInstance().isShowTypes() ? this.doComputeType(context) : null;
        CidrValueDescription valueDescription = this.doComputeValueDescription(context);
        XValuePresentation presentation = this.createValuePresentation(context, valueDescription.getValue(), type);
        String pointerAddress = valueDescription.getPointerAddress();
        if (pointerAddress != null) {
            presentation = new CidrPointerValuePresentationWrapper(pointerAddress, presentation);
        }
        return Pair.create((Object)presentation, (Object)valueDescription.getFullValueEvaluator());
    }

    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        return new XRegularValuePresentation(value, type);
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        if (!this.myPresentationErrors.isEmpty()) {
            node.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        return errorNodesList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode2) {
        if (toNode2.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process, position, frame));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode2);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode2) {
        if (toNode2.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode2.addChildren(list, true);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        return this.getProcess().createEvaluationContext(driver, expirable, this.myFrame);
    }
}

