/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRichValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.ValuePresentationKt;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import icons.CidrDebuggerIcons;
import java.math.BigInteger;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_VAR_DATA = Key.create((String)"THROW_ON_VAR_DATA");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<LLValueData> myPresentationVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult = new CachedDebuggerResult();

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        this(var, var.getName(), process, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName, process, position, frame);
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result2 = this.myRendererResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedRenderer() called before getRenderer()");
            return new ValueRenderer(this);
        }
        return result2;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myRendererResult.getResult(new CachedDebuggerResult.NotNullCalculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DebuggerCommandException {
                return CidrPhysicalValue.this.doCreateRenderer(context);
            }
        });
    }

    @NotNull
    protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return ValueRendererFactory.createRenderer(context, this);
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myVar.getReferenceExpression();
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputeNearestUsagePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        return this.getTypesHelper().computeNearestUsageSourcePositionAsync(position, this.getVar(), indicator);
    }

    @NotNull
    public LLValue getVar() {
        return this.myVar;
    }

    @NotNull
    public LLValue getPresentationVar() {
        LLValue presentationVar = this.myPresentationVar;
        return presentationVar != null ? presentationVar : this.myVar;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    @NotNull
    @NlsSafe
    public String getType() {
        return this.myVar.getType();
    }

    public boolean isValueDataAvailable() {
        return this.myVarDataResult.getResultIfAvailable() != null;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (!this.isValueDataAvailable() && CidrDebuggerSettings.getInstance().isMuteVariables() && (this.isFrameVariable() || CidrPhysicalValue.isFrameVariableNode(node))) {
            String type = CidrDebuggerSettings.getInstance().isShowTypes() ? ValueRenderer.getDisplayType(this) : null;
            XRegularValuePresentation presentation = new XRegularValuePresentation("", type);
            node.setFullValueEvaluator(this.createOnDemandValueEvaluator());
            node.setPresentation(CidrDebuggerIcons.ValueMuted, (XValuePresentation)presentation, false);
        } else {
            super.computePresentation(node, place);
        }
    }

    protected boolean isFrameVariable() {
        return false;
    }

    protected static boolean isFrameVariableNode(@NotNull XValueNode node) {
        while (node instanceof XValueNodeImpl) {
            XValueNodeImpl nodeImpl = (XValueNodeImpl)node;
            if (nodeImpl.getValueContainer() instanceof CidrLocalValue) {
                return true;
            }
            if (!Registry.is((String)"cidr.debugger.muteVariables.muteChildren", (boolean)false)) break;
            node = (XValueNode)ObjectUtils.tryCast((Object)nodeImpl.getParent(), XValueNode.class);
        }
        return false;
    }

    private XFullValueEvaluator createOnDemandValueEvaluator() {
        return new XFullValueEvaluator(CidrDebuggerBundle.message("debugger.variables.loadMutedValue.link", new Object[0])){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback instanceof HeadlessValueEvaluationCallback) {
                    XValueNodeImpl node = ((HeadlessValueEvaluationCallback)callback).getNode();
                    node.clearFullValueEvaluator();
                    CidrPhysicalValue.super.computePresentation((XValueNode)node, XValuePlace.TREE);
                }
                callback.evaluated("");
            }
        }.setShowValuePopup(false);
    }

    @NotNull
    public LLValueData getPreparedVarData() {
        LLValueData result2 = this.myVarDataResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedVarData() called before getVarData()");
            return new LLValueData("", null, false, false, false);
        }
        return result2;
    }

    @NotNull
    public LLValueData getVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                ThrowInTest.doThrow((UserDataHolder)CidrPhysicalValue.this, THROW_ON_VAR_DATA);
                return context.getData(CidrPhysicalValue.this.myVar);
            }
        });
    }

    @NotNull
    public LLValueData getPresentationVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        final LLValue presentationVar = this.myPresentationVar;
        if (presentationVar == null) {
            return this.getVarData(context);
        }
        return this.myPresentationVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                return context.getData(presentationVar);
            }
        });
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        return this.getRenderer(context).getDisplayType();
    }

    @Nullable
    public String getShownAddress() {
        if (!this.isValueDataAvailable()) {
            return null;
        }
        return this.getPreparedVarData().getPresentablePointer();
    }

    @Override
    @NotNull
    protected CidrValueDescription doComputeValueDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        return this.getRenderer(context).computeValueDescription(context);
    }

    @Override
    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        if (this.getProcess().isRichValueDescriptionEnabled()) {
            return new CidrRichValuePresentation(value, type);
        }
        XValuePresentation valuePresentation = this.createNumberValuePresentation(context, value, type);
        if (valuePresentation != null) {
            return valuePresentation;
        }
        return super.createValuePresentation(context, value, type);
    }

    @Nullable
    protected XValuePresentation createNumberValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        long number;
        LLValueData valueData = this.getPresentationVarData(context);
        if (valueData.isPointer()) {
            return null;
        }
        Pair<String, String> numberAndData = valueData.splitNumberAndData();
        String numberText = (String)numberAndData.first;
        if (numberText == null) {
            return null;
        }
        if (!value.startsWith(numberText)) {
            return null;
        }
        String text = value.substring(numberText.length());
        try {
            number = new BigInteger(numberText).longValue();
        }
        catch (NumberFormatException ignored) {
            number = 0L;
        }
        boolean isHex = CidrDebuggerSettings.getInstance().isHexFormattingEnabled();
        if (!isHex) {
            return new CidrNumberValuePresentation(value, type, numberText, text);
        }
        CidrDebuggerUtil.ReadActionResult sizeof = CidrDebuggerUtil.runInReadActionWithRetries(() -> {
            context.checkExpiration();
            return this.getTypesHelper().getSizeOf(this);
        }, context);
        int sizeBits = sizeof.wasCompleted && sizeof.value != null ? (Integer)sizeof.value * 8 : 64;
        boolean isHexAsSecondary = CidrDebuggerSettings.getInstance().isHexAsSecondaryFormattingEnabled();
        return ValuePresentationKt.createHexValuePresentation(value, type, numberText, text, number, sizeBits, isHexAsSecondary);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context).computeMayHaveChildren(context);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(@NotNull XCompositeNode node) {
        this.getProcess().postCommand(driver -> CidrPhysicalValue.invokeRenderChildren(node, () -> {
            ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_CHILDREN);
            EvaluationContext context = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
            node.setAlreadySorted(true);
            this.getRenderer(context).computeChildren(context, node);
        }));
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            valueNode.invokeNodeUpdate(() -> {
                XFullValueEvaluator evaluator = valueNode.getFullValueEvaluator();
                if (evaluator != null && !evaluator.isShowValuePopup()) {
                    HeadlessValueEvaluationCallback callback = new HeadlessValueEvaluationCallback(valueNode);
                    evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
                }
            });
        }
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.getRenderer(context).getConsoleDescription(context).toString();
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper() {
        return this.getProcess().getTypesHelper(this.getFrame());
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.getFrame().getFrame().getLanguage();
    }

    public boolean isObjectiveCContext() {
        DebuggerDriver.DebuggerLanguage l = this.getLanguage();
        return l == DebuggerDriver.StandardDebuggerLanguage.OBJC || l == DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    public boolean isSwiftContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isSwiftOptional() {
        return this.isSwiftContext() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }

    public boolean isSwiftVoid() {
        return this.isSwiftContext() && "()".equals(this.getType());
    }

    public static void invokeRenderChildren(@NotNull XCompositeNode node, @NotNull CompositeNodeComputable computable) throws ExecutionException {
        if (node.isObsolete()) {
            return;
        }
        try {
            computable.compute();
        }
        catch (DebuggerCommandException e) {
            node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
        }
        catch (ExecutionException e) {
            node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)))), true);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface CompositeNodeComputable {
        public void compute() throws ExecutionException, DebuggerCommandException;
    }
}

