/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class CidrElementValue
extends CidrPhysicalValue {
    @NotNull
    private final CidrPhysicalValue myContainer;
    private int myIndex;
    private final boolean myModifiable;

    public CidrElementValue(@NotNull LLValue var, @NlsSafe @NotNull String displayName, @NotNull CidrPhysicalValue container, int index, boolean modifiable) {
        super(var, displayName, container.getProcess(), container.getSourcePosition(), container.getFrame());
        this.myContainer = container;
        this.myIndex = index;
        this.myModifiable = modifiable;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public CidrPhysicalValue getContainer() {
        return this.myContainer;
    }

    public XValueModifier getModifier() {
        return this.myModifiable ? new CidrValueModifier(this) : null;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myContainer.getPreparedRenderer().getChildEvaluationExpression(this, lvalue);
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        return this.myContainer.doComputePositionAsync(position, indicator);
    }
}

