/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CidrBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<?>, LLBreakpoint> {
    private final Map<Integer, Map<String, LLBreakpointLocation>> myLocationsMap = new LinkedHashMap<Integer, Map<String, LLBreakpointLocation>>();

    public CidrBreakpointHandler(CidrDebugProcess process) {
        this(process, (Class<? extends XLineBreakpointType<?>>)CidrLineBreakpointType.class);
    }

    public CidrBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XLineBreakpointType<?>> type) {
        super(process, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<LLBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<?> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        CidrLineBreakpointType.Properties properties;
        String condition = this.convertCondition((XBreakpoint<? extends XBreakpointProperties>)breakpoint);
        String path = VfsUtilCore.urlToPath((String)breakpoint.getFileUrl());
        boolean ignoreSourceHash = false;
        if (breakpoint.getProperties() instanceof CidrLineBreakpointType.Properties && (properties = (CidrLineBreakpointType.Properties)breakpoint.getProperties()) != null && properties.isRelaxedMatch()) {
            path = PathUtil.getFileName((String)path);
            ignoreSourceHash = true;
        }
        try {
            DebuggerDriver.AddBreakpointResult result2 = driver.addBreakpoint(path, breakpoint.getLine(), condition, ignoreSourceHash);
            LLBreakpoint brk = result2.getBreakpoint();
            List<LLBreakpointLocation> brkLocations = result2.getBreakpointLocations();
            LinkedHashMap<String, LLBreakpointLocation> brkLocationsMap = new LinkedHashMap<String, LLBreakpointLocation>(brkLocations.size());
            for (LLBreakpointLocation location : brkLocations) {
                brkLocationsMap.put(location.getId(), location);
            }
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                this.myLocationsMap.put(brk.getId(), brkLocationsMap);
            }
            this.updateBreakpointPresentation(breakpoint, !brkLocations.isEmpty());
            return Collections.singletonList(brk);
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull XLineBreakpoint<?> breakpoint) throws ExecutionException, DebuggerCommandException {
        try {
            super.removeCodepointsInBackend(driver, ids, breakpoint);
        }
        finally {
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                for (int id : ids) {
                    this.myLocationsMap.remove(id);
                }
            }
        }
    }

    public void handleBreakpointAdded(@NotNull LLBreakpoint newBreakpoint) {
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(newBreakpoint.getId());
        if (uiBreakpoint != null) {
            return;
        }
    }

    public void handleBreakpointRemoved(int breakpointId) {
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
    }

    public void handleBreakpointUpdated(int breakpointId, @NotNull LLBreakpoint newBreakpoint) {
        this.updateCodepoint(breakpointId, newBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean resolved;
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            locationsMap = new LinkedHashMap<String, LLBreakpointLocation>(locations.size());
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            this.myLocationsMap.put(breakpointId, locationsMap);
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean resolved;
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        boolean resolved;
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            Map<String, LLBreakpointLocation> locationsMap = this.myLocationsMap.get(breakpointId);
            if (locationsMap == null) {
                return;
            }
            for (String locationId : locationIds) {
                locationsMap.remove(locationId);
            }
            resolved = !locationsMap.isEmpty();
        }
        XLineBreakpoint uiBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (uiBreakpoint == null) {
            return;
        }
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    private void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> uiBreakpoint, boolean resolved) {
        if (resolved) {
            this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }
}

