/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.NtSymbolPathEntry;
import com.jetbrains.cidr.execution.debugger.NtSymbolSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    private static boolean ourIsDebugModeEnabled = false;

    public static void setDebugMode(boolean isEnabled) {
        ourIsDebugModeEnabled = isEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return ourIsDebugModeEnabled;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDriverName() {
        return "LLDB";
    }

    @NotNull
    public static ArchitectureType getDefaultTargetArchitecture() {
        return CpuArch.isArm64() ? ArchitectureType.ARM64 : ArchitectureType.X86_64;
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        try {
            GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine(LLDBDriverConfiguration.getDefaultTargetArchitecture());
            commandLine.addParameter("--version");
            displayVersion = CidrRunProcessUtil.readOneLineWithProgress(commandLine, 10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            return null;
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        return ToolVersion.parse(displayVersion, VERSION_PATTERN);
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        return new LLDBDriver(handler, this, architectureType);
    }

    @NotNull
    private static String getPathForArch(@NotNull ArchitectureType architectureType, @NotNull String path) {
        String archDirName = LLDBDriverConfiguration.getArchDirName(architectureType);
        if (archDirName == null) {
            archDirName = LLDBDriverConfiguration.getArchDirName(ArchitectureType.forVmCpuArch(CpuArch.CURRENT));
        }
        if (archDirName == null) {
            throw new UnsupportedOperationException("Unable to locate bundled LLDB for architecture " + architectureType);
        }
        return archDirName + "/" + path;
    }

    @Nullable
    private static String getArchDirName(@NotNull ArchitectureType architectureType) {
        return switch (architectureType) {
            case ArchitectureType.I386 -> "x86";
            case ArchitectureType.X86_64 -> "x64";
            case ArchitectureType.ARM64 -> "aarch64";
            default -> null;
        };
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        return this.getBundledLLDBFrameworkFile(architectureType);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architectureType) {
        return this.getLLDBBinFile(SystemInfo.isWindows ? LLDBDriverConfiguration.getPathForArch(architectureType, "bin/LLDBFrontend.exe") : (SystemInfo.isMac ? "LLDBFrontend" : LLDBDriverConfiguration.getPathForArch(architectureType, "bin/LLDBFrontend")));
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return CidrDebuggerPathManager.getLLDBBinFile(relativePath, null);
    }

    @NotNull
    protected File getBundledLLDBFrameworkFile(ArchitectureType architectureType) {
        return CidrDebuggerPathManager.getLLDBBinFile(SystemInfo.isWindows ? LLDBDriverConfiguration.getPathForArch(architectureType, "bin/liblldb.dll") : (SystemInfo.isMac ? "LLDB.framework" : LLDBDriverConfiguration.getPathForArch(architectureType, "lib/liblldb.so")), SystemInfo.isMac ? "LLDB.framework/Resources" : LLDBDriverConfiguration.getPathForArch(architectureType, "bin"));
    }

    public static boolean hasBundledLLDB() {
        return new LLDBDriverConfiguration().getBundledLLDBFrameworkFile(LLDBDriverConfiguration.getDefaultTargetArchitecture()).exists();
    }

    @Override
    @Deprecated
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        return this.createDriverCommandLine(driver, LLDBDriverConfiguration.getDefaultTargetArchitecture());
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        GeneralCommandLine result2 = this.createLLDBFrontendCommandLine(architectureType);
        result2.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result2);
        return result2;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine(@NotNull ArchitectureType architectureType) throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile(architectureType);
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldb.library.not.found", lldbFrameworkFile));
        }
        File frontendExecutable = this.getLLDBFrontendFile(architectureType);
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldbfrontend.not.found", frontendExecutable.getAbsolutePath()));
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result2.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", lldbFrameworkFile.getParent());
        } else if (SystemInfo.isWindows) {
            File lldbFrameworkDir = lldbFrameworkFile.getParentFile();
            CidrExecUtil.appendSearchPath(env, "PATH", lldbFrameworkDir.getPath());
            File lldbFrontendDir = frontendExecutable.getParentFile();
            if (!FileUtil.filesEqual((File)lldbFrontendDir, (File)lldbFrameworkDir)) {
                CidrExecUtil.appendSearchPath(env, "PATH", lldbFrontendDir.getPath());
            }
            String parentPATH = (String)result2.getParentEnvironment().get("PATH");
            CidrExecUtil.appendSearchPath(env, "PATH", parentPATH);
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            env.put("NSUnbufferedIO", "YES");
        }
        if (SystemInfo.isUnix && this.useSTLRenderers()) {
            result2.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        if (this.useRustTypeSystem()) {
            env.put("LLDB_USE_RUST_TYPE_SYSTEM", "1");
        }
        if (SystemInfo.isWindows) {
            CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
            NtSymbolSettings srvSettings = settings.getNtSymbolSettings();
            String envNtSymbolPath = srvSettings.getUseNtSymbolServers() ? LLDBDriverConfiguration.buildNtSymbolPath(srvSettings) : "";
            env.put("_NT_SYMBOL_PATH", envNtSymbolPath);
        }
        LLDBDriverConfiguration.setupCommonParameters(result2);
        return result2;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result2) {
        if (LLDBDriverConfiguration.isDebugModeEnabled()) {
            result2.addParameter("--debug");
        }
    }

    @NotNull
    private static String buildNtSymbolPath(@NotNull NtSymbolSettings srvSettings) {
        String url;
        StringBuilder result2 = new StringBuilder();
        String cachePath = srvSettings.getNtSymbolCache().trim();
        if (cachePath.isEmpty()) {
            cachePath = NtSymbolSettings.getDefaultSymbolCachePath();
        }
        for (NtSymbolPathEntry entry : srvSettings.getNtSymbolServers()) {
            if (!entry.isEnabled() || (url = entry.getUrl().trim()).isEmpty()) continue;
            result2.append("srv*");
            result2.append(cachePath);
            result2.append("*");
            result2.append(url);
            result2.append(";");
        }
        result2.append("cache*");
        result2.append(cachePath);
        result2.append(";");
        for (NtSymbolPathEntry entry : srvSettings.getNtSymbolPaths()) {
            if (!entry.isEnabled() || (url = entry.getUrl().trim()).isEmpty()) continue;
            result2.append(url);
            result2.append(";");
        }
        return result2.toString();
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        return new LLDBEvaluationContext(driver, expirable, thread, frame, cacheHolder);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return Registry.is((String)"cidr.debugger.lldb.statics");
    }

    public boolean disableASLR() {
        return false;
    }

    public boolean useRustTypeSystem() {
        return false;
    }

    public boolean useSTLRenderers() {
        return true;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return LLDBLanguage.INSTANCE;
    }
}

