/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.features.RichValueDescriptionSupport;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.ProtocolResponses;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufUtils;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<Message>,
RichValueDescriptionSupport {
    public static final Logger LOG = CidrDebuggerLog.LOG;
    public static final Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    private static final Key<Integer> LLVALUE_ID = Key.create((String)"LLDBDriver.LLVALUE_ID");
    private static final Key<LLValueDataLoader> LLVALUE_DATA_LOADER = Key.create((String)"LLDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueData> LLVALUE_DATA = Key.create((String)"LLDBDriver.LLVALUE_DATA");
    private static final Key<Integer> CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.CHILDREN_COUNT_CACHE");
    public static final String NO_RESULT = "<no result>";
    private static final String LOCKED_DEVICE_RESPONSE = "process launch failed: Locked";
    private static final String TERMINATED_DUE_TO_SIGNAL = "Terminated due to signal ";
    private GeneralCommandLine myLLDBCommandLine;
    private BaseProcessHandler myLLDBFrontendHandler;
    private final CompletableFuture<ProtobufServer<ProtocolResponses.CompositeResponse>> myConnectedClient = new CompletableFuture();
    private final BlockingQueue<Integer> myTemporaryBreakpoints = new LinkedBlockingQueue<Integer>();
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i) throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i);
            }
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i, i1);
            }
        }

        @Override
        public void close() throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.flush();
            }
        }
    };
    @Nullable
    private volatile OutputStream myProcessInput;
    private volatile Integer myAsyncAttachingTo;
    private final LLDBDriverConfiguration myStarter;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<ProtocolResponses.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DebuggerFatalException> myAsyncFatalException = new AtomicReference();
    @Nullable
    private ToolVersion myLLDBVersion;
    private long myCapabilities = 0L;
    @Nullable
    private volatile LLThread myStoppedThread;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @Nullable
    private String myAutorunScriptName = null;
    @Nullable
    private String myStepIntoClassName = null;
    @Nullable
    private String myStepOverClassName = null;
    @Nullable
    private String myStepOutClassName = null;

    private void dispatchInput(String input, Model.DispatchTarget target) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage((Message)request, ProtocolResponses.DispatchInput_Res.class, dispatchInput_res -> {});
    }

    protected ProtobufServer<ProtocolResponses.CompositeResponse> getProtobufClient() throws ExecutionException {
        this.checkErrors();
        return ExecutionResult.get(this.myConnectedClient);
    }

    private void storeAsyncFatalException(DebuggerFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    @Override
    public void checkErrors() throws ExecutionException {
        DebuggerFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DebuggerFatalException((Throwable)((Object)exception));
        }
    }

    @NotNull
    private <R extends Message, E extends Exception> DebuggerDriver.StopPlace sendAndHandleJumpRequest(@NotNull LLThread thread, @NotNull Message message, @NotNull Class<R> responseClass, @NotNull @NotNull Function<R,  @NotNull Model.LLDBFrame> getNewFrame) throws ExecutionException, DebuggerCommandException, E {
        ThrowDebuggerCommandExceptionIfNotValid errorHandler = new ThrowDebuggerCommandExceptionIfNotValid(LLDBBundle.message("error.invalid.response", new Object[0]));
        try {
            R response = this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
            Model.LLDBFrame newFrame = (Model.LLDBFrame)getNewFrame.fun(response);
            return new DebuggerDriver.StopPlace(thread, this.newLLFrame(newFrame));
        }
        catch (DebuggerCommandException ex) {
            String errorMessage = ex.getMessage();
            if (errorMessage != null && errorMessage.contains("is outside the current function")) {
                throw new DebuggerDriver.JumpToLineOutsideCurrentFunctionException(errorMessage, ex);
            }
            throw ex;
        }
    }

    @NotNull
    public <R extends Message> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass) throws ExecutionException {
        ThrowIfNotValid errorHandler = new ThrowIfNotValid(LLDBBundle.message("error.invalid.response", new Object[0]));
        return this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
    }

    @NotNull
    public <R extends Message, E extends Exception> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass, @NotNull ResponseMessageConsumer<? super R, E> errorHandler) throws ExecutionException, E {
        return this.sendMessageAndWaitForReply(message, responseClass, errorHandler, 0L);
    }

    @NotNull
    public <R extends Message, E extends Exception> R sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<R> responseClass, @NotNull ResponseMessageConsumer<? super R, E> errorHandler, long msTimeout) throws ExecutionException, E {
        Ref responseRef = Ref.create();
        Consumer responseHandler = responseMessage -> {
            errorHandler.consume((Object)responseMessage);
            if (!errorHandler.isValid()) {
                return;
            }
            responseRef.set(responseMessage);
        };
        this.getProtobufClient().sendMessageAndWaitForReply(message, responseClass, responseHandler, msTimeout);
        errorHandler.throwIfNeeded();
        Message response = (Message)responseRef.get();
        if (response == null) {
            throw new ExecutionException(LLDBBundle.message("error.null.response.to.message", message));
        }
        return (R)response;
    }

    public void setAutorunScriptName(@Nullable String autorunScriptName) {
        this.myAutorunScriptName = autorunScriptName;
    }

    public void setStepIntoClassName(@Nullable String stepIntoClassName) {
        this.myStepIntoClassName = stepIntoClassName;
    }

    public void setStepOverClassName(@Nullable String stepOverClassName) {
        this.myStepOverClassName = stepOverClassName;
    }

    public void setStepOutClassName(@Nullable String stepOutClassName) {
        this.myStepOutClassName = stepOutClassName;
    }

    @Override
    public void setRichValueDescriptionEnabled(boolean enable) throws ExecutionException {
        String command = String.format("jb_renderers_set_markup %d", enable ? 1 : 0);
        this.executeInterpreterCommand(-1L, -1, command);
    }

    public LLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull LLDBDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws ExecutionException {
        super(handler);
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(LLDBDriver.getLogDir(), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(text.trim());
                }
            }
        };
        this.startDriver(architectureType);
    }

    @NotNull
    private static File getLogDir() {
        return new File((String)(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath()));
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    public boolean supportsJumpToLine() {
        return true;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        return this.myLLDBFrontendHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    @Nullable
    public ToolVersion getLLDBVersion() {
        return this.myLLDBVersion;
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        return this.myStarter.getHostMachine();
    }

    private void startDriver(@NotNull ArchitectureType architectureType) throws ExecutionException {
        try {
            this.myProtobufServer = new ProtobufServer<ProtocolResponses.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<ProtocolResponses.CompositeResponse>(){

                @Override
                public ProtocolResponses.CompositeResponse parse(byte[] buffer) throws IOException {
                    return ProtocolResponses.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(Message response) {
                    return response instanceof ProtocolResponses.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                private boolean decomposeRequest(@NotNull Message request) {
                    return request instanceof Protocol.CompositeRequest;
                }

                @Override
                public <ResponseType extends Message> void sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<ResponseType> responseClass, @NotNull Consumer<? super ResponseType> responseHandler, long msTimeout) throws ProtobufTimedOutException, ExecutionFinishedException {
                    try (CidrEventSpan ignored = new CidrEventSpan("debug", (Function0<String>)((Function0)() -> "sendMessageAndWaitForReply (" + ProtobufUtils.unpackComposite(message, this::decomposeRequest).getClass().getSimpleName() + ")"), (Function0<String>)((Function0)() -> message.toString()));){
                        super.sendMessageAndWaitForReply(message, responseClass, responseHandler, msTimeout);
                    }
                }

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.completeExceptionally(e)) {
                        LLDBDriver.this.storeAsyncFatalException(new DebuggerFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, architectureType);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isTraceEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = this.createDebugProcessHandler(this.myLLDBCommandLine, this.myStarter);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                LLDBDriver.this.myConnectedClient.completeExceptionally(new ExecutionFinishedException());
                OutputStream processInput = LLDBDriver.this.myProcessInput;
                if (processInput != null) {
                    try {
                        processInput.close();
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                    }
                }
                LLDBDriver.this.myProcessInput = null;
                LLDBDriver.this.myGLogOutputReaders.close();
                if (LLDBDriver.this.myProtobufServer != null) {
                    LLDBDriver.this.myProtobufServer.tearDown();
                }
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text = event.getText();
                if (text == null) {
                    return;
                }
                if (ProcessOutputType.isStderr((Key)outputType) || ProcessOutputType.isStdout((Key)outputType)) {
                    if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug(PathUtil.getFileName((String)LLDBDriver.this.myLLDBCommandLine.getExePath()) + " [" + outputType + "]: " + text);
                    }
                    LLDBDriver.this.handleDebuggerOutput(text, outputType);
                }
            }
        });
    }

    @Override
    @TestOnly
    public void waitHandlerProcessed() {
        if (this.myProtobufServer != null) {
            this.myProtobufServer.waitFor();
        }
        super.waitHandlerProcessed();
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.setValuesFilteringEnabled(enabled), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.values.filtering.policy", new Object[0])));
    }

    @NotNull
    private static String getLLDBArchitectureType(@Nullable String architectureType) {
        String lldbArchitecture = StringUtil.notNullize((String)architectureType);
        if (lldbArchitecture.equals(ArchitectureType.UNKNOWN.getId())) {
            lldbArchitecture = "";
        }
        return lldbArchitecture;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        String lldbArchitectureId = LLDBDriver.getLLDBArchitectureType(architecture);
        final Boolean useExternalConsole = targetCommandLine.getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(installer.getExecutableFile().getPath(), lldbArchitectureId));
        this.configureTarget();
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)((ThrowableComputable)() -> {
                    String stdoutPath = null;
                    String stderrPath = null;
                    if (LLDBDriver.this.myToRedirect && !useExternalConsole.booleanValue()) {
                        ProcessOutputReaders readers = LLDBDriver.this.initReaders(LocalHost.INSTANCE, targetCommandLine, !SystemInfo.isWindows);
                        stdoutPath = readers.getOutFileAbsolutePath();
                        stderrPath = readers.getErrFileAbsolutePath();
                    }
                    File inputFile = targetCommandLine.getInputFile();
                    String stdinPath = null;
                    try {
                        if (inputFile != null) {
                            if (!inputFile.isFile() || !inputFile.canRead()) {
                                throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                            }
                            stdinPath = inputFile.getPath();
                        } else if (!useExternalConsole.booleanValue()) {
                            if (SystemInfo.isWindows) {
                                WinPipe pipe = WinPipe.createOutboundPipe("stdin");
                                LLDBDriver.this.myProcessInput = pipe.getOutputStream();
                                stdinPath = pipe.getName();
                            } else {
                                Pty pty = new Pty(true);
                                LLDBDriver.this.myProcessInput = pty.getOutputStream();
                                stdinPath = pty.getSlaveName();
                            }
                        }
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                        throw new LLDBDriverException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
                    }
                    return ProtobufMessageFactory.launch(targetCommandLine, useExternalConsole, stdinPath, stdoutPath, stderrPath);
                }), false);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        this.configureTarget();
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.attach(pid), ProtocolResponses.Attach_Res.class, responseHandler);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteAttach(@NotNull String bundleOrExecutablePath, @Nullable String architectureId, final @NotNull GeneralCommandLine installedCommandLine, final int pid, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @Nullable String execSearchPaths) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(bundleOrExecutablePath, StringUtil.notNullize((String)architectureId), "", sysroot != null ? sysroot.getAbsolutePath() : "", ""));
        this.configureTarget();
        if (execSearchPaths != null) {
            this.lldbSet("target.exec-search-paths", execSearchPaths);
        }
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                String debugserverSocket = (String)installedCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.remoteAttach(pid, debugserverSocket), ProtocolResponses.Attach_Res.class, responseHandler);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final @NotNull String name, final boolean wait) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        this.configureTarget();
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), ProtocolResponses.AttachByName_Res.class, responseHandler);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    private static String getLocalPlatform() throws ExecutionException {
        if (SystemInfo.isWindows) {
            return "remote-windows";
        }
        if (SystemInfo.isMac) {
            return "remote-macosx";
        }
        if (SystemInfo.isLinux) {
            return "remote-linux";
        }
        if (SystemInfo.isFreeBSD) {
            return "remote-freebsd";
        }
        throw new ExecutionException(LLDBBundle.message("error.unsupported.os", new Object[0]));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings) throws ExecutionException {
        return this.loadCoreDump(coreFile, symbolFile, sysroot, sourcePathMappings, Collections.emptyList());
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, final @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings, @NotNull List<String> execSearchPaths) throws ExecutionException {
        if (symbolFile != null) {
            String sysrootPath = sysroot != null ? sysroot.getAbsolutePath() : "";
            String platform = sysroot != null ? LLDBDriver.getLocalPlatform() : "";
            this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(symbolFile.getPath(), "", platform, sysrootPath, ""));
        }
        this.configureTarget();
        if (!execSearchPaths.isEmpty()) {
            StringBuilder execSearchPathsArgs = new StringBuilder();
            for (String path : execSearchPaths) {
                execSearchPathsArgs.append("\"").append(path.replace("\\", "\\\\")).append("\" ");
            }
            this.lldbSet("target.exec-search-paths", execSearchPathsArgs.toString());
        }
        this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.loadCoreDump(coreFile.getPath()), ProtocolResponses.LoadCore_Res.class);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.addPathMapping(sourcePathMappings, true);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteLaunch(final @NotNull Installer installer, @Nullable String architectureId, @Nullable File symbolsDir, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        String exePath = installer.getExecutableFile().getPath();
        String remoteExePath = targetCommandLine.getExePath();
        String symbolsDirPath = symbolsDir != null ? symbolsDir.getAbsolutePath() : null;
        architectureId = StringUtil.notNullize((String)architectureId);
        CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"creating remote target: exepath: ", exePath, " remotePath: ", remoteExePath, " symbols dir path: ", symbolsDirPath, " arch: ", architectureId}));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, architectureId, "remote-ios", symbolsDirPath, remoteExePath));
        this.configureTarget();
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)((ThrowableComputable)() -> {
                    String debugserverSocket = (String)targetCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                    CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                    LLDBDriver.this.myProcessInput = new ProcessInputDispatcher();
                    return ProtobufMessageFactory.remoteLaunch(installer.getExecutableFile().getAbsolutePath(), targetCommandLine, debugserverSocket);
                }), true);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        String sysrootPath;
        String exePath = symbolFile != null ? symbolFile.getPath() : "";
        String string = sysrootPath = sysroot != null ? sysroot.getAbsolutePath() : "";
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"attaching remote process started under debug server: url: ", connectionString, " exePath: ", exePath, " sysroot: ", sysrootPath}));
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, "", "", sysrootPath, ""));
        this.configureTarget();
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.attach.remote.debug.server", new Object[0]));
                LLDBDriver.this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.connectProcess(connectionString, null), ProtocolResponses.ConnectProcess_Res.class, responseHandler);
                LLDBDriver.this.resume();
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttachDebugServer(@NotNull String connectionUrl, @Nullable File executable, @Nullable String architectureId, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @Nullable String plugin) throws ExecutionException {
        return this.loadForRemote(connectionUrl, executable, null, pathMappings);
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings) throws ExecutionException {
        this.addPathMapping(mappings, false);
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings, boolean useTargetSourceMap) throws ExecutionException {
        this.addPathMapping(-1, mappings, useTargetSourceMap);
    }

    private void addPathMapping(int index, @NotNull List<DebuggerDriver.PathMapping> mappings, boolean useTargetSourceMap) throws ExecutionException {
        if (mappings.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (index >= 0) {
            builder.append(index).append(' ');
        }
        for (DebuggerDriver.PathMapping each : mappings) {
            builder.append("\"").append(each.from).append("\" ");
            builder.append("\"").append(each.to).append("\" ");
        }
        String command = useTargetSourceMap ? (index >= 0 ? "settings insert-before target.source-map " : "settings append target.source-map ") : (index >= 0 ? "target modules search-paths insert " : "target modules search-paths add ");
        this.myProtobufServer.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, command + builder), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.target.create", new Object[0]));
        this.sendMessageAndWaitForReply((Message)createTargetRequest, ProtocolResponses.CreateTarget_Res.class, responseHandler);
    }

    protected void configureTarget() throws ExecutionException {
        this.lldbSet("target.max-string-summary-length", "256");
    }

    private long doLaunch(@NotNull GeneralCommandLine targetCommandLine, @NotNull ThrowableComputable<Protocol.CompositeRequest, ExecutionException> launchRequestSupplier, boolean isRemoteTarget) throws ExecutionException {
        final Ref launchedPid = new Ref();
        ThrowIfNotValid<ProtocolResponses.Launch_Res> responseHandler = new ThrowIfNotValid<ProtocolResponses.Launch_Res>(LLDBBundle.message("error.cannot.launch.process", new Object[0])){

            @Override
            public void consume(ProtocolResponses.Launch_Res message) {
                super.consume(message);
                if (this.isValid()) {
                    launchedPid.set((Object)message.getPid());
                }
            }
        };
        this.printTargetCommandLine(targetCommandLine);
        Protocol.CompositeRequest launchReq = (Protocol.CompositeRequest)launchRequestSupplier.compute();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)launchReq, ProtocolResponses.Launch_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)responseHandler);
        if (isRemoteTarget && !responseHandler.isValid() && LOCKED_DEVICE_RESPONSE.equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        return (Long)launchedPid.get();
    }

    private void detach() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.detach.process", new Object[0]));
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.detach(), ProtocolResponses.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !LLDBDriver.isDetachErrorShouldBeSuppressed(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    private static boolean isDetachErrorShouldBeSuppressed(@Nullable String message) {
        if (message == null) {
            return false;
        }
        if ("Sending disconnect packet failed.".equals(message)) {
            return true;
        }
        if ("Sending isconnect packet failed.".equals(message)) {
            return true;
        }
        String errorWinPattern = "error: process \\d* in state = exited, but cannot detach it in this state.";
        return message.matches(errorWinPattern);
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        Ref result2 = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.Suspend_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)suspend_res -> result2.set((Object)suspend_res.getCommonResponse().getIsValid())));
        return !result2.isNull() && (Boolean)result2.get() != false;
    }

    @Override
    public boolean resume() throws ExecutionException {
        boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)resume, ProtocolResponses.Continue_Res.class, continue_res -> {
            res[0] = continue_res.getCommonResponse().getIsValid();
        }, 0L);
        return res[0];
    }

    @Override
    public void stepOver(boolean stepByInstruction) throws ExecutionException {
        this.stepOver(this.getLastStoppedThread(), stepByInstruction);
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        this.stepInto(this.getLastStoppedThread(), forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
    }

    @Override
    public void stepOut(boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        this.stepOut(this.getLastStoppedThread(), stopInFramesWithNoDebugInfo);
    }

    @NotNull
    private LLThread getLastStoppedThread() throws ExecutionException {
        LLThread stoppedThread = this.myStoppedThread;
        if (stoppedThread == null) {
            throw new ExecutionException(LLDBBundle.message("error.cannot.retrieve.stopped.thread", new Object[0]));
        }
        return stoppedThread;
    }

    @Override
    public void stepOver(@NotNull LLThread thread, boolean stepByInstruction) throws ExecutionException {
        if (this.myStepOverClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.over", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(thread.getId());
            this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepOver_Res.class, responseHandler);
        } else {
            this.stepScripted(thread.getId(), this.myStepOverClassName, LLDBBundle.message("error.cannot.step.over", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepInto(@NotNull LLThread thread, boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        if (forceStepIntoFramesWithNoDebugInfo) {
            this.lldbSetStepIntoNoDebug(true);
        }
        try {
            if (this.myStepIntoClassName == null) {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.into", new Object[0]));
                Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(thread.getId());
                this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepInto_Res.class, responseHandler);
            } else {
                this.stepScripted(thread.getId(), this.myStepIntoClassName, LLDBBundle.message("error.cannot.step.into", new Object[0]));
            }
        }
        finally {
            if (forceStepIntoFramesWithNoDebugInfo) {
                this.lldbSetStepIntoNoDebug(false);
            }
        }
    }

    @Override
    public void stepOut(@NotNull LLThread thread, boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        if (this.myStepOutClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.step.out", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(thread.getId());
            this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepOut_Res.class, responseHandler, 0L);
        } else {
            this.stepScripted(thread.getId(), this.myStepOutClassName, LLDBBundle.message("error.cannot.step.out", new Object[0]));
        }
    }

    private void stepScripted(long threadId, @NotNull String className, @NlsContexts.DialogMessage @NotNull String exceptionMsg) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(exceptionMsg);
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepScripted(threadId, className);
        this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.StepScripted_Res.class, responseHandler, 0L);
    }

    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        try {
            DebuggerDriver.AddBreakpointResult breakpoint = this.addBreakpoint(path, line);
            this.myTemporaryBreakpoints.add(breakpoint.getBreakpoint().getId());
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException(LLDBBundle.message("error.cannot.set.breakpoint", new Object[0]), (Throwable)e);
        }
        if (!this.resume()) {
            throw new ExecutionException(LLDBBundle.message("error.cannot.resume.program", new Object[0]));
        }
    }

    @Override
    public void runTo(@NotNull Address address2) throws ExecutionException {
        DebuggerDriver.AddBreakpointResult breakpoint = this.addBreakpoint(address2);
        this.myTemporaryBreakpoints.add(breakpoint.getBreakpoint().getId());
        if (!this.resume()) {
            throw new ExecutionException(LLDBBundle.message("error.cannot.resume.program", new Object[0]));
        }
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToLine(@NotNull LLThread thread, @NotNull String path, int line, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        @NotNull String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.jumpToLine(thread.getId(), convertedPath, line + 1, canLeaveFunction);
        return this.sendAndHandleJumpRequest(thread, (Message)req, ProtocolResponses.JumpToLine_Res.class, res -> res.getFrame());
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToAddress(@NotNull LLThread thread, @NotNull Address address2, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.jumpToAddress(thread.getId(), address2.getUnsignedLongValue(), canLeaveFunction);
        return this.sendAndHandleJumpRequest(thread, (Message)req, ProtocolResponses.JumpToAddress_Res.class, res -> res.getFrame());
    }

    @Override
    public void addPathMapping(int index, @NotNull String from, @NotNull String to) throws ExecutionException {
        String convertedFrom = this.myStarter.convertToProjectModelPath(from);
        String convertedTo = this.myStarter.convertToProjectModelPath(to);
        DebuggerDriver.PathMapping pathMapping = new DebuggerDriver.PathMapping(convertedFrom, convertedTo);
        List<DebuggerDriver.PathMapping> list = Collections.singletonList(pathMapping);
        this.addPathMapping(index, list, true);
    }

    @Override
    public void addForcedFileMapping(int index, @NotNull String from, @Nullable DebuggerSourceFileHash hash, @NotNull String to) throws ExecutionException {
        if ((this.myCapabilities & 1L) != 0L && hash != null) {
            this.addPathMapping(index, LLDBDriver.getSourceFileHashSchema(hash) + hash.getHash(), to);
        } else {
            this.addPathMapping(index, from, to);
        }
    }

    @NotNull
    private static String getSourceFileHashSchema(@NotNull DebuggerSourceFileHash hash) {
        return switch (hash.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case DebuggerSourceFileHash.Type.MD5 -> "md5://";
            case DebuggerSourceFileHash.Type.SHA1 -> "sha1://";
            case DebuggerSourceFileHash.Type.SHA256 -> "sha256://";
        };
    }

    @NotNull
    private Set<Integer> removeTemporaryBreakpoints() throws ExecutionException {
        LinkedHashSet<Integer> breakpointIds = new LinkedHashSet<Integer>();
        this.myTemporaryBreakpoints.drainTo(breakpointIds);
        Iterator iterator2 = breakpointIds.iterator();
        while (iterator2.hasNext()) {
            int num = (Integer)iterator2.next();
            Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
            this.getProtobufClient().sendMessage((Message)request, ProtocolResponses.RemoveBreakpoint_Res.class, res -> {
                if (!res.getCommonResponse().getIsValid()) {
                    CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                }
            });
        }
        return breakpointIds;
    }

    private boolean abort() throws ExecutionException {
        Ref toThrow = Ref.create();
        Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), ProtocolResponses.Kill_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (commonResponse.getIsValid()) {
                abort.set((Object)true);
            } else {
                @NlsSafe String errorMessage = commonResponse.getErrorMessage();
                if ("process not exist".equals(errorMessage)) {
                    abort.set((Object)false);
                } else {
                    if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                        errorMessage = LLDBBundle.message("error.cannot.abort.process", new Object[0]);
                    }
                    toThrow.set((Object)new LLDBDriverException(errorMessage));
                }
            }
        }));
        if (!toThrow.isNull()) {
            throw (ExecutionException)((Object)toThrow.get());
        }
        return (Boolean)abort.get();
    }

    @Override
    protected boolean doExit() throws ExecutionException {
        boolean sendExit = this.myConnectedClient.isDone();
        if (sendExit) {
            ExecutionResult.get(this.myConnectedClient).sendMessage((Message)ProtobufMessageFactory.exit(), null, null);
        }
        return sendExit;
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, @NotNull LLValue value, @NotNull String expr, @Nullable LLWatchpoint.Lifetime lifetime, @NotNull LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        Ref result2 = Ref.create(null);
        Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.AddWatchpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                toThrow.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else {
                result2.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
            }
        }));
        if (result2.isNull()) {
            throw (DebuggerCommandException)toThrow.get();
        }
        return (LLWatchpoint)result2.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addBreakpoint(@NotNull String path, int line, @Nullable String condition, boolean ignoreSourceHash) throws ExecutionException {
        String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(convertedPath, line + 1, ignoreSourceHash, condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class);
        return LLDBDriver.makeBreakpoint(res.getBreakpoint(), res.getLocationList());
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addAddressBreakpoint(@NotNull Address address2, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        return this.addBreakpoint(address2, condition);
    }

    protected DebuggerDriver.AddBreakpointResult addBreakpoint(@NotNull Address address2) throws ExecutionException {
        return this.addBreakpoint(address2, null);
    }

    protected DebuggerDriver.AddBreakpointResult addBreakpoint(@NotNull Address address2, @Nullable String condition) throws ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(address2.getUnsignedLongValue(), condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class);
        return LLDBDriver.makeBreakpoint(res.getBreakpoint(), res.getLocationList());
    }

    @NotNull
    private static String makeBreakpointLocationCanonicalName(int breakpointId, int locationId) {
        return breakpointId + "." + locationId;
    }

    @Nullable
    private static LLBreakpointLocation makeLocation(int breakpointId, @NotNull Model.LLDBBreakpointLocation loc) {
        if (!loc.getIsResolved()) {
            return null;
        }
        String id = LLDBDriver.makeBreakpointLocationCanonicalName(breakpointId, loc.getId());
        Address address2 = Address.fromUnsignedLong(loc.getAddr());
        FileLocation location = new FileLocation(loc.getFilePath(), loc.getLine() - 1);
        return new LLBreakpointLocation(id, address2, location);
    }

    @NotNull
    private static DebuggerDriver.AddBreakpointResult makeBreakpoint(@NotNull Model.LLDBBreakpoint breakpoint, @NotNull @NotNull List< @NotNull Model.LLDBBreakpointLocation> breakpointLocations) {
        String orig_file_path = breakpoint.hasOrigFilePath() ? breakpoint.getOrigFilePath() : "<address>";
        int orig_line = breakpoint.hasOrigLine() ? breakpoint.getOrigLine() : 0;
        String condition = breakpoint.hasCondition() ? breakpoint.getCondition() : null;
        LLBreakpoint llBreakpoint = new LLBreakpoint(breakpoint.getId(), orig_file_path, orig_line - 1, condition);
        List locationList = ContainerUtil.mapNotNull(breakpointLocations, loc -> LLDBDriver.makeLocation(breakpoint.getId(), loc));
        return new DebuggerDriver.AddBreakpointResult(llBreakpoint, locationList);
    }

    @Override
    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.AddBreakpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> result2.set((Object)new LLSymbolicBreakpoint(res.getBreakpoint().getId()))));
        return (LLSymbolicBreakpoint)result2.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException {
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.remove.breakpoint", new Object[0]));
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.RemoveBreakpoint_Res.class, responseHandler);
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    private LLThread newLLThread(@NotNull Model.LLDBThread lldbThread) {
        Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
        boolean isStopped = stopReasonInfo.getStopReason() != Model.ThreadStopReason.ThreadStopReasonInvalid;
        return new LLThread(lldbThread.getId(), isStopped ? "STOPPED" : null, lldbThread.getQueue(), lldbThread.getName(), lldbThread.hasTid() ? String.valueOf(lldbThread.getTid()) : null);
    }

    @NotNull
    private LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        return new LLFrame(frame.getNumber(), frame.hasFunction() ? frame.getFunction() : null, frame.hasFile() ? this.myStarter.convertToLocalPath(frame.getFile()) : null, LLDBDriver.createSourceFileHash(frame.hasHashType() ? frame.getHashType() : null, frame.hasHash() ? frame.getHash() : null), frame.hasLine() ? frame.getLine() - 1 : -1, frame.hasPc() ? frame.getPc() : 0L, frame.hasLanguage() ? LLDBDriver.convertLanguage(frame.getLanguage()) : null, frame.hasOptimized() && frame.getOptimized(), frame.hasInlined() && frame.getInlined(), frame.hasModule() ? frame.getModule() : null);
    }

    @Nullable
    private static DebuggerSourceFileHash createSourceFileHash(@Nullable Model.HashType type, @Nullable String hash) {
        DebuggerSourceFileHash.Type t;
        if (type == null || hash == null) {
            return null;
        }
        switch (type) {
            case HashTypeMD5: {
                t = DebuggerSourceFileHash.Type.MD5;
                break;
            }
            case HashTypeSHA1: {
                t = DebuggerSourceFileHash.Type.SHA1;
                break;
            }
            case HashTypeSHA256: {
                t = DebuggerSourceFileHash.Type.SHA256;
                break;
            }
            default: {
                return null;
            }
        }
        return new DebuggerSourceFileHash(t, hash);
    }

    @Nullable
    private static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
                case LanguageRust: {
                    return DebuggerDriver.StandardDebuggerLanguage.RUST;
                }
                case LanguageFortran77: 
                case LanguageFortran90: 
                case LanguageFortran95: 
                case LanguageFortran03: 
                case LanguageFortran08: {
                    return DebuggerDriver.StandardDebuggerLanguage.FORTRAN;
                }
                case LanguageAda83: 
                case LanguageAda95: {
                    return DebuggerDriver.StandardDebuggerLanguage.ADA;
                }
                case LanguageCobol74: 
                case LanguageCobol85: {
                    return DebuggerDriver.StandardDebuggerLanguage.COBOL;
                }
                case LanguagePascal83: {
                    return DebuggerDriver.StandardDebuggerLanguage.PASCAL;
                }
                case LanguageModula2: 
                case LanguageModula3: {
                    return DebuggerDriver.StandardDebuggerLanguage.MODULA;
                }
                case LanguageD: {
                    return DebuggerDriver.StandardDebuggerLanguage.D;
                }
                case LanguageOpenCL: {
                    return DebuggerDriver.StandardDebuggerLanguage.OPENCL;
                }
                case LanguageGo: {
                    return DebuggerDriver.StandardDebuggerLanguage.GO;
                }
                case LanguageHaskell: {
                    return DebuggerDriver.StandardDebuggerLanguage.HASKELL;
                }
                case LanguageOCaml: {
                    return DebuggerDriver.StandardDebuggerLanguage.OCAML;
                }
                case UnsupportedLanguage: {
                    CidrDebuggerLog.LOG.warn("Unknown language reported by LLDB. Protocol needs to be updated");
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            DebuggerDriver.StandardDebuggerLanguage standardLanguage = (DebuggerDriver.StandardDebuggerLanguage)language;
            return switch (standardLanguage) {
                case DebuggerDriver.StandardDebuggerLanguage.C -> Model.Language.LanguageC;
                case DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS -> Model.Language.LanguageC_plus_plus;
                case DebuggerDriver.StandardDebuggerLanguage.OBJC -> Model.Language.LanguageObjC;
                case DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS -> Model.Language.LanguageObjC_plus_plus;
                case DebuggerDriver.StandardDebuggerLanguage.SWIFT -> Model.Language.LanguageSwift;
                case DebuggerDriver.StandardDebuggerLanguage.FORTRAN -> Model.Language.LanguageFortran08;
                case DebuggerDriver.StandardDebuggerLanguage.RUST -> Model.Language.LanguageRust;
                case DebuggerDriver.StandardDebuggerLanguage.ADA -> Model.Language.LanguageAda95;
                case DebuggerDriver.StandardDebuggerLanguage.COBOL -> Model.Language.LanguageCobol85;
                case DebuggerDriver.StandardDebuggerLanguage.PASCAL -> Model.Language.LanguagePascal83;
                case DebuggerDriver.StandardDebuggerLanguage.MODULA -> Model.Language.LanguageModula3;
                case DebuggerDriver.StandardDebuggerLanguage.D -> Model.Language.LanguageD;
                case DebuggerDriver.StandardDebuggerLanguage.OPENCL -> Model.Language.LanguageOpenCL;
                case DebuggerDriver.StandardDebuggerLanguage.GO -> Model.Language.LanguageGo;
                case DebuggerDriver.StandardDebuggerLanguage.HASKELL -> Model.Language.LanguageHaskell;
                case DebuggerDriver.StandardDebuggerLanguage.OCAML -> Model.Language.LanguageOCaml;
                default -> throw new DebuggerCommandException(language + " is not supported by LLDB");
            };
        }
        throw new DebuggerCommandException(language + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getThreads();
        ProtocolResponses.GetThreads_Res res = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetThreads_Res.class);
        return ContainerUtil.map(res.getThreadList(), thread -> this.newLLThread((Model.LLDBThread)thread));
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        ProtocolResponses.GetFrames_Res res;
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(thread.getId(), from, count, untilFirstLineWithCode);
        try {
            res = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetFrames_Res.class);
        }
        catch (ExecutionException ex) {
            if (this.getState() != DebuggerDriver.TargetState.SUSPENDED) {
                throw new DebuggerCommandException(ex);
            }
            throw ex;
        }
        List frames = ContainerUtil.map(res.getFrameList(), frame -> this.newLLFrame((Model.LLDBFrame)frame));
        return DebuggerDriver.ResultList.create(frames, res.getHasMore());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        boolean staticsAndGlobals = this.myStarter.isStaticVarsLoadingEnabled();
        return this.getVariables(threadId, frameIndex, staticsAndGlobals, staticsAndGlobals);
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex, boolean statics, boolean globals) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getVars(threadId, frameIndex, statics, globals);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetVars_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)message);
            } else {
                for (Model.LLDBValue lldbValue : res.getValueList()) {
                    result2.add(this.createLLValue(lldbValue, null));
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return result2;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return LLDBDriver.getLLValueData(value);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.getValueDescription(LLDBDriver.valId(value), maxLength);
        Ref description = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.GetValueDescription_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                return;
            }
            if (res.hasDescription()) {
                description.set((Object)res.getDescription());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        return (String)description.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Integer childrenCount = this.getChildrenCount(value);
        if (count == 0) {
            return DebuggerDriver.ResultList.empty();
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(value), from, count);
        Ref errorMessage = new Ref();
        ArrayList result2 = new ArrayList();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetValueChildren_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                this.convertList(res.getValueList(), result2);
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DebuggerCommandException(message);
        }
        boolean hasMore = from + count < childrenCount;
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @Override
    public void addSymbolsFile(@NotNull File symbols, @Nullable File module) throws ExecutionException {
        Object command = "";
        String modulePath = "";
        if (module != null) {
            command = "target module add \"" + module.getAbsolutePath() + "\" -s \"" + symbols.getAbsolutePath() + "\"";
            modulePath = module.getAbsolutePath();
        } else {
            command = "target symbols add \"" + symbols.getAbsolutePath() + "\"";
        }
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, (String)command), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.add.symbols", symbols.getAbsolutePath(), modulePath)));
    }

    private void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result2) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = this.createLLValue(val, null);
            result2.add(value);
        }
    }

    private static int valId(@NotNull LLValue var) throws ExecutionException {
        return (Integer)var.getUserData(LLVALUE_ID);
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Ref errorMessage = Ref.create((Object)"unknown error");
        ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), ProtocolResponses.GetArraySlice_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                String message = res.getCommonResponse().getErrorMessage();
                if (StringUtil.isNotEmpty((String)message)) {
                    errorMessage.set((Object)message);
                }
                return;
            }
            errorMessage.set(null);
            this.convertList(res.getValueList(), vals);
        }));
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return vals;
    }

    @NotNull
    private LLValue createLLValue(@NotNull Model.LLDBValue lldbValue, @Nullable String expression) {
        LLValue.TypeClass typeClass = switch (lldbValue.getTypeClass()) {
            case Model.TypeClass.TypeClassFunction -> LLValue.TypeClass.FUNCTION;
            case Model.TypeClass.TypeClassBuiltin -> LLValue.TypeClass.BUILTIN;
            case Model.TypeClass.TypeClassClass, Model.TypeClass.TypeClassStruct -> LLValue.TypeClass.CLASS_STRUCT;
            case Model.TypeClass.TypeClassObjCObjectPointer -> LLValue.TypeClass.OBJC_POINTER;
            case Model.TypeClass.TypeClassPointer -> LLValue.TypeClass.POINTER;
            default -> null;
        };
        String referenceExpression = lldbValue.getName();
        LLValue result2 = new LLValue(expression == null ? lldbValue.getName() : expression, lldbValue.getType(), lldbValue.getDisplayType(), lldbValue.hasAddress() ? Long.valueOf(lldbValue.getAddress()) : null, typeClass, referenceExpression);
        result2.putUserData(LLVALUE_ID, lldbValue.getId());
        result2.putUserData(LLVALUE_DATA_LOADER, new LLValueDataLoader());
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static LLValueData getLLValueData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = value;
        synchronized (lLValue) {
            LLValueDataLoader loader = (LLValueDataLoader)value.getUserData(LLVALUE_DATA_LOADER);
            if (loader != null) {
                LLValueData data = loader.loadData(value);
                value.putUserData(LLVALUE_DATA_LOADER, null);
                value.putUserData(LLVALUE_DATA, data);
                return data;
            }
            LLValueData data = (LLValueData)value.getUserData(LLVALUE_DATA);
            if (data == null) {
                throw new ExecutionException(LLDBBundle.message("error.variable.not.initialized", new Object[]{value}));
            }
            return data;
        }
    }

    @Override
    @NotNull
    public LLValue evaluate(long threadId, int frameIndex, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(threadId, frameIndex, expression, LLDBDriver.convertLanguage(language));
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "evaluate", expression);){
            this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.EvaluateExpression_Res.class, res -> {
                if (res.getCommonResponse().getIsValid()) {
                    if (res.hasResult()) {
                        Model.LLDBValue lldbValue = res.getResult();
                        LLValue value = this.createLLValue(lldbValue, expression);
                        result2.set((Object)value);
                    } else {
                        errorMessage.set((Object)NO_RESULT);
                    }
                } else {
                    String error = res.getCommonResponse().getErrorMessage();
                    errorMessage.set((Object)error);
                }
            }, 0L);
        }
        catch (ProtobufTimedOutException e) {
            throw new DebuggerEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                LLValue resultValue = new LLValue("result", "void", null, null, "");
                resultValue.putUserData(LLVALUE_ID, 0);
                resultValue.putUserData(LLVALUE_DATA, new LLValueData("", null, false, false, false));
                resultValue.putUserData(CHILDREN_COUNT_CACHE, 0);
                return resultValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DebuggerCommandException(message);
        }
        if (result2.isNull()) {
            throw new ExecutionException(LLDBBundle.message("error.unknown.evaluation.error", new Object[0]));
        }
        return (LLValue)((Object)result2.get());
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address2, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        Address endAddr;
        Model.LLDBContextInfo contextInfo;
        assert (fallbackRange.contains(address2));
        try {
            ProtocolResponses.ContextInfo_Res res = this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.contextInfo(address2.getUnsignedLongValue()), ProtocolResponses.ContextInfo_Res.class);
            contextInfo = res.hasContextInfo() ? res.getContextInfo() : null;
        }
        catch (LLDBDriverException ex) {
            return this.disassembleRangeWithPivot(fallbackRange, address2, null);
        }
        if (contextInfo == null) {
            return this.disassembleRangeWithPivot(fallbackRange, address2, null);
        }
        Address startAddr = Address.fromUnsignedLong(contextInfo.getStartAddr());
        AddressRange range = AddressUtil.addressRangeExclusive(startAddr, endAddr = Address.fromUnsignedLong(contextInfo.getEndAddr()));
        if (!range.contains(address2)) {
            return this.disassembleRangeWithPivot(fallbackRange, address2, null);
        }
        if (range.getSize() == 1L) {
            return this.disassembleRangeWithPivot(fallbackRange, address2, null);
        }
        String functionName = contextInfo.getName();
        AddressRange saneRange = range.getSize() > 65536L ? range.intersectWith(fallbackRange) : range;
        return this.disassembleRangeWithPivot(saneRange, address2, functionName);
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException {
        return this.disassembleRange(range, null);
    }

    @NotNull
    protected List<LLInstruction> disassembleRange(@NotNull AddressRange range, @Nullable String functionName) throws ExecutionException {
        long start = range.getStart().unsignedLongValue();
        long end = AddressUtil.getEndCoerced(range).unsignedLongValue();
        ProtocolResponses.Disassemble_Res disassembleRes = this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.disassemble(start, end), ProtocolResponses.Disassemble_Res.class);
        return LLDBDriver.convertInstructionList(disassembleRes.getInstructionsList(), functionName, start);
    }

    @NotNull
    protected List<LLInstruction> disassembleRangeWithPivot(@NotNull AddressRange range, @NotNull Address pivot, @Nullable String functionName) throws ExecutionException {
        assert (range.contains(pivot));
        AddressRange rangePostPivot = new AddressRange(pivot, range.getEndInclusive());
        List<LLInstruction> instructionsFromPivot = this.disassembleRange(rangePostPivot, functionName);
        if (instructionsFromPivot.size() == 0) {
            return instructionsFromPivot;
        }
        LLInstruction pivotInstruction = instructionsFromPivot.get(0);
        List<LLInstruction> instructions = this.disassembleRangeUntilPivot(range.getStart(), pivotInstruction, functionName);
        instructions.addAll(instructionsFromPivot);
        return instructions;
    }

    @NotNull
    private List<LLInstruction> disassembleRangeUntilPivot(@NotNull Address start, @NotNull LLInstruction pivot, @Nullable String functionName) throws ExecutionException {
        long startAddr = start.unsignedLongValue();
        AddressRange pivotRange = pivot.getRange();
        long pivotAddr = pivotRange.getStart().unsignedLongValue();
        int pivotInstrSize = (int)pivotRange.getSize();
        ProtocolResponses.Disassemble_Res disassembleRes = this.sendMessageAndWaitForReply((Message)ProtobufMessageFactory.disassembleUntilPivot(startAddr, pivotAddr, pivotInstrSize), ProtocolResponses.Disassemble_Res.class);
        return LLDBDriver.convertInstructionList(disassembleRes.getInstructionsList(), functionName, startAddr);
    }

    @NotNull
    private static List<LLInstruction> convertInstructionList(@NotNull List<Model.LLDBInstruction> instructions, @Nullable String functionName, long functionStart) {
        ArrayList<LLInstruction> result2 = new ArrayList<LLInstruction>(instructions.size());
        for (Model.LLDBInstruction instruction : instructions) {
            long addr = instruction.getAddr();
            LLSymbolOffset functionOffset = functionName == null ? null : new LLSymbolOffset(functionName, addr - functionStart);
            LLInstruction llInstruction = LLInstruction.create(Address.fromUnsignedLong(addr), (Iterable<Byte>)instruction.getOpcodes(), instruction.getMnemonic(), instruction.getOperands(), instruction.getComment(), functionOffset);
            result2.add(llInstruction);
        }
        return result2;
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        return ContainerUtil.map(sectionsMap.keySet(), LLModule::new);
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module) throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        if (!sectionsMap.containsKey(module.getName())) {
            throw new DebuggerCommandException("Can't find module " + module);
        }
        return sectionsMap.get(module.getName());
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException {
        if (this.mySectionsMap == null) {
            this.mySectionsMap = new HashMap<String, List<LLSection>>();
            this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.dumpSections(), ProtocolResponses.DumpSections_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                for (Model.LLDBModule module : res.getModulesList()) {
                    List llSections = ContainerUtil.map(module.getSectionsList(), m -> new LLSection(m.getName(), (List<String>)m.getFlagsList(), AddressUtil.addressRangeExclusive(Address.fromUnsignedLong(m.getStart()), Address.fromUnsignedLong(m.getEnd()))));
                    this.mySectionsMap.put(module.getName(), llSections);
                }
            }));
        }
        return this.mySectionsMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        Ref result2 = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.dumpMemory(range.getStart().unsignedLongValue(), range.getEndInclusive().getUnsignedLongValue() + 1L), ProtocolResponses.DumpMemory_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                exception.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else if ((long)res.getData().size() != range.getSize()) {
                exception.set((Object)new DebuggerCommandException("Unable to read memory " + range));
            } else {
                result2.set((Object)res.getData());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        LLMemoryHunk hunk = new LLMemoryHunk(range, ((ByteString)result2.get()).toByteArray());
        LinkedList<LLMemoryHunk> list = new LinkedList<LLMemoryHunk>();
        list.add(hunk);
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        Ref result2 = new Ref();
        @NlsContexts.DialogMessage Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, s -> StringUtil.escapeCharCharacters((String)s), (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply((Message)ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), ProtocolResponses.ExecuteShellCommand_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                @NlsSafe String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)(!StringUtil.isEmpty((String)message) ? message : LLDBBundle.message("error.invalid.shell.command.response", new Object[0])));
            } else {
                result2.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
            }
        }, (long)(timeoutSecs + 10) * 1000L);
        if (!errorMessage.isNull()) {
            throw new ExecutionException((String)errorMessage.get());
        }
        return (DebuggerDriver.ShellCommandResult)result2.get();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void executeConsoleCommand(@NotNull String command) throws ExecutionException {
        this.executeInterpreterCommand(-1L, -1, command);
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(@NotNull String command) throws ExecutionException {
        return this.executeInterpreterCommand(-1L, -1, command);
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(long threadId, int frameIndex, @NotNull String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameIndex, command);
        ProtocolResponses.HandleConsoleCommand_Res reply = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.HandleConsoleCommand_Res.class);
        if (reply.hasErr()) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(reply.getErr()), ProcessOutputTypes.STDERR);
        }
        if (reply.hasOut()) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(reply.getOut()), ProcessOutputTypes.STDOUT);
            return reply.getOut();
        }
        return "";
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        ProtocolResponses.HandleCompletion_Res reply = this.sendMessageAndWaitForReply((Message)request, ProtocolResponses.HandleCompletion_Res.class);
        return DebuggerDriver.ResultList.create(reply.getCompletionList(), false);
    }

    @Override
    public void handleSignal(@NotNull String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.handle.signal", new Object[0]));
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop, pass, notify);
        this.sendMessageAndWaitForReply((Message)handleSignalReq, ProtocolResponses.HandleSignal_Res.class, responseHandler);
    }

    @Override
    public void cancelSymbolsDownload(@NotNull String details) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest cancelSymbolsDownloadReq = ProtobufMessageFactory.cancelSymbolsDownload(details);
        this.getProtobufClient().sendMessage((Message)cancelSymbolsDownloadReq, null, null);
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @TestOnly
    public OutputStream getProcessInputInternalStream() {
        return this.myProcessInput;
    }

    @Override
    public void removeWatchpoint(@NotNull List<Integer> ids) throws ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(LLDBBundle.message("error.cannot.remove.watchpoint", new Object[0]));
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.sendMessageAndWaitForReply((Message)req, ProtocolResponses.RemoveWatchpoint_Res.class, responseHandler);
    }

    @Override
    @NotNull
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        Integer cached = (Integer)var.getUserData(CHILDREN_COUNT_CACHE);
        if (cached != null) {
            return cached;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetChildrenCount_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getCount());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        var.putUserData(CHILDREN_COUNT_CACHE, (Integer)result2.get());
        return (Integer)result2.get();
    }

    public long getValueAddress(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.GetValueAddress_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getAddress());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return (Long)result2.get();
    }

    protected void lldbSet(@NotNull String setting, boolean enabled) throws ExecutionException {
        this.lldbSet(setting, enabled ? "true" : "false");
    }

    protected void lldbSet(@NotNull String setting, @Nullable String value) throws ExecutionException {
        String settingCommand = value != null ? "set " + setting + " " + value : "remove " + setting;
        this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "settings " + settingCommand), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.setting.to", setting, value)));
    }

    @Contract(pure=true)
    @NotNull
    protected String createTypeSummaryConsoleCommand(@NotNull String summaryString, @Nullable String category, String ... typeNames) {
        return String.format("type summary add --skip-pointers --summary-string %s --category %s %s", LLDBDriver.stringify(summaryString), category != null ? category : "default", Arrays.stream(typeNames).map(s -> DebuggerDriver.stringify(s)).collect(Collectors.joining(" ")));
    }

    private void lldbSetStepIntoNoDebug(boolean value) throws ExecutionException {
        this.lldbSet("target.process.thread.step-in-avoid-nodebug", !value);
    }

    private void haveConnection(@NotNull String version, long capabilities) {
        this.handlePrompt();
        try {
            String[] typeSummaryConsoleCommands;
            this.myLLDBVersion = LLDBDriverConfiguration.parseVersion(version);
            this.myCapabilities = capabilities;
            this.lldbSetStepIntoNoDebug(false);
            this.lldbSet("target.process.thread.step-out-avoid-nodebug", true);
            if (CidrDebuggerLog.LOG.isTraceEnabled()) {
                String logPath = LLDBDriver.getLogDir() + "/lldb.log";
                this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "log enable -f " + logPath + " lldb default"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            if (this.myAutorunScriptName != null) {
                this.executeConsoleCommandAndHandleOutput(String.format("command script import \"%s\"", this.myAutorunScriptName));
            }
            for (String typeSummaryConsoleCommand : typeSummaryConsoleCommands = new String[]{this.createTypeSummaryConsoleCommand("${var%d} ${var}", "cplusplus", "char", "signed char"), this.createTypeSummaryConsoleCommand("${var%u} ${var}", "cplusplus", "unsigned char")}) {
                this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, typeSummaryConsoleCommand), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "type category enable objc"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().isValuesFilterEnabled()), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid(LLDBBundle.message("error.cannot.set.values.filtering.policy", new Object[0])));
            if (this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                this.executeConsoleCommandAndHandleOutput("command script import lldb_formatters");
            }
            this.myConnectedClient.complete(this.myProtobufServer);
        }
        catch (Exception e) {
            this.myConnectedClient.completeExceptionally(e);
        }
    }

    private void executeConsoleCommandAndHandleOutput(@NonNls @NotNull String command) throws ProtobufTimedOutException {
        this.myProtobufServer.sendMessageAndWaitUntilSent((Message)ProtobufMessageFactory.handleConsoleCommand(-1L, -1, command), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut() || res.hasErr()) {
                String message = LLDBBundle.message("error.during.data.formatters.setup.0.1", res.hasOut() ? "\n" + res.getOut() : "", res.hasErr() ? "\n" + res.getErr() : "");
                this.handleTargetOutput(message, ProcessOutputTypes.SYSTEM);
            }
        }));
    }

    public void consume(@NotNull Message generatedMessage) {
        try (CidrEventSpan ignored = new CidrEventSpan("debug", (Function0<String>)((Function0)() -> "consume (" + generatedMessage.getClass().getSimpleName() + ")"), (Function0<String>)((Function0)() -> generatedMessage.toString()));){
            this.handleMessage(generatedMessage);
        }
    }

    private void handleMessage(@NotNull Message generatedMessage) {
        if (generatedMessage instanceof Broadcasts.Initialized_Message) {
            Broadcasts.Initialized_Message init = (Broadcasts.Initialized_Message)generatedMessage;
            this.haveConnection(init.getVersionString(), init.getCapabilities());
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            int signal;
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            String exitDescription = exit.hasExitDescription() ? exit.getExitDescription() : null;
            DebuggerDriver.ExitStatus exitStatus = new DebuggerDriver.ExitStatus(exitCode, exitDescription);
            if (SystemInfo.isMac && exitCode == 0 && exitDescription != null && exitDescription.startsWith(TERMINATED_DUE_TO_SIGNAL) && (signal = StringUtil.parseInt((String)exitDescription.substring(TERMINATED_DUE_TO_SIGNAL.length()).trim(), (int)-1)) > 0) {
                exitStatus = DebuggerDriver.ExitStatus.fromSignal(signal);
            }
            this.handleTargetTerminated(exitStatus);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.myStoppedThread = null;
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            Set<Object> temporaryBreakpoints = Collections.emptySet();
            try {
                temporaryBreakpoints = this.removeTemporaryBreakpoints();
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
            }
            Broadcasts.ProcessInterrupted_Broadcast interrupted_broadcast = (Broadcasts.ProcessInterrupted_Broadcast)generatedMessage;
            Model.LLDBThread lldbThread = interrupted_broadcast.getThread();
            LLThread thread = this.newLLThread(lldbThread);
            LLFrame frame = this.newLLFrame(interrupted_broadcast.getFrame());
            Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.hasStopReasonInfo() ? lldbThread.getStopReasonInfo() : null;
            Model.ThreadStopReason stopReason = stopReasonInfo == null ? null : stopReasonInfo.getStopReason();
            DebuggerDriver.StopPlace stopPlace = stopReasonInfo != null && stopReasonInfo.hasReturnValue() ? new DebuggerDriver.StopPlace(thread, frame, this.createLLValue(stopReasonInfo.getReturnValue(), null)) : new DebuggerDriver.StopPlace(thread, frame);
            this.myStoppedThread = stopPlace.thread;
            if (stopReason == Model.ThreadStopReason.ThreadStopReasonBreakpoint && stopReasonInfo.hasCodepointId() && !temporaryBreakpoints.contains(stopReasonInfo.getCodepointId())) {
                this.handleBreakpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonWatchpoint && stopReasonInfo.hasCodepointId()) {
                this.handleWatchpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonSignal) {
                int signal = stopReasonInfo.getSignal();
                if (LLDBDriver.isTargetTerminationSignal(signal)) {
                    this.handleTargetTerminated(DebuggerDriver.ExitStatus.fromSignal(signal));
                } else {
                    String signalName = StringUtil.defaultIfEmpty((String)stopReasonInfo.getSignalName(), (String)String.valueOf(signal));
                    this.handleSignal(stopPlace, signalName, stopReasonInfo.getStopDescription());
                }
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonException) {
                this.handleException(stopPlace, Address.fromUnsignedLong(stopReasonInfo.getAddress()), stopReasonInfo.hasFile() ? stopReasonInfo.getFile() : null, LLDBDriver.createSourceFileHash(stopReasonInfo.hasHashType() ? stopReasonInfo.getHashType() : null, stopReasonInfo.hasHash() ? stopReasonInfo.getHash() : null), stopReasonInfo.hasLine() ? stopReasonInfo.getLine() - 1 : -1, stopReasonInfo.getStopDescription());
            } else {
                this.handleInterrupted(stopPlace);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handlePrompt(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() == 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleDebuggerOutput(LLDBDriver.asNlsSafe(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage()), ProcessOutputTypes.STDOUT);
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(LLDBDriver.asNlsSafe(outputBroadcast.getText()), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            Broadcasts.ModulesLoaded_Broadcast msg = (Broadcasts.ModulesLoaded_Broadcast)generatedMessage;
            List lst = ContainerUtil.map((Collection)msg.getModulesList(), module -> new LLModule(module.trim()));
            this.handleModulesLoaded(lst);
        } else if (generatedMessage instanceof Broadcasts.BreakpointAdded_Broadcast) {
            Broadcasts.BreakpointAdded_Broadcast msg = (Broadcasts.BreakpointAdded_Broadcast)generatedMessage;
            Model.LLDBBreakpoint brk = msg.getBreakpoint();
            List<Model.LLDBBreakpointLocation> brkLocations = msg.getLocationList();
            DebuggerDriver.AddBreakpointResult result2 = LLDBDriver.makeBreakpoint(brk, brkLocations);
            this.handleBreakpointAdded(result2.getBreakpoint());
            this.handleBreakpointLocationsUpdated(result2.getBreakpoint().getId(), result2.getBreakpointLocations());
        } else if (generatedMessage instanceof Broadcasts.BreakpointRemoved_Broadcast) {
            Broadcasts.BreakpointRemoved_Broadcast msg = (Broadcasts.BreakpointRemoved_Broadcast)generatedMessage;
            int breakpointId = msg.getBreakpointId();
            this.handleBreakpointRemoved(breakpointId);
        } else if (generatedMessage instanceof Broadcasts.BreakpointLocationsAdded_Broadcast) {
            Broadcasts.BreakpointLocationsAdded_Broadcast msg = (Broadcasts.BreakpointLocationsAdded_Broadcast)generatedMessage;
            int breakpointId = msg.getBreakpointId();
            List<Model.LLDBBreakpointLocation> locations = msg.getLocationList();
            List locationList = ContainerUtil.mapNotNull(locations, loc -> LLDBDriver.makeLocation(breakpointId, loc));
            this.handleBreakpointLocationsUpdated(breakpointId, locationList);
        } else if (generatedMessage instanceof Broadcasts.BreakpointLocationsRemoved_Broadcast) {
            Broadcasts.BreakpointLocationsRemoved_Broadcast msg = (Broadcasts.BreakpointLocationsRemoved_Broadcast)generatedMessage;
            int breakpointId = msg.getBreakpointId();
            List<Integer> locationIds = msg.getLocationIdList();
            List locationStrids = ContainerUtil.map(locationIds, id -> LLDBDriver.makeBreakpointLocationCanonicalName(breakpointId, id));
            this.handleBreakpointLocationsRemoved(breakpointId, locationStrids);
        } else if (generatedMessage instanceof Broadcasts.BreakpointLocationsResolved_Broadcast) {
            Broadcasts.BreakpointLocationsResolved_Broadcast msg = (Broadcasts.BreakpointLocationsResolved_Broadcast)generatedMessage;
            int breakpointId = msg.getBreakpointId();
            List<Model.LLDBBreakpointLocation> locations = msg.getLocationList();
            List locationList = ContainerUtil.mapNotNull(locations, loc -> LLDBDriver.makeLocation(breakpointId, loc));
            this.handleBreakpointLocationsUpdated(breakpointId, locationList);
        } else if (generatedMessage instanceof Broadcasts.BreakpointChanged_Broadcast) {
            Broadcasts.BreakpointChanged_Broadcast msg = (Broadcasts.BreakpointChanged_Broadcast)generatedMessage;
            Model.BreakpointChangedEventType eventType = msg.getEventType();
            Model.LLDBBreakpoint brk = msg.getBreakpoint();
            List<Model.LLDBBreakpointLocation> brkLocations = msg.getLocationList();
            DebuggerDriver.AddBreakpointResult bRes = LLDBDriver.makeBreakpoint(brk, brkLocations);
            LLBreakpoint breakpoint = bRes.getBreakpoint();
            this.handleBreakpointUpdated(breakpoint);
            this.handleBreakpointLocationsReplaced(breakpoint.getId(), bRes.getBreakpointLocations());
        } else if (generatedMessage instanceof Broadcasts.SelectedFrameChanged_Broadcast) {
            Broadcasts.SelectedFrameChanged_Broadcast msg = (Broadcasts.SelectedFrameChanged_Broadcast)generatedMessage;
            LLThread thread = this.newLLThread(msg.getThread());
            LLFrame frame = this.newLLFrame(msg.getFrame());
            this.handleSelectedFrameChanged(thread, frame);
        } else if (generatedMessage instanceof Broadcasts.SymbolsDownloadStarted_Broadcast) {
            Broadcasts.SymbolsDownloadStarted_Broadcast msg = (Broadcasts.SymbolsDownloadStarted_Broadcast)generatedMessage;
            this.handleSymbolsDownloadStarted(msg.getCaption(), msg.getDetails());
        } else if (generatedMessage instanceof Broadcasts.SymbolsDownloadProgress_Broadcast) {
            Broadcasts.SymbolsDownloadProgress_Broadcast msg = (Broadcasts.SymbolsDownloadProgress_Broadcast)generatedMessage;
            this.handleSymbolsDownloadProgress(msg.getPercent());
        } else if (generatedMessage instanceof Broadcasts.SymbolsDownloadFinished_Broadcast) {
            this.handleSymbolsDownloadFinished();
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    protected static class ThrowDebuggerCommandExceptionIfNotValid<T extends Message>
    extends ResponseMessageConsumer<T, DebuggerCommandException> {
        public ThrowDebuggerCommandExceptionIfNotValid(@NlsContexts.DialogMessage String message) {
            super(message);
        }

        @Override
        public void throwError() throws DebuggerCommandException {
            throw new DebuggerCommandException(this.getMessage());
        }
    }

    protected static abstract class ResponseMessageConsumer<T extends Message, E extends Exception>
    implements Consumer<T> {
        private @NlsContexts.DialogMessage String myMessage;
        private boolean myIsValid = false;

        public ResponseMessageConsumer(@NlsContexts.DialogMessage String message) {
            this.myMessage = message;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof ProtocolResponses.CommonResponse)) continue;
                ProtocolResponses.CommonResponse commonResponse = (ProtocolResponses.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws E {
            if (!this.myIsValid) {
                this.throwError();
            }
        }

        @NlsContexts.DialogMessage
        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        abstract void throwError() throws E;
    }

    protected static class ThrowIfNotValid<T extends Message>
    extends ResponseMessageConsumer<T, LLDBDriverException> {
        public ThrowIfNotValid(@NlsContexts.DialogMessage String message) {
            super(message);
        }

        @Override
        public void consume(T message) {
            super.consume(message);
        }

        @Override
        public void throwIfNeeded() throws LLDBDriverException {
            super.throwIfNeeded();
        }

        @Override
        public void throwError() throws LLDBDriverException {
            throw new LLDBDriverException(this.getMessage());
        }
    }

    private class LLValueDataLoader {
        private LLValueDataLoader() {
        }

        @NotNull
        public LLValueData loadData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            Protocol.CompositeRequest req = ProtobufMessageFactory.getValueData(LLDBDriver.valId(value), 256);
            Ref lldbDataRef = Ref.create();
            Ref exception = Ref.create();
            LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply((Message)req, ProtocolResponses.GetValueData_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                    return;
                }
                lldbDataRef.set((Object)res.getValue());
            }));
            if (!exception.isNull()) {
                throw (DebuggerCommandException)exception.get();
            }
            Model.LLDBValueData lldbData = (Model.LLDBValueData)lldbDataRef.get();
            return new LLValueData(lldbData.getValue(), lldbData.hasDescription() ? lldbData.getDescription() : null, lldbData.getHasLongerDescription(), lldbData.getMayHaveChildren(), lldbData.getIsSynthetic());
        }
    }

    private class ProcessInputDispatcher
    extends OutputStream {
        private ProcessInputDispatcher() {
        }

        @Override
        public void write(int i) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(byte @NotNull [] bytes, int i, int i1) throws IOException {
            try {
                String input = new String(bytes, i, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }
}

