/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class LLDBBinUrlProvider {
    private static final String LLDB_BIN_PROPERTIES = "bin.LLDB.properties";
    private static final String LLDB_FRONTEND_BIN_PROPERTIES = "bin.LLDBFrontend.properties";
    public static final Bin lldbFrontend;
    public static final Bin lldb;

    private static Properties loadProperties(String propertiesResourceFilePath) throws IOException {
        Properties properties = new Properties();
        properties.load(LLDBBinUrlProvider.class.getClassLoader().getResourceAsStream(propertiesResourceFilePath));
        return properties;
    }

    static {
        Bin lldb_ = null;
        Bin lldbFrontend_ = null;
        try {
            Properties properties = LLDBBinUrlProvider.loadProperties(LLDB_BIN_PROPERTIES);
            lldb_ = new Bin("lldb", properties.getProperty("urlBase"), properties.getProperty("linux@hash"), properties.getProperty("mac@hash"), properties.getProperty("win@hash"));
            properties = LLDBBinUrlProvider.loadProperties(LLDB_FRONTEND_BIN_PROPERTIES);
            lldbFrontend_ = new Bin("lldbfrontend", properties.getProperty("urlBase"), properties.getProperty("hash"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        lldb = lldb_;
        lldbFrontend = lldbFrontend_;
    }

    public static class Bin {
        public final URL linuxAarch64;
        public final URL linuxX64;
        public final URL macX64;
        public final URL winAarch64;
        public final URL winX86;
        public final URL winX64;

        Bin(String name, String urlBase, String linuxVersion, String macVersion, String winVersion) throws MalformedURLException {
            this.linuxAarch64 = Bin.generateUrl(name, urlBase, linuxVersion, Os.linux, Arch.aarch64);
            this.linuxX64 = Bin.generateUrl(name, urlBase, linuxVersion, Os.linux, Arch.x64);
            this.macX64 = Bin.generateUrl(name, urlBase, macVersion, Os.mac, Arch.x64);
            this.winAarch64 = Bin.generateUrl(name, urlBase, winVersion, Os.win, Arch.aarch64);
            this.winX86 = Bin.generateUrl(name, urlBase, winVersion, Os.win, Arch.x86);
            this.winX64 = Bin.generateUrl(name, urlBase, winVersion, Os.win, Arch.x64);
        }

        Bin(String name, String urlBase, String version) throws MalformedURLException {
            this(name, urlBase, version, version, version);
        }

        private static URL generateUrl(String name, String urlBase, String version, Os os, Arch arch) throws MalformedURLException {
            return new URL(urlBase + name + "/" + version + "/" + name + "-" + version + "-" + os.name() + "-" + arch.name() + (os == Os.win ? ".zip" : ".tar.gz"));
        }

        private static enum Os {
            mac,
            linux,
            win;

        }

        private static enum Arch {
            x86,
            x64,
            aarch64;

        }
    }
}

