/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBTuple
extends ArrayList<Object> {
    private static final List<String> TRUE_STRINGS = Arrays.asList("true", "yes", "on");
    private static final List<String> FALSE_STRINGS = Arrays.asList("false", "no", "off");

    @NotNull
    public static GDBTuple of(Object ... elements) {
        GDBTuple tuple = new GDBTuple();
        tuple.addAll(Arrays.asList(elements));
        return tuple;
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    protected <T> T get(@NonNls @NotNull String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return defaultValue;
    }

    @NonNls
    @Nullable
    public String getString(@NonNls @NotNull String key) {
        return this.getString(key, null);
    }

    @Contract(value="_, !null -> !null")
    @NonNls
    @Nullable
    public String getString(@NonNls @NotNull String key, @NonNls @Nullable String defaultValue) {
        return this.get(key, String.class, defaultValue);
    }

    @NonNls
    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredStringOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
    }

    @NonNls
    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(@NonNls @NotNull String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getString(key), exceptionSupplier);
    }

    @NonNls
    @NotNull
    public String getRequiredString(@NonNls @NotNull String key) throws ExecutionException {
        return this.getRequiredStringOrThrow(key, ExecutionException::new);
    }

    @Nullable
    public GDBTuple getTuple(@NonNls @NotNull String key) {
        return this.get(key, GDBTuple.class, null);
    }

    @NotNull
    public GDBTuple getTupleOrEmpty(@NonNls @NotNull String key) {
        GDBTuple value = this.getTuple(key);
        if (value == null) {
            value = new GDBTuple();
        }
        return value;
    }

    @NotNull
    public GDBTuple getRequiredTuple(@NonNls @NotNull String key) throws ExecutionException {
        return this.getRequiredTupleOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredTupleOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(@NonNls @NotNull String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getTuple(key), exceptionSupplier);
    }

    @Nullable
    public Address getAddress(@NonNls @NotNull String key) {
        return this.getAddress(key, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Address getAddress(@NonNls @NotNull String key, @Nullable Address defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseAddress(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Address getRequiredAddress(@NonNls @NotNull String key) throws ExecutionException {
        return this.getRequiredAddressOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> Address getRequiredAddressOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseAddress(s, null), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private static Address parseAddress(@NonNls @NotNull String s, @Nullable Address defaultValue) {
        try {
            return Address.parseHexString(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Integer getInteger(@NonNls @NotNull String key, @Nullable Integer defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseInteger(s, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(@NonNls @NotNull String key, int defaultValue) {
        return this.getInteger(key, defaultValue);
    }

    public int getRequiredInt(@NonNls @NotNull String key) throws ExecutionException {
        return this.getRequiredIntOrThrow(key, ExecutionException::new);
    }

    public <X extends Throwable> int getRequiredIntOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseInteger(s, null), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private static Integer parseInteger(@NonNls @NotNull String s, @Nullable Integer defaultValue) {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(@NonNls @NotNull String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(@NonNls @NotNull String key, boolean defaultValue) {
        @NonNls String s = this.getString(key);
        if (s != null) {
            String lowerCase = StringUtil.toLowerCase((String)s);
            if (TRUE_STRINGS.contains(lowerCase)) {
                return true;
            }
            if (FALSE_STRINGS.contains(lowerCase)) {
                return false;
            }
            Integer integer = GDBTuple.parseInteger(s, null);
            if (integer != null) {
                return integer != 0;
            }
        }
        return defaultValue;
    }

    @Nullable
    public FileLocation getLocation(@NonNls @NotNull String key) {
        return this.getLocation(key, (FileLocation)null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public FileLocation getLocation(@NonNls @NotNull String key, @Nullable FileLocation defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return FileLocation.tryParse(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public FileLocation getRequiredLocation(@NonNls @NotNull String key) throws ExecutionException {
        return this.getRequiredLocationOrThrow(key, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> FileLocation getRequiredLocationOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(FileLocation.tryParse(s), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.location.string", s, key, this)));
    }

    @Nullable
    public FileLocation getLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey) {
        return this.getLocation(pathKey, lineKey, null);
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    public FileLocation getLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey, @Nullable FileLocation defaultValue) {
        String path = this.getString(pathKey);
        Integer lineNumber = this.getInteger(lineKey, null);
        if (path != null && lineNumber != null) {
            return FileLocation.fromFileLineNumber(path, lineNumber);
        }
        return defaultValue;
    }

    @NotNull
    public FileLocation getRequiredLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey) throws ExecutionException {
        return this.getRequiredLocationOrThrow(pathKey, lineKey, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> FileLocation getRequiredLocationOrThrow(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String path = GDBTuple.checkNotNullOrThrow(this.getString(pathKey), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(pathKey)));
        int lineNumber = this.getRequiredIntOrThrow(lineKey, exceptionConstructor);
        return FileLocation.fromFileLineNumber(path, lineNumber);
    }

    @NotNull
    public <T> List<T> getAll(@NonNls @NotNull String key, @NotNull Class<T> clazz) {
        SmartList result2 = new SmartList();
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (o == null) continue;
            result2.add(clazz.cast(o));
        }
        return result2;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(@NonNls @NotNull String key, @NotNull Class<T> clazz) {
        return this.getWithSuccessors(key, clazz, null);
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(@NonNls @NotNull String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        SmartList successors = new SmartList();
        Object found = null;
        for (Object each : this) {
            if (found == null) {
                found = GDBTuple.getIfEquals(each, key);
                continue;
            }
            if (each instanceof Pair) break;
            successors.add(clazz.cast(each));
        }
        if (found == null) {
            found = defaultValue;
        }
        return Pair.create(found, (Object)successors);
    }

    @NotNull
    private Supplier<String> missingKeyError(@NonNls @NotNull String key) {
        return GDBBundle.messagePointer("error.missing.required.key", key, this);
    }

    @NotNull
    private static <X extends Throwable> Supplier<X> withMessage(@NotNull Function<String, ? extends X> exceptionConstructor, @NotNull Supplier<String> messageSupplier) {
        return () -> (Throwable)exceptionConstructor.apply((String)messageSupplier.get());
    }

    @NotNull
    private static <T, X extends Throwable> T checkNotNullOrThrow(@Nullable T value, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    @Nullable
    private static <T> T getIfEquals(@NotNull Object val, @NonNls @NotNull String key) {
        if (val.equals(key)) {
            return (T)val;
        }
        if (val instanceof Pair && ((Pair)val).first.equals(key)) {
            return (T)((Pair)val).second;
        }
        return null;
    }
}

