/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.VersionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.unix.Pty;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GDBDriver
extends DebuggerDriver {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^GNU gdb (?:\\([^()]*(?:(?:\\([^()]+\\))[^()]*)*\\))+[^\\d]*(\\d+\\.\\d+(?:\\.\\d+)?).*");
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    private static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    @NonNls
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    @NonNls
    private static final String MAX_COMPLETIONS_REACHED = "*** List may be truncated, max-completions reached. ***";
    @NonNls
    private static final String FINISH_NOT_MEANINGFUL_IN_THE_OUTERMOST_FRAME = "\"finish\" not meaningful in the outermost frame.";
    @NonNls
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern INSTRUCTION_LINE = Pattern.compile("^.{0,4}0x([0-9a-f]+)(?: (<.*>))?:\t((?:[0-9a-f]{2}(?: |(?=\t)))+)\t(.*)$");
    private static final Pattern INSTRUCTION_COMMENT = Pattern.compile("^([^#]*?)\\s*#\\s*(.*)$");
    private static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME = Pattern.compile("^([^#]*(?:0|0x[0-9a-f]+))\\s*(<.*>)\\s*$", 2);
    private static final Pattern WHATIS_TYPE_OUTPUT = Pattern.compile("^(?:\\+.*?\\n)*type = (?:(?:/\\* real type = (.*) \\*/\\n.*)|(.*))\\n");
    private static final Pattern NON_ID_PATTERN = Pattern.compile("\\W+");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    private static final Pattern OBJECT_FILE_HEADER = Pattern.compile("^(?: {2}Object file: (.*)|\\w+ file: `(.+)', file type .+\\.)$");
    private static final Pattern SECTIONS_INFO = Pattern.compile("^(?: \\[\\d+])?\\s*(0x[0-9a-f]+)->(0x[0-9a-f]+)(?: at 0x[0-9a-f]+): (\\S+)(.*)$");
    private static final Pattern LINE_INFO_RESULT = Pattern.compile("^Line ([0-9]+) of .* starts at address 0x([0-9a-f]+)(?: (<.*>))? and ends at 0x([0-9a-f]+)(?: (<.*>))?.*");
    private static final Pattern LINE_INFO_NO_CODE_RESULT = Pattern.compile("^Line ([0-9]+) of .* is at address 0x([0-9a-f]+)(?: (<.*>))? but contains no code.*");
    private static final int IGNORE_RESPONSE_COMMAND_TOKEN = 0;
    private static final Pattern VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: (\\w?\".*\"(?:\\.\\.\\.)?))?$");
    private static final LLValueLoadedData EMPTY_LOADED_VALUE = new LLValueLoadedData("", null, 0, false, false, "", "");
    @Nullable
    private static Boolean ourShellAvailable;
    @TestOnly
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @NotNull
    private final DebuggerDriverConfiguration myStarter;
    @NlsSafe
    @NotNull
    private final String myInterruptSignalName;
    @Nullable
    private Version myGdbVersion;
    @Nullable
    private String myWinBreakPath;
    private boolean myWindowsIoRedirectionEnabled;
    private boolean myUseExternalConsoleRequested;
    @NotNull
    private final GeneralCommandLine myGdbCommandLine;
    @NotNull
    private final BaseProcessHandler myProcessHandler;
    private final boolean myEmulateStepMode;
    private volatile boolean myMIAsyncMode = false;
    private volatile boolean myStepMode = false;
    private final Deque<Integer> myPromptLevelStack = new ArrayDeque<Integer>();
    @NotNull
    private final Writer mySink;
    @Nullable
    private volatile OutputStream myProcessInput;
    private final Collection<String> allocatedVariables = new ArrayList<String>();
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i) throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i);
            }
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i, i1);
            }
        }

        @Override
        public void close() throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.flush();
            }
        }
    };
    private final Semaphore myCommandSemaphore = new Semaphore();
    private final ExecutorService myCommandExecutor;
    private final BlockingQueue<Response> myResultQueue = new LinkedBlockingQueue<Response>();
    private final Semaphore myStopSemaphore = new Semaphore();
    private boolean myIsInterruptedStop;
    private final Semaphore myPendingForAttachNotification = new Semaphore();
    @Nullable
    private volatile Integer myTargetPID = null;
    @Nullable
    private volatile LongSet myIndirectSymbols;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @NotNull
    private final ModuleMap myModuleMap = new ModuleMap();
    @Nullable
    private volatile LLModule myTargetModule = null;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace = null;
    @NotNull
    private volatile Communication myCommunication = new Communication("");
    @Nullable
    private volatile String myLastCommand = null;
    private boolean myIsConsoleCommand;
    private ThreadFrameInfoDriverDelegate myThreadFrameInfoDriverDelegate = new ThreadFrameInfoDriverDelegate(){};
    private final Bridge myBridge = new Bridge(){

        @Override
        @NotNull
        public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> c) {
            return GDBDriver.this.executeAsyncCommand(c);
        }

        @Override
        @NotNull
        public <T> T executeCommand(@NotNull Command<T> c) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.executeCommand(c);
        }

        @Override
        @NotNull
        public String sendSilentRequestAndGetOutput(@NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
            return GDBDriver.this.sendSilentRequestAndWaitForDone(command, args).getOutput();
        }

        @Override
        @NotNull
        public LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doReadFrame(level, frameTuple);
        }

        @Override
        @NotNull
        public DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doGetFrames(threadId, from, count, untilFirstLineWithCode);
        }

        @Override
        @NotNull
        public List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doGetFrameVariables(threadId, frameIndex);
        }

        @Override
        @NotNull
        public LLValueData doEvaluateAndLoad(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
            LLValue threadIdValue = GDBDriver.this.doEvaluate(threadId, frameIndex, expression, language);
            return GDBDriver.this.doLoadVariable((LLValue)threadIdValue).data;
        }

        @Override
        @Nullable
        public DebuggerDriver.StopPlace getStopPlace() {
            return GDBDriver.this.myStopPlace;
        }

        @Override
        @NotNull
        public LLValueData doLoadVariableData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doLoadVariable((LLValue)value).data;
        }

        @Override
        @NotNull
        public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doGetVariableChildren(var, offset, count);
        }

        @Override
        @NotNull
        public LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
            String debuggerLanguage = GDBDriver.convertLanguage(language);
            return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage);
        }

        @Override
        @Nullable
        public LLValue doReadReturnValue(@NotNull GDBTuple stopTuple, long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
            return GDBDriver.this.doReadReturnValue(stopTuple, threadId, frameIndex);
        }
    };

    @TestOnly
    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        this.setMIOutputFilterInTests((NotNullFunction<? super String, String>)((NotNullFunction)s -> s.replaceAll(regexp, replacement)));
    }

    @TestOnly
    public void setMIOutputFilterInTests(@Nullable NotNullFunction<? super String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    @TestOnly
    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    @Deprecated
    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter) throws ExecutionException {
        this(handler, starter, ArchitectureType.UNKNOWN);
    }

    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws ExecutionException {
        super(handler);
        this.myStarter = starter;
        this.myInterruptSignalName = this.getInterruptSignalName();
        this.myEmulateStepMode = this.isMac();
        this.myCommandExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)this.getClass().getSimpleName(), (int)1);
        this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this, architectureType);
        this.myProcessHandler = this.createDebugProcessHandler(this.myGdbCommandLine, this.myStarter);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            @NotNull
            private StringBuilder myBuffer = new StringBuilder();
            private Boolean myGotAnyStdout = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                @NotNull String text = event.getText();
                if (outputType == ProcessOutputTypes.STDERR && !this.myGotAnyStdout.booleanValue()) {
                    GDBDriver.this.handleTargetOutput(text, outputType);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    int end;
                    this.myGotAnyStdout = true;
                    this.myBuffer.append(text);
                    String content = this.myBuffer.toString();
                    boolean changed = false;
                    while ((end = content.indexOf("\n")) != -1) {
                        String response = content.substring(0, end).trim();
                        content = content.substring(end + 1);
                        changed = true;
                        MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                        if (filter != null) {
                            for (String line : StringUtil.splitByLines((String)filter.apply(GDBDriver.this.myCommunication.command, response))) {
                                GDBDriver.this.processResponse(line);
                            }
                            continue;
                        }
                        GDBDriver.this.processResponse(response);
                    }
                    if (changed) {
                        this.myBuffer = new StringBuilder(content);
                    }
                } else {
                    if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug("<" + text);
                    }
                    if (ProcessOutputType.isStderr((Key)outputType)) {
                        GDBDriver.this.handleDebuggerOutput(text, outputType);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                CidrDebuggerLog.LOG.debug("<[terminated]");
                GDBDriver.this.cleanupOnTermination();
                GDBDriver.this.handleExited(event.getExitCode());
            }
        });
        OutputStream input = this.myProcessHandler.getProcessInput();
        Charset charset = this.myProcessHandler.getCharset();
        assert (charset != null);
        this.mySink = new OutputStreamWriter(input, charset);
        this.myCommandSemaphore.down();
        this.executeCommandNoUserException(() -> this.handlePrompt());
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    public boolean supportsJumpToLine() {
        return true;
    }

    @Override
    @TestOnly
    public void waitHandlerProcessed() {
        if (this.myCommandExecutor.isShutdown()) {
            while (true) {
                try {
                    while (!this.myCommandExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        super.waitHandlerProcessed();
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(@NotNull List<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(@NotNull File file, @Nullable File module) {
    }

    @Override
    public boolean isInPromptMode() {
        return this.getPromptLevel() > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(@NotNull DebuggerDriver.TargetState state) {
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() {
                    GDBDriver.this.allocatedVariables.forEach(GDBDriver.this::doDeleteVar);
                    GDBDriver.this.allocatedVariables.clear();
                }
            });
        }
    }

    private void doDeleteVar(String varId) {
        try {
            this.sendRequestAndWaitForDone("-var-delete %s", varId);
        }
        catch (ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @NotNull
    private String getInterruptSignalName() {
        String signalName;
        if (this.isWindows()) {
            return "INT";
        }
        try {
            String signalNameFromRegistry = Registry.stringValue((String)"cidr.debugger.gdb.interrupt.signal");
            signalName = StringUtil.trimStart((String)StringUtil.toUpperCase((String)signalNameFromRegistry.trim()), (String)"SIG");
            if (!StringUtil.isLatinAlphanumeric((CharSequence)signalName)) {
                this.warnUser("Invalid interrupt signal name '" + signalNameFromRegistry + "'; falling back to SIGSTOP");
                signalName = "STOP";
            }
        }
        catch (MissingResourceException e) {
            signalName = "STOP";
        }
        if (!this.getHostMachine().isRemote() && UnixProcessManager.getSignalNumber((String)signalName) == -1) {
            this.warnUser("Unknown interrupt signal SIG" + signalName);
        }
        return signalName;
    }

    @NotNull
    protected String shellQuote(@NotNull String s) {
        if (this.isWindows()) {
            return CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false);
        }
        return GDBDriver.format("'%s'", s.replace("'", "'\\''"));
    }

    private void warnUser(@NlsSafe @NotNull String message) {
        this.warnUser(message, null);
    }

    private void warnUser(@NlsSafe @NotNull String message, @Nullable Throwable e) {
        message = message.trim();
        this.handleTargetOutput(message + "\n\n", ProcessOutputTypes.SYSTEM);
        CidrDebuggerLog.LOG.warn(message, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) {
    }

    private void doSetUpGDB(boolean isRemoteTarget) throws ExecutionException {
        boolean isElevated = this.myStarter.isElevated();
        try {
            this.doSetMaxDescription(true);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("print asm-demangle", true);
            this.gdbSet("python print-stack", "full");
            if (this.myEmulateStepMode) {
                this.gdbSet("step-mode", true);
            }
            this.gdbSet("backtrace past-main", true);
            this.gdbSet("backtrace past-entry", true);
            this.doSetMIAsync(isRemoteTarget || isElevated || Registry.is((String)"cidr.debugger.gdb.forceMIAsync", (boolean)false));
            if (!isRemoteTarget && !"INT".equals(this.myInterruptSignalName)) {
                try {
                    this.sendSilentRequestAndWaitForDone("handle SIG%s stop nopass", this.myInterruptSignalName);
                }
                catch (GDBCommandException e) {
                    this.warnUser("Unable to setup interrupt signal '" + this.myInterruptSignalName + "': " + e.getMessage());
                }
            }
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            @NonNls Object script = "import sys; sys.dont_write_bytecode = True; ";
            String printersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            if (printersPath != null) {
                script = (String)script + "sys.path.insert(0, " + GDBDriver.stringify(this.toEnvPath(printersPath)) + "); ";
                script = (String)script + "from default.printers import register_default_printers; register_default_printers(None); ";
                if (this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE) {
                    Response response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0]);
                    boolean hasSTLprinters = response.getOutput().contains("libstdc++-v6");
                    if (!hasSTLprinters) {
                        script = (String)script + "from libstdcxx.v6.printers import register_libstdcxx_printers; register_libstdcxx_printers(None); ";
                    }
                    script = (String)script + "from default.libstdcxx_printers import patch_libstdcxx_printers_module; patch_libstdcxx_printers_module(); ";
                }
                this.sendSilentRequestAndWaitForDone("python %s", script);
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
            }
        }
        catch (GDBCommandException e) {
            this.warnUser("Error during pretty printers setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.\n\n" + e.getResponse().getOutput(), e);
        }
    }

    private void doSetStepMode(boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (this.myStepMode == enabled) {
            return;
        }
        if (!this.myEmulateStepMode) {
            this.gdbSet("step-mode", enabled);
        }
        this.myStepMode = enabled;
    }

    public boolean isMIAsyncMode() {
        return this.myMIAsyncMode;
    }

    private void doSetMIAsync(boolean enabled) throws ExecutionException, DebuggerCommandException {
        try {
            boolean actualAsync = this.gdbShow("mi-async").getBoolean("value");
            if (enabled == actualAsync) {
                this.myMIAsyncMode = actualAsync;
                return;
            }
            this.gdbSet("mi-async", enabled);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Can't enable 'mi-async' mode (too old GDB?); falling back to 'target-async'");
            this.gdbSet("target-async", enabled);
        }
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", enabled ? 256 : 0);
    }

    protected void gdbSet(@NonNls @NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NonNls @NotNull String setting, int value) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, String.valueOf(value));
    }

    protected void gdbSet(@NonNls @NotNull String setting, @NonNls @Nullable String value) throws ExecutionException, DebuggerCommandException {
        String command;
        String string = command = value != null ? GDBDriver.format("-gdb-set %s %s", setting, value) : GDBDriver.format("unset %s", setting);
        if (StringUtil.containsLineBreak((CharSequence)command)) {
            command = GDBDriver.createMI2Command(command, -1L, -1);
        }
        this.sendRequestAndWaitForDone("%s", command);
    }

    @NotNull
    protected GDBTuple gdbShow(@NonNls @NotNull String setting) throws ExecutionException, DebuggerCommandException {
        return this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        boolean bl = this.myUseExternalConsoleRequested = targetCommandLine.getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        if (this.isMac()) {
            this.tryLoadIndirectSymbols(targetCommandLine);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            this.doLoadExecutable(installer.getExecutableFile());
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return GDBDriver.this.launch(targetCommandLine);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(@NotNull String name, boolean wait) throws ExecutionException {
        throw new ExecutionException(GDBBundle.message("error.attaching.by.name.not.implemented", new Object[0]));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings) throws ExecutionException {
        return this.loadCoreDump(coreFile, symbolFile, sysroot, sourcePathMappings, Collections.emptyList());
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(final @NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings, @NotNull List<String> execSearchPaths) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            if (symbolFile != null) {
                this.doLoadExecutable(symbolFile);
            }
            if (sysroot != null) {
                this.gdbSet("sysroot", sysroot.getPath());
            }
            this.doAddPathMapping(sourcePathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.targetSelectCore(coreFile);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void targetSelectCore(@NotNull File coreFile) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doReadTargetInfo();
            Response response = this.sendRequest("-target-select core %s", this.toEnvPath(coreFile.getPath())).waitFor(GDBResponse.ResultRecord.Type.connected);
            GDBTuple frameTuple = response.getResultList().getRequiredTuple("frame");
            LLFrame frame = this.doReadFrame(frameTuple.getInt("level", 0), frameTuple);
            int threadId = 1;
            try {
                LLValue threadIdValue = this.doEvaluate(-1L, -1, "$_gthread", null);
                threadId = (int)this.doLoadVariable((LLValue)threadIdValue).data.intValue();
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn("Unable to retrieve thread id using $_gthread: " + e.getMessage());
            }
            LLThread thread = this.doGetThread(threadId);
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.handleInterrupted(stopPlace);
            return -1;
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        if (this.isMac()) {
            throw new ExecutionException(GDBBundle.message("error.attaching.unsupported.for.gdb.on.os.x", new Object[0]));
        }
        this.executeCommandNoUserException(() -> this.doSetUpGDB(false));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.attachTo(pid);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        return this.loadForRemote(connectionString, symbolFile, sysroot, pathMappings, Collections.emptyList());
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, final @NotNull List<String> additionalCommands) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(true);
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            this.doAddPathMapping(pathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.connectTo(connectionString, additionalCommands);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(true);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void doAddPathMapping(@NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException, DebuggerCommandException {
        for (DebuggerDriver.PathMapping each : pathMappings) {
            String from = FileUtil.toSystemIndependentName((String)each.from);
            String to = FileUtil.toSystemIndependentName((String)each.to);
            try {
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                String envFrom = this.toEnvPath(from);
                if (from.equals(envFrom)) continue;
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
            }
            catch (DebuggerCommandException e) {
                throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
            }
        }
    }

    private void tryLoadIndirectSymbols(@NotNull GeneralCommandLine line) {
        try {
            this.myIndirectSymbols = MacOSDebugSymbols.load(line);
        }
        catch (IOException e) {
            this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
        }
    }

    private void doLoadExecutable(@NotNull File file) throws ExecutionException, DebuggerCommandException {
        String path = this.toEnvPath(file.getPath());
        this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(FileUtil.toSystemIndependentName((String)path)));
        this.handleModulesLoaded(Collections.singletonList(new LLModule(path)));
    }

    private int launch(@NotNull GeneralCommandLine targetCommandLine) throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            String ldPreloadValue;
            this.printTargetCommandLine(targetCommandLine);
            Charset charset = targetCommandLine.getCharset();
            try {
                this.gdbSet("charset", charset.name());
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn(e.getMessage());
            }
            File workDirectory = targetCommandLine.getWorkDirectory();
            if (workDirectory != null) {
                this.sendRequestAndWaitForDone("-environment-cd %s", GDBDriver.stringify(this.toEnvPath(workDirectory.getPath())));
            }
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            if (this.getHostMachine().isRemote() && (ldPreloadValue = (String)targetCommandLine.getEnvironment().remove("LD_PRELOAD")) != null) {
                this.doWrapExec(GDBDriver.format("env LD_PRELOAD=%s", this.shellQuote(ldPreloadValue)));
            }
            this.doPrepareInferiorEnv(targetCommandLine, gdbEnv);
            boolean useStartupWithShellWorkaroundOnSierra = this.isMacOSSierra() && Registry.is((String)"cidr.debugger.gdb.workaround.macOS.startupWithShell", (boolean)true);
            Request execRunRequest = this.buildRequest("-exec-run", new Object[0]);
            Object params = this.getInferiorArgs(targetCommandLine.getParametersList(), !useStartupWithShellWorkaroundOnSierra, this.isWindowsIoRedirectionEnabled());
            try {
                File inputFile = targetCommandLine.getInputFile();
                if (inputFile != null) {
                    Path inputPath = this.getHostMachine().getPath(inputFile.getPath(), new String[0]);
                    if (!Files.exists(inputPath, new LinkOption[0]) || !Files.isReadable(inputPath)) {
                        throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                    }
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(this.toEnvPath(inputFile.getPath())));
                } else if (!this.isWindows() && !this.getHostMachine().isRemote()) {
                    Pty pty = new Pty(true);
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(pty.getSlaveName()));
                    this.myProcessInput = pty.getOutputStream();
                } else if (this.getHostMachine().isRemote()) {
                    pipe = this.getHostMachine().openNamedPipe();
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(pipe.getName()));
                    this.myProcessInput = pipe.getOutputStream();
                } else if (this.isWindowsIoRedirectionEnabled()) {
                    pipe = WinPipe.createOutboundPipe("stdin");
                    params = GDBDriver.format(" < %s ", this.shellQuote(pipe.getName())) + (String)params;
                    this.myProcessInput = pipe.getOutputStream();
                }
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
                throw new ExecutionException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
            }
            if (this.myToRedirect) {
                if (this.isWindows() && !this.isWindowsIoRedirectionEnabled()) {
                    this.gdbSet("new-console", true);
                } else {
                    boolean isCsh;
                    ProcessOutputReaders readers = this.initReaders(this.getHostMachine(), targetCommandLine, !this.isWindows());
                    String redirectParams = GDBDriver.format(" 1> %s 2> %s ", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())), this.shellQuote(this.toEnvPath(readers.getErrFileAbsolutePath())));
                    String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                    boolean bl = isCsh = this.isUnix() && gdbShell.endsWith("csh");
                    if (useStartupWithShellWorkaroundOnSierra) {
                        this.gdbSet("startup-with-shell", false);
                        String[] symbolNames = new String[]{"main", "__cxx_global_var_init", "__libc_csu_init", "__static_initialization_and_destruction_0"};
                        ArrayList<Integer> startBreakpointNumbers = new ArrayList<Integer>(symbolNames.length);
                        for (String symbolName : symbolNames) {
                            startBreakpointNumbers.add(this.doInsertSymbolicBreakpoint(symbolName, null, true).getId());
                        }
                        ThreadPlan.BreakpointHit startThreadPlan = (stopPlace, breakpointNumber) -> {
                            this.executeAsyncCommand(() -> {
                                this.sendSilentRequestAndWaitForDone("-break-delete %s", StringUtil.join((Iterable)startBreakpointNumbers, (String)" "));
                                try {
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getOutFileAbsolutePath()), 1)));
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getErrFileAbsolutePath()), 2)));
                                }
                                catch (GDBCommandException e) {
                                    this.warnUser("Unable to setup IO redirection: " + e.getMessage(), e);
                                }
                                if (!startBreakpointNumbers.contains(breakpointNumber) || !this.doResumeInternal(false)) {
                                    this.handleBreakpoint(stopPlace, breakpointNumber);
                                }
                            });
                            return false;
                        };
                        execRunRequest = execRunRequest.withThreadPlan(startThreadPlan).suppressRunningEvent();
                        if (ContainerUtil.find((Iterable)targetCommandLine.getParametersList().getList(), StringUtil::containsWhitespaces) != null) {
                            this.warnUser("'startup-with-shell' is turned off in order to make GDB run on macOS Sierra and higher.\nThe program arguments might be passed incorrectly");
                        }
                    } else if (this.isWindows()) {
                        params = redirectParams + (String)params;
                    } else if (!isCsh) {
                        boolean isZsh = gdbShell.endsWith("zsh");
                        String ARGV0 = "ARGV0";
                        if (isZsh && gdbEnv.containsKey("ARGV0") && !targetCommandLine.getEnvironment().containsKey("ARGV0")) {
                            this.gdbSet("env ARGV0", null);
                        }
                        params = (String)params + redirectParams;
                    } else if (GDBDriver.isBourneShellAvailable()) {
                        this.doWrapExec(this.getShellCommandLineString("exec \"$@\" " + redirectParams));
                    } else {
                        params = (String)params + GDBDriver.format(" >&! %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())));
                        this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                    }
                }
            }
            this.doReadTargetInfo();
            this.gdbSet("args", (String)params);
            try {
                execRunRequest.send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
            catch (GDBCommandException e) {
                if (this.isMacOSSierra() && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
            Integer pid = this.myTargetPID;
            CidrDebuggerLog.LOG.assertTrue(pid != null);
            return pid;
        });
    }

    protected boolean isWindowsIoRedirectionEnabled() {
        return this.myWindowsIoRedirectionEnabled;
    }

    @NotNull
    protected static String createDupFdCall(@NotNull String path, int fd) {
        String open = "((int (*)(const char *, int))open)";
        String dup2 = "((int (*)(int, int))dup2)";
        String openCall = GDBDriver.format("%s(%s, %o)", "((int (*)(const char *, int))open)", GDBDriver.stringify(path), 1);
        return GDBDriver.format("%s(%s, %d)", "((int (*)(int, int))dup2)", openCall, fd);
    }

    protected void doWrapExec(@NotNull String wrapper) throws ExecutionException, DebuggerCommandException {
        String oldWrapper = this.gdbShow("exec-wrapper").getString("value");
        if (oldWrapper != null) {
            wrapper = (String)wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", (String)wrapper);
    }

    protected static boolean isBourneShellAvailable() throws ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters) {
        return new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters);
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull String command) {
        return this.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        return commandLine.getCommandLineList(null).stream().map(s -> this.shellQuote((String)s)).collect(Collectors.joining(" "));
    }

    @NotNull
    protected String getInferiorArgs(@NotNull ParametersList parametersList, boolean escapeParameters, boolean escapeForIORedirectionOnWindows) {
        Function<String, String> quoteFunction = parameter -> parameter;
        List<String> params = parametersList.getList();
        if (escapeParameters) {
            if (!this.isWindows()) {
                quoteFunction = parameter -> this.shellQuote((String)parameter);
            } else if (!escapeForIORedirectionOnWindows) {
                quoteFunction = parameter -> CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            } else {
                params = GDBDriver.quoteParametersForIORedirectionOnWindows(params);
            }
        }
        return params.stream().map(quoteFunction).collect(Collectors.joining(" "));
    }

    @NotNull
    private static List<String> quoteParametersForIORedirectionOnWindows(@NotNull List<String> params) {
        ArrayList<String> quotedParams = new ArrayList<String>(params.size());
        boolean quote = false;
        for (String parameter : params) {
            String escapedParameter = CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            StringBuilder sb = new StringBuilder();
            boolean wildRedirection = false;
            char prev = '\u0000';
            for (int i = 0; i < escapedParameter.length(); ++i) {
                char ch = escapedParameter.charAt(i);
                if (ch == '\"') {
                    if (prev == '\\') {
                        sb.append(prev);
                    } else {
                        boolean bl = quote = !quote;
                    }
                }
                if (!(ch != '<' && ch != '>' || quote)) {
                    wildRedirection = true;
                }
                sb.append(ch);
                prev = ch;
            }
            if (wildRedirection) {
                if (sb.charAt(0) == '\"') {
                    sb.insert(0, '\\');
                } else {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
            }
            quotedParams.add(sb.toString());
        }
        return quotedParams;
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value = (String)((Couple)entry.getValue()).first;
            if (key.contains("=")) {
                CidrDebuggerLog.LOG.warn("Ignoring '" + key + "' env variable.");
                continue;
            }
            this.gdbSet("env " + key, value);
        }
        if (this.isMac() && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doReadTargetInfo() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendSilentRequestAndWaitForDone("maintenance info sections", new Object[0]);
        String consoleOutput = response.getOutput();
        Pattern pattern = Pattern.compile(".*`(.+)', file type (.+)\\.");
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String target = matcher.group(1);
            this.myTargetModule = new LLModule(target);
            String fileType = matcher.group(2);
            this.doSelectWinbreakBinary(fileType);
            break;
        }
    }

    protected void doSelectWinbreakBinary(@NotNull String targetFileType) throws ExecutionException {
        String winBreakName;
        if (!this.isWindows() || this.myMIAsyncMode) {
            return;
        }
        if (targetFileType.matches(".*\\bi\\d86\\b.*")) {
            winBreakName = "winbreak32.exe";
        } else if (targetFileType.contains("86_64") || targetFileType.contains("86-64")) {
            winBreakName = "winbreak64.exe";
        } else {
            throw new ExecutionException(GDBBundle.message("error.cannot.determine.architecture.target", targetFileType));
        }
        CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + targetFileType);
        File winBreakFile = CidrDebuggerPathManager.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new ExecutionException(GDBBundle.message("error.cannot.find.winbreak.executable", winBreakFile.getPath()));
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    private void attachTo(final int pid) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(GDBDriver.this.isWindows()).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                return pid;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    private void detach(boolean isRemoteTarget) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message = response.getGDBErrorMessage();
            if (message != null) {
                if (message.equals("Remote connection closed") || message.matches("Remote communication error\\. *Target disconnected\\..*") || message.equals("Remote doesn't know how to detach") || message.equals("Can't detach process.")) {
                    this.warnUser(message);
                } else if (!message.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message);
                }
            }
            if (isRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    private void connectTo(final @NotNull String connectionString, final @NotNull List<String> additionalCommands) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.sendRequest("-target-select remote %s", connectionString).waitFor(GDBResponse.ResultRecord.Type.connected);
                for (String command : additionalCommands) {
                    GDBDriver.this.sendRequest("%s", command).waitFor(GDBResponse.ResultRecord.Type.done);
                }
                return -1;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleConnected(connectionString);
            }
        });
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommandNoUserException(() -> this.doInterrupt(false));
    }

    private boolean doInterrupt(boolean tearDownRequest) throws ExecutionException {
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        Integer pid = this.myTargetPID;
        if (pid == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myMIAsyncMode) {
            return this.doInterruptAsync(tearDownRequest);
        }
        this.doInterruptWithSignal(pid, tearDownRequest);
        return true;
    }

    protected boolean doInterruptAsync(boolean tearDownRequest) throws ExecutionException {
        try {
            this.buildRequest("-exec-interrupt", new Object[0]).tearDownRequest(tearDownRequest).send().waitFor(GDBResponse.ResultRecord.Type.done);
            return true;
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn((Throwable)e);
            return false;
        }
    }

    protected void doInterruptWithSignal(int pid, boolean tearDownRequest) throws ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", tearDownRequest, (ThrowableRunnable<? extends ExecutionException>)((ThrowableRunnable)() -> {
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(">interrupt");
            }
            if (this.isWindows()) {
                this.doInterruptWinBreak(pid);
            } else {
                this.doInterruptUnixSignal(pid);
            }
        }));
    }

    private void doInterruptWinBreak(int pid) throws ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new ExecutionException(GDBBundle.message("error.winbreak.was.not.selected", new Object[0]));
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            throw new ExecutionException(GDBDriver.extractErrorLinesFromOutput(stderr));
        }
    }

    @NlsSafe
    @NotNull
    private static String extractErrorLinesFromOutput(@Nls @NotNull String stderr) {
        try (Scanner scanner = new Scanner(stderr);){
            StringBuilder errorMessage = new StringBuilder();
            while (scanner.hasNext()) {
                if (scanner.findInLine("ERROR: (.*)") != null) {
                    MatchResult result2 = scanner.match();
                    if (errorMessage.length() > 0) {
                        errorMessage.append('\n');
                    }
                    errorMessage.append(result2.group(1));
                }
                scanner.nextLine();
            }
            String string = errorMessage.toString();
            return string;
        }
    }

    private void doInterruptUnixSignal(int pid) throws ExecutionException {
        @NlsSafe String SIG = "SIG";
        String signalDisplayName = SIG + this.myInterruptSignalName;
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        int err = this.getHostMachine().sendSignal(pid, this.myInterruptSignalName, this.myProcessHandler.getProcess());
        if (err == -1) {
            throw new ExecutionException(GDBBundle.message("error.cannot.send.signal.to.pid", signalDisplayName, pid));
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        return this.doInterruptAndWait(false);
    }

    private boolean doInterruptAndWait(boolean tearDownRequest) throws ExecutionException {
        this.myStopSemaphore.down();
        try {
            if (this.doInterrupt(tearDownRequest)) {
                if (tearDownRequest && !GDBDriver.waitForSemaphore(this.myStopSemaphore, 1500L)) {
                    throw new ExecutionException(GDBBundle.message("error.cannot.interrupt.gdb.to.request.exit", new Object[0]));
                }
                GDBDriver.waitForSemaphore(this.myStopSemaphore);
                boolean bl = this.myIsInterruptedStop;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myStopSemaphore.up();
        }
    }

    @TestOnly
    public String @NotNull [] listVarObjects() throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(new SuspendedCommand<String[]>(){

            @Override
            public String[] call() throws ExecutionException, DebuggerCommandException {
                Response response = GDBDriver.this.sendRequestAndWaitForDone("-var-update 0 *", new Object[0]);
                GDBTuple changelist = Objects.requireNonNull(response.getResultList().getTuple("changelist"));
                return (String[])changelist.stream().map(t -> ((GDBTuple)t).getString("name")).toArray(String[]::new);
            }
        });
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommandNoUserException(this::doResume);
    }

    private boolean doResume() throws ExecutionException, DebuggerCommandException {
        return this.doResume(false);
    }

    private boolean doResume(boolean suppressRunningEvent) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        return this.doResumeInternal(suppressRunningEvent);
    }

    private boolean doResumeInternal(boolean suppressRunningEvent) throws ExecutionException, GDBCommandException {
        try {
            this.buildRequest("-exec-continue %s", this.onStoppedThreadAndFrame()).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        this.stepInto(this.getLastStopThread(), forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
    }

    @Override
    public void stepOver(boolean stepByInstruction) throws ExecutionException {
        this.stepOver(this.getLastStopThread(), stepByInstruction);
    }

    @Override
    public void stepOut(boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        this.stepOut(this.getLastStopThread(), stopInFramesWithNoDebugInfo);
    }

    @NotNull
    private LLThread getLastStopThread() throws ExecutionException {
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        if (stopPlace == null) {
            throw new ExecutionException(GDBBundle.message("error.cannot.retrieve.stopped.thread", new Object[0]));
        }
        return stopPlace.thread;
    }

    @Override
    public void stepInto(@NotNull LLThread thread, boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            if (!stepByInstruction) {
                this.doSetStepMode(forceStepIntoFramesWithNoDebugInfo);
            }
            this.buildRequest("-exec-step%s %s", GDBDriver.withInstructionMode(stepByInstruction), GDBDriver.onThread(thread.getId())).onSteppingFinished(stopPlace -> {
                if (stepByInstruction || forceStepIntoFramesWithNoDebugInfo || stopPlace.frame.hasDebugInfo()) {
                    return true;
                }
                if (this.isMac() && this.isIndirectSymbolFrame(stopPlace.frame)) {
                    this.executeAsyncCommand(() -> this.sendSilentRequest("-exec-step %s", GDBDriver.onThread(thread.getId())));
                    return false;
                }
                return this.asyncStepOutUntilFrameWithDebugInfo(stopPlace);
            }).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOver(@NotNull LLThread thread, boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            try (CidrEventSpan ignored = new CidrEventSpan("debug", "stepOver", null);){
                if (!stepByInstruction) {
                    this.doSetStepMode(false);
                }
                this.buildRequest("-exec-next%s %s", GDBDriver.withInstructionMode(stepByInstruction), GDBDriver.onThread(thread.getId())).onSteppingFinished(stepByInstruction ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
        });
    }

    @Override
    public void stepOut(@NotNull LLThread thread, boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            block2: {
                this.doSetStepMode(false);
                try {
                    this.buildRequest("-exec-finish %s", GDBDriver.onThread(thread.getId())).onSteppingFinished(stopInFramesWithNoDebugInfo ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                }
                catch (GDBCommandException e) {
                    if (GDBDriver.messageContains(e, FINISH_NOT_MEANINGFUL_IN_THE_OUTERMOST_FRAME) && this.doResume()) break block2;
                    throw e;
                }
            }
        });
    }

    private boolean asyncStepOutUntilFrameWithDebugInfo(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean shouldStop = stopPlace.frame.hasDebugInfo();
        if (!shouldStop) {
            LLThread thread = stopPlace.thread;
            this.executeAsyncCommand(() -> this.buildRequest("-exec-next %s", GDBDriver.onThread(thread.getId())).suppressAll().onSteppingFinished(this::asyncStepOutUntilFrameWithDebugInfo).send());
        }
        return shouldStop;
    }

    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        this.runTo(GDBDriver.atSourceLine(this.toEnvPath(path), line));
    }

    @Override
    public void runTo(@NotNull Address address2) throws ExecutionException {
        this.runTo(GDBDriver.atAddress(address2));
    }

    protected void runTo(@NotNull String location) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            String command = GDBDriver.format("advance %s", location);
            String consoleCommand = GDBDriver.createConsoleCommand(command, this.myStopPlace);
            return this.sendRequestAndWaitForRunning("%s", consoleCommand);
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToLine(@NotNull LLThread thread, @NotNull String path, int line, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            void var10_12;
            String sourceLine = GDBDriver.atSourceLine(this.toEnvPath(path), line);
            Response lineInfoResponse = this.sendSilentRequestAndWaitForDone("info line %s", sourceLine);
            String[] outputLines = StringUtil.splitByLines((String)lineInfoResponse.getOutput(), (boolean)true);
            ArrayList<CallSite> result2 = new ArrayList<CallSite>(outputLines.length);
            String[] stringArray = outputLines;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                String lineInfo = stringArray[var10_12];
                Matcher lineMatcher = LINE_INFO_RESULT.matcher(lineInfo);
                if (lineMatcher.matches()) {
                    result2.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                } else {
                    lineMatcher = LINE_INFO_NO_CODE_RESULT.matcher(lineInfo);
                    if (lineMatcher.matches()) {
                        result2.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                    }
                }
                ++var10_12;
            }
            if (result2.size() == 0) {
                throw new DebuggerCommandException(String.format("Can't resolve address for line %s", sourceLine));
            }
            if (result2.size() > 1) {
                StringBuilder errMsg = new StringBuilder("Too many candidates found :\n");
                for (String string : result2) {
                    errMsg.append("\t").append(string).append("\n");
                }
                throw new DebuggerCommandException(errMsg.toString());
            }
            String address2 = (String)result2.get(0);
            return this.doJumpToAddress(thread, address2);
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToAddress(@NotNull LLThread thread, @NotNull Address address2, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doJumpToAddress(thread, address2.toString()));
    }

    @NotNull
    private DebuggerDriver.StopPlace doJumpToAddress(@NotNull LLThread thread, @NotNull String value) throws ExecutionException, DebuggerCommandException {
        this.sendRequestAndWaitForDone("-gdb-set $pc=%s", value);
        DebuggerDriver.ResultList<LLFrame> frames = this.doGetFrames(thread.getId(), 0, 1, false);
        return new DebuggerDriver.StopPlace(thread, (LLFrame)frames.list.get(0));
    }

    @Override
    public void addPathMapping(int index, @NotNull String from, @NotNull String to) throws ExecutionException {
        DebuggerDriver.PathMapping pathMapping = new DebuggerDriver.PathMapping(from, to);
        List<DebuggerDriver.PathMapping> list = Collections.singletonList(pathMapping);
        this.executeCommandNoUserException(() -> this.doAddPathMapping(list));
    }

    @Override
    public void addForcedFileMapping(int index, @NotNull String from, @Nullable DebuggerSourceFileHash hash, @NotNull String to) throws ExecutionException {
        this.addPathMapping(index, from, to);
    }

    private boolean abort() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            DebuggerDriver.TargetState state = this.getState();
            if (state == DebuggerDriver.TargetState.NOT_READY || state == DebuggerDriver.TargetState.FINISHED) {
                return false;
            }
            this.doInterruptAndWait();
            try {
                this.sendSilentRequest("kill", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                if ("The program is not being run.".equals(e.getMessage())) {
                    return false;
                }
                throw e;
            }
            return true;
        });
    }

    @Override
    protected boolean doExit() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            boolean sendGdbExit;
            boolean bl = sendGdbExit = !this.isInPromptMode();
            if (sendGdbExit) {
                try {
                    this.doInterruptAndWait(true);
                }
                catch (ExecutionFinishedException executionFinishedException) {
                    // empty catch block
                }
                this.buildRequest("-gdb-exit", new Object[0]).tearDownRequest(true).send();
            }
            return sendGdbExit;
        });
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, @NotNull LLValue value, @NotNull String expr, @Nullable LLWatchpoint.Lifetime lifetime, @NotNull LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
                throw new ExecutionException(GDBBundle.message("error.cannot.set.watchpoint.while.program.running", new Object[0]));
            }
            String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
            Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
            return GDBDriver.readWatchpoint(response.getResultList(), accessType);
        });
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression) throws ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + (String)expression + ")", null);
            String value = this.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + value;
        }
        return expression;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addBreakpoint(@NotNull String path, int line, @Nullable String condition, boolean ignoreSourceHash) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                DebuggerDriver.AddBreakpointResult addBreakpointResult = this.doInsertBreakpoint(GDBDriver.atSourceLine(this.toEnvPath(path), line), condition);
                return addBreakpointResult;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addAddressBreakpoint(@NotNull Address address2, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                DebuggerDriver.AddBreakpointResult addBreakpointResult = this.doInsertAddressBreakpoint(address2, condition);
                return addBreakpointResult;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    public String interruptAndExecuteConsole(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                String miCommand = GDBDriver.createConsoleCommand(command);
                String string = this.sendSilentRequestAndWaitForDone("%s", miCommand).getOutput();
                return string;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @NotNull
    private DebuggerDriver.AddBreakpointResult doInsertBreakpoint(@NotNull String location, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        GDBTuple resultList = this.doGdbBreakInsert(location, condition, false);
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private DebuggerDriver.AddBreakpointResult doInsertAddressBreakpoint(@NotNull Address address2, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        GDBTuple resultList = this.sendRequestAndWaitForDone("-break-insert %s *%s", GDBDriver.withCondition(condition), address2.toString()).getResultList();
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private GDBTuple doGdbBreakInsert(@NotNull String location, @Nullable String condition, boolean temporary) throws ExecutionException, GDBCommandException {
        return this.sendRequestAndWaitForDone("-break-insert -f %s %s %s", temporary ? "-t" : "", GDBDriver.withCondition(condition), location).getResultList();
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doInsertSymbolicBreakpoint(symBreakpoint.getPattern(), symBreakpoint.getCondition(), false));
    }

    @NotNull
    private LLSymbolicBreakpoint doInsertSymbolicBreakpoint(@NotNull String function, @Nullable String condition, boolean temporary) throws ExecutionException, DebuggerCommandException {
        GDBTuple bkpt = this.doGdbBreakInsert(GDBDriver.atFunction(function), condition, temporary).getRequiredTuple("bkpt");
        int number = bkpt.getRequiredInt("number");
        return new LLSymbolicBreakpoint(number);
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @Nullable
    private static LLBreakpointLocation readBreakpointLocation(@NotNull GDBTuple info, @NotNull String id) {
        Address address2;
        String addr = info.getString("addr");
        boolean pending = "<PENDING>".equals(addr);
        FileLocation location = info.getLocation("fullname", "line");
        if (location == null && pending) {
            location = info.getLocation("pending");
        }
        if ((address2 = info.getAddress("addr")) == null) {
            return null;
        }
        return new LLBreakpointLocation(id, address2, location);
    }

    @NotNull
    private static DebuggerDriver.AddBreakpointResult readBreakpoint(@NotNull GDBTuple info) throws ExecutionException, DebuggerCommandException {
        Object locations;
        boolean multipleLocations;
        Pair<GDBTuple, List<GDBTuple>> breakpointWithLocations = info.getWithSuccessors("bkpt", GDBTuple.class);
        GDBTuple breakpointTuple = (GDBTuple)breakpointWithLocations.first;
        List multipleLocationTuples = (List)breakpointWithLocations.second;
        if (breakpointTuple == null) {
            throw new DebuggerCommandException("No code at this line");
        }
        int number = breakpointTuple.getRequiredInt("number");
        String addr = breakpointTuple.getString("addr");
        boolean bl = multipleLocations = "<MULTIPLE>".equals(addr) && !multipleLocationTuples.isEmpty();
        if (multipleLocations) {
            locations = new SmartList();
            for (GDBTuple locTuple : multipleLocationTuples) {
                String locId;
                LLBreakpointLocation location = GDBDriver.readBreakpointLocation(locTuple, locId = locTuple.getRequiredString("number"));
                if (location == null) continue;
                locations.add(location);
            }
        } else {
            String locId = number + ".1";
            LLBreakpointLocation location = GDBDriver.readBreakpointLocation(breakpointTuple, locId);
            locations = location != null ? Collections.singletonList(location) : Collections.emptyList();
        }
        FileLocation originalLocation = breakpointTuple.getLocation("original-location");
        String origFilePath = originalLocation != null ? originalLocation.getPath() : "<address>";
        int origLine = originalLocation != null ? originalLocation.getLine() : 0;
        String condition = breakpointTuple.getString("cond");
        return new DebuggerDriver.AddBreakpointResult(new LLBreakpoint(number, origFilePath, origLine, condition), (List<LLBreakpointLocation>)locations);
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws ExecutionException, DebuggerCommandException {
        int threadId = stopTuple.getRequiredInt("thread-id");
        Communication savedCommunication = this.myCommunication;
        LLThread thread = this.doGetThread(threadId);
        this.myCommunication = savedCommunication;
        GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> new ExecutionException(GDBBundle.message("error.cannot.read.stop.place", stopTuple)));
        LLFrame frame = this.doReadFrame(0, frameTuple);
        return new DebuggerDriver.StopPlace(thread, frame, this.doReadReturnValue(stopTuple, threadId, frame.getIndex()));
    }

    @Nullable
    private LLValue doReadReturnValue(@NotNull GDBTuple stopTuple, long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        if (frameIndex != 0) {
            return null;
        }
        String returnVarName = stopTuple.getString("gdb-result-var");
        if (returnVarName != null && !returnVarName.isBlank()) {
            String frameAddress = this.doGetFrameAddr(threadId, 0);
            return this.doLoadFrameVariable(returnVarName, threadId, 0, frameAddress);
        }
        return null;
    }

    @NotNull
    private CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBTuple stopTuple) {
        return this.myThreadFrameInfoDriverDelegate.doReadStopPlaceAsync(this.myBridge, this, stopTuple);
    }

    private @NotNull CompletableFuture<@Nullable Pair<LLThread, LLFrame>> doReadSelectedFrameChangedAsync(@NotNull GDBTuple resultTuple) {
        return this.executeAsyncCommand(() -> {
            int threadId = resultTuple.getRequiredInt("id");
            GDBTuple frameInfo = resultTuple.getTuple("frame");
            if (frameInfo == null) {
                return null;
            }
            Integer frameIdx = frameInfo.getInteger("level", null);
            if (frameIdx == null) {
                return null;
            }
            return new Pair((Object)this.doGetThread(threadId), (Object)this.doReadFrame(frameIdx, frameInfo));
        }).handle((result2, throwable) -> {
            if (throwable != null) {
                CidrDebuggerLog.LOG.error(throwable);
            }
            return result2;
        });
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.getThreads(this.myBridge, this);
    }

    @NotNull
    private List<LLThread> doGetThreads() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result2 = new ArrayList<LLThread>(threads.size());
        for (GDBTuple each : threads) {
            result2.add(GDBDriver.doReadThreadInfo(each));
        }
        result2.sort(Comparator.comparingLong(LLThread::getId));
        return result2;
    }

    @NotNull
    private LLThread doGetThread(int threadId) throws DebuggerCommandException, ExecutionException {
        Response response = this.sendRequestAndWaitForDone("-thread-info %d", threadId);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        if (threads.size() != 1) {
            throw new ExecutionException(GDBBundle.message("error.cannot.get.thread.info.by.id", threadId));
        }
        return GDBDriver.doReadThreadInfo((GDBTuple)threads.get(0));
    }

    @NotNull
    private static LLThread doReadThreadInfo(@NotNull GDBTuple threadTuple) throws ExecutionException {
        int id = threadTuple.getRequiredInt("id");
        String name = threadTuple.getString("name");
        @NonNls String state = threadTuple.getRequiredString("state");
        String tid = threadTuple.getString("target-id");
        if (tid != null) {
            tid = GDBDriver.extractThreadId(tid);
        }
        return new LLThread(id, StringUtil.toUpperCase((String)state), null, name, tid);
    }

    @NotNull
    private static String extractThreadId(@NotNull String tid) {
        return StringUtil.trimStart((String)tid, (String)"Thread ");
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.getFrames(this.myBridge, thread, from, count, untilFirstLineWithCode);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = response.getGDBErrorMessage();
        if (frames == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                return DebuggerDriver.ResultList.empty();
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result2 = new ArrayList<LLFrame>(frames.size());
        for (int i = 0; i < Math.min(frames.size(), count); ++i) {
            GDBTuple each = frames.get(i);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result2.add(frame);
            if (untilFirstLineWithCode && frame.getLine() != -1) break;
        }
        boolean hasMore = result2.size() < frames.size();
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        String module = frameTuple.getString("from");
        int line = -1;
        if (file != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        if (module == null && !addr.isNull()) {
            LLModule mod = this.myModuleMap.findModuleByAddress(addr);
            if (mod != null) {
                module = mod.getPath();
            } else {
                LLModule targetModule = this.myTargetModule;
                if (targetModule != null) {
                    module = targetModule.getPath();
                }
            }
        }
        if (module != null) {
            module = PathUtil.getFileName((String)module);
        }
        if (func != null) {
            func = func.substring(func.indexOf(33) + 1);
        }
        return new LLFrame(level, "??".equals(func) ? null : func, file, null, line, addr, null, false, false, module);
    }

    private boolean isIndirectSymbolFrame(@NotNull LLFrame frame) {
        LongSet indirectSymbols = this.myIndirectSymbols;
        if (indirectSymbols == null) {
            return false;
        }
        return !frame.hasDebugInfo() && !frame.hasSymbolInfo() && indirectSymbols.contains(frame.getProgramCounter().unsignedLongValue());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.getVariables(this.myBridge, thread, frame);
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        return (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex));
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        return response.getResultList().getRequiredStringOrThrow("value", () -> new ExecutionException(GDBBundle.message("error.cannot.evaluate.frame.address.for.thread.frame", threadId, frameIndex)));
    }

    @NotNull
    private List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        SmartList result2 = new SmartList();
        String frameAddress = this.doGetFrameAddr(threadId, frameIndex);
        for (String varName : this.doListFrameVariables(threadId, frameIndex)) {
            result2.add(this.doLoadFrameVariable(varName, threadId, frameIndex, frameAddress));
        }
        return result2;
    }

    @NotNull
    private LLValue doLoadFrameVariable(String varName, long threadId, int frameIndex, String frameAddress) throws ExecutionException {
        Pair<Boolean, String> typePair = this.doGetExpressionType(varName, threadId, frameIndex);
        LLValue llValue = new LLValue(varName.isEmpty() ? "<unknown>" : varName, (String)typePair.second, null, null, varName);
        if (((Boolean)typePair.first).booleanValue()) {
            String fvKey = GDBDriver.makeFVKey(frameAddress, varName);
            FrameValueLoader loader = new FrameValueLoader(fvKey, threadId, frameIndex);
            llValue.putUserData(LLVALUE_DATA_LOADER, loader);
        } else {
            GDBDriver.doUpdateLoadedData(llValue, EMPTY_LOADED_VALUE);
        }
        return llValue;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.getData(this.myBridge, value);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            String id = this.doLoadVariable((LLValue)value).id;
            boolean bl = lengthChanged = maxLength != 256;
            if (lengthChanged) {
                this.doSetMaxDescription(false);
            }
            try {
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(true);
                }
            }
            return (String)GDBDriver.getDescriptionFromValue((String)response.getResultList().getRequiredString((String)"value")).second;
        });
    }

    @TestOnly
    @NotNull
    public String getVariableID(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> this.doLoadVariable((LLValue)value).id);
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.getVariableChildren(this.myBridge, value, from, count);
    }

    @NotNull
    protected DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = this.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset, 2));
            boolean hasMore = endOffset < 2;
            return DebuggerDriver.ResultList.create(list, hasMore);
        }
        if (data.isMap) {
            return this.doGetMapChildren(var, offset, count);
        }
        final ArrayList result2 = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) {
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result2.add(GDBDriver.this.doReadVariable(child, var.getReferenceExpression(), null));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result2.addAll(GDBDriver.this.doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result2.size() < childrenCount;
            return DebuggerDriver.ResultList.create(result2, hasMore);
        }
        return this.doGetPlainVariableChildren(var, offset, offset + count);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        if (offset > endPos) {
            throw new ExecutionException(GDBBundle.message("error.incorrect.children.range.from.to", offset, endPos));
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result2.add(this.doReadVariable(each, var.getReferenceExpression(), null));
        }
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded = this.doLoadVariable(var);
        if (!loaded.mayHaveChildren()) {
            return Pair.create((Object)new GDBTuple(), (Object)false);
        }
        String id = loaded.id;
        String listChildrenArg = Registry.is((String)"cidr.debugger.gdb.listChildrenWithoutValues", (boolean)false) ? "--no-values" : "--all-values";
        Response response = this.sendRequestAndWaitForDone("-var-list-children %s %s %d %d", listChildrenArg, GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        return Pair.create((Object)children, (Object)hasMore);
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount = this.doLoadVariable((LLValue)var).childrenCount;
        if (childrenCount == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children == null) {
            children = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children);
        }
        Iterator iterator2 = children.iterator();
        while (iterator2.hasNext() && (each = GDBDriver.getChildTuple(children, o = iterator2.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name = each.getRequiredStringOrThrow("name", msg -> new ExecutionException(GDBBundle.message("error.unexpected.gdb.fake.variable", msg)));
            LLValue fakeValue = new LLValue("", "", null, null, name);
            int numchild = each.getInt("numchild", 0);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(name, null, numchild, false, false, "", null));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i = 0; i < size - 1; i += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key = this.doReadVariable(keyTuple, var.getReferenceExpression(), "first");
            LLValue value = this.doReadVariable(valueTuple, var.getReferenceExpression(), "second");
            LLValue element = new LLValue("[" + (offset + i / 2) + "]", "std::pair<" + key.getType() + ", " + value.getType() + ">", null, null, value.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", null, 2, false, false, "", null));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
            result2.add(element);
        }
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws ExecutionException {
        if (!(o instanceof Pair)) {
            throw new ExecutionException(GDBBundle.message("error.invalid.object.in.list", varObjList));
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new ExecutionException(GDBBundle.message("error.pair.first.required.to.be.child", p));
        }
        GDBTuple result2 = (GDBTuple)p.second;
        String name = result2.getString("name");
        return name != null && name.matches(".*\\.<error at.*") ? null : result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String expression, long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response;
        block11: {
            String varId = GDBDriver.format("var%d_%s", this.allocatedVariables.size() + 1, NON_ID_PATTERN.matcher(expression).replaceAll(""));
            this.allocatedVariables.add(varId);
            String command = GDBDriver.createMI2Command(GDBDriver.format("-var-create %s * %s", varId, GDBDriver.stringify(GDBDriver.escapeVariadicArgIfNeeded(expression))), threadId, frameIndex);
            GDBCommandException err = null;
            response = null;
            try {
                response = this.sendRequestAndWaitForDone("%s", command);
            }
            catch (GDBCommandException e) {
                err = e;
            }
            if (response == null || response.getReceivedSignalCount() != 0) {
                try {
                    this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(varId));
                }
                catch (GDBCommandException e) {
                    if (!"Variable object not found".equals(e.getResponse().getGDBErrorMessage())) {
                        if (err != null) {
                            err.addSuppressed(e);
                        }
                    }
                }
                finally {
                    if (err == null) break block11;
                    throw err;
                }
            }
        }
        return response.getRecord();
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String displayName) {
        String name = varTuple.getString("name");
        String type = varTuple.getString("type");
        boolean invalid = name == null || type == null;
        name = StringUtil.notNullize((String)name, (String)"<unknown>");
        type = StringUtil.notNullize((String)type, (String)"<unknown>");
        String id = name;
        String value = varTuple.getString("value");
        String displayHint = varTuple.getString("displayhint");
        String exp = varTuple.getString("exp");
        if (exp != null) {
            String childName = StringUtil.substringAfterLast((String)name, (String)".");
            boolean isAnonymous = childName != null && childName.endsWith("_anonymous") && StringUtil.parseInt((String)StringUtil.trimEnd((String)childName, (String)"_anonymous"), (int)-1) != -1;
            name = isAnonymous ? "" : exp;
        }
        LLValue result2 = new LLValue(displayName != null ? displayName : name, GDBDriver.fixType(type), null, null, (String)(parentRef.isEmpty() ? name : parentRef + "." + name));
        if (invalid) {
            GDBDriver.doUpdateLoadedData(result2, new LLValueLoadedData("", null, 0, false, false, StringUtil.notNullize((String)value), displayHint));
        } else {
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, id, null, StringUtil.notNullize((String)value));
            if (value == null) {
                result2.putUserData(LLVALUE_DATA_LOADER, new CreatedValueLoader(data));
            } else {
                GDBDriver.doUpdateLoadedData(result2, data);
            }
        }
        return result2;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariableStatic(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader = (LLValueLoader)value.getUserData(LLVALUE_DATA_LOADER);
        if (loader != null) {
            loader.loadValue(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value.getUserData(LLVALUE_DATA)) == null) {
            throw new ExecutionException(GDBBundle.message("error.variable.not.initialized", new Object[]{value}));
        }
        return data;
    }

    @NotNull
    protected LLValueLoadedData doLoadVariable(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return GDBDriver.doLoadVariableStatic(value);
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull String id, @Nullable String fvKey, @NotNull String value) {
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        String displayHint = varTuple.getString("displayhint");
        return new LLValueLoadedData(id, fvKey, childrenCount, isDynamic, hasDynamicChildren, value, displayHint);
    }

    private static void doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        var.putUserData(LLVALUE_DATA, data);
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        return (Integer)this.executeCommand(() -> this.doGetChildrenCount(var));
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = this.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", "");
    }

    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        final String debuggerLanguage = GDBDriver.convertLanguage(language);
        return this.executeCommand(new EvaluationCommand<LLValue>(expression){

            @Override
            public LLValue call() throws ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage);
            }
        });
    }

    @Override
    @NotNull
    public LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        return this.myThreadFrameInfoDriverDelegate.evaluate(this.myBridge, thread, frame, expression, language);
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address2, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doDisassembleFunction(address2, fallbackRange));
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doDisassembleRange(range));
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleFunction(@NotNull Address address2, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        assert (fallbackRange.contains(address2));
        Pair<Address, String> functionStart = this.doGetFunctionStart(address2);
        if (functionStart == null) {
            return this.doDisassembleRange(fallbackRange);
        }
        Address startAddress = (Address)functionStart.first;
        String functionName = (String)functionStart.second;
        if (address2.minus(startAddress) > 65536L) {
            return this.doDisassembleRange(fallbackRange);
        }
        Pair<Address, String> pastFunctionEnd = this.doGetFunctionStart(startAddress.plus(65536));
        if (pastFunctionEnd != null && ((Address)pastFunctionEnd.first).equals(startAddress)) {
            AddressRange startUntilFallbackEndRange = AddressUtil.addressRangeInclusive(startAddress, fallbackRange.getEndInclusive());
            return this.doDisassembleRange(fallbackRange.intersectWith(startUntilFallbackEndRange));
        }
        return this.doDisassemble(startAddress.toString(), functionName);
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleRange(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.doDisassemble(GDBDriver.format("%s,+%d", range.getStart(), range.getSize()), null);
    }

    @NotNull
    private ArrayList<LLInstruction> doDisassemble(@NotNull String disassembleAddressArg, @Nullable String functionName) throws ExecutionException, GDBCommandException {
        Response response = this.sendSilentRequestAndWaitForDone("disassemble /r %s", disassembleAddressArg);
        String[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        ArrayList<LLInstruction> result2 = new ArrayList<LLInstruction>(outputLines.length);
        for (String line : outputLines) {
            LLInstruction instruction;
            Matcher lineMatcher = INSTRUCTION_LINE.matcher(line);
            if (!lineMatcher.matches() || (instruction = GDBDriver.parseInstruction(functionName, lineMatcher.group(1), lineMatcher.group(2), lineMatcher.group(3), lineMatcher.group(4))) == null) continue;
            result2.add(instruction);
        }
        return result2;
    }

    @Nullable
    protected static LLInstruction parseInstruction(@Nullable String functionName, @NotNull String addressString, @Nullable String functionOffsetStr, @NotNull String opcodes, @NotNull String disassembly) {
        if (CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(disassembly).matches()) {
            return null;
        }
        String instruction = null;
        String comment = null;
        if (!BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
            Matcher commentMatcher = INSTRUCTION_COMMENT.matcher(disassembly = INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME.matcher(disassembly).replaceAll("$1  # $2"));
            if (commentMatcher.matches()) {
                instruction = commentMatcher.group(1);
                comment = commentMatcher.group(2);
            } else {
                instruction = disassembly;
            }
        }
        Address address2 = Address.parseHexString(addressString);
        LLSymbolOffset functionOffset = functionOffsetStr == null ? null : LLSymbolOffset.parseAngleBrackets(functionOffsetStr, functionName);
        return LLInstruction.create(address2, opcodes, instruction, comment, functionOffset);
    }

    @Nullable
    protected Pair<Address, String> doGetFunctionStart(@NotNull Address address2) throws ExecutionException, DebuggerCommandException {
        Response response = this.doDataDisassemble(AddressUtil.addressToRange(address2, 1L));
        if (response.getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
            return null;
        }
        GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
        if (asmInsns.isEmpty()) {
            return null;
        }
        GDBTuple insn = (GDBTuple)asmInsns.get(0);
        String funcName = insn.getString("func-name");
        Integer offset = insn.getInteger("offset", null);
        if (funcName == null || offset == null) {
            return null;
        }
        Address functionStart = insn.getRequiredAddress("address").minus(offset);
        if (functionStart.equals(Address.NULL)) {
            return null;
        }
        return Pair.create((Object)functionStart, (Object)funcName);
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), AddressUtil.getEndCoerced(range)).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.error);
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        List modules = ContainerUtil.map(sectionsMap.keySet(), LLModule::new);
        return Collections.unmodifiableList(modules);
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
            List<LLSection> sections = sectionsMap.get(module.getPath());
            if (sections == null) {
                throw new DebuggerCommandException("Unknown module '" + module + "'");
            }
            return sections;
        });
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException, GDBCommandException {
        if (this.mySectionsMap == null) {
            String allObjectsFlag = this.myGdbVersion == null || this.myGdbVersion.lessThan(Integer.valueOf(11)) ? "ALLOBJ" : "-all-objects";
            Response response = this.sendSilentRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("maintenance info sections " + allObjectsFlag));
            this.mySectionsMap = GDBDriver.doReadSectionsMap(response.getOutput());
        }
        return this.mySectionsMap;
    }

    @NotNull
    protected static Map<String, List<LLSection>> doReadSectionsMap(@NotNull String output) throws ExecutionException {
        LinkedHashMap<String, List<LLSection>> sectionsMap = new LinkedHashMap<String, List<LLSection>>();
        ArrayList<LLSection> sections = null;
        for (String str : output.split("\n")) {
            Matcher matcher;
            Matcher headerMatcher = OBJECT_FILE_HEADER.matcher(str);
            if (headerMatcher.matches()) {
                String objectName = headerMatcher.group(1);
                if (objectName == null) {
                    objectName = headerMatcher.group(2);
                }
                sections = new ArrayList<LLSection>();
                sectionsMap.putIfAbsent(objectName, Collections.unmodifiableList(sections));
                continue;
            }
            if (sections == null || !(matcher = SECTIONS_INFO.matcher(str)).matches()) continue;
            Address start = GDBDriver.parseAddress(matcher.group(1));
            Address end = GDBDriver.parseAddress(matcher.group(2));
            String name = matcher.group(3);
            List flags = StringUtil.split((String)matcher.group(4), (String)" ");
            sections.add(new LLSection(name, flags, AddressUtil.addressRangeExclusive(start, end)));
        }
        return sectionsMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            Response response = this.sendRequestAndWaitForDone("-data-read-memory-bytes %s %d", range.getStart(), range.getSize());
            ArrayList<LLMemoryHunk> list = new ArrayList<LLMemoryHunk>();
            for (Object o : response.getResultList().getRequiredTuple("memory")) {
                GDBTuple tuple = (GDBTuple)o;
                Address begin = tuple.getRequiredAddress("begin").plus(tuple.getInt("offset", 0));
                Address end = tuple.getRequiredAddress("end");
                AddressRange hunkRange = AddressUtil.addressRangeExclusive(begin, end);
                String contents = tuple.getRequiredString("contents");
                byte[] bytes = GDBDriver.bytesFromString(contents);
                if ((long)bytes.length != range.getSize()) {
                    CidrDebuggerLog.LOG.warn("Memory range of size " + range.getSize() + "; content size is " + bytes.length);
                    continue;
                }
                LLMemoryHunk hunk = new LLMemoryHunk(hunkRange, bytes);
                list.add(hunk);
            }
            return list;
        });
    }

    private static byte[] bytesFromString(@NotNull String data) {
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((Character.digit(data.charAt(i * 2), 16) << 4) + Character.digit(data.charAt(i * 2 + 1), 16));
        }
        return bytes;
    }

    private LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
        if (language != null) {
            this.sendRequestAndWaitForDone("-gdb-set language %s", language);
        }
        try {
            CidrEventSpan ignored = new CidrEventSpan("debug", "doEvaluate", expression);
            try {
                GDBResponse.Record response = this.doCreateVar(expression, threadId, frameIndex);
                LLValue lLValue = this.doReadVariable(response.getResultList(), "", null);
                ignored.close();
                return lLValue;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
            }
        }
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            return switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case DebuggerDriver.StandardDebuggerLanguage.C -> "c";
                case DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS -> "c++";
                case DebuggerDriver.StandardDebuggerLanguage.OBJC -> "objective-c";
                default -> throw new DebuggerCommandException(language + " is not supported by GDB");
            };
        }
        throw new DebuggerCommandException(language + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        throw new ExecutionException(GDBBundle.message("error.executing.shell.commands.not.implemented.yet", new Object[0]));
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        return this.executeInterpreterCommand(-1L, -1, command);
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(final long threadId, final int frameIndex, final @NotNull String command) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(new ConsoleCommand<String>(command){

            @Override
            public String call() throws ExecutionException {
                String commandToSend;
                if (GDBDriver.this.checkIsInPromptModeWhenSettled(300)) {
                    commandToSend = command;
                } else {
                    String trimmed;
                    long actualThreadId = threadId;
                    int actualFrameIndex = frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = command.trim())) {
                        GDBDriver.this.handleDebuggerOutput(GDBBundle.message("command.0.is.not.supported", trimmed) + "\n", ProcessOutputTypes.STDOUT);
                        return "";
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                return GDBDriver.this.sendRequest("%s", commandToSend).waitAndPokeForPrompt((int)this.getTimeout()).getOutput();
            }
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws ExecutionException {
        String completionPrefix = StringUtil.trimLeading((String)command.substring(0, pos));
        if (completionPrefix.startsWith("!")) {
            return DebuggerDriver.ResultList.empty();
        }
        try {
            return this.executeCommand(() -> this.doCompleteConsoleCommand(completionPrefix));
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            return DebuggerDriver.ResultList.empty();
        }
    }

    @NotNull
    private DebuggerDriver.ResultList<String> doCompleteConsoleCommand(@NotNull String completionPrefix) throws ExecutionException, GDBCommandException {
        List fullCompletions;
        if (this.checkIsInPromptModeWhenSettled(300)) {
            return DebuggerDriver.ResultList.empty();
        }
        Response response = this.sendSilentRequestAndWaitForDone("complete %s", completionPrefix);
        Object[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        boolean hasMore = false;
        if (outputLines.length > 0 && ((String)outputLines[outputLines.length - 1]).endsWith(MAX_COMPLETIONS_REACHED)) {
            outputLines[outputLines.length - 1] = "";
            hasMore = true;
        }
        if ((fullCompletions = ContainerUtil.filter((Object[])outputLines, line -> !StringUtil.isEmptyOrSpaces((String)line) && !line.startsWith("!"))).isEmpty()) {
            return DebuggerDriver.ResultList.empty();
        }
        int indexOfSpace = completionPrefix.lastIndexOf(32);
        String trimPrefix = indexOfSpace == -1 ? "" : completionPrefix.substring(0, indexOfSpace + 1);
        List completions = ContainerUtil.map((Collection)fullCompletions, line -> StringUtil.trimStart((String)line, (String)trimPrefix));
        return DebuggerDriver.ResultList.create(completions, hasMore);
    }

    @Override
    public void handleSignal(@NotNull String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = GDBDriver.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    @Override
    public void cancelSymbolsDownload(@NotNull String details) throws ExecutionException, DebuggerCommandException {
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    public static String createConsoleCommand(@NotNull String request) {
        return GDBDriver.createConsoleCommand(request, -1L, -1);
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @Nullable DebuggerDriver.StopPlace stopPlace) {
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(stopPlace));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int frameIndex) {
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(threadId, frameIndex));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @NotNull String onThreadAndFrame) {
        return GDBDriver.format("-interpreter-exec %s console %s", onThreadAndFrame, GDBDriver.stringify(request));
    }

    @NotNull
    protected static String createMI2Command(@NotNull String request, long threadId, int frameIndex) {
        return GDBDriver.format("%d-interpreter-exec %s %s %s", 0, GDBDriver.onThreadAndFrame(threadId, frameIndex), "mi2", GDBDriver.stringify(request));
    }

    @NotNull
    private String onStoppedThreadAndFrame() {
        return GDBDriver.onThreadAndFrame(this.myStopPlace);
    }

    private static String onThreadAndFrame(@Nullable DebuggerDriver.StopPlace stopPlace) {
        long threadId = stopPlace == null ? -1L : stopPlace.thread.getId();
        int frameIndex = stopPlace == null ? -1 : stopPlace.frame.getIndex();
        return GDBDriver.onThreadAndFrame(threadId, frameIndex);
    }

    @Contract(pure=true)
    @NotNull
    private static String onThread(long threadId) {
        return threadId >= 0L ? GDBDriver.format("--thread %d", threadId) : "";
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? GDBDriver.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        return GDBDriver.stringify(GDBDriver.format("%s:%d", source, line + 1));
    }

    private static String atAddress(@NotNull Address address2) {
        return GDBDriver.format("*%s", address2);
    }

    private static String atFunction(@NotNull String func) {
        return GDBDriver.format("--function %s", GDBDriver.stringify(func));
    }

    private static String withCondition(@Nullable String condition) {
        return condition != null ? GDBDriver.format("-c %s", GDBDriver.stringify(condition)) : "";
    }

    private static String withInstructionMode(boolean stepByInstruction) {
        return stepByInstruction ? "-instruction" : "";
    }

    @Contract(pure=true)
    @NotNull
    protected Request buildRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) {
        return new Request(GDBDriver.format(command, args));
    }

    @NotNull
    protected Communication sendRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).send();
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
    }

    @NotNull
    private Communication sendSilentRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).suppressAll().send();
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, boolean tearDownRequest, @NotNull ThrowableRunnable<? extends ExecutionException> r) throws ExecutionException {
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors(boolean tearDownRequest) throws ExecutionException {
        if (!tearDownRequest && this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws ExecutionException {
        while (!this.myResultQueue.isEmpty()) {
            Response response = (Response)this.myResultQueue.remove();
            try {
                response.checkError();
            }
            catch (ExecutionException e) {
                if (ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class)) continue;
                throw e;
            }
        }
    }

    @Override
    protected void handleDebuggerOutput(@Nls @NotNull String text, @NotNull Key type) {
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleDebuggerOutput(text, type);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myStopSemaphore.up();
        super.handleTargetTerminated(exitStatus);
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    protected boolean checkIsInPromptModeWhenSettled(int timeoutMs) {
        while (this.isInPromptMode()) {
            try {
                Response response = this.myResultQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
                if (response == Response.NULL) continue;
            }
            catch (InterruptedException e) {}
            break;
        }
        return this.isInPromptMode();
    }

    private static ExecutionException unexpectedResponse(Object response) {
        return new ExecutionException(GDBBundle.message("error.unexpected.response", response));
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message = e.getMessage();
        return message != null && message.contains(string);
    }

    private static void waitForSemaphore(@NotNull Semaphore s) throws ExecutionException {
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    private static boolean waitForSemaphore(@NotNull Semaphore s, long msTimeout) throws ExecutionException {
        try {
            return s.waitForUnsafe(msTimeout);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPromptLevel() {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            return this.myPromptLevelStack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPromptMode(int promptLevel) {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            Deque<Integer> stack = this.myPromptLevelStack;
            if (promptLevel > 0) {
                while (!stack.isEmpty() && stack.getLast() > promptLevel) {
                    stack.removeLast();
                }
                if (stack.isEmpty() || stack.getLast() < promptLevel) {
                    stack.addLast(promptLevel);
                }
            } else {
                stack.clear();
            }
        }
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        this.setPromptMode(prompt.length());
        this.myResultQueue.offer(Response.NULL);
        this.myCommandSemaphore.up();
        return true;
    }

    private void processResponse(@NotNull String output) {
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "processResponse", output);){
            try {
                this.doProcessResponse(output);
            }
            catch (Throwable e) {
                this.myResultQueue.offer(new ErrorResponse(GDBBundle.message("error.cannot.process.mi.record", this.myCommunication.command, output), e));
            }
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, ExecutionException {
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        if (output.startsWith("0^")) {
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
                if (this.myGdbVersion == null) {
                    this.myGdbVersion = VersionUtil.parseVersion((String)text, (Pattern[])new Pattern[]{VERSION_PATTERN});
                    this.myWindowsIoRedirectionEnabled = this.isWindows() && !StringUtil.containsIgnoreCase((String)text, (String)"cygwin") && this.myGdbVersion != null && this.myGdbVersion.major >= 8 && !Registry.is((String)"cidr.debugger.gdb.workaround.windows.forceExternalConsole", (boolean)false) && !this.myUseExternalConsoleRequested;
                }
                this.myCommunication.consoleOutput.append(text);
            }
            case log: {
                this.handleDebuggerOutput(text, ProcessOutputTypes.STDOUT);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) throws ExecutionException {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                if (!this.myCommunication.suppressRunningResult) break;
                return;
            }
            case error: {
                GDBTuple tuple = record.getResultList();
                String reason = tuple.getString("reason");
                if (!"breakpoint-hit".equals(reason)) break;
                this.doReadStopPlaceAsync(tuple).thenAccept(stopPlace -> {
                    this.myStopPlace = stopPlace;
                    try {
                        this.processBreakpointHit((DebuggerDriver.StopPlace)stopPlace, tuple, this.myCommunication);
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e);
                    }
                });
                break;
            }
        }
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws ExecutionException {
        String type = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
        GDBTuple resultTuple = record.getResultList();
        switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
            case notify: {
                switch (type) {
                    case "library-loaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            LLModule module = new LLModule(moduleName);
                            this.handleModulesLoaded(Collections.singletonList(module));
                            GDBTuple ranges = resultTuple.getTuple("ranges");
                            if (ranges != null) {
                                for (Object o2 : ranges) {
                                    GDBTuple range = (GDBTuple)o2;
                                    Address from = range.getAddress("from");
                                    Address to = range.getAddress("to");
                                    if (from == null || to == null) continue;
                                    this.myModuleMap.addModule(AddressUtil.addressRangeExclusive(from, to), module);
                                }
                            }
                        }
                        this.mySectionsMap = null;
                        break;
                    }
                    case "library-unloaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            LLModule module = new LLModule(moduleName);
                            this.handleModulesUnloaded(Collections.singletonList(module));
                            this.myModuleMap.removeModule(module);
                        }
                        this.mySectionsMap = null;
                        break;
                    }
                    case "breakpoint-modified": {
                        try {
                            DebuggerDriver.AddBreakpointResult breakpointRes = GDBDriver.readBreakpoint(resultTuple);
                            LLBreakpoint breakpoint = breakpointRes.getBreakpoint();
                            this.handleBreakpointUpdated(breakpoint);
                            this.handleBreakpointLocationsReplaced(breakpoint.getId(), breakpointRes.getBreakpointLocations());
                            break;
                        }
                        catch (DebuggerCommandException e) {
                            throw new ExecutionException((Throwable)e);
                        }
                    }
                    case "thread-group-exited": {
                        Integer code = resultTuple.getInteger("exit-code", null);
                        this.handleTargetTerminated(code != null ? new DebuggerDriver.ExitStatus(code) : DebuggerDriver.ExitStatus.UNKNOWN);
                        break;
                    }
                    case "thread-group-started": {
                        this.myTargetPID = resultTuple.getRequiredInt("pid");
                        break;
                    }
                    case "thread-selected": {
                        this.doReadSelectedFrameChangedAsync(resultTuple).thenAccept(pair -> {
                            if (pair != null) {
                                this.handleSelectedFrameChanged((LLThread)pair.first, (LLFrame)pair.second);
                            }
                        });
                    }
                }
                return;
            }
            case exec: {
                if (!type.equals("stopped")) {
                    return;
                }
                if (resultTuple.getAll("reason", String.class).stream().anyMatch(o -> o.startsWith("exited"))) {
                    DebuggerDriver.TargetState state = this.getState();
                    CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + state));
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                boolean bl = this.myIsInterruptedStop = resultTuple.getString("reason", "").equals("signal-received") && (resultTuple.getString("signal-name", "").equals("SIGINT") || resultTuple.getString("signal-name", "").equals("SIG" + this.myInterruptSignalName));
                if (this.myStopSemaphore.tryUp() && this.myIsInterruptedStop) {
                    return;
                }
                Communication originalCommunication = this.myCommunication;
                this.doReadStopPlaceAsync(resultTuple).thenAccept(stopPlace -> {
                    this.myStopPlace = stopPlace;
                    try {
                        this.doProcessAsyncStopPlace((DebuggerDriver.StopPlace)stopPlace, resultTuple, originalCommunication);
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e);
                    }
                });
                return;
            }
        }
    }

    private void doProcessAsyncStopPlace(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple, @NotNull Communication communication) throws ExecutionException {
        switch (resultTuple.getString("reason", "")) {
            case "signal-received": {
                ++communication.receivedSignalCount;
                String signalName = resultTuple.getString("signal-name", "UNKNOWN");
                if (GDBDriver.isTargetTerminationSignal(signalName)) {
                    int signal = UnixProcessManager.getPortableSignalNumber((String)StringUtil.trimStart((String)signalName, (String)"SIG"));
                    this.handleTargetTerminated(signal == -1 ? DebuggerDriver.ExitStatus.UNKNOWN : DebuggerDriver.ExitStatus.fromSignal(signal));
                } else {
                    String meaning = resultTuple.getString("signal-meaning", "");
                    this.handleSignal(stopPlace, signalName, meaning);
                    this.tryToFlushOnWindows();
                }
                return;
            }
            case "breakpoint-hit": {
                this.processBreakpointHit(stopPlace, resultTuple, communication);
                this.tryToFlushOnWindows();
                return;
            }
            case "location-reached": {
                break;
            }
            case "function-finished": 
            case "end-stepping-range": {
                boolean shouldHandle = communication.myThreadPlan.onSteppingFinished(stopPlace);
                if (shouldHandle) break;
                return;
            }
            case "watchpoint-trigger": 
            case "read-watchpoint-trigger": 
            case "access-watchpoint-trigger": {
                String tupleKey;
                String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                GDBTuple wpt = null;
                String[] stringArray = tupleKeys;
                int n = stringArray.length;
                for (int i = 0; i < n && (wpt = resultTuple.getTuple(tupleKey = stringArray[i])) == null; ++i) {
                }
                if (wpt == null) break;
                int number = wpt.getRequiredInt("number");
                this.handleWatchpoint(stopPlace, number);
                this.tryToFlushOnWindows();
                return;
            }
            case "watchpoint-scope": {
                int wpnum = resultTuple.getRequiredInt("wpnum");
                this.handleWatchpointScope(wpnum);
                this.tryToFlushOnWindows();
                return;
            }
        }
        this.handleInterrupted(stopPlace);
        this.tryToFlushOnWindows();
    }

    protected void tryToFlushOnWindows() throws ExecutionException {
        if (this.myWindowsIoRedirectionEnabled && Registry.is((String)"cidr.debugger.gdb.workaround.windows.flushStreamsOnSuspend", (boolean)true) && this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            String fflushCall = "((int(*)(void*))fflush)(0)";
            String command = GDBDriver.format("0-data-evaluate-expression %s", "((int(*)(void*))fflush)(0)");
            new Communication(command).doInitiate();
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple, @NotNull Communication communication) throws ExecutionException {
        int num = resultTuple.getRequiredInt("bkptno");
        boolean shouldHandle = communication.myThreadPlan.onBreakpointHit(stopPlace, num);
        if (shouldHandle) {
            this.handleBreakpoint(stopPlace, num);
        }
    }

    private void cleanupOnTermination() {
        OutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        this.myResultQueue.offer(new ErrorResponse((NotNullProducer<ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        this.myCommandSemaphore.up();
        this.myStopSemaphore.up();
        this.myPendingForAttachNotification.up();
        this.myCommandExecutor.shutdown();
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws ExecutionException {
        long timeout = c.getTimeout();
        try {
            CompletableFuture<T> future = this.doExecuteCommand(c, false);
            return timeout < 0L ? ExecutionResult.get(future) : ExecutionResult.get(future, timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            CompletionException ce = (CompletionException)ExceptionUtil.findCause((Throwable)e, CompletionException.class);
            ExecutionException cause = (ExecutionException)((Object)ExceptionUtil.findCause((Throwable)(ce != null ? ce : e).getCause(), ExecutionException.class));
            throw cause != null ? cause : e;
        }
        catch (RejectedExecutionException e) {
            throw new ExecutionFinishedException((Throwable)e);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private <T> CompletableFuture<T> executeAsyncCommand(Command<T> c) {
        return this.doExecuteCommand(c, true);
    }

    private <T> CompletableFuture<T> doExecuteCommand(Command<T> c, boolean async) {
        return CompletableFuture.supplyAsync(() -> {
            CidrEventSpan ignored = new CidrEventSpan("debug", "doExecuteCommand", c.getClass().getName());
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && !(c instanceof DestroyCommand) && this.checkIsInPromptModeWhenSettled(500)) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                Object t = c.call();
                ignored.close();
                return t;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (async) {
                        this.myResultQueue.offer(new ErrorResponse(e));
                    }
                    throw new CompletionException(e);
                }
            }
        }, this.myCommandExecutor);
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value) {
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(1);
            description = matcher.group(2);
        }
        if (description == null) {
            description = value;
        }
        return Pair.create((Object)value, (Object)description);
    }

    @NotNull
    private Collection<String> doListFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --no-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        return variables.stream().map(var -> ((GDBTuple)var).getString("name", "")).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @NotNull
    private Pair<Boolean, String> doGetExpressionType(@NotNull String expr, long threadId, int frameIndex) throws ExecutionException {
        if (StringUtil.isEmptyOrSpaces((String)expr)) {
            return new Pair((Object)false, (Object)"<unknown>");
        }
        String command = GDBDriver.createConsoleCommand(GDBDriver.format("whatis/rmt %s", GDBDriver.escapeVariadicArgIfNeeded(expr)), threadId, frameIndex);
        try {
            String output = this.sendSilentRequestAndWaitForDone("%s", command).getOutput();
            Matcher m = WHATIS_TYPE_OUTPUT.matcher(output);
            if (m.matches()) {
                String substring = m.group(1) != null ? m.group(1) : m.group(2);
                return new Pair((Object)true, (Object)StringUtil.convertLineSeparators((String)substring, (String)" ").trim());
            }
            return new Pair((Object)false, (Object)"<unknown>");
        }
        catch (GDBCommandException e) {
            String error = e.getMessage();
            if ("value has been optimized out".equals(error)) {
                return new Pair((Object)false, (Object)"<optimized out>");
            }
            return new Pair((Object)false, (Object)("error: " + error));
        }
    }

    @NotNull
    private static String escapeVariadicArgIfNeeded(@NotNull String expr) {
        if (StringUtil.containsChar((String)expr, (char)'#') && !StringUtil.containsChar((String)expr, (char)'\'')) {
            return "'" + expr + "'";
        }
        return expr;
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name) {
        return frameAddr + "-" + name;
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        return this.myStarter.getHostMachine();
    }

    @NotNull
    private String toEnvPath(@NotNull String path) {
        return this.myStarter.convertToEnvPath(path);
    }

    private boolean isWindows() {
        return this.getHostMachine().getOSType() == OSType.WIN;
    }

    private boolean isMac() {
        return this.getHostMachine().getOSType() == OSType.MAC;
    }

    private boolean isUnix() {
        return !this.isWindows();
    }

    private boolean isMacOSSierra() {
        return !this.getHostMachine().isRemote() && SystemInfo.isMac;
    }

    private boolean isLinux() {
        return this.getHostMachine().getOSType() == OSType.LINUX;
    }

    public void setThreadFrameInfoDriverDelegate(@NotNull ThreadFrameInfoDriverDelegate driverDelegate) {
        this.myThreadFrameInfoDriverDelegate = driverDelegate;
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }

    private static class ModuleMap {
        @NotNull
        private final MutableAddressSpace<ModuleRegion> myAddressSpace = AddressSpaceKt.mutableAddressSpace();

        private ModuleMap() {
        }

        public synchronized void addModule(@NotNull AddressRange range, @NotNull LLModule module) throws ExecutionException {
            this.myAddressSpace.reallocate(new ModuleRegion(range, module));
        }

        public synchronized void removeModule(@NotNull LLModule module) {
            this.myAddressSpace.filterRegions().forEach(region2 -> {
                if (region2.getModule().equals(module)) {
                    this.myAddressSpace.unallocate((ModuleRegion)region2);
                }
            });
        }

        @Nullable
        public synchronized LLModule findModuleByAddress(@NotNull Address address2) {
            ModuleRegion region2 = (ModuleRegion)this.myAddressSpace.getRegion(address2);
            return region2 != null ? region2.getModule() : null;
        }
    }

    protected class Communication {
        private static final String GDB_POKE_COMMAND = "0-gdb-set $__poke_gdb=1";
        @NotNull
        public final String command;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        public final boolean tearDownRequest;
        @NotNull
        public final ThreadPlan myThreadPlan;
        @NotNull
        public final StringBuffer consoleOutput = new StringBuffer();
        public int receivedSignalCount;

        public Communication(String command) {
            this(command, false, false, false, false, false, ThreadPlan.DEFAULT);
        }

        public Communication(String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult, @NotNull boolean tearDownRequest, ThreadPlan threadPlan) {
            this.command = command;
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || this.isMultilineCommand(), (Object)("MI command must not contain unescaped newlines: " + command));
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
            this.tearDownRequest = tearDownRequest;
            this.myThreadPlan = threadPlan;
        }

        protected boolean isMultilineCommand() {
            int promptLevel = GDBDriver.this.getPromptLevel();
            return promptLevel == 1 && this.command.equals("end") || promptLevel == 0 && this.command.endsWith("\nend");
        }

        protected boolean usePokeCommandWorkaround() {
            if (GDBDriver.this.isLinux() && this.command.startsWith("-exec-run")) {
                return true;
            }
            if (GDBDriver.this.isLinux() && this.command.startsWith("-target-attach")) {
                return true;
            }
            return GDBDriver.this.isWindows() && this.isMultilineCommand();
        }

        public void initiate() throws ExecutionException {
            GDBDriver.this.sendRequestOrSpecialCommunication(this.command, this.tearDownRequest, (ThrowableRunnable<? extends ExecutionException>)((ThrowableRunnable)() -> {
                GDBDriver.this.myCommunication = this;
                this.doInitiate();
            }));
        }

        public void doInitiate() throws ExecutionException {
            this.doWrite(this.command);
            if (this.usePokeCommandWorkaround()) {
                this.doWrite(GDB_POKE_COMMAND);
            }
        }

        protected void doWrite(@NotNull String command) throws ExecutionException {
            try {
                this.doWriteIO(command);
            }
            catch (IOException e) {
                if (GDBDriver.this.isTerminated()) {
                    throw new ExecutionFinishedException((Throwable)e);
                }
                throw new ExecutionException(GDBBundle.message("error.cannot.send.request", new Object[0]), (Throwable)e);
            }
        }

        protected void doWriteIO(@NotNull String command) throws IOException {
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(">" + command);
            }
            GDBDriver.this.mySink.write(command + "\n");
            GDBDriver.this.mySink.flush();
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }

        public Response waitAndPokeForPrompt(int timeoutMs) throws ExecutionException {
            return this.doWaitForResponse(true, timeoutMs);
        }

        @NotNull
        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            Response response = this.doWaitForResponse(false, 0);
            GDBResponse.Record result2 = response.getRecord();
            Object resultType = result2.getType();
            if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
                return response;
            }
            String errorMessage = response.getGDBErrorMessage();
            if (!"-exec-interrupt".equals(this.command) || !GDBDriver.INFERIOR_NOT_EXECUTING.equals(errorMessage)) {
                CidrDebuggerLog.LOG.warn("[UNEXPECTED] >" + this.command);
                CidrDebuggerLog.LOG.warn("[UNEXPECTED] <" + result2);
            }
            if (GDBDriver.this.getState() != DebuggerDriver.TargetState.NOT_READY) {
                if ("ptrace: No such process.".equals(errorMessage)) {
                    GDBDriver.this.handleTargetTerminated(DebuggerDriver.ExitStatus.UNKNOWN);
                    throw new ExecutionFinishedException();
                }
                if (GDBDriver.this.getState() == DebuggerDriver.TargetState.FINISHED && ArrayUtil.contains((Object)GDBResponse.ResultRecord.Type.running, (Object[])expectedTypes)) {
                    throw new ExecutionFinishedException();
                }
            }
            if (resultType == GDBResponse.ResultRecord.Type.error) {
                throw response.createGDBError();
            }
            throw GDBDriver.unexpectedResponse(result2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private Response doWaitForResponse(boolean isConsoleCommand, int timeoutMs) throws ExecutionException {
            try (CidrEventSpan ignored = new CidrEventSpan("debug", "doWaitForResponse", this.command);){
                int timeoutElapsedMs = 0;
                int timeoutStepMs = 125;
                int EXP_BACK_OFF = 2;
                while (true) {
                    Response response;
                    if ((response = GDBDriver.this.myResultQueue.poll(timeoutStepMs, TimeUnit.MILLISECONDS)) != null) {
                        Response response2 = response;
                        return response2;
                    }
                    if (timeoutMs > 0 && (timeoutElapsedMs += timeoutStepMs) > timeoutMs) {
                        throw new ExecutionException(GDBBundle.message("error.no.result.response.or.multiline.prompt.within.reasonable.amount.time", new Object[0]));
                    }
                    if (isConsoleCommand) {
                        this.doWrite("\n");
                    }
                    timeoutStepMs *= 2;
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
            }
        }
    }

    public static interface ThreadFrameInfoDriverDelegate {
        @NotNull
        default public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            return driver.executeAsyncCommand(() -> driver.doReadStopPlace(stopTuple)).handle((result2, throwable) -> {
                if (throwable != null) {
                    CidrDebuggerLog.LOG.error(throwable);
                }
                return result2;
            });
        }

        @NotNull
        default public List<LLThread> getThreads(@NotNull Bridge bridge, @NotNull GDBDriver driver) throws ExecutionException, DebuggerCommandException {
            return (List)bridge.executeCommand(() -> driver.doGetThreads());
        }

        @NotNull
        default public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            return bridge.executeCommand(() -> bridge.doGetFrames(thread.getId(), from, count, untilFirstLineWithCode));
        }

        @NotNull
        default public List<LLValue> getVariables(@NotNull Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
            return (List)bridge.executeCommand(() -> bridge.doGetFrameVariables(thread.getId(), frame.getIndex()));
        }

        @NotNull
        default public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull Bridge bridge, @NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
            return (DebuggerDriver.ResultList)bridge.executeCommand(() -> bridge.doGetVariableChildren(value, from, count));
        }

        @NotNull
        default public LLValueData getData(@NotNull Bridge bridge, @NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
            return (LLValueData)bridge.executeCommand(() -> GDBDriver.doLoadVariableStatic((LLValue)var).data);
        }

        @NotNull
        default public LLValue evaluate(final @NotNull Bridge bridge, final @NotNull LLThread thread, final @NotNull LLFrame frame, final @NotNull String expression, final @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
            return bridge.executeCommand(new EvaluationCommand<LLValue>(expression){

                @Override
                public LLValue call() throws ExecutionException, DebuggerCommandException {
                    return bridge.doEvaluate(thread.getId(), frame.getIndex(), expression, language);
                }
            });
        }
    }

    public static interface Bridge {
        @NotNull
        public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> var1);

        @NotNull
        public <T> T executeCommand(@NotNull Command<T> var1) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public String sendSilentRequestAndGetOutput(@PrintFormat @NonNls @NotNull String var1, Object ... var2) throws ExecutionException, GDBCommandException;

        @NotNull
        public LLFrame doReadFrame(int var1, @NotNull GDBTuple var2) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> doGetFrames(long var1, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public List<LLValue> doGetFrameVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValueData doEvaluateAndLoad(long var1, int var3, String var4, @Nullable String var5) throws ExecutionException, DebuggerCommandException;

        @Nullable
        public DebuggerDriver.StopPlace getStopPlace();

        @NotNull
        public LLValueData doLoadVariableData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValue doEvaluate(long var1, int var3, String var4, @Nullable DebuggerDriver.DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

        @Nullable
        public LLValue doReadReturnValue(@NotNull GDBTuple var1, long var2, int var4) throws ExecutionException, DebuggerCommandException;
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws ExecutionException, DebuggerCommandException;
    }

    public static interface Command<T> {
        @Nullable
        public T call() throws ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return GDBDriver.getTimeoutMs();
        }
    }

    protected static interface Response {
        public static final Response NULL = new Response(){

            @Override
            @NotNull
            public GDBResponse.Record getRecord() {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getOutput() {
                return "";
            }

            @Override
            public int getReceivedSignalCount() {
                throw new UnsupportedOperationException();
            }
        };

        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws ExecutionException {
            return this.getRecord().getResultList();
        }

        @NlsSafe
        @NotNull
        public String getOutput() throws ExecutionException;

        default public void checkError() throws ExecutionException {
        }

        @NotNull
        default public GDBCommandException createGDBError() throws ExecutionException {
            String errorMessage = this.getGDBErrorMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown GDB error";
            }
            return new GDBCommandException(this, errorMessage);
        }

        @Nullable
        default public String getGDBErrorMessage() throws ExecutionException {
            return this.getRecord().getResultList().getString("msg");
        }

        public int getReceivedSignalCount() throws ExecutionException;
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        GDBCommandException(@NotNull Response response, @NotNull String message) {
            super(message);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            return this.myResponse;
        }
    }

    protected static interface LoadingCommand
    extends StartCommand<Void>,
    VoidCommand {
    }

    protected static interface LaunchCommand
    extends StartCommand<Integer> {
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;
        @NotNull
        private ThreadPlan myThreadPlan = ThreadPlan.DEFAULT;
        private boolean myTearDownRequest;

        public Request(String command) {
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws ExecutionException {
            Communication communication = new Communication(this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult, this.myTearDownRequest, this.myThreadPlan);
            communication.initiate();
            return communication;
        }

        @NotNull
        public String getCommand() {
            return this.myCommand;
        }

        public Request suppressAll() {
            return this.suppressOutputEvent().suppressRunningEvent().suppressRunningResult();
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }

        private Request tearDownRequest(boolean tearDownRequest) {
            this.myTearDownRequest = tearDownRequest;
            return this;
        }

        public Request withThreadPlan(@Nullable ThreadPlan threadPlan) {
            this.myThreadPlan = threadPlan != null ? threadPlan : ThreadPlan.DEFAULT;
            return this;
        }

        public Request onSteppingFinished(@Nullable ThreadPlan.SteppingFinished threadPlan) {
            return this.withThreadPlan(threadPlan);
        }
    }

    protected static interface DestroyCommand
    extends Command<Boolean> {
        @Override
        default public long getTimeout() {
            return 1500L;
        }
    }

    protected static class LLValueLoadedData {
        @NotNull
        public final String id;
        @Nullable
        public final String fvKey;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        @NotNull
        public final LLValueData data;

        public LLValueLoadedData(@NotNull String id, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, @NotNull String value, @Nullable String displayHint) {
            this.id = id;
            this.fvKey = fvKey;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = displayHint != null && "map".equals(displayHint.split("=", 2)[0]);
            String descriptionFromDisplayHint = LLValueLoadedData.extractDescriptionFromDisplayHint(displayHint);
            if (descriptionFromDisplayHint != null && value.equals("{...}")) {
                value = descriptionFromDisplayHint;
            }
            Pair<String, String> valueAndDescription = GDBDriver.getDescriptionFromValue(value);
            value = (String)valueAndDescription.first;
            String description = (String)valueAndDescription.second;
            boolean hasLongerDescription = description != null && description.length() >= 256;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren || isDynamic;
            this.data = new LLValueData(value, description, hasLongerDescription, mayHaveChildren, isDynamic);
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }

        @Nullable
        private static String extractDescriptionFromDisplayHint(@Nullable String displayHint) {
            int eqIndex;
            if (displayHint != null && (eqIndex = displayHint.indexOf(61)) != -1) {
                return displayHint.substring(eqIndex + 1);
            }
            return null;
        }
    }

    public static interface SuspendedCommand<T>
    extends Command<T> {
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFvKey;
        private final long myThreadId;
        private final int myFrameIndex;

        FrameValueLoader(String fvKey, long threadId, int frameIndex) {
            this.myFvKey = fvKey;
            this.myThreadId = threadId;
            this.myFrameIndex = frameIndex;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            String name = value.getName();
            GDBResponse.Record varObj = GDBDriver.this.doCreateVar(name, this.myThreadId, this.myFrameIndex);
            String id = varObj.getResultList().getRequiredString("name");
            String v = varObj.getResultList().getString("value", "");
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varObj.getResultList(), id, this.myFvKey, v);
            GDBDriver.doUpdateLoadedData(value, data);
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            return this.myKey;
        }

        @NotNull
        public LLValue getValue() {
            return this.myValue;
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) {
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
            return true;
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            String id = this.partialLoadedData.id;
            GDBTuple varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", DebuggerDriver.stringify(id)).getResultList();
            String val = varObj.getRequiredString("value");
            String displayHint = varObj.getString("displayhint", "");
            GDBDriver.doUpdateLoadedData(value, new LLValueLoadedData(id, this.partialLoadedData.fvKey, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, val, displayHint));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<ExecutionException> myErrorSupplier;

        ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(throwable)));
        }

        ErrorResponse(@NlsContexts.DialogMessage @Nullable String message, @Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(message, throwable)));
        }

        ErrorResponse(@NotNull NotNullProducer<ExecutionException> errorSupplier) {
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public ExecutionException getError() {
            return (ExecutionException)((Object)this.myErrorSupplier.produce());
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws ExecutionException {
            throw this.getError();
        }
    }

    protected static interface ThreadPlan {
        public static final ThreadPlan DEFAULT = new ThreadPlan(){};

        default public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace stopPlace) throws ExecutionException {
            return true;
        }

        default public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) throws ExecutionException {
            return true;
        }

        @FunctionalInterface
        public static interface BreakpointHit
        extends ThreadPlan {
            @Override
            public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace var1, int var2) throws ExecutionException;
        }

        @FunctionalInterface
        public static interface SteppingFinished
        extends ThreadPlan {
            @Override
            public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace var1) throws ExecutionException;
        }
    }

    public static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression) {
            this.myExpression = expression;
        }

        @NotNull
        public String getExpression() {
            return this.myExpression;
        }

        @Override
        public long getTimeout() {
            return GDBDriver.getEvaluationTimeoutMs();
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        ConsoleCommand(@NotNull String expression) {
            super(expression);
        }
    }

    private static class ModuleRegion
    implements AddressSpace.Region {
        @NotNull
        private final AddressRange myRange;
        @NotNull
        private final LLModule myModule;

        private ModuleRegion(@NotNull AddressRange range, @NotNull LLModule module) {
            this.myRange = range;
            this.myModule = module;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.myRange;
        }

        @NotNull
        public LLModule getModule() {
            return this.myModule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleRegion region2 = (ModuleRegion)o;
            return this.myRange.equals(region2.myRange) && this.myModule.equals(region2.myModule);
        }

        public int hashCode() {
            return Objects.hash(this.myRange, this.myModule);
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            return this.myRecord;
        }

        @Override
        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }
    }

    protected abstract class AttachConnectCommand
    implements LaunchCommand {
        protected AttachConnectCommand() {
        }

        @Override
        @NotNull
        public Integer call() throws ExecutionException, DebuggerCommandException {
            int pid;
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                pid = this.attach();
                GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doReadTargetInfo();
            this.whenAttached();
            GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
            return pid;
        }

        protected abstract int attach() throws ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws ExecutionException, DebuggerCommandException;
    }

    protected static interface StartCommand<T>
    extends Command<T> {
        @Override
        default public long getTimeout() {
            return GDBDriver.getLoadTimeoutMs();
        }
    }
}

