/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.cuda.CudaLLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "CudaCommands", "intellij.cidr.debugger"})
public final class CudaSupport
implements CidrDebugProcessConfigurator {
    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        DebuggerDriverConfiguration driverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        if (!(driverConfiguration instanceof GDBDriverConfiguration) || !Intrinsics.areEqual((Object)PathUtil.getFileName((String)((GDBDriverConfiguration)driverConfiguration).getGDBExecutablePath()), (Object)"cuda-gdb")) {
            return;
        }
        process.postCommand(arg_0 -> CudaSupport.configure$lambda$0(this, process, arg_0));
    }

    private static final void configure$lambda$0(CudaSupport this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        Intrinsics.checkNotNull((Object)driver, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver");
        String output = ((GDBDriver)driver).sendSilentRequestAndWaitForDone("show cuda", new Object[0]).getOutput();
        if (StringsKt.contains((CharSequence)output, (CharSequence)"CUDA Debugger", (boolean)true)) {
            ((GDBDriver)driver).setThreadFrameInfoDriverDelegate(this$0.new CudaCommands());
            CidrDebuggerUsagesCollector.Companion.logCudaDetected($process.getProject());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J?\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport$CudaCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;)V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "evaluate", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "expression", "", "language", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DebuggerLanguage;", "getVariables", "", "switchContextIfNeededAndExecute", "T", "switchedContextExecutor", "Lkotlin/Function0;", "defaultExecutor", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.cidr.debugger"})
    private final class CudaCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @Override
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            CompletableFuture<DebuggerDriver.StopPlace> completableFuture;
            GDBTuple cudaFocus = stopTuple.getTupleOrEmpty("CudaFocus");
            if (cudaFocus.isEmpty()) {
                completableFuture = GDBDriver.ThreadFrameInfoDriverDelegate.super.doReadStopPlaceAsync(bridge, driver, stopTuple);
            } else {
                DebuggerDriver.StopPlace stopPlace;
                try {
                    GDBTuple $this$doReadStopPlaceAsync_u24lambda_u240 = cudaFocus;
                    boolean bl = false;
                    CudaLLThread thread = new CudaLLThread($this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("kernel"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("grid"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredString("blockIdx"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredString("threadIdx"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("device"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("sm"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("warp"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("lane"));
                    GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> CudaCommands.doReadStopPlaceAsync$lambda$1(stopTuple));
                    LLFrame frame = bridge.doReadFrame(0, frameTuple);
                    stopPlace = new DebuggerDriver.StopPlace(thread, frame, bridge.doReadReturnValue(stopTuple, thread.getId(), frame.getIndex()));
                }
                catch (ExecutionException e) {
                    CidrDebuggerLog.LOG.error((Throwable)e);
                    stopPlace = null;
                }
                DebuggerDriver.StopPlace stopPlace2 = stopPlace;
                completableFuture = CompletableFuture.completedFuture(stopPlace2);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public List<LLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            return (List)this.switchContextIfNeededAndExecute(bridge, thread, (Function0)new Function0<List<LLValue>>(bridge, frame){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLFrame $frame;
                {
                    this.$bridge = $bridge;
                    this.$frame = $frame;
                    super(0);
                }

                @NotNull
                public final List<LLValue> invoke() {
                    return this.$bridge.doGetFrameVariables(-1L, this.$frame.getIndex());
                }
            }, (Function0)new Function0<List<LLValue>>(this, bridge, thread, frame){
                final /* synthetic */ CudaCommands this$0;
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ LLFrame $frame;
                {
                    this.this$0 = $receiver;
                    this.$bridge = $bridge;
                    this.$thread = $thread;
                    this.$frame = $frame;
                    super(0);
                }

                @NotNull
                public final List<LLValue> invoke() {
                    return CudaCommands.access$getVariables$s228224222(this.this$0, this.$bridge, this.$thread, this.$frame);
                }
            });
        }

        @Override
        @NotNull
        public LLValue evaluate(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) {
            return (LLValue)((Object)this.switchContextIfNeededAndExecute(bridge, thread, (Function0)new Function0<LLValue>(bridge, frame, expression, language){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLFrame $frame;
                final /* synthetic */ String $expression;
                final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;
                {
                    this.$bridge = $bridge;
                    this.$frame = $frame;
                    this.$expression = $expression;
                    this.$language = $language;
                    super(0);
                }

                @NotNull
                public final LLValue invoke() {
                    return this.$bridge.doEvaluate(-1L, this.$frame.getIndex(), this.$expression, this.$language);
                }
            }, (Function0)new Function0<LLValue>(this, bridge, thread, frame, expression, language){
                final /* synthetic */ CudaCommands this$0;
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ LLFrame $frame;
                final /* synthetic */ String $expression;
                final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;
                {
                    this.this$0 = $receiver;
                    this.$bridge = $bridge;
                    this.$thread = $thread;
                    this.$frame = $frame;
                    this.$expression = $expression;
                    this.$language = $language;
                    super(0);
                }

                @NotNull
                public final LLValue invoke() {
                    return CudaCommands.access$evaluate$s228224222(this.this$0, this.$bridge, this.$thread, this.$frame, this.$expression, this.$language);
                }
            }));
        }

        private final <T> T switchContextIfNeededAndExecute(GDBDriver.Bridge bridge, LLThread thread, Function0<? extends T> switchedContextExecutor, Function0<? extends T> defaultExecutor) {
            return (T)(thread instanceof CudaLLThread ? bridge.executeCommand(() -> CudaCommands.switchContextIfNeededAndExecute$lambda$2(bridge, thread, switchedContextExecutor)) : defaultExecutor.invoke());
        }

        private static final ExecutionException doReadStopPlaceAsync$lambda$1(GDBTuple $stopTuple) {
            Object[] objectArray = new Object[]{$stopTuple};
            return new ExecutionException(GDBBundle.message("error.cannot.read.stop.place", objectArray));
        }

        private static final Object switchContextIfNeededAndExecute$lambda$2(GDBDriver.Bridge $bridge, LLThread $thread, Function0 $switchedContextExecutor) {
            String consoleOutput = $bridge.sendSilentRequestAndGetOutput("cuda kernel", new Object[0]);
            if (StringsKt.startsWith$default((String)consoleOutput, (String)"Focus is not set", (boolean)false, (int)2, null)) {
                $bridge.sendSilentRequestAndGetOutput("cuda kernel " + ((CudaLLThread)$thread).getKernel() + " grid " + ((CudaLLThread)$thread).getGrid() + " thread " + ((CudaLLThread)$thread).getThreadIdx() + " block " + ((CudaLLThread)$thread).getBlockIdx() + " device " + ((CudaLLThread)$thread).getDevice() + " sm " + ((CudaLLThread)$thread).getSm() + " warp " + ((CudaLLThread)$thread).getWarp() + " lane " + ((CudaLLThread)$thread).getLane(), new Object[0]);
            }
            return $switchedContextExecutor.invoke();
        }

        public static final /* synthetic */ List access$getVariables$s228224222(CudaCommands $this, GDBDriver.Bridge bridge, LLThread thread, LLFrame frame) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.getVariables(bridge, thread, frame);
        }

        public static final /* synthetic */ LLValue access$evaluate$s228224222(CudaCommands $this, GDBDriver.Bridge bridge, LLThread thread, LLFrame frame, String expression, DebuggerDriver.DebuggerLanguage language) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.evaluate(bridge, thread, frame, expression, language);
        }
    }
}

