/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriverConfiguration
extends UserDataHolderBase {
    @NotNull
    @NlsSafe
    public abstract String getDriverName();

    public boolean isAttachSupported() {
        return true;
    }

    @NotNull
    public abstract DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler var1, @NotNull ArchitectureType var2) throws ExecutionException;

    @Deprecated
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        return this.createDriverCommandLine(driver, ArchitectureType.UNKNOWN);
    }

    @NotNull
    public abstract GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver var1, @NotNull ArchitectureType var2) throws ExecutionException;

    protected static void setupCommonParameters(@NotNull GeneralCommandLine result2) {
        result2.setCharset(StandardCharsets.UTF_8);
    }

    @Contract(value="null -> null")
    public String convertToLocalPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    @Contract(value="null -> null")
    public String convertToEnvPath(@Nullable String localPath) {
        return localPath;
    }

    public boolean isElevated() {
        return false;
    }

    @NotNull
    public BaseProcessHandler<?> createDebugProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        HostMachine host = this.getHostMachine();
        if (host.isRemote() || this.isElevated()) {
            return host.createProcessBuilder().withElevated(this.isElevated()).withRunDebugEnvSetup(true).build(commandLine);
        }
        OSProcessHandler handler = new OSProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return BaseOutputReader.Options.BLOCKING;
            }
        };
        handler.setShouldDestroyProcessRecursively(false);
        return handler;
    }

    @NotNull
    public HostMachine getHostMachine() {
        return LocalHost.INSTANCE;
    }

    public abstract EvaluationContext createEvaluationContext(@NotNull DebuggerDriver var1, @Nullable Expirable var2, @NotNull LLThread var3, @NotNull LLFrame var4, @NotNull UserDataHolderEx var5);

    @NotNull
    public abstract Language getConsoleLanguage();

    @Deprecated
    public boolean supportsArrayEvaluation() {
        return false;
    }

    @Deprecated
    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }
}

