/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DebuggerDriver {
    public static final Key<String> DEBUGSERVER_SOCKET = Key.create((String)"DEBUGSERVER_SOCKET");
    public static final Key<Integer> DEBUGSERVER_ID = Key.create((String)"DEBUGSERVER_ID");
    public static final Key<Boolean> USE_EXTERNAL_CONSOLE_KEY = Key.create((String)"USE_EXTERNAL_CONSOLE");
    public static final int LOAD_TIMEOUT_MS = 90000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int CLOSE_TIMEOUT_MS = 300;
    public static final int DESTROY_TIMEOUT_MS = 1500;
    public static final int MAX_DESCRIPTION = 256;
    public static final int MAX_DISASSEMBLE_FUNCTION_SIZE = 65536;
    @NotNull
    protected final Handler myHandler;
    @NotNull
    private volatile TargetState myState = TargetState.NOT_READY;
    @NotNull
    protected final QueueProcessor<Runnable> myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
    @Nullable
    private ProcessOutputReaders myReaders;
    @Nullable
    private CidrEventSpan myStateSpan;
    protected boolean myToRedirect;

    public DebuggerDriver(@NotNull Handler handler) {
        this.myHandler = Handler.createQueuedHandler(handler, this.myHandlerProcessor);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    public boolean supportsJumpToLine() {
        return false;
    }

    @NotNull
    public abstract BaseProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    @NotNull
    public TargetState getState() {
        return this.myState;
    }

    @NotNull
    public abstract HostMachine getHostMachine();

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForLaunch(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(int var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(@NotNull String var1, boolean var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadCoreDump(@NotNull File var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4) throws ExecutionException;

    @NotNull
    public abstract Inferior loadCoreDump(@NotNull File var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4, @NotNull List<String> var5) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForRemote(@NotNull String var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    @Deprecated
    public abstract void stepOver(boolean var1) throws ExecutionException;

    @Deprecated
    public abstract void stepInto(boolean var1, boolean var2) throws ExecutionException;

    @Deprecated
    public abstract void stepOut(boolean var1) throws ExecutionException;

    public void stepOver(@NotNull LLThread thread, boolean stepByInstruction) throws ExecutionException {
        this.stepOver(stepByInstruction);
    }

    public void stepInto(@NotNull LLThread thread, boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        this.stepInto(forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
    }

    public void stepOut(@NotNull LLThread thread, boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        this.stepOut(stopInFramesWithNoDebugInfo);
    }

    public abstract void runTo(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void runTo(@NotNull Address var1) throws ExecutionException;

    @NotNull
    public abstract StopPlace jumpToLine(@NotNull LLThread var1, @NotNull String var2, int var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract StopPlace jumpToAddress(@NotNull LLThread var1, @NotNull Address var2, boolean var3) throws ExecutionException, DebuggerCommandException;

    public abstract void addPathMapping(int var1, @NotNull String var2, @NotNull String var3) throws ExecutionException;

    public abstract void addForcedFileMapping(int var1, @NotNull String var2, @Nullable DebuggerSourceFileHash var3, @NotNull String var4) throws ExecutionException;

    protected abstract boolean doExit() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(long var1, int var3, @NotNull LLValue var4, @NotNull String var5, @Nullable LLWatchpoint.Lifetime var6, @NotNull LLWatchpoint.AccessType var7) throws ExecutionException, DebuggerCommandException;

    public abstract void removeWatchpoint(@NotNull List<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public AddBreakpointResult addBreakpoint(@NotNull String path, int line) throws ExecutionException, DebuggerCommandException {
        return this.addBreakpoint(path, line, null, false);
    }

    @NotNull
    public AddBreakpointResult addBreakpoint(@NotNull String path, int line, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        return this.addBreakpoint(path, line, condition, false);
    }

    @NotNull
    public abstract AddBreakpointResult addBreakpoint(@NotNull String var1, int var2, @Nullable String var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract AddBreakpointResult addAddressBreakpoint(@NotNull Address var1, @Nullable String var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern) throws ExecutionException, DebuggerCommandException {
        return this.addSymbolicBreakpoint(symbolPattern, null, null);
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern, @Nullable String module, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(symbolPattern);
        symBreakpoint.setModule(module);
        symBreakpoint.setCondition(condition);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @Nullable
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DebuggerCommandException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count) throws ExecutionException, DebuggerCommandException {
        return this.getFrames(thread, from, count, false);
    }

    @NotNull
    public abstract ResultList<LLFrame> getFrames(@NotNull LLThread var1, int var2, int var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public List<LLValue> getVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        return this.getVariables(thread.getId(), frame.getIndex());
    }

    @Deprecated
    @NotNull
    public abstract List<LLValue> getVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract LLValueData getData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract String getDescription(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract Integer getChildrenCount(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<LLValue> getVariableChildren(@NotNull LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(thread.getId(), frame.getIndex(), expression, language);
    }

    @NotNull
    public final LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NlsSafe @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(thread, frame, expression, null);
    }

    @Deprecated
    @NotNull
    public final LLValue evaluate(long threadId, int frameIndex, @NlsSafe @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(threadId, frameIndex, expression, null);
    }

    @Deprecated
    @NotNull
    public abstract LLValue evaluate(long var1, int var3, @NotNull String var4, @Nullable DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

    public int getPointerSize() throws ExecutionException, DebuggerCommandException {
        LLValue value = this.evaluate(-1L, -1, "sizeof(void *)");
        return (int)this.getData(value).intValue();
    }

    @NotNull
    public abstract List<LLInstruction> disassembleFunction(@NotNull Address var1, @NotNull AddressRange var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLInstruction> disassemble(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLInstruction disassemble(@NotNull Address address2) throws ExecutionException, DebuggerCommandException {
        List<LLInstruction> instructions = this.disassemble(AddressUtil.addressToRange(address2, 1L));
        return instructions.isEmpty() ? null : instructions.get(0);
    }

    @NotNull
    public abstract List<LLMemoryHunk> dumpMemory(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLSection> getModuleSections(@NotNull LLModule var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    @Deprecated(forRemoval=true)
    @TestOnly
    public void executeConsoleCommand(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        this.executeInterpreterCommand(-1L, -1, command);
    }

    @TestOnly
    @NotNull
    public abstract String executeInterpreterCommand(@NotNull String var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract String executeInterpreterCommand(long var1, int var3, @NotNull String var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<String> completeConsoleCommand(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void handleSignal(@NotNull String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    public abstract void cancelSymbolsDownload(@NotNull String var1) throws ExecutionException, DebuggerCommandException;

    protected void setState(@NotNull TargetState state) {
        this.myState = state;
        if (state == TargetState.RUNNING) {
            this.traceState(new CidrEventSpan("debug", "driver running", null, "<DebuggerDriver>"));
        } else {
            this.traceState(null);
        }
        if (state == TargetState.FINISHED) {
            this.closeOutputReaders();
        }
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandler.handleRunning();
    }

    protected void handleModulesLoaded(@NotNull List<LLModule> modules) {
        this.myHandler.handleModulesLoaded(modules);
    }

    protected void handleModulesUnloaded(@NotNull List<LLModule> modules) {
        this.myHandler.handleModulesUnloaded(modules);
    }

    protected void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        this.myHandler.handleBreakpointAdded(breakpoint);
    }

    protected void handleBreakpointRemoved(int breakpointId) {
        this.myHandler.handleBreakpointRemoved(breakpointId);
    }

    protected void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        this.myHandler.handleBreakpointUpdated(breakpoint);
    }

    protected void handleBreakpointLocationsReplaced(@NotNull int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        this.myHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
    }

    protected void handleBreakpointLocationsUpdated(@NotNull int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        this.myHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
    }

    protected void handleBreakpointLocationsRemoved(@NotNull int breakpointId, @NotNull List<String> locationIds) {
        this.myHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
    }

    protected void handleInterrupted(@NotNull StopPlace stopPlace) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleInterrupted(stopPlace);
    }

    protected void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleSignal(stopPlace, signal, meaning);
    }

    protected void handleException(@NotNull StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleException(stopPlace, exceptionAddress, exceptionFile, exceptionHash, exceptionLine, description);
    }

    protected void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleBreakpoint(stopPlace, breakpointNumber);
    }

    protected void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpoint(stopPlace, watchpointNumber);
    }

    protected void handleWatchpointScope(int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpointScope(watchpointNumber);
    }

    protected void handleTargetOutput(@Nls @NotNull String text, @NotNull Key type) {
        DebuggerDriver.logOutputSummary("Target", text, type);
        this.myHandler.handleTargetOutput(text, type);
    }

    protected void handleAttached(int pid) {
        this.myHandler.handleAttached(pid);
    }

    protected void handleConnected(@NotNull String connection) {
        this.myHandler.handleConnected(connection);
    }

    protected void handleDisconnected() {
        this.myHandler.handleDisconnected();
    }

    protected void handleDebuggerOutput(@Nls @NotNull String text, @NotNull Key type) {
        DebuggerDriver.logOutputSummary("Debugger", text, type);
        this.myHandler.handleDebuggerOutput(text, type);
    }

    private static void logOutputSummary(@NonNls @NotNull String description, @NonNls @NotNull String text, @NotNull Key type) {
        if (CidrDebuggerLog.LOG.isTraceEnabled()) {
            int maxLength = 80;
            int length = text.length();
            @NonNls Object shortText = DebuggerDriver.stringify(StringUtil.shortenTextWithEllipsis((String)text, (int)80, (int)0));
            if (length > 80) {
                shortText = (String)shortText + " (" + length + " chars)";
            }
            CidrDebuggerLog.LOG.trace(description + " [" + type + "]: " + (String)shortText);
        }
    }

    protected void handlePrompt() {
        this.handlePrompt(false);
    }

    protected void handlePrompt(boolean inMultiLineCommand) {
        this.handlePrompt(inMultiLineCommand ? 1 : 0);
    }

    protected void handlePrompt(int promptLevel) {
        this.handlePrompt((String)(promptLevel == 0 ? "(" + this.getPromptText() + ") " : StringUtil.repeat((String)"> ", (int)promptLevel)));
    }

    protected abstract String getPromptText();

    protected void handlePrompt(@NotNull String prompt) {
        this.myHandler.handlePrompt(prompt);
    }

    protected void handleTargetTerminated(@NotNull ExitStatus exitStatus) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetTerminated(exitStatus);
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleDetached();
    }

    protected void handleExited(int code) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleExited(code);
    }

    protected void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
        this.myHandler.handleSelectedFrameChanged(thread, frame);
    }

    protected void handleSymbolsDownloadStarted(@NotNull String caption, @NotNull String details) {
        this.myHandler.handleSymbolsDownloadStarted(caption, details);
    }

    protected void handleSymbolsDownloadProgress(int percent) {
        this.myHandler.handleSymbolsDownloadProgress(percent);
    }

    protected void handleSymbolsDownloadFinished() {
        this.myHandler.handleSymbolsDownloadFinished();
    }

    @TestOnly
    public void waitHandlerProcessed() {
        this.myHandlerProcessor.waitFor();
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public abstract void checkErrors() throws ExecutionException;

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    @NotNull
    protected ProcessOutputReaders initReaders(@NotNull HostMachine host, @NotNull GeneralCommandLine targetCommandLine, boolean usePty) throws ExecutionException {
        String name = CommandLineUtil.extractPresentableName((String)targetCommandLine.getCommandLineString());
        this.myReaders = new ProcessOutputReaders(host, name, targetCommandLine.getCharset(), usePty){

            @Override
            protected void onTextAvailable(@NlsSafe @NotNull String text, @NotNull Key type) {
                DebuggerDriver.this.handleTargetOutput(text, type);
            }
        };
        return this.myReaders;
    }

    protected void closeOutputReaders() {
        ProcessOutputReaders readers = this.myReaders;
        if (readers != null) {
            try {
                if (!readers.waitFor(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Closing inferior output readers took too long");
                }
            }
            finally {
                readers.close();
                this.myReaders = null;
            }
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name) {
        return "SIGTERM".equals(name) || "SIGKILL".equals(name);
    }

    public abstract void addSymbolsFile(@NotNull File var1, @Nullable File var2) throws ExecutionException;

    @NotNull
    protected static String format(@NonNls @PrintFormat @NotNull String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static int escapedByte(@NotNull String s, int idx, @NotNull ByteArrayOutputStream bs) {
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    public static String stringify(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length() + 2).append('\"');
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
        return buffer.append('\"').toString();
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i = idx - 1;
                    bs.reset();
                    while ((i = DebuggerDriver.escapedByte(s, i, bs)) != -1) {
                        idx = i;
                    }
                    if (bs.size() > 0) {
                        buffer.append(new String(bs.toByteArray(), StandardCharsets.UTF_8));
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    @Contract(value="_, !null -> !null")
    public static Address parseAddress(@NotNull String str, Address defaultValue) {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Address parseAddress(@NotNull String str) throws ExecutionException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public static Address parseAddressSafe(@NotNull String str) throws DebuggerCommandException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(e);
        }
    }

    protected static int getTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout", (int)30000);
    }

    protected static int getLoadTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.load", (int)90000);
    }

    protected static int getEvaluationTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.evaluate", (int)30000);
    }

    @NlsSafe
    protected static String asNlsSafe(@NlsSafe String s) {
        return s;
    }

    @NotNull
    protected BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine, final @NotNull DebuggerDriverConfiguration config) throws ExecutionException {
        BaseProcessHandler<?> handler = config.createDebugProcessHandler(commandLine);
        final Process process = handler.getProcess();
        CidrDebuggerLog.LOG.info("[PID " + process.pid() + "] Debugger started: " + commandLine.getCommandLineString());
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (process.isAlive() && willBeDestroyed) {
                    try {
                        if (!DebuggerDriver.this.doExit()) {
                            return;
                        }
                    }
                    catch (ExecutionException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                        return;
                    }
                    try {
                        process.waitFor(1500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                String exitCodeString = ProcessTerminatedListener.stringifyExitCode((Platform)config.getHostMachine().getOSType().toPlatform(), (int)event.getExitCode());
                CidrDebuggerLog.LOG.info("[PID " + process.pid() + "] Debugger exited with code " + exitCodeString);
                if (process.isAlive() && OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                }
            }
        });
        return handler;
    }

    private void traceState(@Nullable CidrEventSpan eventSpan) {
        if (this.myStateSpan != null) {
            this.myStateSpan.close();
        }
        this.myStateSpan = eventSpan;
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHED;

    }

    public static interface Handler
    extends EventListener {
        default public void handleRunning() {
        }

        default public void handleModulesLoaded(@NotNull List<LLModule> modules) {
        }

        default public void handleModulesUnloaded(@NotNull List<LLModule> modules) {
        }

        default public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        }

        default public void handleBreakpointRemoved(int breakpointId) {
        }

        default public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        }

        default public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        }

        default public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        }

        default public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        }

        default public void handleInterrupted(@NotNull StopPlace stopPlace) {
        }

        default public void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        }

        default public void handleException(@NotNull StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        }

        default public void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        }

        default public void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        }

        default public void handleWatchpointScope(int watchpointNumber) {
        }

        default public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        }

        default public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        }

        default public void handlePrompt(@NotNull String prompt) {
        }

        default public void handleTargetTerminated(@NotNull ExitStatus exitStatus) {
        }

        default public void handleExited(int code) {
        }

        default public void handleAttached(int pid) {
        }

        default public void handleDetached() {
        }

        default public void handleConnected(@NotNull String connection) {
        }

        default public void handleDisconnected() {
        }

        default public void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
        }

        default public void handleSymbolsDownloadStarted(@NotNull String caption, @NotNull String details) {
        }

        default public void handleSymbolsDownloadProgress(int percent) {
        }

        default public void handleSymbolsDownloadFinished() {
        }

        @NotNull
        public static Handler createQueuedHandler(@NotNull Handler handler, @NotNull QueueProcessor<Runnable> queueProcessor) {
            return (Handler)Proxy.newProxyInstance(Handler.class.getClassLoader(), new Class[]{Handler.class}, (proxy, method, args) -> {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)handler, args);
                }
                queueProcessor.add(() -> {
                    try {
                        method.invoke((Object)handler, args);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                });
                return null;
            });
        }
    }

    public static class AddBreakpointResult {
        @NotNull
        private final LLBreakpoint myBreakpoint;
        @NotNull
        private final @NotNull List<@NotNull LLBreakpointLocation> myBreakpointLocations;

        public AddBreakpointResult(@NotNull LLBreakpoint breakpoint, @NotNull @NotNull List<@NotNull LLBreakpointLocation> locations) {
            this.myBreakpoint = breakpoint;
            this.myBreakpointLocations = locations;
        }

        @NotNull
        public LLBreakpoint getBreakpoint() {
            return this.myBreakpoint;
        }

        @NotNull
        public @NotNull List<@NotNull LLBreakpointLocation> getBreakpointLocations() {
            return this.myBreakpointLocations;
        }
    }

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        @NotNull
        private String myPattern = "";
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private long myThreadId = 0L;

        @NotNull
        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(@NotNull String pattern) {
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module) {
            this.myModule = module;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition) {
            this.myCondition = condition;
        }

        public long getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(long threadId) {
            this.myThreadId = threadId;
        }
    }

    public static class ResultList<T> {
        @NotNull
        public final List<T> list;
        public final boolean hasMore;

        public ResultList(@NotNull List<T> list, boolean hasMore) {
            this.list = list;
            this.hasMore = hasMore;
        }

        @NotNull
        public static <T> ResultList<T> create(@NotNull List<T> list, boolean hasMore) {
            return new ResultList<T>(list, hasMore);
        }

        @NotNull
        public static <T> ResultList<T> empty() {
            return ResultList.create(Collections.emptyList(), false);
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static class StopPlace {
        @NotNull
        public final LLThread thread;
        @NotNull
        public final LLFrame frame;
        @Nullable
        public final LLValue returnValue;

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame) {
            this(thread, frame, null);
        }

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame, @Nullable LLValue returnValue) {
            this.thread = thread;
            this.frame = frame;
            this.returnValue = returnValue;
        }

        public String toString() {
            return this.thread + ": " + this.frame;
        }
    }

    public static class ExitStatus {
        public static final ExitStatus UNKNOWN = new ExitStatus(-1);
        public final int code;
        @Nullable
        public final String description;

        public ExitStatus(int code) {
            this(code, null);
        }

        public ExitStatus(int code, @Nullable String description) {
            this.code = code;
            this.description = description;
        }

        @NotNull
        public static ExitStatus fromSignal(int signalNumber) {
            int exitCode = 128 + signalNumber;
            return new ExitStatus(exitCode);
        }

        public String toString() {
            if (this == UNKNOWN) {
                return "UNKNOWN";
            }
            Object string = Integer.toString(this.code);
            if (this.description != null) {
                string = (String)string + this.description;
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExitStatus status = (ExitStatus)o;
            if (this == UNKNOWN || status == UNKNOWN) {
                return false;
            }
            return this.code == status.code && Objects.equals(this.description, status.description);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.description);
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift"),
        RUST("Rust"),
        FORTRAN("Fortran"),
        ADA("Ada"),
        COBOL("Cobol"),
        PASCAL("Pascal"),
        MODULA("Modula"),
        D("D"),
        OPENCL("OpenCL"),
        GO("Go"),
        HASKELL("Haskell"),
        OCAML("OCaml"),
        JAVA("Java"),
        KOTLIN("Kotlin");

        private final String myName;

        private StandardDebuggerLanguage(String name) {
            this.myName = name;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    public static class PathMapping {
        @NotNull
        public final String from;
        @NotNull
        public final String to;

        public PathMapping(@NotNull String from, @NotNull String to) {
            this.from = from;
            this.to = to;
        }
    }

    public abstract class Inferior {
        private final int myId;
        private final AtomicBoolean myIsRunning = new AtomicBoolean();

        public Inferior() {
            this(1);
        }

        public Inferior(int id) {
            this.myId = id;
        }

        public int getId() {
            return this.myId;
        }

        @NotNull
        public DebuggerDriver getDriver() {
            return DebuggerDriver.this;
        }

        public long start() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(false, true)) {
                throw new IllegalStateException("started already");
            }
            return this.startImpl();
        }

        public void detach() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return;
            }
            this.detachImpl();
        }

        public boolean destroy() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return false;
            }
            return this.destroyImpl();
        }

        protected abstract long startImpl() throws ExecutionException;

        protected abstract void detachImpl() throws ExecutionException;

        protected abstract boolean destroyImpl() throws ExecutionException;
    }

    public static class JumpToLineOutsideCurrentFunctionException
    extends DebuggerCommandException {
        public JumpToLineOutsideCurrentFunctionException(@NotNull String s) {
            super(s);
        }

        public JumpToLineOutsideCurrentFunctionException(@NotNull String s, Throwable throwable) {
            super(s, throwable);
        }
    }

    public static class ShellCommandResult {
        @NotNull
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }
    }
}

