/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.actions.AddWatchAsArrayAction;
import com.jetbrains.cidr.execution.debugger.actions.SetArraySizeInplaceEditor;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressInputComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/AddWatchAsArrayAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getWatchesView", "Lcom/intellij/xdebugger/impl/frame/XWatchesView;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "perform", "", "nodeName", "", "update", "intellij.cidr.debugger"})
public final class AddWatchAsArrayAction
extends XDebuggerTreeActionBase
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        XValue value = XDebuggerTreeActionBase.getSelectedValue((DataContext)e.getDataContext());
        boolean isFeatureEnabled = Registry.is((String)"cidr.debugger.value.showAsArray", (boolean)false);
        e.getPresentation().setVisible(value instanceof CidrPhysicalValue && isFeatureEnabled);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return false;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return false;
        }
        LLValueData data = value.getPreparedVarData();
        return data.isValidPointer();
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return;
        }
        String baseExpr = value.getEvaluationExpression();
        String baseExprDeref = GotoAddressInputComponent.Companion.dereference$intellij_cidr_debugger((XExpression)XExpressionImpl.fromText((String)baseExpr)).getExpression();
        XWatchesView xWatchesView = this.getWatchesView(e);
        if (xWatchesView == null) {
            return;
        }
        XWatchesView watchesView = xWatchesView;
        SetArraySizeInplaceEditor setArraySizeInplaceEditor2 = new SetArraySizeInplaceEditor(node, nodeName, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(baseExprDeref, watchesView){
            final /* synthetic */ String $baseExprDeref;
            final /* synthetic */ XWatchesView $watchesView;
            {
                this.$baseExprDeref = $baseExprDeref;
                this.$watchesView = $watchesView;
                super(1);
            }

            public final void invoke(@NotNull String size) {
                XExpressionImpl watchExpression = XExpressionImpl.fromText((String)(this.$baseExprDeref + " @ " + size));
                DebuggerUIUtil.invokeLater(() -> perform.setArraySizeInplaceEditor.1.invoke$lambda$0(this.$watchesView, watchExpression));
            }

            private static final void invoke$lambda$0(XWatchesView $watchesView, XExpressionImpl $watchExpression) {
                $watchesView.addWatchExpression((XExpression)$watchExpression, -1, true);
            }
        }));
        setArraySizeInplaceEditor2.show(CidrDebuggerBundle.message("debugger.variables.viewAsArray.enterSize.prompt", new Object[0]));
    }

    private final XWatchesView getWatchesView(AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSession session;
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project = e.getProject();
        if (view == null && project != null && (session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session).getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }
}

