/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ThrowInTest {
    public static void throwOn(@NotNull Object holder, @NotNull Key key, boolean userException) {
        ThrowInTest.throwOn(holder, key, userException ? TestDebuggerException::new : TestExecutionException::new);
    }

    public static void throwOn(@NotNull Object holder, @NotNull Key key, @NotNull Supplier<Throwable> throwableSupplier) {
        ((UserDataHolder)holder).putUserData(key, throwableSupplier);
    }

    public static void doThrow(@NotNull UserDataHolder holder, @NotNull Key key) throws ExecutionException, DebuggerCommandException {
        Supplier throwableSupplier = (Supplier)holder.getUserData(key);
        if (throwableSupplier == null) {
            return;
        }
        Throwable throwable = (Throwable)throwableSupplier.get();
        if (throwable instanceof ExecutionException) {
            throw (ExecutionException)throwable;
        }
        if (throwable instanceof DebuggerCommandException) {
            throw (DebuggerCommandException)throwable;
        }
        throw new TestRuntimeException(throwable);
    }

    private static class TestRuntimeException
    extends RuntimeException
    implements TestException {
        TestRuntimeException(@NotNull Throwable cause) {
            super("runtime exception", cause);
        }
    }

    private static class TestExecutionException
    extends ExecutionException
    implements TestException {
        TestExecutionException() {
            super(CidrDebuggerBundle.message("dialog.message.execution.exception", new Object[0]));
        }
    }

    private static class TestDebuggerException
    extends DebuggerCommandException
    implements TestException {
        TestDebuggerException() {
            super("user exception");
        }
    }

    public static interface TestException {
    }
}

