/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrOSProcessUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class NativeStacktraceProvider {
    @Nullable
    public String getNativeStacktrace(int pid) throws ExecutionException {
        String string;
        DebuggerController controller = new DebuggerController(pid);
        try {
            StringBuilder stacktraces = new StringBuilder();
            controller.attach();
            controller.interrupt();
            List<LLThread> threads = controller.getThreads();
            int counter = 0;
            for (LLThread thread : threads) {
                DebuggerDriver.ResultList<LLFrame> frames = controller.getFrames(thread, 0, 30);
                stacktraces.append("Thread ").append(++counter);
                stacktraces.append('\n');
                for (LLFrame frame : frames.list) {
                    stacktraces.append("[").append(frame.getProgramCounter()).append("] ").append(frame.getFunction()).append(" at ").append(frame.getFile()).append(":").append(frame.getIndex()).append('\n');
                }
                stacktraces.append('\n');
            }
            controller.resume();
            controller.detach();
            string = stacktraces.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    controller.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                throw new ExecutionException(thr);
            }
        }
        controller.close();
        return string;
    }

    private static final class DebuggerController
    implements AutoCloseable {
        private final int myPid;
        @NotNull
        private final MyDebuggerHandler myHandler;
        @NotNull
        private final DebuggerDriver myDriver;
        @Nullable
        private DebuggerDriver.Inferior myInferior = null;

        private DebuggerController(int pid) {
            this.myPid = pid;
            this.myHandler = new MyDebuggerHandler();
            this.myDriver = DebuggerController.createDriver(this.myHandler, pid);
        }

        void attach() throws Exception {
            assert (this.myInferior == null) : "Attaching twice?";
            this.myInferior = this.myDriver.loadForAttach(this.myPid);
            this.myInferior.start();
            this.myHandler.running.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void interrupt() throws Exception {
            this.myDriver.interrupt();
            this.myHandler.suspended.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void resume() throws Exception {
            this.myDriver.resume();
            this.myHandler.running.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void detach() throws Exception {
            assert (this.myInferior != null) : "Forgot to attach first?";
            this.myInferior.detach();
            this.myInferior = null;
            this.myHandler.detached.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        @NotNull
        public List<LLThread> getThreads() throws Exception {
            return this.myDriver.getThreads();
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count) throws Exception {
            return this.myDriver.getFrames(thread, from, count);
        }

        @Override
        public void close() throws ExecutionException {
            try {
                if (this.myInferior != null) {
                    if (this.myDriver.getState() == DebuggerDriver.TargetState.SUSPENDED) {
                        this.resume();
                    }
                    this.detach();
                }
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                throw new ExecutionException(thr);
            }
            finally {
                this.myDriver.getProcessHandler().destroyProcess();
            }
        }

        @NotNull
        private static DebuggerDriver createDriver(@NotNull MyDebuggerHandler handler, int pid) {
            ArchitectureType archType;
            DebuggerDriverConfiguration configuration = SystemInfoRt.isLinux ? new GDBDriverConfiguration(){} : new LLDBDriverConfiguration(){};
            try {
                archType = SystemInfoRt.isMac ? ArchitectureType.UNKNOWN : CidrOSProcessUtil.getProcessArchitectureType(pid);
            }
            catch (Throwable thr) {
                archType = ArchitectureType.UNKNOWN;
            }
            DebuggerDriver driver = null;
            try {
                driver = configuration.createDriver(handler, archType);
                driver.getProcessHandler().startNotify();
            }
            catch (Throwable thr) {
                if (driver != null) {
                    driver.getProcessHandler().destroyProcess();
                }
                ExceptionUtil.rethrow((Throwable)thr);
            }
            return driver;
        }

        private static class MyDebuggerHandler
        implements DebuggerDriver.Handler {
            @NotNull
            CompletableFuture<Object> attached = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> running = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> suspended = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> detached = new CompletableFuture();

            private MyDebuggerHandler() {
            }

            @Override
            public void handleAttached(int pid) {
                this.attached.complete(true);
            }

            @Override
            public void handleRunning() {
                this.running.complete(true);
            }

            @Override
            public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
                this.suspended.complete(true);
            }

            @Override
            public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
                this.suspended.complete(true);
            }

            @Override
            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                this.suspended.complete(true);
            }

            @Override
            public void handleDetached() {
                this.detached.complete(true);
            }

            void clear() {
                if (this.attached.isDone()) {
                    this.attached = new CompletableFuture();
                }
                if (this.running.isDone()) {
                    this.running = new CompletableFuture();
                }
                if (this.suspended.isDone()) {
                    this.suspended = new CompletableFuture();
                }
                if (this.detached.isDone()) {
                    this.detached = new CompletableFuture();
                }
            }
        }
    }
}

