/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSuspendContext
extends XSuspendContext {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final CidrExecutionStack myActiveStack;
    @NotNull
    private final Map<LLThread, CidrExecutionStack> myLoadedStacks = new HashMap<LLThread, CidrExecutionStack>();

    CidrSuspendContext(@NotNull CidrDebugProcess process, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable CidrSuspensionCause cause) {
        this.myProcess = process;
        this.myActiveStack = this.myProcess.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause, stopPlace.returnValue);
        this.myLoadedStacks.put(stopPlace.thread, this.myActiveStack);
    }

    @NotNull
    public CidrExecutionStack getActiveExecutionStack() {
        return this.myActiveStack;
    }

    @NotNull
    public CidrExecutionStack getOrCreateExecutionStack(@NotNull LLThread llThread) {
        return this.myLoadedStacks.computeIfAbsent(llThread, t -> this.myProcess.newExecutionStack((LLThread)t, null, false, null, null));
    }

    public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_THREAD_COLLECTION);
                List<LLThread> threads = driver.getThreads();
                ArrayList<CidrExecutionStack> stacks = new ArrayList<CidrExecutionStack>(threads.size());
                for (LLThread each : threads) {
                    stacks.add(this.getOrCreateExecutionStack(each));
                }
                container.addExecutionStack(stacks, true);
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }
}

