/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrLineGutterDraggableObject;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CidrLineGutterIconRenderer
extends GutterIconRenderer {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;

    CidrLineGutterIconRenderer(@NotNull CidrDebugProcess process, @NotNull LLThread thread) {
        this.myProcess = process;
        this.myThread = thread;
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Debugger.NextStatement;
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.LEFT;
    }

    @NotNull
    public String getTooltipText() {
        return CidrDebuggerBundle.message("debug.jumpToLine.tooltip", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CidrLineGutterIconRenderer renderer = (CidrLineGutterIconRenderer)((Object)o);
        return this.myThread.equals(renderer.myThread);
    }

    public int hashCode() {
        return Objects.hash(this.myThread) * 6827 + 4177;
    }

    public boolean isDumbAware() {
        return true;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @NotNull
    public GutterDraggableObject getDraggableObject() {
        return new CidrLineGutterDraggableObject(this.myProcess, this.myThread);
    }
}

