/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrLineGutterDraggableObject
implements GutterDraggableObject {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;

    CidrLineGutterDraggableObject(@NotNull CidrDebugProcess process, @NotNull LLThread thread) {
        this.myProcess = process;
        this.myThread = thread;
    }

    public boolean copy(int line, @Nullable VirtualFile file, int actionId) {
        if (file == null) {
            return false;
        }
        return this.myProcess.jumpToLine(this.myThread, file, line);
    }

    public Cursor getCursor(int line, VirtualFile file, int actionId) {
        this.updateCaretPosition(file, line);
        return super.getCursor(line, file, actionId);
    }

    private void updateCaretPosition(VirtualFile file, int line) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProcess.getProject()).getSelectedEditor(file);
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToLogicalPosition(new LogicalPosition(line, 0));
    }
}

