/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrLineGutterIconRenderer;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.StackFilteringContainer;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecutionStack
extends XExecutionStack {
    @NotNull
    protected final CidrDebugProcess myProcess;
    @NotNull
    protected final LLThread myThread;
    @Nullable
    private volatile CidrStackFrame myTopFrame;
    @Nullable
    protected final CidrSuspensionCause mySuspensionCause;
    @Nullable
    protected final LLValue myReturnValue;
    @NotNull
    private final CidrStackFramesCache myStackFramesCache = new CidrStackFramesCache();
    private boolean myBatchRequests = true;

    public CidrExecutionStack(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause suspensionCause, @Nullable LLValue returnValue) {
        super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
        this.myProcess = process;
        this.myThread = thread;
        this.mySuspensionCause = suspensionCause;
        this.myReturnValue = returnValue;
        this.myTopFrame = frame == null ? null : this.newFrame(frame);
    }

    @NotNull
    public LLThread getThread() {
        return this.myThread;
    }

    @Nullable
    public CidrStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    @Nullable
    public CidrSuspensionCause getSuspensionCause() {
        return this.mySuspensionCause;
    }

    public void renewTopFrame() {
        CidrStackFrame topFrame = this.myTopFrame;
        if (topFrame != null) {
            this.myTopFrame = this.newFrame(topFrame.getFrame());
        }
    }

    public void computeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        XExecutionStack.XStackFrameContainer proxyContainer;
        boolean filteringSupported = this.myProcess.isLibraryFrameFilterSupported();
        boolean filteringTurnedOff = XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames();
        Object object = proxyContainer = filteringSupported && !filteringTurnedOff ? new StackFilteringContainer(this.getTopFrame(), container) : container;
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(proxyContainer)) {
            return;
        }
        if (this.myBatchRequests) {
            this.doComputeStackFramesWithBatching(originalFrom, proxyContainer);
        } else {
            this.doComputeStackFrames(originalFrom, proxyContainer);
        }
    }

    private static void addStackFramesToContainer(@NotNull XExecutionStack.XStackFrameContainer container, @NotNull List<CidrStackFrame> frames, @Nullable XStackFrame toSelect, boolean hasMore) {
        if (container instanceof XStackFrameContainerEx) {
            ((XStackFrameContainerEx)container).addStackFrames(frames, toSelect, !hasMore);
        } else {
            container.addStackFrames(frames, !hasMore);
        }
    }

    private void doComputeStackFramesWithBatching(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                boolean repeat;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result2 = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                int currentBatchSize = 100;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    repeat = false;
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, currentBatchSize, currentFrom == 0);
                    CidrStackFrame top = this.myTopFrame;
                    result2.ensureCapacity(result2.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top != null) {
                                frame = top;
                            } else {
                                top = this.myTopFrame = this.newFrame((LLFrame)framesResult.list.get(i));
                                frame = this.myTopFrame;
                            }
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result2.add(frame);
                    }
                    hasMore = framesResult.hasMore;
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || (toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result2, CidrStackFrame::hasSourceFile)))) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                    currentFrom = framesResult.list.size();
                    currentBatchSize -= currentFrom;
                    repeat = true;
                } while (repeat);
                CidrExecutionStack.addStackFramesToContainer(container, result2, toSelect, hasMore);
                if (hasMore && !container.isObsolete()) {
                    this.doComputeStackFramesWithBatching(currentFrom + result2.size(), container);
                }
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result2 = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, 100, false);
                    CidrStackFrame top = this.myTopFrame;
                    result2.ensureCapacity(result2.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top == null) {
                                this.myTopFrame = top = this.newFrame((LLFrame)framesResult.list.get(i));
                            }
                            frame = top;
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result2.add(frame);
                    }
                    hasMore = framesResult.hasMore;
                    currentFrom = framesResult.list.size();
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame()) continue;
                    toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result2, CidrStackFrame::hasSourceFile)));
                } while (hasMore);
                CidrExecutionStack.addStackFramesToContainer(container, result2, toSelect, false);
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private boolean shouldSelectDisasmFrame() {
        return this.mySuspensionCause == null;
    }

    @NotNull
    protected CidrStackFrame newFrame(@NotNull LLFrame frame) {
        return new CidrStackFrame(this.myProcess, this.myThread, frame, this.mySuspensionCause, frame.getIndex() == 0 ? this.myReturnValue : null);
    }

    @Nullable
    public GutterIconRenderer getExecutionLineIconRenderer() {
        return this.myProcess.supportsJumpToLine() ? new CidrLineGutterIconRenderer(this.myProcess, this.myThread) : super.getExecutionLineIconRenderer();
    }

    public String toString() {
        return this.myThread.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CidrExecutionStack stack = (CidrExecutionStack)((Object)o);
        return this.myProcess.equals(stack.myProcess) && this.myThread.equals(stack.myThread);
    }

    public int hashCode() {
        return Objects.hash(this.myProcess, this.myThread);
    }

    public void setRequestsBatching(boolean enable) {
        this.myBatchRequests = enable;
    }

    private class CidrStackFramesCache {
        @NotNull
        private final List<LLFrame> myFrames = new ArrayList<LLFrame>();
        private boolean myHasMore = true;

        private CidrStackFramesCache() {
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull DebuggerDriver driver, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (!Registry.is((String)"cidr.debugger.cache.callstacks", (boolean)true)) {
                return driver.getFrames(CidrExecutionStack.this.myThread, from, count, untilFirstLineWithCode);
            }
            if (untilFirstLineWithCode) {
                this.cacheUntil(driver, from, false);
                if (this.myFrames.size() < from + count) {
                    for (int i = from; i < this.myFrames.size(); ++i) {
                        if (!this.myFrames.get(i).hasDebugInfo()) continue;
                        return this.createResult(from, this.myFrames.size());
                    }
                }
            }
            this.cacheUntil(driver, from + count, untilFirstLineWithCode);
            return this.createResult(from, Integer.min(from + count, this.myFrames.size()));
        }

        private void cacheUntil(@NotNull DebuggerDriver driver, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (!this.myHasMore) {
                return;
            }
            if (this.myFrames.size() >= count) {
                return;
            }
            DebuggerDriver.ResultList<LLFrame> result2 = driver.getFrames(CidrExecutionStack.this.myThread, this.myFrames.size(), count - this.myFrames.size(), untilFirstLineWithCode);
            this.myFrames.addAll(result2.list);
            this.myHasMore = result2.hasMore;
        }

        @NotNull
        private DebuggerDriver.ResultList<LLFrame> createResult(int from, int to) {
            return new DebuggerDriver.ResultList<LLFrame>(this.myFrames.subList(from, to), this.myHasMore || this.myFrames.size() > to);
        }
    }
}

