/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProfile;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerLanguageSupport {
    @Nullable
    public XDebuggerEditorsProvider createEditor(@Nullable RunProfile profile) {
        if (profile instanceof CidrDebugProfile || profile == null) {
            return this.createEditorProvider();
        }
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider createEditor(@NotNull Project project, @Nullable RunProfile profile) {
        return this.createEditor(profile);
    }

    @Nullable
    public XDebuggerEditorsProvider createEditor(@NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        return this.createEditorProvider();
    }

    @NotNull
    protected XDebuggerEditorsProvider createEditorProvider() {
        return new CidrDebuggerEditorsProvider();
    }

    @Deprecated
    @NotNull
    protected CidrDebuggerTypesHelper createTypesHelper(@NotNull CidrDebugProcess process) {
        return new CidrDebuggerTypesHelper(process);
    }

    @NotNull
    protected CidrDebuggerTypesHelperBase createDebuggerTypesHelper(@NotNull CidrDebugProcess process) {
        return this.createTypesHelper(process);
    }

    @Nullable
    protected CidrEvaluator createEvaluator(@NotNull CidrStackFrame frame) {
        return new CidrEvaluator(frame);
    }

    @NotNull
    protected CidrFrameTypeDecorator createFrameTypeDecorator(@NotNull CidrStackFrame frame) {
        return CidrFrameTypeDecorator.Default;
    }

    protected boolean useFrameLanguageFromDebugger(@Nullable RunProfile profile) {
        return true;
    }

    @NotNull
    public Set<DebuggerDriver.DebuggerLanguage> getSupportedDebuggerLanguages() {
        return Collections.emptySet();
    }
}

