/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerEditorsExtensionBase
implements CidrDebuggerEditorsExtension {
    @Override
    @Nullable
    public Document createDocument(@NotNull Project project, @NotNull String text, @NotNull XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        PsiElement context = this.getContext(project, sourcePosition);
        if (context == null) {
            return null;
        }
        return (Document)WriteAction.computeAndWait(() -> {
            PsiFile fragment = this.createExpressionCodeFragment(project, text, context, mode);
            return PsiDocumentManager.getInstance((Project)project).getDocument(fragment);
        });
    }

    @Nullable
    protected PsiElement getContext(@NotNull Project project, @NotNull XSourcePosition sourcePosition) {
        return XDebuggerUtil.getInstance().findContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project, false);
    }

    @NotNull
    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @NotNull PsiElement context, @NotNull EvaluationMode mode) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)text);
    }
}

