/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessListener;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSourceFileLocator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspendContext;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.features.RichValueDescriptionSupport;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.jetbrains.cidr.util.events.CidrEventTracerKt;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final String MEMORY_VIEW_CONTENT_ID = "DEBUGGER_MEMORY_VIEW";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key<Boolean> THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key<Boolean> THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private static final Topic<CidrDebugProcessListener> ourListenerTopic = new Topic("CidrDebugProcessListener events", CidrDebugProcessListener.class);
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final Disposable myProcessDisposable;
    private final CidrDebuggerCommandExecutor myDebuggerCommandExecutor;
    private final Disposable myUiDisposable;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    @NlsSafe
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final CidrAddressBreakpointHandler myAddressBreakpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore = new Semaphore(0);
    protected final ConsoleView myConsole;
    protected boolean showConsole = true;
    private final List<Filter> myBackendConsoleFilters;
    private final LanguageConsoleView myBackendConsole;
    @Nullable
    private final MemoryViewPanel myHexdumpViewPanel;
    @NotNull
    private final CidrDebuggerModuleMemory myMemory;
    protected final RunParameters myRunParameters;
    private final ConcurrentMap<String, CidrDebuggerTypesHelperBase> myTypesHelpers = new ConcurrentHashMap<String, CidrDebuggerTypesHelperBase>();
    private final List<Couple<File>> mySymbolFiles = new ArrayList<Couple<File>>();
    final ExecutionResult<DebuggerDriver.Inferior> myInferiorResult = new ExecutionResult();
    private volatile State myState = State.INITIALIZED;
    @Nls
    private volatile String myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
    @Nullable
    private volatile LLThread myCurrentThread;
    private final CidrSourceFileLocator mySourceFileLocator = new CidrSourceFileLocator(this);
    @NotNull
    private HexChangedHandler myHexChangedHandler;
    @NotNull
    private final Object mySymbolsDownloadTaskLock = new Object();
    @Nullable
    private SymbolsDownloadTask mySymbolsDownloadTask;

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws com.intellij.execution.ExecutionException {
        this(parameters, session, consoleBuilder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, final @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider) throws com.intellij.execution.ExecutionException {
        super(session);
        session.setPauseActionSupported(true);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRunParameters = parameters;
        this.myConfiguration = parameters.getDebuggerDriverConfiguration();
        this.myDriverName = this.myConfiguration.getDriverName();
        Disposable pluginDisposable = (Disposable)this.getProject().getService(CidrDebuggerPluginService.class);
        this.myProcessDisposable = Disposer.newDisposable((Disposable)pluginDisposable, (String)"CidrDebugProcess");
        this.myUiDisposable = Disposer.newDisposable();
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.getBackendConsoleTabName(), this.myConfiguration.getConsoleLanguage());
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, (Object)this);
        this.myBackendConsole.setEditable(false);
        this.myProcessHandler = new MyProcessHandler();
        this.myDriverDoNotUse = this.myConfiguration.createDriver(this, ArchitectureType.forArchitecture(parameters.getArchitectureId()));
        this.myDebuggerCommandExecutor = new CidrDebuggerCommandExecutor(this, this.myDriverDoNotUse, this.myProcessDisposable);
        final BaseProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        driverProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode = event.getExitCode();
                if (exitCode == 0) {
                    return;
                }
                if (exitCode == 143) {
                    return;
                }
                boolean isRemote = CidrDebugProcess.this.myConfiguration.getHostMachine().isRemote();
                if (isRemote && (exitCode == -1 || exitCode == 137)) {
                    return;
                }
                Platform platform = CidrDebugProcess.this.myConfiguration.getHostMachine().getOSType().toPlatform();
                String exitCodeStringified = ProcessTerminatedListener.stringifyExitCode((Platform)platform, (int)exitCode);
                if (SystemInfo.isLinux && exitCode == 127 || SystemInfo.isMac && exitCode == 134 || SystemInfo.isWindows && exitCode == -1073741515) {
                    String messageCrashed = CidrDebuggerBundle.message("debug.popup.error.crashed", exitCodeStringified);
                    String message = messageCrashed + " A library required by the native debugger might be missing on your system.";
                    if (SystemInfo.isLinux || SystemInfo.isMac) {
                        message = message + " See idea.log file for more details.";
                    }
                    CidrDebugProcess.this.getSession().reportMessage(message, MessageType.ERROR);
                    return;
                }
                String message = new HtmlBuilder().append(CidrDebuggerBundle.message("debug.popup.error.crashed", exitCodeStringified)).append(" ").appendLink("Restart", CidrDebugProcess.this.getRestartDebuggerMessage()).toString();
                CidrDebugProcess.this.getSession().reportMessage(message, MessageType.ERROR, new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        CidrDebugProcess.this.restartDebugger(session);
                    }
                });
            }
        });
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                driverProcessHandler.startNotify();
            }

            private boolean shouldDetach(boolean willBeDestroyed) {
                return !willBeDestroyed;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                CidrDebugProcess.this.myAttachedSemaphore.release();
                Alarm forceTerminateAlarm = new Alarm();
                CidrDebugProcess.this.postCommand(driver -> {
                    try {
                        CidrDebugProcess.this.doDisconnectTarget(CidrDebugProcess.this.myInferiorResult.get(), !this.shouldDetach(willBeDestroyed));
                    }
                    finally {
                        if (forceTerminateAlarm.cancelAllRequests() > 0) {
                            CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                        }
                    }
                    driver.checkErrors();
                });
                forceTerminateAlarm.addRequest(() -> {
                    CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                    CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                }, 3000L, ModalityState.any());
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = State.FINISHED;
                Disposer.dispose((Disposable)CidrDebugProcess.this.myProcessDisposable);
            }
        }, this.myProcessDisposable);
        this.myEditorsProvider = this.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myAddressBreakpointHandler = new CidrAddressBreakpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myAddressBreakpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = handlersList.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myConsole = consoleBuilder.getConsole();
        this.myBackendConsoleFilters = new SmartList((Object[])backendConsoleFilterProvider.getDefaultFilters(this.getProject()));
        this.myBackendConsoleFilters.forEach(arg_0 -> ((LanguageConsoleView)this.myBackendConsole).addMessageFilter(arg_0));
        this.myMemory = new CidrDebuggerModuleMemory(this, this.myUiDisposable);
        this.myHexdumpViewPanel = MemoryViewPanel.create(this.getProject(), (VirtualFile)this.myMemory.getHexdumpDoc().getVirtualFile());
        this.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                XSuspendContext suspendContext = session.getSuspendContext();
                if (suspendContext == null) {
                    return;
                }
                CidrStackFrame frame = (CidrStackFrame)((Object)ObjectUtils.tryCast((Object)session.getCurrentStackFrame(), CidrStackFrame.class));
                if (frame == null) {
                    return;
                }
                LLThread newSelectedThread = frame.getThread();
                CidrDebuggerLog.LOG.info("Current thread changed: " + newSelectedThread);
                CidrDebugProcess.this.myCurrentThread = newSelectedThread;
            }
        }, this.myProcessDisposable);
        MySuspensionGutterIconManager gutterIconManager = new MySuspensionGutterIconManager();
        Disposer.register((Disposable)this.myProcessDisposable, (Disposable)gutterIconManager);
        this.myHexChangedHandler = () -> this.getSession().rebuildViews();
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        settings.addHexFormattingSettingsListener(new CidrDebuggerSettings.SettingListener(){

            @Override
            public void settingChanged() {
                CidrDebugProcess.this.myHexChangedHandler.handleHexChanged();
            }
        }, this.myProcessDisposable);
        CidrDebuggerSettings.SettingListener rebuildViewsFunctor = () -> this.getSession().rebuildViews();
        settings.addMuteVariablesListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addValuesFilterEnabledListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addFrameDecorationSettingsListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addValuePresentationSettingsListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addShowFunctionReturnValueListener(rebuildViewsFunctor, this.myProcessDisposable);
        ((CidrDebugProcessListener)this.getProject().getMessageBus().syncPublisher(ourListenerTopic)).processCreated(this, ((XDebugSessionImpl)session).getExecutionEnvironment());
        Disposer.register((Disposable)this.myProcessDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = CidrDebugProcess.this.mySymbolsDownloadTaskLock;
                synchronized (object) {
                    if (CidrDebugProcess.this.mySymbolsDownloadTask != null) {
                        CidrDebugProcess.this.mySymbolsDownloadTask.setDone();
                        CidrDebugProcess.this.mySymbolsDownloadTask = null;
                    }
                }
            }
        });
    }

    protected void restartDebugger(@NotNull XDebugSession session) {
        XDebugSessionTab sessionTab = ((XDebugSessionImpl)session).getSessionTab();
        if (sessionTab == null || Disposer.isDisposed((Disposable)sessionTab)) {
            return;
        }
        RunContentDescriptor runContentDescriptor = sessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            return;
        }
        JComponent component = runContentDescriptor.getComponent();
        if (component == null) {
            return;
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)component);
        ExecutionEnvironment environment = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(context);
        if (environment == null) {
            return;
        }
        ExecutionUtil.restart((ExecutionEnvironment)environment);
    }

    @NlsContexts.LinkLabel
    @NotNull
    protected String getRestartDebuggerMessage() {
        return CidrDebuggerBundle.message("debug.popup.rerun", this.getSession().getSessionName());
    }

    @NotNull
    public Disposable getProcessDisposable() {
        return this.myProcessDisposable;
    }

    @NotNull
    public String getCurrentStateMessage() {
        return this.myCurrentStateMessage;
    }

    @NotNull
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private XDebuggerEditorsProvider createEditorsProvider(RunProfile profile) throws com.intellij.execution.ExecutionException {
        return CidrDebuggerLanguageSupportManager.getInstance().createEditor(this.getProject(), profile);
    }

    public boolean isDetachDefault() {
        return false;
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public boolean supportsJumpToLine() {
        return !((XDebugSessionImpl)this.getSession()).isReadOnly() && this.myDriverDoNotUse.supportsJumpToLine();
    }

    public boolean isRichValueDescriptionEnabled() {
        return this.getUserData(CidrValue.THREAT_VALUE_AS_RICH_TEXT) == Boolean.TRUE;
    }

    @NotNull
    public Project getProject() {
        return this.getSession().getProject();
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        return this.myConfiguration.createEvaluationContext(driver, expirable, frame.getThread(), frame.getFrame(), frame);
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    @TestOnly
    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    @TestOnly
    public DebuggerDriver.Inferior getInferiorInTests() {
        try {
            return this.myInferiorResult.get();
        }
        catch (com.intellij.execution.ExecutionException e) {
            return null;
        }
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStack(@NotNull XSuspendContext suspendContext, @NotNull XDebugSession session) {
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        CidrExecutionStack cidrExecutionStack = (CidrExecutionStack)((Object)ObjectUtils.tryCast((Object)activeExecutionStack, CidrExecutionStack.class));
        try {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(false);
            }
            super.logStack(suspendContext, session);
        }
        finally {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(true);
            }
        }
    }

    public void setHexChangedHandler(@NotNull HexChangedHandler handler) {
        this.myHexChangedHandler = handler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    @TestOnly
    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        CidrDebugProcess.registerTabCompletion((Editor)this.myBackendConsole.getConsoleEditor());
        this.postCommand((DebuggerDriver driver) -> {
            DebuggerDriver.Inferior inferior;
            try {
                inferior = this.doLoadTarget(driver);
                List<Couple<File>> list = this.mySymbolFiles;
                synchronized (list) {
                    for (Couple<File> file : this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file.first, (File)file.second);
                    }
                    this.mySymbolFiles.clear();
                }
                this.myState = State.STARTED;
            }
            catch (com.intellij.execution.ExecutionException e) {
                this.myInferiorResult.setException(e);
                throw e;
            }
            this.myInferiorResult.set(inferior);
        });
        for (CidrDebugProcessConfigurator configurator : (CidrDebugProcessConfigurator[])CidrDebugProcessConfigurator.EP_NAME.getExtensions()) {
            configurator.configure(this);
        }
    }

    protected static void registerTabCompletion(final Editor editor) {
        AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
        if (action == null) {
            return;
        }
        AnActionWrapper wrappedAction = new AnActionWrapper(action){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)editor);
                e.getPresentation().setEnabled(lookup == null || !lookup.isAvailableToUser());
            }
        };
        wrappedAction.registerCustomShortcutSet(9, 0, editor.getContentComponent());
    }

    @NotNull
    protected abstract DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException;

    @Nullable
    public MemoryViewPanel getHexdumpViewPanel() {
        return this.myHexdumpViewPanel;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                Content content = ui.createContent("ConsoleContent", console.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), null, console.getPreferredFocusableComponent());
                content.setCloseable(false);
                if (CidrDebugProcess.this.showConsole) {
                    ui.addContent(content, 1, PlaceInGrid.bottom, false);
                }
                return content;
            }

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myUiDisposable);
                Content backendConsoleContent = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.getBackendConsoleTabName(), AllIcons.Debugger.Console, CidrDebugProcess.this.myBackendConsole.getPreferredFocusableComponent());
                Disposer.register((Disposable)CidrDebugProcess.this.myUiDisposable, (Disposable)CidrDebugProcess.this.myBackendConsole);
                backendConsoleContent.setCloseable(false);
                this.addContent(ui, backendConsoleContent, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)CidrDebugProcess.this.myBackendConsole, text -> CidrDebugProcess.this.executeConsoleCommand((String)text), (String)"AppCode.Debug.Console", null, null);
                if (CidrDebugProcess.this.myHexdumpViewPanel != null) {
                    Content memoryViewContent = ui.createContent(CidrDebugProcess.MEMORY_VIEW_CONTENT_ID, CidrDebugProcess.this.myHexdumpViewPanel.getComponent(), CidrDebuggerBundle.message("debug.memory.view.process", new Object[0]), null, CidrDebugProcess.this.myHexdumpViewPanel.getPreferredFocusableComponent());
                    Disposer.register((Disposable)CidrDebugProcess.this.myUiDisposable, (Disposable)CidrDebugProcess.this.myHexdumpViewPanel);
                    memoryViewContent.setCloseable(false);
                    this.addContent(ui, memoryViewContent, false);
                }
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){
                    private CidrEventSpan myStateSpan;

                    public void sessionPaused() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker("debug", "session paused", null);
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        CidrEventTracerKt.traceMarker("debug", "session resumed");
                        this.traceState(new CidrEventSpan("debug", "session running", null, "<DebugSession>"));
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker("debug", "sessionStopped", null);
                        this.enableConsole(false);
                    }

                    private void enableConsole(boolean enabled) {
                        if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                            return;
                        }
                        CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                    }

                    private void traceState(@Nullable CidrEventSpan eventSpan) {
                        if (this.myStateSpan != null) {
                            this.myStateSpan.close();
                        }
                        this.myStateSpan = eventSpan;
                    }
                });
            }

            private void addContent(@NotNull RunnerLayoutUi ui, Content content, boolean defaultIsMinimized) {
                boolean newDebugWindowView;
                boolean bl = newDebugWindowView = Registry.is((String)"debugger.new.debug.tool.window.view") || UIExperiment.isNewDebuggerUIEnabled();
                if (newDebugWindowView) {
                    ui.addContent(content, -1, PlaceInGrid.center, defaultIsMinimized);
                } else {
                    ui.addContent(content, 0, PlaceInGrid.center, defaultIsMinimized);
                }
            }
        };
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @Nls
    @NotNull
    protected String getBackendConsoleTabName() {
        return this.myDriverName;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        return this.myConsole;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand((DebuggerDriver driver) -> {
            if (this.myState != State.STARTED) {
                return;
            }
            this.doStartTarget(this.myInferiorResult.get());
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
            this.getSession().rebuildViews();
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws com.intellij.execution.ExecutionException {
        return inferior.start();
    }

    protected void doDisconnectTarget(@NotNull DebuggerDriver.Inferior inferior, boolean shouldDestroy) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (shouldDestroy) {
            inferior.destroy();
        } else {
            inferior.detach();
        }
    }

    public void stop() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
            this.myAddressBreakpointHandler.cleanup();
        });
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(DebuggerDriver::interrupt);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.postCommand(DebuggerDriver::resume);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        Address address2 = this.positionToAddress(position);
        this.postCommand((DebuggerDriver driver) -> {
            if (address2 != null) {
                driver.runTo(address2);
            } else {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    public boolean jumpToLine(@NotNull LLThread thread, @NotNull VirtualFile file, int line) {
        XSuspendContext context = this.getSession().getSuspendContext();
        if (context == null) {
            return false;
        }
        this.jumpToLineImpl(thread, file, line, false, context).thenAccept(askToRetry -> {
            if (!askToRetry.booleanValue()) {
                return;
            }
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)CidrDebuggerBundle.message("debug.jumpToLine.warning", new Object[0])).icon(Messages.getWarningIcon());
                if (yesNo.ask(this.getProject())) {
                    XSuspendContext newContext = this.getSession().getSuspendContext();
                    if (newContext == null) {
                        return;
                    }
                    this.jumpToLineImpl(thread, file, line, true, newContext);
                }
            });
        });
        return true;
    }

    @NotNull
    private CompletableFuture<Boolean> jumpToLineImpl(@NotNull LLThread thread, @NotNull VirtualFile file, int line, boolean canLeaveFunction, @NotNull XSuspendContext context) {
        Address address2;
        String path = file.getPath();
        XSourcePosition position = XDebuggerUtil.getInstance().createPosition(file, line);
        Address address3 = address2 = position != null ? this.positionToAddress(position) : null;
        if (this.fileToMemoryDoc(file) != null && address2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.handleRunning();
        return this.postCommand((DebuggerDriver driver) -> {
            try {
                if (address2 != null) {
                    return driver.jumpToAddress(thread, address2, canLeaveFunction);
                }
                return driver.jumpToLine(thread, path, line, canLeaveFunction);
            }
            catch (DebuggerDriver.JumpToLineOutsideCurrentFunctionException ignored) {
                return null;
            }
            catch (DebuggerCommandException ex) {
                @NlsSafe String message = CidrDebugProcess.formatJumpToLineErrorMessageToHTML(ex.getMessage());
                this.getSession().reportMessage(message, MessageType.ERROR);
                throw ex;
            }
        }).handle((stopPlace, ex) -> {
            boolean askToRetry = false;
            if (ex != null) {
                this.getSession().positionReached(context);
            } else if (stopPlace == null) {
                this.getSession().positionReached(context);
                askToRetry = true;
            } else {
                this.handleInterrupted((DebuggerDriver.StopPlace)stopPlace);
            }
            return askToRetry;
        });
    }

    @NotNull
    @NlsSafe
    private static String formatJumpToLineErrorMessageToHTML(@NotNull String message) {
        @NlsSafe String shortMessage = CidrDebugProcess.stripJumpToLineErrorMessage(message);
        return HtmlChunk.text((String)shortMessage).toString();
    }

    @NotNull
    private static String stripJumpToLineErrorMessage(@NotNull String message) {
        int offset = (message = message.trim()).indexOf(10);
        if (offset == -1) {
            return message;
        }
        for (int i = 0; i < 5 && offset != -1; ++i) {
            offset = message.indexOf(10, offset + 1);
        }
        if (offset == -1) {
            return message;
        }
        return message.substring(0, offset + 1) + "\t...";
    }

    @Nullable
    private Address positionToAddress(@NotNull XSourcePosition position) {
        CidrMemoryDoc<?> memoryDoc = this.fileToMemoryDoc(position.getFile());
        return memoryDoc == null ? null : memoryDoc.getAddress(position);
    }

    @Nullable
    public CidrMemoryDoc<?> fileToMemoryDoc(@NotNull VirtualFile virtualFile) {
        if (!(virtualFile instanceof MemoryViewFile)) {
            return null;
        }
        MemoryViewFile memoryViewFile = (MemoryViewFile)virtualFile;
        CidrMemoryDoc<?> memoryDoc = memoryViewFile.getMemoryDoc();
        if (memoryDoc != null && !this.myMemory.contains(memoryDoc)) {
            return null;
        }
        return memoryDoc;
    }

    private static boolean isDisassemblyContext(@Nullable XSuspendContext context) {
        if (context == null) {
            return false;
        }
        XExecutionStack stack = context.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile();
    }

    protected boolean useLegacyStepping() {
        return Registry.is((String)"cidr.debugger.stepping.legacyStepping", (boolean)false);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        if (this.useLegacyStepping()) {
            this.postCommand((DebuggerDriver driver) -> driver.stepOver(stepByInstruction));
            return;
        }
        LLThread currentThread = this.myCurrentThread;
        if (currentThread == null) {
            CidrDebuggerLog.LOG.error("No current thread, can't step over");
            return;
        }
        this.postCommand((DebuggerDriver driver) -> driver.stepOver(currentThread, stepByInstruction));
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        if (this.useLegacyStepping()) {
            this.postCommand((DebuggerDriver driver) -> driver.stepInto(false, stepByInstruction));
            return;
        }
        LLThread currentThread = this.myCurrentThread;
        if (currentThread == null) {
            CidrDebuggerLog.LOG.error("No current thread, can't step into");
            return;
        }
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(currentThread, false, stepByInstruction));
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        if (this.useLegacyStepping()) {
            this.postCommand((DebuggerDriver driver) -> driver.stepInto(true, stepByInstruction));
            return;
        }
        LLThread currentThread = this.myCurrentThread;
        if (currentThread == null) {
            CidrDebuggerLog.LOG.error("No current thread, can't force step into");
            return;
        }
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(currentThread, true, stepByInstruction));
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        boolean stopInFramesWithoutDebugInfo = CidrDebugProcess.isDisassemblyContext(context);
        if (this.useLegacyStepping()) {
            this.postCommand((DebuggerDriver driver) -> driver.stepOut(stopInFramesWithoutDebugInfo));
            return;
        }
        LLThread currentThread = this.myCurrentThread;
        if (currentThread == null) {
            CidrDebuggerLog.LOG.error("No current thread, can't step out");
            return;
        }
        this.postCommand((DebuggerDriver driver) -> driver.stepOut(currentThread, stopInFramesWithoutDebugInfo));
    }

    @NotNull
    public Pair<XSourcePosition, Boolean> createSourceOrDisasmPosition(@Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address pc) {
        XSourcePosition sourcePosition;
        if (file != null && (sourcePosition = this.createSourcePosition(file, hash, line)) != null) {
            return Pair.create((Object)sourcePosition, (Object)true);
        }
        return Pair.create((Object)this.createDisasmPosition(pc), (Object)false);
    }

    @Nullable
    public XSourcePosition createSourcePosition(@NotNull String file, @Nullable DebuggerSourceFileHash hash, int line) {
        try {
            VirtualFile resolvedFile = this.resolveFile(file, hash);
            return resolvedFile != null ? XDebuggerUtil.getInstance().createPosition(resolvedFile, line) : null;
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
    }

    @Nullable
    public VirtualFile resolveFile(@NotNull String file, @Nullable DebuggerSourceFileHash hash) {
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile vFile = this.mySourceFileLocator.locate(file, hash);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = (VirtualFile)SlowOperations.allowSlowOperations(() -> ProjectRootUtil.findSymlinkedFileInContent((Project)this.getProject(), (VirtualFile)vFile));
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address2) {
        return this.myMemory.getDisasmDoc().getAddressPosition(address2);
    }

    protected void executeConsoleCommand(@NotNull String text) {
        long threadId = this.getCurrentThreadId();
        int frameIndex = this.getCurrentFrameIndex();
        this.postCommand((DebuggerDriver driver) -> {
            RichValueDescriptionSupport richValueDescriptionSupport = this.isRichValueDescriptionEnabled() ? (RichValueDescriptionSupport)ObjectUtils.tryCast((Object)driver, RichValueDescriptionSupport.class) : null;
            try {
                if (richValueDescriptionSupport != null) {
                    richValueDescriptionSupport.setRichValueDescriptionEnabled(false);
                }
                driver.executeInterpreterCommand(threadId, frameIndex, text);
            }
            catch (DebuggerCommandException e) {
                this.printlnToConsole(e.getMessage());
            }
            finally {
                if (richValueDescriptionSupport != null) {
                    richValueDescriptionSupport.setRichValueDescriptionEnabled(true);
                }
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command) {
        return this.postCommand((DebuggerCommand)command);
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command, boolean useAlternativeDispatcher) {
        return this.postCommand((DebuggerCommand)command, useAlternativeDispatcher);
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command) {
        return this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning(), false);
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command, boolean useAlternativeDispatcher) {
        return this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning(), useAlternativeDispatcher);
    }

    @NotNull
    public CidrDebuggerCommandExecutor getDebuggerCommandExecutor() {
        return this.myDebuggerCommandExecutor;
    }

    public void completeConsoleCommand(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        String command = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        DebuggerDriver.ResultList<String> completions = this.completeConsoleCommand(command, offset, progressIndicator);
        if (!completions.list.isEmpty()) {
            if (completions.hasMore && completions.list.size() > 1) {
                result2.addLookupAdvertisement(CidrDebuggerBundle.message("debug.console.completions.tooManyCompletions", completions.list.size()));
            }
            result2.addAllElements((Iterable)ContainerUtil.map(completions.list, lookupString -> LookupElementBuilder.create((String)(lookupString + " "))));
        }
    }

    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int offset, @NotNull ProgressIndicator progressIndicator) {
        CompletableFuture completionFuture = this.postCommand((DebuggerDriver driver) -> {
            if (driver.isInPromptMode()) {
                return DebuggerDriver.ResultList.empty();
            }
            return driver.completeConsoleCommand(command, offset);
        });
        try {
            return (DebuggerDriver.ResultList)ApplicationUtil.runWithCheckCanceled(completionFuture, (ProgressIndicator)progressIndicator);
        }
        catch (ExecutionException e) {
            return DebuggerDriver.ResultList.empty();
        }
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        if (position == null) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            CidrDebuggerTypesHelperBase typesHelper = this.getTypesHelper(position);
            if (!(typesHelper instanceof CidrDebuggerTypesHelper)) {
                return null;
            }
            return ((CidrDebuggerTypesHelper)typesHelper).getContextElement(position);
        });
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull CidrStackFrame frame) {
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(frame));
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull XSourcePosition position) {
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(position));
    }

    @NotNull
    private CidrDebuggerTypesHelperBase getTypesHelper(@Nullable Language language) {
        Language key = language == null ? Language.ANY : language;
        return this.myTypesHelpers.computeIfAbsent(key.getID(), langId -> CidrDebuggerLanguageSupportManager.getInstance().createTypesHelper(language, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + this.myState));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        return this.myRunParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand<?> command, @NotNull com.intellij.execution.ExecutionException exception) {
        DebuggerIllegalStateException illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class));
        if (illegalState != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            if (this.myConfiguration.getHostMachine().getOSType() == OSType.LINUX && exception.getMessage().contains("ptrace: Operation not permitted")) {
                this.printlnToConsole(CidrDebuggerBundle.message("debug.command.error.checkPermissionsMessage", new Object[0]));
            }
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            if (!this.reportEvaluationTimeOutError(exception)) {
                this.reportErrorInRedBalloon(exception);
            }
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(com.intellij.execution.ExecutionException e) {
        DebuggerCommandException dce = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
        String message = (dce != null ? dce : e).getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    private boolean reportEvaluationTimeOutError(@NotNull com.intellij.execution.ExecutionException e) {
        DebuggerEvaluationTimedOutException evaluationTimedOutException = (DebuggerEvaluationTimedOutException)((Object)ExceptionUtil.findCause((Throwable)e, DebuggerEvaluationTimedOutException.class));
        if (evaluationTimedOutException == null) {
            return false;
        }
        String message = CidrDebuggerBundle.message("debug.command.error.evaluationTimedOut", evaluationTimedOutException.getExpression(), CidrDebuggerBundle.message("debug.settings.enableValueRenderers.action", new Object[0]));
        this.getSession().reportMessage(message, MessageType.ERROR, eventType -> {
            if (eventType.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                CidrDebuggerSettings.getInstance().setRenderersEnabled(false);
            }
        });
        return true;
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = (String)message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable((String)message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleRunning() {
        this.getSession().sessionResumed();
        this.myCurrentThread = null;
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        this.myCurrentThread = stopPlace.thread;
        this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(this, stopPlace, null));
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.myCurrentThread = stopPlace.thread;
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.suspension.cause", new Object[0]), signal + " (" + meaning + ")", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter()));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        this.myCurrentThread = stopPlace.thread;
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.exception.cause", new Object[0]), description, exceptionFile, exceptionHash, exceptionLine, exceptionAddress));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        this.printlnToConsole(cause.getDisplayString());
        ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)new CidrSuspendContext(this, stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        this.myCurrentThread = stopPlace.thread;
        Object b = this.myBreakpointHandler.getXBreakpoint(breakpointNumber);
        if (b == null) {
            b = this.myAddressBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        this.myCurrentThread = stopPlace.thread;
        Object b = this.myWatchpointHandler.getXBreakpoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.exception.cause", new Object[0]), "Exception breakpoint", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter());
        }
        CidrSuspendContext suspendContext = new CidrSuspendContext(this, stopPlace, cause);
        if (b == null) {
            ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)suspendContext, true);
            return;
        }
        XExpression expressionObject = b.getLogExpressionObject();
        if (expressionObject == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
            return;
        }
        String expression = expressionObject.getExpression();
        this.postCommand((DebuggerDriver driver) -> {
            String evaluatedLogExpression;
            CidrExecutionStack executionStack = suspendContext.getActiveExecutionStack();
            XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
            XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
            CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
            if (evaluator != null) {
                try {
                    CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, (XExpression)XExpressionImpl.fromText((String)expression));
                    evaluatedLogExpression = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                }
                catch (DebuggerCommandException e) {
                    evaluatedLogExpression = "error evaluating " + expression + ": " + e.getMessage();
                }
            } else {
                evaluatedLogExpression = "error evaluating " + expression;
            }
            return evaluatedLogExpression;
        }).whenComplete((evaluatedLogExpression, e) -> {
            Object expressionString = null;
            if (evaluatedLogExpression != null) {
                expressionString = evaluatedLogExpression;
            } else if (e != null) {
                expressionString = "error evaluating " + expression + ": " + e.getMessage();
            }
            boolean shouldSuspend = this.getSession().breakpointReached(b, (String)expressionString, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        ConsoleViewContentType contentType = ProcessOutputType.isStdout((Key)type) ? ConsoleViewContentType.NORMAL_OUTPUT : (ProcessOutputType.isStderr((Key)type) ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> this.myBackendConsole.print(text, contentType));
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        LanguageConsoleView backendConsole = this.getDebuggerConsole();
        if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
            return;
        }
        backendConsole.setPrompt(prompt);
    }

    @Override
    public void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
        if (exitStatus != DebuggerDriver.ExitStatus.UNKNOWN) {
            this.myProcessHandler.setExitCode(exitStatus.code);
            if (exitStatus.description != null) {
                this.myProcessHandler.notifyTextAvailable(exitStatus.description + "\n", ProcessOutputTypes.SYSTEM);
            }
        } else {
            this.myProcessHandler.setExitCode(-1);
        }
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber));
        this.postCommand(DebuggerDriver::resume);
    }

    @Override
    public void handleModulesLoaded(@NotNull List<LLModule> modules) {
    }

    @Override
    public void handleModulesUnloaded(@NotNull List<LLModule> modules) {
    }

    @Override
    public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        this.myBreakpointHandler.handleBreakpointAdded(breakpoint);
        this.myAddressBreakpointHandler.handleBreakpointAdded(breakpoint);
    }

    @Override
    public void handleBreakpointRemoved(int breakpointId) {
        this.myBreakpointHandler.handleBreakpointRemoved(breakpointId);
        this.myAddressBreakpointHandler.handleBreakpointRemoved(breakpointId);
    }

    @Override
    public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        this.myBreakpointHandler.handleBreakpointUpdated(breakpoint.getId(), breakpoint);
        this.myAddressBreakpointHandler.handleBreakpointUpdated(breakpoint.getId(), breakpoint);
    }

    @Override
    public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        this.myBreakpointHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
        this.myAddressBreakpointHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
    }

    @Override
    public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        this.myBreakpointHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
        this.myAddressBreakpointHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
    }

    @Override
    public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        this.myBreakpointHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
        this.myAddressBreakpointHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
    }

    @Override
    public void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
        CidrSuspendContext suspendContext = (CidrSuspendContext)((Object)ObjectUtils.tryCast((Object)this.getSession().getSuspendContext(), CidrSuspendContext.class));
        if (suspendContext == null) {
            return;
        }
        CidrExecutionStack newStack = suspendContext.getOrCreateExecutionStack(thread);
        CidrStackFrame newFrame = newStack.newFrame(frame);
        boolean isTopFrame = frame.getIndex() == 0;
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.getSession().setCurrentStackFrame((XExecutionStack)newStack, (XStackFrame)newFrame, isTopFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadStarted(@NotNull @NlsContexts.ProgressText String caption, @NotNull String details) {
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask != null) {
                this.mySymbolsDownloadTask.setDone();
            }
            this.mySymbolsDownloadTask = new SymbolsDownloadTask(caption, details);
            this.mySymbolsDownloadTask.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadProgress(int percent) {
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask == null) {
                return;
            }
            this.mySymbolsDownloadTask.setPercent(percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadFinished() {
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask == null) {
                return;
            }
            this.mySymbolsDownloadTask.setDone();
            this.mySymbolsDownloadTask = null;
        }
    }

    @NotNull
    public CidrSourceFileLocator getSourceFileLocator() {
        return this.mySourceFileLocator;
    }

    @NotNull
    public CidrExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause, @Nullable LLValue returnValue) {
        return new CidrExecutionStack(this, thread, frame, current, cause, returnValue);
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED;

    }

    private class MyProcessHandler
    extends ProcessHandler {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            return exitCode == null ? 0 : exitCode;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach) {
            ProcessIOExecutorService.INSTANCE.execute(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (x$0, x$1) -> super.notifyTextAvailable(x$0, x$1));
        }
    }

    private class MySuspensionGutterIconManager
    implements XDebugSessionListener,
    XDebuggerManagerListener,
    Disposable {
        @NotNull
        private final XDebugSession mySession;
        @NotNull
        private final ExecutionPointHighlighter myExecutionPointHighlighter;

        MySuspensionGutterIconManager() {
            Project project = CidrDebugProcess.this.getProject();
            this.mySession = CidrDebugProcess.this.getSession();
            this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
            this.mySession.addSessionListener((XDebugSessionListener)this, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(XDebuggerManager.TOPIC, (Object)this);
        }

        public void dispose() {
            this.hide();
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
            this.update();
        }

        public void sessionStopped() {
            this.update();
        }

        public void stackFrameChanged() {
            this.update();
        }

        public void settingsChanged() {
            this.update();
        }

        public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
            this.update();
        }

        private void hide() {
            this.myExecutionPointHighlighter.hide();
        }

        private void update() {
            this.hide();
            if (XDebuggerManager.getInstance((Project)this.mySession.getProject()).getCurrentSession() != this.mySession) {
                return;
            }
            @Nullable XSuspendContext suspendContext = this.mySession.getSuspendContext();
            if (suspendContext == null) {
                return;
            }
            @Nullable XExecutionStack suspendExecutionStack = suspendContext.getActiveExecutionStack();
            if (!(suspendExecutionStack instanceof CidrExecutionStack)) {
                return;
            }
            @Nullable CidrSuspensionCause suspensionCause = ((CidrExecutionStack)suspendExecutionStack).getSuspensionCause();
            if (suspensionCause == null) {
                return;
            }
            @Nullable XSourcePosition position = (XSourcePosition)CidrDebugProcess.this.createSourceOrDisasmPosition((String)suspensionCause.file, (DebuggerSourceFileHash)suspensionCause.hash, (int)suspensionCause.line, (Address)suspensionCause.address).first;
            if (position == null) {
                return;
            }
            @Nullable XStackFrame suspendFrame = suspendExecutionStack.getTopFrame();
            if (suspendFrame == null || this.mySession.getCurrentStackFrame() != suspendFrame) {
                return;
            }
            this.myExecutionPointHighlighter.show(position, suspendFrame.getSourcePosition() != position, (GutterIconRenderer)new MySuspensionGutterIconRenderer(suspensionCause));
        }
    }

    @FunctionalInterface
    public static interface HexChangedHandler {
        public void handleHexChanged();
    }

    public static interface DebuggerStartupCommand
    extends VoidDebuggerCommand {
    }

    @FunctionalInterface
    public static interface VoidDebuggerCommand
    extends DebuggerCommand<Void> {
        public void run(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @Override
        default public Void call(@NotNull DebuggerDriver driver) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            this.run(driver);
            return null;
        }
    }

    @FunctionalInterface
    public static interface DebuggerCommand<R> {
        public R call(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        default public boolean canExecuteWhileRunning() {
            return true;
        }
    }

    @FunctionalInterface
    public static interface SuspendedDebuggerCommand<R>
    extends DebuggerCommand<R> {
        @Override
        default public boolean canExecuteWhileRunning() {
            return false;
        }
    }

    public static interface DebuggerUIUpdateCommand
    extends VoidDebuggerCommand,
    SuspendedDebuggerCommand<Void> {
    }

    private class SymbolsDownloadTask
    extends Task.Backgroundable {
        private static final long TIMEOUT_MS = 100L;
        @NotNull
        private final @NlsContexts.ProgressText String myCaption;
        @NotNull
        private final String myDetails;
        private int myPercent;
        private boolean myDone;

        SymbolsDownloadTask(@NotNull String caption, String details) {
            super(CidrDebugProcess.this.getProject(), CidrDebuggerBundle.message("progress.title.downloading.symbols", new Object[0]), true);
            this.myPercent = 0;
            this.myDone = false;
            this.myCaption = caption;
            this.myDetails = details;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setText(this.myCaption);
            indicator.setIndeterminate(false);
            try {
                SymbolsDownloadTask symbolsDownloadTask = this;
                synchronized (symbolsDownloadTask) {
                    while (!this.myDone) {
                        if (indicator.isCanceled()) {
                            CidrDebugProcess.this.postCommand(driver -> driver.cancelSymbolsDownload(this.myDetails), true);
                            break;
                        }
                        indicator.setFraction((double)this.myPercent / 100.0);
                        ((Object)((Object)this)).wait(100L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void setPercent(int percent) {
            this.myPercent = percent;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void setDone() {
            this.myDone = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    private static final class MySuspensionGutterIconRenderer
    extends GutterIconRenderer {
        @NotNull
        private final CidrSuspensionCause mySuspensionCause;

        private MySuspensionGutterIconRenderer(@NotNull CidrSuspensionCause suspensionCause) {
            this.mySuspensionCause = suspensionCause;
        }

        @NotNull
        public Icon getIcon() {
            return this.mySuspensionCause.icon;
        }

        @NotNull
        public String getTooltipText() {
            return this.mySuspensionCause.getDisplayString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MySuspensionGutterIconRenderer renderer = (MySuspensionGutterIconRenderer)((Object)o);
            return this.mySuspensionCause.equals(renderer.mySuspensionCause);
        }

        public int hashCode() {
            return Objects.hash(this.mySuspensionCause);
        }

        public boolean isDumbAware() {
            return true;
        }
    }
}

