/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessOutputReaders {
    private final AtomicReference<MyOutputReader[]> myReaders = new AtomicReference<MyOutputReader[]>(new MyOutputReader[2]);
    private final String myPresentableName;
    private final Charset myCharset;

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        this.myPresentableName = presentableName;
        this.myCharset = charset;
        OSType osType = host.getOSType();
        try {
            MyOutputReader[] readers = this.getReaders();
            if (osType == OSType.WIN) {
                readers[0] = new MyWinPipeOutputReader(ProcessOutputTypes.STDOUT);
                readers[1] = new MyWinPipeOutputReader(ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix && host.isRemote()) {
                readers[0] = new MyRemoteUnixPipeOutputReader(host.openNamedPipe(), ProcessOutputTypes.STDOUT);
                readers[1] = new MyRemoteUnixPipeOutputReader(host.openNamedPipe(), ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix) {
                readers[0] = new MyUnixPtyOutputReader(ProcessOutputTypes.STDOUT);
                readers[1] = new MyUnixPtyOutputReader(ProcessOutputTypes.STDERR);
            } else {
                readers[0] = new MyFileOutputReader(ProcessOutputTypes.STDOUT);
                readers[1] = new MyFileOutputReader(ProcessOutputTypes.STDERR);
            }
            readers[0].start();
            readers[1].start();
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create output file", (Throwable)e);
        }
    }

    public String getOutFileAbsolutePath() throws ExecutionException {
        return this.getReader(0).getFileAbsolutePath();
    }

    public String getErrFileAbsolutePath() throws ExecutionException {
        return this.getReader(1).getFileAbsolutePath();
    }

    protected MyOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    protected MyOutputReader getReader(int num) throws ExecutionException {
        MyOutputReader[] readers = this.getReaders();
        if (ArrayUtil.isEmpty((Object[])readers)) {
            throw new ExecutionException("Reader is closed");
        }
        return readers[num];
    }

    protected boolean doWaitFor(MyOutputReader[] readers) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
        }
        return true;
    }

    protected boolean doWaitFor(MyOutputReader[] readers, long timeout, TimeUnit unit) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor() {
        return this.doWaitFor(this.getReaders());
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        MyOutputReader[] readers;
        for (MyOutputReader each : readers = this.myReaders.getAndSet(new MyOutputReader[0])) {
            each.stop();
        }
        this.doWaitFor(readers);
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key var2);

    protected class MyOutputReader
    extends BaseOutputReader {
        @NotNull
        private final Key myType;
        @NotNull
        private final String myFileAbsolutePath;

        protected MyOutputReader(@NotNull Key type, @NotNull String fileAbsolutePath, InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            super(stream, ProcessOutputReaders.this.myCharset, (BaseOutputReader.Options)new ReaderOptions(sleepingPolicy));
            this.myType = type;
            this.myFileAbsolutePath = fileAbsolutePath;
        }

        public void start() {
            this.start(ProcessOutputReaders.this.myPresentableName);
        }

        protected void onTextAvailable(@NotNull String text) {
            text = StringUtil.trimEnd((String)text, (String)"\r");
            text = StringUtil.convertLineSeparators((String)text);
            ProcessOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }

        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        CidrLogService.LOG.error((Throwable)e);
                    }
                }
            }
        }

        @NotNull
        public String getFileAbsolutePath() {
            return this.myFileAbsolutePath;
        }
    }

    protected class MyWinPipeOutputReader
    extends MyOutputReader {
        @NotNull
        private final WinPipe myPipe;

        protected MyWinPipeOutputReader(Key type) throws IOException {
            this(WinPipe.createInboundPipe(type.toString()), type);
        }

        protected MyWinPipeOutputReader(@NotNull WinPipe pipe, Key type) {
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
            this.myPipe = pipe;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.myPipe.close();
            }
        }

        protected void doRun() {
            try {
                if (!this.myPipe.waitForConnection()) {
                    CidrLogService.LOG.error(String.format("Stream reading can't be initiated: couldn't connect to pipe %s. ", this.myPipe.getName()));
                    return;
                }
            }
            catch (IOException e) {
                CidrLogService.LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException eClose) {
                    CidrLogService.LOG.error("Can't close stream", (Throwable)eClose);
                }
                return;
            }
            super.doRun();
        }
    }

    protected class MyRemoteUnixPipeOutputReader
    extends MyOutputReader {
        protected MyRemoteUnixPipeOutputReader(@NotNull NamedPipe pipe, Key type) throws IOException {
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }
    }

    protected class MyUnixPtyOutputReader
    extends MyOutputReader {
        protected MyUnixPtyOutputReader(Key type) throws IOException {
            this(new Pty(true), type);
        }

        protected MyUnixPtyOutputReader(@NotNull Pty pty, Key type) {
            super(type, pty.getSlaveName(), (InputStream)pty.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }
    }

    protected class MyFileOutputReader
    extends MyOutputReader {
        @NotNull
        private final File myFileToDelete;

        protected MyFileOutputReader(Key type) throws IOException {
            this(FileUtil.createTempFile((String)this$0.getClass().getSimpleName(), (String)type.toString(), (boolean)true), type);
        }

        protected MyFileOutputReader(@NotNull File file, Key type) throws IOException {
            super(type, file.getAbsolutePath(), new FileInputStream(file), BaseDataReader.SleepingPolicy.NON_BLOCKING);
            this.myFileToDelete = file;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FileUtil.delete((File)this.myFileToDelete);
            }
        }
    }

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean withSeparators() {
            return true;
        }

        public boolean splitToLines() {
            return false;
        }

        public boolean sendIncompleteLines() {
            return true;
        }
    }
}

