/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ExecutionResult<T> {
    @NotNull
    private final CompletableFuture<T> myResult;

    public ExecutionResult() {
        this(new CompletableFuture());
    }

    private ExecutionResult(@NotNull CompletableFuture<T> result2) {
        this.myResult = result2;
    }

    public void set(@Nullable T result2) {
        if (!this.myResult.complete(result2)) {
            throw new IllegalStateException("Result is already set");
        }
    }

    public void setException(Throwable e) {
        if (!this.myResult.completeExceptionally(e)) {
            throw new IllegalStateException("Result is already set");
        }
    }

    public boolean isDone() {
        return this.myResult.isDone();
    }

    public T get() throws ExecutionException {
        return ExecutionResult.get(this.myResult);
    }

    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return ExecutionResult.get(this.myResult, timeout, unit);
    }

    public static <T> T get(@NotNull Future<T> future) throws ExecutionException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(CidrDebuggerBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw new ExecutionException(e.getMessage(), e.getCause());
        }
    }

    public static <T> T get(@NotNull Future<T> future, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(CidrDebuggerBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw new ExecutionException(e.getMessage(), e.getCause());
        }
    }

    @NotNull
    public CompletableFuture<T> asCompletableFuture() {
        return this.myResult;
    }

    @NotNull
    public static <T> ExecutionResult<T> fromCompletableFuture(@NotNull CompletableFuture<T> future) {
        return new ExecutionResult<T>(future);
    }

    @NotNull
    public static <T> ExecutionResult<T> fromPromise(@NotNull Promise<T> promise) {
        ExecutionResult<T> result2 = new ExecutionResult<T>();
        promise.onSuccess(result2::set).onError(result2::setException);
        return result2;
    }
}

