/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunProcessUtil {
    public static final int READ_VERSION_TIMEOUT = 10000;

    @NotNull
    public static ProcessOutput runProcess(@NotNull BaseProcessHandler<?> handler, @Nullable ProgressIndicator indicator, int timeout) {
        return CidrRunProcessUtil.runProcess(handler, indicator, timeout);
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull ProcessHandler handler, @Nullable ProgressIndicator indicator, int timeout) {
        return CidrRunProcessUtil.runProcess(new CapturingProcessRunner(handler), indicator, timeout);
    }

    private static ProcessOutput runProcess(@NotNull CapturingProcessRunner runner, @Nullable ProgressIndicator indicator, int timeout) {
        return indicator == null ? runner.runProcess(timeout) : runner.runProcess(indicator, timeout);
    }

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrRunProcessUtil.runWithProgress(handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler<?> handler, int timeout) {
        return CidrRunProcessUtil.runWithProgress(handler, timeout);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull ProcessHandler handler, int timeout) {
        ProgressIndicator indicator = CidrRunProcessUtil.getProgressIndicator();
        ProcessOutput result2 = CidrRunProcessUtil.runProcess(handler, indicator, timeout);
        if (result2.isCancelled()) {
            throw new ProcessCanceledException();
        }
        return result2;
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        try {
            ProcessOutput output = CidrRunProcessUtil.runWithProgress(new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }
}

