/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    private static final Logger LOG = Logger.getInstance(ResourceUtil.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readResourceFromFile(@NotNull Class<?> resourceContainerClass, @NonNls @NotNull String filePath) {
        try (InputStream stream = resourceContainerClass.getClassLoader().getResourceAsStream(filePath);){
            String string;
            block16: {
                LineNumberReader lineNumberReader = stream == null ? null : new LineNumberReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    String line;
                    if (stream == null) {
                        throw new IOException("Resource not found: " + filePath);
                    }
                    StringBuilder result2 = new StringBuilder();
                    while ((line = lineNumberReader.readLine()) != null) {
                        result2.append(line);
                        result2.append("\n");
                    }
                    string = result2.toString();
                    if (lineNumberReader == null) break block16;
                }
                catch (Throwable throwable) {
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lineNumberReader.close();
            }
            return string;
        }
        catch (IOException e) {
            LOG.error("Cannot load resource from" + filePath, (Throwable)e);
            return "";
        }
    }
}

