/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="toString()", childrenArray="toArray()", hasChildren="!guaranteedToBeEmpty()")
public abstract class PathTreeBase<Self extends PathTreeBase<Self>> {
    @Nullable
    protected Map<String, Self> myChildren;
    private final boolean myResolveSymlinksIfNecessary;

    public PathTreeBase() {
        this(true);
    }

    public PathTreeBase(boolean resolveSymlinksIfNecessary) {
        this.myResolveSymlinksIfNecessary = resolveSymlinksIfNecessary;
    }

    @NotNull
    protected <T> Map<String, T> createChildrenMap(int capacity) {
        return capacity >= 0 ? CollectionFactory.createFilePathMap((int)capacity) : CollectionFactory.createFilePathMap();
    }

    @NotNull
    public Collection<Self> getChildren() {
        return this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        return this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        return this.getSubTree(PathTreeBase.splitPathInComponents(this.toCanonicalPath(path)), strategy);
    }

    @NotNull
    private static List<String> splitPathInComponents(@NotNull String path) {
        return StringUtil.split((String)path, (String)"/", (boolean)true, (boolean)false);
    }

    @NotNull
    private String toCanonicalPath(@NotNull String path) {
        int index = path.indexOf("://");
        if (index < 0) {
            return FileUtil.toCanonicalPath((String)path, (boolean)this.myResolveSymlinksIfNecessary);
        }
        int split = index + "://".length();
        return path.substring(0, split) + FileUtil.toCanonicalPath((String)path.substring(split), (boolean)this.myResolveSymlinksIfNecessary);
    }

    @Nullable
    private Self getSubTree(@NotNull Iterable<String> pathComps, SearchStrategy strategy) {
        Self result2 = this.self();
        Iterator<String> iterator2 = pathComps.iterator();
        while (iterator2.hasNext()) {
            Self t = result2;
            String key = iterator2.next();
            Self st = ((PathTreeBase)t).getChild(key);
            if (st != null) {
                result2 = st;
                continue;
            }
            switch (strategy) {
                case NULL_IF_NOT_FOUND: {
                    return null;
                }
                case DEEPEST_EXISTING_PREFIX: {
                    return result2;
                }
                case BUILD_IF_NOT_FOUND: {
                    result2 = ((PathTreeBase)t).createChild(key);
                }
            }
        }
        return result2;
    }

    @NotNull
    protected Self self() {
        return (Self)this;
    }

    @NotNull
    protected abstract Self createNewTree(@Nullable Self var1);

    @Nullable
    private Self getChild(@NotNull String key) {
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTreeBase)this.myChildren.get(key));
    }

    private Self createChild(@NotNull String name) {
        if (this.myChildren == null) {
            this.myChildren = this.createChildrenMap(-1);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put(name, tree);
        return tree;
    }

    Self clone(@Nullable Self parent) {
        Self clone = this.createNewTree(parent);
        Map<String, Self> children = this.myChildren;
        if (children == null) {
            return clone;
        }
        ((PathTreeBase)clone).myChildren = this.createChildrenMap(children.size());
        for (Map.Entry<String, Self> entry : children.entrySet()) {
            ((PathTreeBase)clone).myChildren.put(entry.getKey(), ((PathTreeBase)entry.getValue()).clone(clone));
        }
        return clone;
    }

    @Nullable
    public static <Self extends PathTreeBase<Self>> Self merge(@NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        return trees.isEmpty() ? null : PathTreeBase.merge(null, trees, allowReuse);
    }

    @NotNull
    private static <Self extends PathTreeBase<Self>> Self merge(@Nullable Self parent, @NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        Iterator<@NotNull Self> it = trees.iterator();
        assert (it.hasNext());
        PathTreeBase tree = (PathTreeBase)it.next();
        if (!it.hasNext()) {
            return (Self)(allowReuse ? tree : tree.clone(parent));
        }
        Self mergedTree = tree.createNewTree(parent);
        MultiMap childrenPerKey = new MultiMap(mergedTree.createChildrenMap(trees.size()));
        while (true) {
            tree.mergeInto(mergedTree, childrenPerKey);
            if (!it.hasNext()) break;
            tree = (PathTreeBase)it.next();
        }
        if (childrenPerKey.isEmpty()) {
            return mergedTree;
        }
        mergedTree.myChildren = mergedTree.createChildrenMap(childrenPerKey.size());
        for (Map.Entry entry : childrenPerKey.entrySet()) {
            Self mergedChild = PathTreeBase.merge(mergedTree, (Collection)entry.getValue(), allowReuse);
            mergedTree.myChildren.put((String)entry.getKey(), mergedChild);
        }
        return mergedTree;
    }

    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        Map<String, Self> children = this.myChildren;
        if (children != null) {
            for (Map.Entry<String, Self> entry : children.entrySet()) {
                childrenPerKey.putValue((Object)entry.getKey(), (Object)((PathTreeBase)entry.getValue()));
            }
        }
    }

    public void accept(@NotNull Visitor<Self> visitor) {
        this.accept(null, visitor);
    }

    private void accept(@Nullable String path, @NotNull Visitor<Self> visitor) {
        Map<String, Self> children;
        visitor.enter();
        if (visitor.visit((String)path, this.self()) && !ContainerUtil.isEmpty(children = this.myChildren)) {
            if (path != null) {
                path = (String)path + "/";
            }
            for (Map.Entry<String, Self> childEntry : children.entrySet()) {
                ProgressManager.checkCanceled();
                PathTreeBase childTree = (PathTreeBase)childEntry.getValue();
                childTree.accept((String)(path != null ? (String)path + childEntry.getKey() : childEntry.getKey()), visitor);
            }
        }
        visitor.exit();
    }

    public String toString() {
        if (this.guaranteedToBeEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(1024).append('[');
        this.accept(new ToStringVisitor(sb));
        return sb.append(']').toString();
    }

    protected abstract boolean isLeaf();

    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        sb.append(PathTreeBase.pathToDebugString(path));
    }

    @NotNull
    protected static String pathToDebugString(@Nullable String path) {
        return path != null ? path : "\u2205";
    }

    final Object[] toArray() {
        if (this.guaranteedToBeEmpty()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final ArrayList entries2 = new ArrayList();
        this.accept(new Visitor<Self>(){

            @Override
            public boolean visit(@Nullable String path, @NotNull Self subTree) {
                if (((PathTreeBase)subTree).isLeaf()) {
                    entries2.add(((PathTreeBase)subTree).nodeDebugRenderer(path));
                }
                return true;
            }
        });
        return entries2.toArray();
    }

    protected boolean guaranteedToBeEmpty() {
        return ContainerUtil.isEmpty(this.myChildren) && !this.isLeaf();
    }

    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        return PathTreeBase.pathToDebugString(path);
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }

    public static interface Visitor<T extends PathTreeBase<?>> {
        default public void enter() {
        }

        public boolean visit(@Nullable String var1, @NotNull T var2);

        default public void exit() {
        }
    }

    protected static final class ToStringVisitor<Self extends PathTreeBase<?>>
    implements Visitor<Self> {
        @NotNull
        private final StringBuilder sb;
        private boolean isFirstElement = true;

        public ToStringVisitor(@NotNull StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public boolean visit(@Nullable String path, @NotNull Self subTree) {
            if (!((PathTreeBase)subTree).isLeaf()) {
                return true;
            }
            if (!this.isFirstElement) {
                this.sb.append(',').append(' ');
            }
            ((PathTreeBase)subTree).nodeToString(this.sb, path);
            this.isFirstElement = false;
            return true;
        }
    }
}

