/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.CidrPluginPathMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrPathManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
    private static Path ourCidrRootPath;
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    private static final Map<String, Ref<Path>> ourPluginPathsByIdCache;
    private static final Set<Path> ourFileWithExecutableUpdated;

    public static Path getCidrSourcesRoot() {
        if (ourCidrRootPath == null) {
            ourCidrRootPath = Paths.get(PathManager.getHomePath(), System.getProperty("cidr.root.path", "CIDR"));
        }
        return ourCidrRootPath;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath, boolean archSpecific) {
        return platformPath + "/" + (String)(archSpecific && (SystemInfo.isWindows || SystemInfo.isLinux) ? (CpuArch.isArm64() ? "aarch64" : "x64") + "/" : "") + relativePath;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath) {
        return CidrPathManager.getPlatformRelativePath(platformPath, relativePath, true);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath, boolean archSpecific) {
        return CidrPathManager.getPlatformRelativePath(SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux"), relativePath, archSpecific);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath) {
        return CidrPathManager.getPlatformRelativePath(relativePath, true);
    }

    @NotNull
    public static File getBinFile(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        return CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries).toFile();
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        return CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries, true);
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries, boolean ensureIsExecutable) {
        String pluginId;
        Path pluginPath = null;
        if (CidrPathManager.lookForBinariesInsidePlugin()) {
            pluginPath = CidrPathManager.getPluginPath(clazz);
        }
        Path basePath = null;
        if (pluginPath != null) {
            basePath = pluginPath.resolve("bin");
        } else if (PluginManagerCore.isRunningFromSources()) {
            basePath = CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
        }
        if ((basePath == null || !Files.isDirectory(basePath, new LinkOption[0])) && CidrPathManager.lookForBinariesInsidePlugin() && (pluginId = CidrPathManager.getMappedPluginId(clazz)) != null && (pluginPath = CidrPathManager.getPluginPath(pluginId, clazz.getClassLoader())) != null) {
            basePath = pluginPath.resolve("bin");
        }
        if (basePath != null) {
            Path result2 = basePath.resolve(relativePath);
            if (ensureIsExecutable) {
                CidrPathManager.ensureFileIsExecutable(result2);
                if (relativePathToAdditionalBinaries != null) {
                    CidrPathManager.ensureFilesInDirAreExecutable(basePath.resolve(relativePathToAdditionalBinaries));
                }
            }
            return result2;
        }
        return Paths.get(PathManager.getBinPath(), relativePath);
    }

    private static void ensureFilesInDirAreExecutable(@NotNull Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path child : stream) {
                CidrPathManager.ensureFileIsExecutable(child);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path ensureFileIsExecutable(@NotNull Path file) {
        if (ourFileWithExecutableUpdated.contains(file)) {
            return file;
        }
        if (Files.isRegularFile(file, new LinkOption[0]) && !Files.isExecutable(file)) {
            LOG.info("Setting executable flag for " + file);
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE);
            try {
                perms.addAll(Files.getPosixFilePermissions(file, new LinkOption[0]));
                Files.setPosixFilePermissions(file, perms);
            }
            catch (IOException e) {
                LOG.warn("Cannot set executable flag for " + file, (Throwable)e);
            }
        }
        ourFileWithExecutableUpdated.add(file);
        return file;
    }

    private static boolean lookForBinariesInsidePlugin() {
        return !PlatformUtils.isCidr();
    }

    @Nullable
    private static Path getPluginPath(@NotNull Class<?> clazz) {
        Ref result2 = ourPluginPathsCache.get(clazz);
        if (result2 == null) {
            PluginId id;
            IdeaPluginDescriptor plugin;
            result2 = new Ref();
            ClassLoader loader = clazz.getClassLoader();
            if (loader instanceof PluginAwareClassLoader && (plugin = PluginManagerCore.getPlugin((PluginId)(id = ((PluginAwareClassLoader)loader).getPluginId()))) != null) {
                result2.set((Object)plugin.getPluginPath());
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)result2);
        }
        return (Path)result2.get();
    }

    @Nullable
    private static String getMappedPluginId(@NotNull Class<?> clazz) {
        for (CidrPluginPathMapper mapper : (CidrPluginPathMapper[])CidrPluginPathMapper.EP_NAME.getExtensions()) {
            String pluginId = mapper.getPluginId(clazz);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    private static Path getPluginPath(@NotNull String pluginId, @Nullable ClassLoader loader) {
        Ref result2 = ourPluginPathsByIdCache.get(pluginId);
        if (result2 == null) {
            result2 = new Ref();
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
            if (plugin != null) {
                Path path = loader instanceof PluginAwareClassLoader ? plugin.getPluginPath() : plugin.getPluginPath().resolve("../..");
                result2.set((Object)path);
            }
            ourPluginPathsByIdCache.putIfAbsent(pluginId, (Ref<Path>)result2);
        }
        return (Path)result2.get();
    }

    static {
        ourPluginPathsCache = new ConcurrentHashMap();
        ourPluginPathsByIdCache = new ConcurrentHashMap<String, Ref<Path>>();
        ourFileWithExecutableUpdated = ContainerUtil.newConcurrentSet();
    }
}

