/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CidrLogService {
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)CidrLogService.class.getPackage().getName());
    @NotNull
    private final Cache<StackTail, Object> myStackCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    public static void logOnce(@NotNull Level level, @NonNls @NotNull String message) {
        CidrLogService.logOnce(LOG, level, message);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String message) {
        CidrLogService.getInstance().logMessageOnce(logger, level, message);
    }

    public static void logOnce(@NotNull Level level, @NonNls @Nullable String message, @NotNull Throwable ex) {
        CidrLogService.logOnce(LOG, level, message, ex);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @Nullable String message, @NotNull Throwable ex) {
        CidrLogService.getInstance().logExceptionOnce(logger, level, message, ex);
    }

    @NotNull
    private static CidrLogService getInstance() {
        return (CidrLogService)ApplicationManager.getApplication().getService(CidrLogService.class);
    }

    private void logMessageOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String message) {
        StackTail stackTail = new StackTail(message);
        Object present = this.myStackCache.getIfPresent((Object)stackTail);
        if (present == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(message);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(message);
            } else if (level.equals(Level.INFO)) {
                logger.warn(message);
            }
        }
    }

    private void logExceptionOnce(@NotNull Logger logger, @NotNull Level level, @Nullable String message, @NotNull Throwable ex) {
        StackTail stackTail = new StackTail(message, ex);
        Object present = this.myStackCache.getIfPresent((Object)stackTail);
        if (present == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(message != null ? message : ex.getMessage(), ex);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(message != null ? message : ex.getMessage(), ex);
            }
        }
    }

    private static class StackTail {
        private static final int TAIL_SIZE = 5;
        @Nullable
        private final String myMessage;
        private final StackTraceElement @NotNull [] myStackTrace;
        private final int myHashCode;

        StackTail(@NotNull String message) {
            this.myMessage = message;
            this.myStackTrace = new StackTraceElement[0];
            this.myHashCode = StackTail.calculateHashCode(this.myMessage, this.myStackTrace);
        }

        StackTail(@Nullable String message, @NotNull Throwable thr) {
            this.myMessage = message;
            StackTraceElement[] stackTrace = thr.getStackTrace();
            int numToTake = Math.min(stackTrace.length, 5);
            this.myStackTrace = new StackTraceElement[numToTake];
            System.arraycopy(stackTrace, 0, this.myStackTrace, 0, numToTake);
            this.myHashCode = StackTail.calculateHashCode(this.myMessage, this.myStackTrace);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackTail)) {
                return false;
            }
            StackTail other = (StackTail)obj;
            if (!Objects.equals(this.myMessage, other.myMessage)) {
                return false;
            }
            if (this.myStackTrace.length != other.myStackTrace.length) {
                return false;
            }
            for (int i = 0; i < this.myStackTrace.length; ++i) {
                if (this.myStackTrace[i].equals(other.myStackTrace[i])) continue;
                return false;
            }
            return true;
        }

        private static int calculateHashCode(@Nullable String message, StackTraceElement @NotNull [] stackTrace) {
            int hc = Objects.hash(message);
            for (StackTraceElement element : stackTrace) {
                hc ^= element.hashCode();
            }
            return hc;
        }
    }
}

