/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.util.system.CpuArch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ArchitectureType {
    I386(32, 3, 332, "i386", "i486", "i586", "i686", "x86"),
    X86_64(64, 62, 34404, "x86_64", "x64", "amd64"),
    ARM(32, 40, 448, "arm", "xscale", "arm64_32"),
    ARM64(64, 183, 43620, "arm64", "armv8", "aarch64"),
    MIPS(32, 8, null, "mips"),
    MIPS64(64, 8, null, "mips64"),
    PPC(32, 20, null, "ppc", "powerpc"),
    PPC64(64, 21, null, "powerpc64", "ppc970-64"),
    SPARC(32, 2, null, "sparc"),
    SPARCV9(64, 43, null, "sparcv9"),
    RISCV32(32, 243, 20530, "riscv32"),
    RISCV64(64, 243, 20580, "riscv64"),
    UNKNOWN(0, null, null, "unknown");

    private final byte myBits;
    private final String @NotNull [] myIdPrefixArray;
    private final short myElfMachineCode;
    private final short myPeMachineCode;

    private ArchitectureType(@Nullable int bits, @NotNull Integer elfMachineCode, Integer peMachineCode, String ... idPrefix) {
        this.myElfMachineCode = elfMachineCode != null ? elfMachineCode.shortValue() : (short)0;
        short s = this.myPeMachineCode = peMachineCode != null ? peMachineCode.shortValue() : (short)0;
        if (idPrefix.length == 0) {
            throw new IllegalArgumentException("Missing architecture name");
        }
        this.myBits = (byte)bits;
        this.myIdPrefixArray = idPrefix;
    }

    @NotNull
    public String getId() {
        return this.myIdPrefixArray[0];
    }

    public int getBits() {
        return this.myBits;
    }

    @NotNull
    public static ArchitectureType forArchitecture(@Nullable String arch) {
        ArchitectureType found = UNKNOWN;
        if (arch != null) {
            int foundPrefixLength = 0;
            for (ArchitectureType value : ArchitectureType.values()) {
                for (String prefix : value.myIdPrefixArray) {
                    if (foundPrefixLength >= prefix.length() || !arch.startsWith(prefix)) continue;
                    foundPrefixLength = prefix.length();
                    found = value;
                    if (foundPrefixLength != arch.length()) continue;
                    return found;
                }
            }
        }
        return found;
    }

    @NotNull
    public static ArchitectureType forVmCpuArch(@NotNull CpuArch cpuArch) {
        return switch (cpuArch) {
            default -> throw new IncompatibleClassChangeError();
            case CpuArch.X86 -> I386;
            case CpuArch.X86_64 -> X86_64;
            case CpuArch.ARM64 -> ARM64;
            case CpuArch.OTHER, CpuArch.UNKNOWN -> UNKNOWN;
        };
    }

    @NotNull
    public static ArchitectureType forPeMachineType(short peCode) {
        for (ArchitectureType value : ArchitectureType.values()) {
            if (value.myPeMachineCode != peCode) continue;
            return value;
        }
        return UNKNOWN;
    }

    @NotNull
    public static ArchitectureType forElfMachineType(short elfCode) {
        for (ArchitectureType value : ArchitectureType.values()) {
            if (value.myElfMachineCode != elfCode) continue;
            return value;
        }
        return UNKNOWN;
    }
}

