/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.android.tools.idea.io.grpc.CallCredentials;
import com.android.tools.idea.io.grpc.Metadata;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusException;
import com.google.services.firebase.directaccess.client.TokenCallCredentialsKt;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/services/firebase/directaccess/client/TokenCallCredentials;", "Lcom/android/tools/idea/io/grpc/CallCredentials;", "tokenFetcher", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "applyRequestMetadata", "", "requestInfo", "Lcom/android/tools/idea/io/grpc/CallCredentials$RequestInfo;", "executor", "Ljava/util/concurrent/Executor;", "applier", "Lcom/android/tools/idea/io/grpc/CallCredentials$MetadataApplier;", "thisUsesUnstableApi", "directaccess-client"})
public final class TokenCallCredentials
extends CallCredentials {
    @NotNull
    private final Function0<String> tokenFetcher;

    public TokenCallCredentials(@NotNull Function0<String> tokenFetcher) {
        Intrinsics.checkNotNullParameter(tokenFetcher, (String)"tokenFetcher");
        this.tokenFetcher = tokenFetcher;
    }

    public void applyRequestMetadata(@NotNull CallCredentials.RequestInfo requestInfo, @NotNull Executor executor, @NotNull CallCredentials.MetadataApplier applier) {
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        executor.execute(new Runnable(this, applier){
            final /* synthetic */ TokenCallCredentials this$0;
            final /* synthetic */ CallCredentials.MetadataApplier $applier;
            {
                this.this$0 = $receiver;
                this.$applier = $applier;
            }

            public final void run() {
                try {
                    String string = (String)TokenCallCredentials.access$getTokenFetcher$p(this.this$0).invoke();
                    if (string == null) {
                        StatusException statusException = Status.UNAUTHENTICATED.asException();
                        Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"UNAUTHENTICATED.asException()");
                        throw (Throwable)statusException;
                    }
                    String token = string;
                    Metadata headers = new Metadata();
                    headers.put(TokenCallCredentialsKt.access$getAUTHORIZATION_METADATA_KEY$p(), (Object)("Bearer " + token));
                    this.$applier.apply(headers);
                }
                catch (Throwable e) {
                    Status status = Status.fromThrowable((Throwable)e);
                    if (status.getCode() == Status.UNAUTHENTICATED.getCode()) {
                        this.$applier.fail(status);
                    }
                    Logger.getLogger(Reflection.getOrCreateKotlinClass(TokenCallCredentials.class).getQualifiedName()).log(Level.SEVERE, "Error applying header", e);
                    this.$applier.fail(Status.UNAUTHENTICATED.withCause(e));
                }
            }
        });
    }

    public void thisUsesUnstableApi() {
    }

    public static final /* synthetic */ Function0 access$getTokenFetcher$p(TokenCallCredentials $this) {
        return $this.tokenFetcher;
    }
}

