/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.android.tools.adbbridge.Reservation;
import com.android.tools.adbbridge.TestExecution;
import com.android.tools.idea.io.grpc.Channel;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerImpl;
import com.google.services.firebase.directaccess.client.model.DeviceAssociationNameKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\f*\u00020\u0013\u001a\u001b\u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\r0\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"GOOGLE_USER_PROJECT_KEY", "", "DirectAccessReservationManager", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl;", "cloudProjectId", "scope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lcom/android/tools/idea/io/grpc/Channel;", "oAuthTokenFetcher", "Lkotlin/Function0;", "containsConnectedDevice", "", "Lcom/android/tools/adbbridge/Reservation;", "findOrCreateReservation", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "codename", "api", "isClosed", "Lcom/android/tools/adbbridge/Reservation$SessionState;", "waitUntilActive", "", "Lkotlinx/coroutines/flow/StateFlow;", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "directaccess-client"})
@SourceDebugExtension(value={"SMAP\nDirectAccessReservationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n288#2:273\n1743#2,3:274\n289#2:277\n*S KotlinDebug\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerKt\n*L\n88#1:273\n90#1:274,3\n88#1:277\n*E\n"})
public final class DirectAccessReservationManagerKt {
    @NotNull
    public static final String GOOGLE_USER_PROJECT_KEY = "X-Goog-User-Project";

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Reservation findOrCreateReservation(@NotNull DirectAccessReservationManager $this$findOrCreateReservation, @NotNull String codename, @NotNull String api) {
        Reservation reservation;
        Object v3;
        block4: {
            Object element$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$findOrCreateReservation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)codename, (String)"codename");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            Iterable $this$firstOrNull$iv = $this$findOrCreateReservation.listReservations();
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            do {
                block7: {
                    boolean bl2;
                    block5: {
                        Iterator iterator2;
                        block9: {
                            block6: {
                                Iterable $this$any$iv;
                                block8: {
                                    if (!iterator.hasNext()) break block6;
                                    element$iv = iterator.next();
                                    Reservation reservation2 = (Reservation)element$iv;
                                    boolean bl3 = false;
                                    Reservation.SessionState sessionState = reservation2.getSessionState();
                                    Intrinsics.checkNotNullExpressionValue((Object)sessionState, (String)"reservation.sessionState");
                                    if (DirectAccessReservationManagerKt.isClosed(sessionState)) break block7;
                                    List list = reservation2.getAndroidDeviceList().getAndroidDevicesList();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"reservation.androidDeviceList.androidDevicesList");
                                    $this$any$iv = list;
                                    boolean $i$f$any = false;
                                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block8;
                                    bl2 = false;
                                    break block5;
                                }
                                iterator2 = $this$any$iv.iterator();
                                break block9;
                            }
                            v3 = null;
                            break block4;
                        }
                        while (iterator2.hasNext()) {
                            Object element$iv2 = iterator2.next();
                            TestExecution.AndroidDevice it = (TestExecution.AndroidDevice)element$iv2;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it.getAndroidModelId(), (Object)codename) && Intrinsics.areEqual((Object)it.getAndroidVersionId(), (Object)api))) continue;
                            bl2 = true;
                            break block5;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v3 = element$iv;
        }
        if ((reservation = (Reservation)v3) == null) {
            reservation = $this$findOrCreateReservation.createReservation(codename, api);
        }
        return reservation;
    }

    private static final boolean containsConnectedDevice(Reservation $this$containsConnectedDevice) {
        List list = $this$containsConnectedDevice.getConnectionInfo().getAdbConnectInfo().getAdbDevicesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"connectionInfo.adbConnectInfo.adbDevicesList");
        return !((Collection)list).isEmpty();
    }

    @Nullable
    public static final Object waitUntilActive(@NotNull StateFlow<Reservation> $this$waitUntilActive, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)$this$waitUntilActive), (Function2)((Function2)new Function2<Reservation, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        Reservation reservation = (Reservation)this.L$0;
                        boolean active = bl = DirectAccessReservationManagerKt.access$containsConnectedDevice(reservation);
                        boolean bl2 = false;
                        Logger.getLogger(Reflection.getOrCreateKotlinClass(DirectAccessReservationManager.class).getQualifiedName()).info(active ? "Found: " + DeviceAssociationNameKt.getDeviceAssociationName(reservation) : "Waiting for " + reservation.getName() + " to activate...");
                        return Boxing.boxBoolean((!bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Reservation p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final boolean isClosed(@NotNull Reservation.SessionState $this$isClosed) {
        Intrinsics.checkNotNullParameter((Object)$this$isClosed, (String)"<this>");
        return $this$isClosed != Reservation.SessionState.ACTIVE && $this$isClosed != Reservation.SessionState.PENDING && $this$isClosed != Reservation.SessionState.REQUESTED;
    }

    @NotNull
    public static final DirectAccessReservationManagerImpl DirectAccessReservationManager(@NotNull String cloudProjectId, @NotNull CoroutineScope scope, @NotNull Channel channel, @NotNull Function0<String> oAuthTokenFetcher) {
        Intrinsics.checkNotNullParameter((Object)cloudProjectId, (String)"cloudProjectId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(oAuthTokenFetcher, (String)"oAuthTokenFetcher");
        return new DirectAccessReservationManagerImpl(cloudProjectId, scope, channel, oAuthTokenFetcher, null, 16, null);
    }

    public static final /* synthetic */ boolean access$containsConnectedDevice(Reservation $receiver) {
        return DirectAccessReservationManagerKt.containsConnectedDevice($receiver);
    }
}

